/**
  ******************************************************************************
  * ļ canhl.c
  *     ChipON_AE/FAE_Group
  *     2019-10-19
  *     ļṩCANģص뷢͹ܣ
  *          + CANӳ
  *          + CANж
  *          + CAN
  *          + CANʼ
  ******************************************************************************/
#include "system_init.h"
#include "canhl.h"

#define 	xCAN_ACR    (uint32_t)0x00000000;  //մ
#define 	xCAN_MSK 	(uint32_t)0xffffffff;  //

volatile uint8_t CAN_TX_FLAG=0; 	//ͱ־
uint32_t SENDID = 0;			    //ID
uint8_t  SendData[8]={'A','B','C','D','E','F','G','H'};  //
uint8_t  ReceiveData[8]={0};	    //

/*============================================================================
 *void xGPIO_CAN()
------------------------------------------------------------------------------
		: canض
		: 
		: 
ע		:
============================================================================*/
void xGPIO_CAN()
{
	GPIO_InitTypeDef GPIO_InitStructure;

	/*CANΪģʽӦ˿ʱ*/
	GPIO_InitStructure.m_Mode = GPIO_MODE_RMP;
	GPIO_InitStructure.m_Speed = GPIO_HIGH_SPEED;
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;
	GPIO_InitStructure.m_OpenDrain = GPIO_POD_PP;
	GPIO_InitStructure.m_Pin = GPIO_PIN_MASK_13|GPIO_PIN_MASK_14;
	GPIO_Configuration(GPIOD_SFR,&GPIO_InitStructure);
	/*ӳ书ΪCANģʽ*/
	PCLK_CTL0_Peripheral_Clock_Enable(PCLK_CTL0_GPIODCLKEN,TRUE);
	GPIO_Pin_RMP_Config(GPIOD_SFR,GPIO_Pin_Num_13,GPIO_RMP_AF9_CAN1);
	GPIO_Pin_RMP_Config(GPIOD_SFR,GPIO_Pin_Num_14,GPIO_RMP_AF9_CAN1);
}

/*============================================================================
 *void xInit_LP_CAN(CAN_SFRmap* CANx,uint8_t Bdrt,uint32_t MODE)
------------------------------------------------------------------------------
		: canģʼ
		: 1.CANx: ָCANڴṹָ룬ȡֵΪCAN0_SFR
		  2.Bdrt  ʣcanhl.h
		  3.MODE  ģʽCAN_MODE_NORMAL CAN_MODE_SILENT CAN_MODE_LOOPBACK CAN_MODE_SILENT_LOOPBACK
		: 
ע		:
============================================================================*/
void xInit_LP_CAN(CAN_SFRmap* CANx,uint8_t Bdrt,uint32_t MODE)
{
	CAN_InitTypeDef CAN_InitStructure;
	/* CANʱʹܣλ */

    OSC_SCK_Source_Config(SCLK_SOURCE_INTHF); //ϵͳƵ
	BKP_Write_And_Read_Enable(TRUE); //дʹ
	RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_CAN0RST, TRUE);
	SFR_CLR_BIT_ASM(PM_CTL2, PM_CTL2_CAN0LPEN_POS); //CAN0LPENʹܣPA13\PA14ΪCAN0
    PCLK_CTL2_Peripheral_Clock_Enable(PCLK_CTL2_CAN0CLKEN, TRUE);
    RST_CTL2_Peripheral_Reset_Enable(RST_CTL2_CAN0RST, FALSE);
	SFR_SET_BIT_ASM(PM_CTL2, PM_CTL2_CAN0LPEN_POS); //CAN0LPENʹܣPA13\PA14ΪCAN0
	OSC_SCK_Source_Config(SCLK_SOURCE_PLL);    //ϵͳָƵ

	CAN_InitStructure.m_Acceptance = xCAN_ACR;                    //˲
	CAN_InitStructure.m_AcceptanceMask = xCAN_MSK;		          //
	CAN_InitStructure.m_WorkSource = CAN_SOURCE_HFCLK_DIV_2;      //CANʱڲƵ

	if(Bdrt==CAN_BAUDRATE_125K)
	{
		CAN_InitStructure.m_BaudRate = 7;					  //ʱӷƵ  1M
	}
	else if(Bdrt==CAN_BAUDRATE_250K)
	{
		CAN_InitStructure.m_BaudRate = 3;					  //ʱӷƵ  2M
	}
	else if(Bdrt==CAN_BAUDRATE_500K)
	{
		CAN_InitStructure.m_BaudRate = 1;					  //ʱӷƵ  4M
	}
	else if(Bdrt==CAN_BAUDRATE_1M)
	{
		CAN_InitStructure.m_BaudRate = 0;					  //ʱӷƵ 8M
	}
	//TSEG1TSEG2ñֵһΪ70-80%CANĲҪ
	CAN_InitStructure.m_TimeSeg1 = 4;						   //TSEG1
	CAN_InitStructure.m_TimeSeg2 = 1;						   //TSEG2
	CAN_InitStructure.m_BusSample = CAN_BUS_SAMPLE_3_TIMES;	   //
	CAN_InitStructure.m_SyncJumpWidth = 1;					   //ͬת
	CAN_InitStructure.m_Enable = TRUE;						   //ʹ
	CAN_InitStructure.m_Mode = MODE;				           //ģʽ
	CAN_Configuration(CANx,&CAN_InitStructure);			   //д
}

/*============================================================================
 *void xInit_CAN(CAN_SFRmap* CANx,uint8_t Bdrt,uint32_t MODE)
------------------------------------------------------------------------------
		: canģʼ
		: 1.CANx: ָCANڴṹָ룬ȡֵΪCAN0_SFR~CAN3_SFR
		  2.Bdrt  ʣcanhl.h
		  3.MODE  ģʽCAN_MODE_NORMAL CAN_MODE_SILENT CAN_MODE_LOOPBACK CAN_MODE_SILENT_LOOPBACK
		: 
ע		:
============================================================================*/
void xInit_CAN(CAN_SFRmap* CANx,uint8_t Bdrt,uint32_t MODE)
{
	CAN_InitTypeDef CAN_InitStructure;
	/* CANʱʹܣλ */

	CAN_Reset(CANx);
	CAN_InitStructure.m_Acceptance = xCAN_ACR;                    //˲
	CAN_InitStructure.m_AcceptanceMask = xCAN_MSK;		          //
	CAN_InitStructure.m_WorkSource = CAN_SOURCE_HFCLK_DIV_2;      //CANʱڲƵ

	if(Bdrt==CAN_BAUDRATE_125K)
	{
		CAN_InitStructure.m_BaudRate = 7;					  //ʱӷƵ  1M
	}
	else if(Bdrt==CAN_BAUDRATE_250K)
	{
		CAN_InitStructure.m_BaudRate = 3;					  //ʱӷƵ  2M
	}
	else if(Bdrt==CAN_BAUDRATE_500K)
	{
		CAN_InitStructure.m_BaudRate = 1;					  //ʱӷƵ  4M
	}
	else if(Bdrt==CAN_BAUDRATE_1M)
	{
		CAN_InitStructure.m_BaudRate = 0;					  //ʱӷƵ 8M
	}
	//TSEG1TSEG2ñֵ75%ʣ8=Seg1+Sync/(Seg1+Seg2+Sync)*100%
	CAN_InitStructure.m_TimeSeg1 = 4;						   //TSEG1
	CAN_InitStructure.m_TimeSeg2 = 1;						   //TSEG2
	CAN_InitStructure.m_BusSample = CAN_BUS_SAMPLE_3_TIMES;	   //
	CAN_InitStructure.m_SyncJumpWidth = 1;					   //ͬת
	CAN_InitStructure.m_Enable = TRUE;						   //ʹ
	CAN_InitStructure.m_Mode = MODE;				           //ģʽ
	CAN_Configuration(CANx,&CAN_InitStructure);			   //д
}
/*============================================================================
 *void xINT_CAN(CAN_SFRmap* CANx)
------------------------------------------------------------------------------
		: canж
		: 1.CANx: ָCANڴṹָ룬ȡֵΪCAN0_SFR~CAN3_SFR
		: 
ע		:
============================================================================*/
void xINT_CAN(CAN_SFRmap* CANx)
{

	/* ж */
	CAN_Set_INT_Enable(CANx,CAN_INT_TRANSMIT|CAN_INT_BUS_ERROR|CAN_INT_ARBITRATION_LOST,TRUE);
	/* ж */
	CAN_Set_INT_Enable(CANx,CAN_INT_RECEIVE,TRUE);
	/* ж */
//	CAN_Set_INT_Enable(CANx,CAN_INT_DATA_OVERFLOW,TRUE);
	if(CANx == CAN1_SFR)
	{
		/* CANж */
		INT_Interrupt_Priority_Config(INT_CAN1,3,0);						//CANռȼ4,ȼ0
		INT_Clear_Interrupt_Flag(INT_CAN1);									//CANжϱ־
		INT_Interrupt_Enable(INT_CAN1,TRUE);								//CANжʹ
	}
	else
	{
	/* CANж */
		INT_Interrupt_Priority_Config(INT_CAN0,3,1);						//CANռȼ4,ȼ0
		INT_Clear_Interrupt_Flag(INT_CAN0);									//CANжϱ־
		INT_Interrupt_Enable(INT_CAN0,TRUE);								//CANжʹ
	}



}

/*============================================================================
 *void CAN_Transmit_DATA(CAN_SFRmap* CANx, uint8_t *data , uint8_t lenth)
------------------------------------------------------------------------------
		: ݷͼ
		: 1.ҪʼCAN	CAN0_SFRCAN1_SFRCAN2_SFR
		  2.ID
		  2.ַ
		  3.ݳ
		  4.֡        CAN_DATA_FRAME֡                     CAN_REMOTE_FRAMEԶ֡
		  5.֡ʽ        CAN_FRAME_FORMAT_SFF׼֡     CAN_FRAME_FORMAT_EFFչ֡
		: CAN_ERROR_BUFFERFULL  CAN_ERROR_NOERROR
ע		:
============================================================================*/
CAN_ErrorT CAN_Transmit_DATA(CAN_SFRmap* CANx,   //CANͨ
						uint32_t  TargetID,//ID
						uint8_t*  data ,   //ָ
						uint8_t   lenth,   //
						uint32_t  MsgType, //֡        CAN_DATA_FRAME//֡           CAN_REMOTE_FRAME//Զ֡
						uint32_t  RmtFrm   //֡ʽ        CAN_FRAME_FORMAT_SFF//׼֡     CAN_FRAME_FORMAT_EFF//չ֡
						)
{
	CAN_ErrorT x;
	uint8_t i;
	CAN_MessageTypeDef	CAN_MessageStructure;

	CAN_MessageStructure.m_FrameFormat = RmtFrm;             	 //֡ʽ
	CAN_MessageStructure.m_RemoteTransmit = MsgType;		 	 //֡
	if(RmtFrm==CAN_FRAME_FORMAT_SFF)//׼֡
	{
		CAN_MessageStructure.m_StandardID = TargetID;			 //׼֡ID
		CAN_MessageStructure.m_ExtendedID = 0;			         //չ֡ID
	}
	else if(RmtFrm==CAN_FRAME_FORMAT_EFF)//չ֡
	{
		CAN_MessageStructure.m_StandardID = 0;					 //׼֡ID
		CAN_MessageStructure.m_ExtendedID = TargetID;			 //չ֡ID
	}
	if(lenth>8)
	{
		lenth=8;
	}
	CAN_MessageStructure.m_DataLength = lenth;			    	 //
	for(i=0;i<lenth;i++)
	{
		CAN_MessageStructure.m_Data[i] = data[i];				 //
	}
	/* ͻ */
	if((!CAN_Get_Transmit_Status(CANx,CAN_TX_BUFFER_STATUS)))
	{
		x=CAN_ERROR_BUFFERFULL;
		return x;
	}
	/* תݵͻ */
	CAN_Transmit_Message_Configuration(CANx,&CAN_MessageStructure);
	/* η */

	CANx->CTLR = CANx->CTLR | 0x300;

	x=CAN_ERROR_NOERROR;
	return x;
}

