/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: CCPx_PWM_Mode
 *  :  V2.3
 *  :  20191116
 *   :  ChipON_AE/FAE_Group
 *     ļṩCCP PWMӦ̲ο
 *
 ****************************************************************************************/
#include "system_init.h"
#define					PWM_Edge_Out				0	//ضPWMź
#define					PWM_Center_Out 			    1	//ĶPWMź

#define					CCP_PWM_WORK			PWM_Edge_Out	//  ѡPWMģʽ  0ضPWMź    1ĶPWMź




/**
  *   CCPx PWMGPIOӳá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *     GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *    PinRemap: ӳѡ
  *   ޡ
  */
void CCPx_PWM_GPIO_Init(GPIO_SFRmap* GPIOx,uint16_t GpioPin,uint8_t PinRemap)													//CCP0 PWMģʽ
{
	 static uint16_t GpioPinNum;

	GPIO_Write_Mode_Bits(GPIOx,GpioPin,GPIO_MODE_RMP);

	if(GpioPin==GPIO_PIN_MASK_0)
	{
		GpioPinNum =GPIO_Pin_Num_0;
	}else if(GpioPin==GPIO_PIN_MASK_1)
	{
		GpioPinNum =GPIO_Pin_Num_1;
	}else if(GpioPin==GPIO_PIN_MASK_2)
	{
		GpioPinNum =GPIO_Pin_Num_2;
	}else if(GpioPin==GPIO_PIN_MASK_3)
	{
		GpioPinNum =GPIO_Pin_Num_3;
	}else if(GpioPin==GPIO_PIN_MASK_4)
	{
		GpioPinNum =GPIO_Pin_Num_4;
	}else if(GpioPin==GPIO_PIN_MASK_5)
	{
		GpioPinNum =GPIO_Pin_Num_5;
	}else if(GpioPin==GPIO_PIN_MASK_6)
	{
		GpioPinNum =GPIO_Pin_Num_6;
	}else if(GpioPin==GPIO_PIN_MASK_7)
	{
		GpioPinNum =GPIO_Pin_Num_7;
	}else if(GpioPin==GPIO_PIN_MASK_8)
	{
		GpioPinNum =GPIO_Pin_Num_8;
	}else if(GpioPin==GPIO_PIN_MASK_9)
	{
		GpioPinNum =GPIO_Pin_Num_9;
	}else if(GpioPin==GPIO_PIN_MASK_10)
	{
		GpioPinNum =GPIO_Pin_Num_10;
	}else if(GpioPin==GPIO_PIN_MASK_11)
	{
		GpioPinNum =GPIO_Pin_Num_11;
	}else if(GpioPin==GPIO_PIN_MASK_12)
	{
		GpioPinNum =GPIO_Pin_Num_12;
	}else if(GpioPin==GPIO_PIN_MASK_13)
	{
		GpioPinNum =GPIO_Pin_Num_13;
	}else if(GpioPin==GPIO_PIN_MASK_14)
	{
		GpioPinNum =GPIO_Pin_Num_14;
	}else if(GpioPin==GPIO_PIN_MASK_15)
	{
		GpioPinNum =GPIO_Pin_Num_15;
	}

	GPIO_Pin_RMP_Config(GPIOx,GpioPinNum,PinRemap);     //ӳ书


}

/**
  *   CCPx PWM·ͬڲͬռձȵĹܺ
  *  : CCPx: ָCCPͨöʱڴṹָ룬
  *               ȡֵCCP0_SFR/CCP1_SFR/CCP2_SFR/CCP3_SFR/CCP4_SFR/
  *
  *
  *   ޡ
  */
void CCPx_FOUR_PWM(CCP_SFRmap* CCPx)
{

	TIM_Reset(CCPx);//ʱ踴λʹʱ

	CCP_PWM_Mode_Config(CCPx,CCP_CHANNEL_1,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_PWM_Mode_Config(CCPx,CCP_CHANNEL_2,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_PWM_Mode_Config(CCPx,CCP_CHANNEL_3,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_PWM_Mode_Config(CCPx,CCP_CHANNEL_4,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_Channel_Output_Control(CCPx,CCP_CHANNEL_1,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Channel_Output_Control(CCPx,CCP_CHANNEL_2,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Channel_Output_Control(CCPx,CCP_CHANNEL_3,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Channel_Output_Control(CCPx,CCP_CHANNEL_4,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Set_Compare_Result(CCPx,CCP_CHANNEL_1,0x1FFF);									//CHANNEL_1 PWMռձ
	CCP_Set_Compare_Result(CCPx,CCP_CHANNEL_2,0x3FFF);									//CHANNEL_2 PWMռձ
	CCP_Set_Compare_Result(CCPx,CCP_CHANNEL_3,0x7FFF);									//CHANNEL_3 PWMռձ
	CCP_Set_Compare_Result(CCPx,CCP_CHANNEL_4,0xAFFF);									//CHANNEL_4 PWMռձ


	GPTIM_Updata_Immediately_Config(CCPx,TRUE);									//¿
	GPTIM_Updata_Enable(CCPx,TRUE);												//øʹ
	GPTIM_Work_Mode_Config(CCPx,GPTIM_TIMER_MODE);								//ʱģʽѡ
	GPTIM_Set_Counter(CCPx,0);													//ʱֵ
	GPTIM_Set_Period(CCPx,0xFFFF);											    //ʱֵ
	GPTIM_Set_Prescaler(CCPx,47);											   //ʱԤƵֵ
#if		CCP_PWM_WORK==PWM_Edge_Out
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_OF);						   //ϼģʽ,ضPWMź
#else
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_DOWN_OF);					   //ϡ¼ģʽ,ĶPWMź
#endif

	GPTIM_Clock_Config(CCPx,GPTIM_SCLK);										//ѡSCLKʱ
	GPTIM_Cmd(CCPx,TRUE);                                                       //ʱʹ
}

/**
  *   CCP20 CCP21 PWMܳʼ
  *  : CCPx: ָCCPͨöʱڴṹָ룬
  *               ȡֵ/CCP20_SFR/CCP21_SFR
  *    Channel:  CCP_CHANNEL_1: ͨ1
  *              CCP_CHANNEL_2: ͨ2
  *              CCP_CHANNEL_3: ͨ3
  *              CCP_CHANNEL_4: ͨ4
  *      Period ֵ32λ
  *     Dutyռձȣ32λ
  *
  *   ޡ
  */
void CCP2021_PWM_PPX_Duty(CCP_SFRmap* CCPx, uint32_t Channel,uint32_t Period,uint32_t Duty)
{

	TIM_Reset(CCPx);//ʱ踴λʹʱ

	CCP_PWM_Mode_Config(CCPx,Channel,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_Channel_Output_Control(CCPx,Channel,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Set_Compare_Result(CCPx,Channel,Duty);									//PWMռձ


	GPTIM_Updata_Immediately_Config(CCPx,TRUE);									//¿
	GPTIM_Updata_Enable(CCPx,TRUE);												//øʹ
	GPTIM_Work_Mode_Config(CCPx,GPTIM_TIMER_MODE);								//ʱģʽѡ
	GPTIM_Set_Counter(CCPx,0);													//ʱֵ
	GPTIM_Set_Period(CCPx,Period);											    //ʱֵPPX
	GPTIM_Set_Prescaler(CCPx,2);												//ʱԤƵֵ

#if		CCP_PWM_WORK==PWM_Edge_Out
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_OF);							//ϼģʽ,ضPWMź
#else
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_DOWN_OF);							    	//ϡ¼ģʽ,ĶPWMź
#endif

	GPTIM_Clock_Config(CCPx,GPTIM_SCLK);										//ѡSCLKʱ
	GPTIM_Cmd(CCPx,TRUE);                                                       //ʱʹ
}

/**
  *   CCPx PWMܳʼ
  *  : CCPx: ָCCPͨöʱڴṹָ룬
  *               ȡֵCCP0_SFR/CCP1_SFR/CCP2_SFR/CCP3_SFR/CCP4_SFR/
  *               CCP18_SFR/CCP19_SFR/CCP22_SFR/CCP23_SFR
  *    Channel:  CCP_CHANNEL_1: ͨ1
  *              CCP_CHANNEL_2: ͨ2
  *              CCP_CHANNEL_3: ͨ3
  *              CCP_CHANNEL_4: ͨ4
  *      Period ֵ16λ
  *        Duty ռձȣ16λ
  *
  *   ޡ
  */
void CCPx_PWM_PPX_Duty(CCP_SFRmap* CCPx, uint32_t Channel,uint16_t Period,uint16_t Duty)
{

	TIM_Reset(CCPx);//ʱ踴λʹʱ
	CCP_PWM_Mode_Config(CCPx,Channel,CCP_PWM_MODE);								//CCP PWMͨģʽ
	CCP_Channel_Output_Control(CCPx,Channel,CCP_CHANNEL_OUTPUT_PWM_ACTIVE);		//CCPͨPWMЧ
	CCP_Set_Compare_Result(CCPx,Channel,Duty);									//PWMռձ
	GPTIM_Updata_Immediately_Config(CCPx,TRUE);									//¿
	GPTIM_Updata_Enable(CCPx,TRUE);												//øʹ
	GPTIM_Work_Mode_Config(CCPx,GPTIM_TIMER_MODE);								//ʱģʽѡ
	GPTIM_Set_Counter(CCPx,0);													//ʱֵ
	GPTIM_Set_Period(CCPx,Period);											    //ʱֵPeriod
	GPTIM_Set_Prescaler(CCPx,118);											   //ʱԤƵֵ
#if		CCP_PWM_WORK==PWM_Edge_Out
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_OF);						   //ϼģʽ,ضPWMź
#else
	GPTIM_Counter_Mode_Config(CCPx,GPTIM_COUNT_UP_DOWN_OF);				       //ϡ¼ģʽ,ĶPWMź
#endif
	GPTIM_Clock_Config(CCPx,GPTIM_SCLK);										//ѡSCLKʱ
	GPTIM_Cmd(CCPx,TRUE);                                                       //ʱʹ
}




//
void main()
{
	/*ûɲοKF32A151_demoʵPWMģʽùܡ
	     1CCP0  ͨ3  1KHZ ռձΪ50% PWMPB8
	     2CCP3 ͨ3  15HZ ռձΪ50% PWMPB13  D415HZƵ˸
	     3CCP20 ͨ0 10HZ ռձΪ50% PWMPE0
	     4CCP1    ĸͨ    ͬƵʲͬռձȵPWM  38HZ PWM
	     CCP_PWM_WORK    궨ѡ񣺱ضģʽĶģʽ
	  ʾԲPB8Ϊ1KHZҵPWM,PB13Ϊ15HZPWMPE0Ϊ10HZPWM ռձȶΪ50%
	 */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ
	CCPx_PWM_GPIO_Init(GPIOB_SFR,GPIO_PIN_MASK_8,GPIO_RMP_AF1_T0);  //CCP0  PB8ӳPWM
	CCPx_PWM_GPIO_Init(GPIOB_SFR,GPIO_PIN_MASK_13,GPIO_RMP_AF1_T3); //CCP3  PB13ӳPWM
	CCPx_PWM_GPIO_Init(GPIOE_SFR,GPIO_PIN_MASK_0,GPIO_RMP_AF3_T20); //CCP20 PE0ӳPWM

	CCPx_PWM_GPIO_Init(GPIOF_SFR,GPIO_PIN_MASK_0,GPIO_RMP_AF1_T1); //CCP1   PF0ӳΪPWM  38HZ PWM
	CCPx_PWM_GPIO_Init(GPIOB_SFR,GPIO_PIN_MASK_1,GPIO_RMP_AF1_T1); //CCP1   PB1ӳΪPWM  38HZ PWM
	CCPx_PWM_GPIO_Init(GPIOB_SFR,GPIO_PIN_MASK_2,GPIO_RMP_AF1_T1); //CCP1   PB2ӳΪPWM  38HZ PWM
	CCPx_PWM_GPIO_Init(GPIOB_SFR,GPIO_PIN_MASK_3,GPIO_RMP_AF1_T1); //CCP1   PB3ӳΪPWM  38HZ PWM

	CCPx_PWM_PPX_Duty(CCP0_SFR,CCP_CHANNEL_3,1000,500);  //CCP0   ͨ3 PB8 1KHZ ռձΪ50% PWM
	CCPx_PWM_PPX_Duty(CCP3_SFR,CCP_CHANNEL_3,65535,32767);//CCP3  ͨ3  PB13 15HZ  ռձΪ50% PWM
	CCP2021_PWM_PPX_Duty(CCP20_SFR,CCP_CHANNEL_1,0X3D09FF,0X1E8480);//CCP20 ͨ0 PE0 10HZ ռձΪ50% PWM

	CCPx_FOUR_PWM(CCP1_SFR); //CCP1    ĸͨ    ͬƵʲͬռձȵPWM  38HZ PWM
	while(1)
    {
    }
}



void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

