/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: Breathing_LED
 *  :  V2.3
 *  :  20191116
 *   :  ChipON_AE/FAE_Group
 *     ļṩͨöʱӦ
 *
 *
 ****************************************************************************************/
#include "system_init.h"

volatile uint8_t direc_flag;     //ռձȱ仯
volatile uint32_t PWM_VLAUE;     //ռձȴС
volatile uint32_t HUXI_COUNT;    //ռձȱ仯ٶȱ


/**
  *   ͨöʱGPTIMx ʼá
  *   GPTIMx:ȡֵΪT0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR/ T18_SFR/T19_SFR/T20_SFR/T21_SFR/T22_SFR/T23_SFR
  *  PeripheralȡֵΪINT_T0/INT_T1/INT_T2/INT_T3/INT_T4/INT_T18/INT_T19/INT_T20/INT_T21/INT_T22/INT_T23
  *
  *   ޡ
  */
void GENERAL_TIMER_SINGLE_Tx_Config(GPTIM_SFRmap* GPTIMx,InterruptIndex Peripheral)
{
	//ʱʱԴѡʱ120Mʱ60Ƶ0.5usִмһΣ10050usһж
	TIM_Reset(GPTIMx);																//ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(GPTIMx,TRUE);									//¿
	GPTIM_Updata_Enable(GPTIMx,TRUE);												//øʹ
	GPTIM_Work_Mode_Config(GPTIMx,GPTIM_TIMER_MODE);								//ʱģʽѡ
	GPTIM_Set_Counter(GPTIMx,0);													//ʱֵ
	GPTIM_Set_Period(GPTIMx,100);											    	//ʱֵ100
	GPTIM_Set_Prescaler(GPTIMx,59);													//ʱԤƵֵ59+1=60
	GPTIM_Counter_Mode_Config(GPTIMx,GPTIM_COUNT_UP_DOWN_OUF);						//-¼,жϱ־
	GPTIM_Clock_Config(GPTIMx,GPTIM_SCLK);											//ѡSCLKʱ
	INT_Interrupt_Priority_Config(Peripheral,4,0);									//ռȼ4,ȼ0
	GPTIM_Overflow_INT_Enable(GPTIMx,TRUE);											//жʹ
	INT_Interrupt_Enable(Peripheral,TRUE);											//жʹ
	INT_Clear_Interrupt_Flag(Peripheral);											//жϱ־
	GPTIM_Cmd(GPTIMx,TRUE);															//ʱʹ
	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);									//жԶջʹõֶ
	INT_All_Enable (TRUE);															//ȫֿжʹ,жʹܿƲλ/NMI/Ӳж

}

/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}

//
void main()
{
	/*ûɲοKF32A151_demoD4 ʵֺЧ
	 * ʹͨöʱ18 öʱʱΪ50usһжϣ
	 *ȻжϺPB13óģƵΪ100HZ PWMź 
	 *ıռձȴС򣬴ӶʵD4
	 * */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();
	direc_flag =0;//ռձȸķʼ
	PWM_VLAUE =50;//ռձȴСʼ
	//ʼPB13ߵƽ
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_13);
	//ʹͨöʱT18ΪʱжӦ
	GENERAL_TIMER_SINGLE_Tx_Config(T18_SFR,INT_T18);   //50usһж

    while(1)
    {
        	if((HUXI_COUNT >= 1000) && (direc_flag == 0))//ռձȱ仯ٶȵ
        	{
        		//ռձȼС
        	   HUXI_COUNT =0;
        		PWM_VLAUE++;

        		if(PWM_VLAUE >= 99)
        		{
        			PWM_VLAUE =99;
        			direc_flag = 1;//ռձȸķ
        		}
        	}

        	if((HUXI_COUNT >= 500) && (direc_flag == 1)) //ռձȱ仯ٶȵ
        	{
        		//ռձ
        		HUXI_COUNT =0;
        		PWM_VLAUE--;
        		if(PWM_VLAUE <= 10)
        	    {
        			direc_flag = 0; //ռձȸķ
        			PWM_VLAUE =10;
        	    }


        	}

    }


}



void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

