/****************************************************************************************
 * ļ: main.c
 * Ŀ: I2C
 *  :  V2.3
 *  :  20191116
 *     ChipON_AE/FAE_Group
 *     ļṩI2CͨŹòο̡
 *
 ****************************************************************************************/
#include "system_init.h"
#include "I2C_Master_Slave.h"
#include "Usart.h"


#define BUFFER_SIZE_Read     64   //ݸ
uint8_t i2c_buffer_read[BUFFER_SIZE_Read]={0};//ȡI2Cݺ洢

#if	IIC_MODE==MODE_Slave  //ӻģʽ

uint8_t I2C_RecNum=0;                 //յڼݵı
#define I2C_SLAVE_ADDRESS      0xA0   //ýƥI2C 7λַ
//ýƥI2C 10λַ
#define I2C_SLAVE_ADDRESS10B   0x3A0   //0XF6A0
//ע⣺͵ĸλַ ڶλ͵λǶӦӻҪĸλַ

//ӻģʽںͶI2CַݵԱ,
uint8_t i2c_buffer_read_test[BUFFER_SIZE_Read] = {
		                                      0X5A,0X22,0X33,0X44,0X66,0X77,0X88,0X99,0XAA,0XBB,
		                                      0X01,0X02,0X03,0X04,0X05,0X06,0X07,0X08,0X09,0X10,
		                                      0X11,0X12,0X13,0X14,0X15,0X16,0X17,0X18,0X19,0X20,
		                                      0X21,0X22,0X23,0X24,0X25,0X26,0X27,0X28,0X29,0X30,
		                                      0X31,0X32,0X33,0X34,0X35,0X36,0X37,0X38,0X39,0X40,
		                                      0X41,0X42,0X43,0X44,0X45,0X46,0X47,0X48,0X49,0X50,
		                                      0X51,0X52,0X53,0XA5};

#else
#define I2C_SLAVE_ADDR     0xA0  //ҪдI2Cӻ7λַ
#define I2C_SLAVE_ADDR10B  0xF6A0  //ҪдI2Cӻ10λַ
//ģʽҪд
#define BUFFER_SIZE_Write        64   //д64
uint8_t i2c_buffer_write[BUFFER_SIZE_Write] = {
								  0X5A,0X22,0X33,0X44,0X66,0X77,0X88,0X99,0XAA,0XBB,
								  0X01,0X02,0X03,0X04,0X05,0X06,0X07,0X08,0X09,0X10,
								  0X11,0X12,0X13,0X14,0X15,0X16,0X17,0X18,0X19,0X20,
								  0X21,0X22,0X23,0X24,0X25,0X26,0X27,0X28,0X29,0X30,
								  0X31,0X32,0X33,0X34,0X35,0X36,0X37,0X38,0X39,0X40,
								  0X41,0X42,0X43,0X44,0X45,0X46,0X47,0X48,0X49,0X50,
								  0X51,0X52,0X53,0XA5};


uint8_t i2c_Read_buffer[BUFFER_SIZE_Write];
#endif

//ʱ ֲvolatileܻᱻŻ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=2000;
		while(j--);
	}

}




/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
	/*ʼλGPIOx裬ʹGPIOxʱ*/
		GPIO_Reset(GPIOx);

	/*  PxyΪģʽ */
	GPIO_InitTypeDef GPIO_InitStructure;
	GPIO_Struct_Init(&GPIO_InitStructure);
	GPIO_InitStructure.m_Pin = GpioPin;
	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
	GPIO_Configuration(GPIOx,&GPIO_InitStructure);

	GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ

}



#if	IIC_MODE==MODE_Slave  //ӻģʽ
/**
  *    I2Cݽյ
  *    Rev_Temp:  8λ
  *    
  */
void I2C_receive_input(uint8_t Rev_Temp)
{
		if(I2C_RecNum < sizeof(i2c_buffer_read))
	   {
			i2c_buffer_read[I2C_RecNum] = Rev_Temp;
	        I2C_RecNum++;
	   }
}

/**
  *   ԱI2CǷƥ
  *    Rev_Temp:  8λ
  *    
  */
uint8_t I2C_Data_test(void)
{

	volatile uint16_t i;
    for(i = 0;i < BUFFER_SIZE_Read;i++)
    {
        if(i2c_buffer_read[i] != i2c_buffer_read_test[i])
        {
           return RESET;
        }
    }

    return SET;
}
#endif



//
void main()
{
	/*ûɲοKF32A151_demoʵʹI2Cӹܡ
	* ʹI2C1 PB1 PB2 ӻI2CͨšI2C_Master_Slave.h  궨 IIC_MODE ѡģʽӻģʽ
	* ܼ:	1.I2C Masterܣÿ80msӻ64ֽݣȷӦʱD4˸D4Ƴ
	* 			2.I2C Slaveܣ͹64ݶݶԱƥPB13תD4˸D4Ƴ
	* Ӳ˵ ʹKF32A151demoԽӣPB1PB1ԽӣPB2PB2Խӣ
	*           PB13ӦD4
	*           ҪôڽUSART0_RX PA0 	USART0_TX0	PA1  Usart.h ں궨Usart_Print  1
	*  ע  110λַʱҪעӻַĸλǵڶλ͵λЧ
	*
    */

	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ

	//ʼPB13Ϊߵƽ
	GPIO_Reset(GPIOB_SFR);
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_13);

	I2C_GPIO_init(); //I2C GPIOӳSCL:PB1   SDA:PB2


#if	IIC_MODE==MODE_Master // ģʽ
	I2C_init_Master(I2C1_SFR);  //I2C1ʼ
#else

#if IIC_10BIT_Address
	I2C_init_Slave(I2C1_SFR,I2C_SLAVE_ADDRESS10B);//I2C1 ӻ10λַ0XF6A0
#else
	I2C_init_Slave(I2C1_SFR,I2C_SLAVE_ADDRESS);//I2C1 ӻ7λַ0XA0
#endif
/********************I2Cж*****************/
			INT_Interrupt_Enable(INT_I2C1, TRUE);     //ʹI2C1 ж
			I2C_ISIE_INT_Enable(I2C1_SFR, TRUE);         //ʹI2Cж
			INT_All_Enable(TRUE);                     //ж
#endif

#if Usart_Print
	GPIO_USART();//USART0ӳ䣬	//USART0_RX		PA0  //USART0_TX0	PA1
	USART_Async_config(USART0_SFR);//ȫ˫첽8bit 9600
#endif
	while(1)
    {
#if	IIC_MODE==MODE_Master  //ģʽ
		delay_ms(200);
#if IIC_10BIT_Address
		I2C_Buffer_write(I2C_SLAVE_ADDR10B,i2c_buffer_write,sizeof(i2c_buffer_write));//I2C_SLAVE_ADDRд64
#else
		I2C_Buffer_write(I2C_SLAVE_ADDR,i2c_buffer_write,sizeof(i2c_buffer_write));//I2C_SLAVE_ADDRд64
#endif
		GPIO_Toggle_Output_Data_Config(GPIOB_SFR,GPIO_PIN_MASK_13);//PB13ת


#else     //ӻģʽ
#if Usart_Print
		//ڴӡյ
		USART_Send(USART0_SFR,i2c_buffer_read,sizeof(i2c_buffer_read));
#endif
		if(I2C_OK == I2C_Data_test())//ж϶I2CԤǷƥ䡣
		{
			GPIO_Toggle_Output_Data_Config(GPIOB_SFR,GPIO_PIN_MASK_13);//ƥPB13ת
			delay_ms(200);
		}

#endif

    }

}



/**
  *    У鷢ļ
  *    file: ָļƵָ
  *      line У
  *   ޡ
  */
void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

