/**
  ********************************************************************
  * ļ  Usart.c
  *      ChipON_AE/FAE_Group
  *     V2.1
  *     2019-11-16
  *     ļṩUsart GPIOʼUsartòUsartͺغ
  *
  *********************************************************************
*/
#include "system_init.h"
#include "Usart.h"
/**
  *    GPIOӳ
  *    
  *    
  */
void GPIO_USART(void)
{

	 /* ˿ӳAF5 */
	//USART0_RX		PA0
	//USART0_TX1	PA2
	GPIO_Write_Mode_Bits(GPIOA_SFR ,GPIO_PIN_MASK_0, GPIO_MODE_RMP);           //ӳIOڹģʽ
	GPIO_Write_Mode_Bits(GPIOA_SFR ,GPIO_PIN_MASK_2, GPIO_MODE_RMP);           //ӳIOڹģʽ
	GPIO_Pin_RMP_Config (GPIOA_SFR, GPIO_Pin_Num_0, GPIO_RMP_AF5_USART0);	   //ӳΪUSART0
	GPIO_Pin_RMP_Config (GPIOA_SFR, GPIO_Pin_Num_2, GPIO_RMP_AF5_USART0);      //ӳΪUSART0
	GPIO_Pin_Lock_Config (GPIOA_SFR ,GPIO_PIN_MASK_0, TRUE);                   //
	GPIO_Pin_Lock_Config (GPIOA_SFR ,GPIO_PIN_MASK_2, TRUE);                   //
}

/**
  *    ڷ
  *    USARTx:   ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *      Databuf   ָݵָ
  *      length      ͵ĳ
  *    
  */
void USART_Send(USART_SFRmap* USARTx, uint8_t* Databuf, uint32_t length)
{
	uint32_t i;
	for(i=0;i<length;i++)
	{
		//ڷ
		USART_SendData(USARTx,Databuf[i]);
		//ɱ־
		while(!USART_Get_Transmitter_Empty_Flag(USARTx));
	}
}


/**
  *   첽ȫ˫(Ĭ8bitշʹ  ȫ˫ 9600)
  *    ָUSARTڴṹָ룬ȡֵΪUSART0_SFR~USART8_SFR
  *    
  */
void USART_Async_config(USART_SFRmap *USARTx)
{
	USART_InitTypeDef USART_InitStructure;

	USART_Struct_Init(&USART_InitStructure);
    USART_InitStructure.m_Mode=USART_MODE_FULLDUPLEXASY;                        //ȫ˫
    USART_InitStructure.m_TransferDir=USART_DIRECTION_FULL_DUPLEX;              //䷽
    USART_InitStructure.m_WordLength=USART_WORDLENGTH_8B;                       //8λ
    USART_InitStructure.m_StopBits=USART_STOPBITS_1;                            //1λֹͣλ
    USART_InitStructure.m_BaudRateBRCKS=USART_CLK_HFCLK;                        //ڲƵʱΪ USARTʷʱ

    /*  =Fck/(16*z1+x/y)) ʱڲƵ16M*/
    //4800    z:208    x:0    y:0
    //9600    z:104    x:0    y:0
    //19200   z:52     x:0    y:0
    //115200  z:8      x:1    y:13
    //9600
    USART_InitStructure.m_BaudRateInteger=8;         //USARTzȡֵΪ0~65535
    USART_InitStructure.m_BaudRateNumerator=1;         //USARTСӲxȡֵΪ0~0xF
    USART_InitStructure.m_BaudRateDenominator=13;       //USARTСĸyȡֵΪ0~0xF

	USART_Reset(USARTx);                                       //USARTxλ
	USART_Configuration(USARTx,&USART_InitStructure);          //USARTx
	USART_Passageway_Select_Config(USARTx, USART_U7816R_PASSAGEWAY_TX1);
	USART_Clear_Transmit_BUFR_INT_Flag(USARTx);                //USARTxBUF
	USART_Cmd(USARTx,TRUE);                                    //USARTxʹ
}
