/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: EXTHLF
 *  :  V2.3
 *  :  20191116
 *   :  ChipON_AE/FAE_Group
 *     ļṩⲿӦ̲ο
 *
 ****************************************************************************************/
#include "system_init.h"
//ʱ ֲvolatileܻᱻŻ
void delay_ms(volatile uint32_t nms)
{
	volatile uint32_t i,j;
	for(i=0;i<nms;i++)
	{
		j=5000;
		while(j--);
	}

}



typedef enum
{
  LED0 = 0,
  LED1 = 1,
  LED2 = 2,

} Led_TypeDef;


#define LEDn                             3
#define LED0_PIN                         GPIO_PIN_MASK_13
#define LED0_GPIO_PORT                   GPIOB_SFR


#define LED1_PIN                         GPIO_PIN_MASK_9
#define LED1_GPIO_PORT                   GPIOB_SFR


#define LED2_PIN                         GPIO_PIN_MASK_10
#define LED2_GPIO_PORT                   GPIOB_SFR



GPIO_SFRmap* GPIO_PORT[LEDn] = {LED0_GPIO_PORT, LED1_GPIO_PORT, LED2_GPIO_PORT};
const uint16_t GPIO_PIN[LEDn] = {LED0_PIN, LED1_PIN, LED2_PIN};



/**
  *   LEDƹܺ
  *  : Led: LED0 LED1 LED2
  *
  *   ޡ
  */
void Demo_LEDOn(Led_TypeDef Led)
{
  GPIO_Set_Output_Data_Bits(GPIO_PORT[Led],GPIO_PIN[Led],Bit_SET);					//Ϊߵƽ
}

/**
  *   ϨLEDƹܺ
  *  : Led:  LED0 LED1 LED2  *
  *   ޡ
  */
void Demo_LEDOff(Led_TypeDef Led)
{
	GPIO_Set_Output_Data_Bits(GPIO_PORT[Led],GPIO_PIN[Led],Bit_RESET);				//Ϊ͵ƽ
}

/**
  *   DEMOLEDƳʼá
  *  : Led:  LED0 LED1 LED2
  *
  *   ޡ
  */
void Demo_LEDInit(Led_TypeDef Led)
{
    GPIO_InitTypeDef  GPIO_InitStructure;
    GPIO_Struct_Init(&GPIO_InitStructure);
  /* GPIO_LED  */
    GPIO_InitStructure.m_Pin = GPIO_PIN[Led];

	GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
	GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
	GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
	GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
    GPIO_Configuration(GPIO_PORT[Led], &GPIO_InitStructure);
}


/**
  *  ͹ĶʱT0ʱʱá
  *   Periodµֵȡֵ16λ
  *     PrescalerINTLFԤƵֵ
  *   ޡ
  */
void LPTIMER_T0_Config(uint32_t Period,uint32_t Prescaler)
{

	OSC_SCK_Source_Config(SCLK_SOURCE_INTHF);                 //ѡINTHFΪϵͳʱ

	OSC_Backup_Write_Read_Enable(TRUE);                       //ʹܱд

	PM_CCP0CLKLPEN_Enable(TRUE);                              //CCP0͹ʱʹ

	TIM_Reset(T0_SFR);										  //ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(T0_SFR,TRUE);			  //¿
	GPTIM_Updata_Enable(T0_SFR,TRUE);						  //øʹ
	GPTIM_Work_Mode_Config(T0_SFR,GPTIM_TIMER_MODE);		  //ʱģʽѡ
	GPTIM_Set_Counter(T0_SFR,0);							  //ʱֵ
	GPTIM_Set_Period(T0_SFR,Period);						  //ʱֵ
	GPTIM_Set_Prescaler(T0_SFR,Prescaler);				      //ʱԤƵֵ
	GPTIM_Counter_Mode_Config(T0_SFR,GPTIM_COUNT_UP_DOWN_OUF);//-¼,жϱ־
	GPTIM_Clock_Config(T0_SFR,GPTIM_LFCLK);					  //ѡLFCLKʱ

	INT_Interrupt_Priority_Config(INT_T0,4,0);				  //ռȼ4,ȼ0
	GPTIM_Overflow_INT_Enable(T0_SFR,TRUE);					  //жʹ
	INT_Interrupt_Enable(INT_T0,TRUE);						  //жʹ
	INT_Clear_Interrupt_Flag(INT_T0);						  //жϱ־
	GPTIM_Cmd(T0_SFR,TRUE);									  //ʱʹ
	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);			  //жԶջʹõֶ
	INT_All_Enable (TRUE);									  //ȫֿжʹ,жʹܿƲλ/NMI/Ӳж

	OSC_Backup_Write_Read_Enable(FALSE);                      //ֹд

	OSC_SCK_Source_Config(SCLK_SOURCE_PLL);                   //ѡPLLΪϵͳʱ


}

/**
  * description:EXTHF&EXTLF init config
  * in: none
  *
  * return: none
  */
void OSC_EXTHLF_Config(void)
{
	volatile unsigned int delay_C;
	/* enable INTLF  */
	OSC_INTLF_Software_Enable(TRUE);
	/* enable INTHF  */
	OSC_INTHF_Software_Enable(TRUE);  		  //INTHF need 200us starting time 
	FLASH_CFG = 0xC7;                         //Flash confige default setting 
    delay_C = 0xc8;
	while (delay_C--); //delay 200us
	OSC_SCK_Division_Config(SCLK_DIVISION_1); // clock division 1:1
	OSC_SCK_Source_Config(SCLK_SOURCE_INTHF); //slect INTHF to be system clock;
	while (OSC_Get_INTHF_INT_Flag() != SET);

	/* Config the BKP area is enable, BKP register and data can be write and read */
	SFR_SET_BIT_ASM(OSC_CTL0, OSC_CTL0_PMWREN_POS);  
	SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPREGCLR_POS);
	SFR_SET_BIT_ASM(PM_CTL0, PM_CTL0_BKPWR_POS);

	/************set OSCIN io to be low level signal ,improve EXTHF operation time***********/
    GPIO_Write_Mode_Bits(GPIOD_SFR, GPIO_PIN_MASK_9,GPIO_MODE_OUT);  //Set PD9 OUT 
	GPIO_Set_Output_Data_Bits(GPIOD_SFR,GPIO_PIN_MASK_9,Bit_RESET);	 //Set PD9 OUT LOW
	delay_C = 0xc8;
	while (delay_C--); //delay 200us
	/************over***********/

	GPIO_Write_Mode_Bits(GPIOD_SFR, GPIO_PIN_MASK_9,GPIO_MODE_AN);  //Set PD9 anloge mode in
	OSC_High_Speed_Enable (1);  //osc<20Mhz;OSC_HFOSCCAL1_HSFSEN=1;
	PM_EXTHF_PIN_Selection_Config(PM_EXTHF_PIN2_IO_PORT); //slect PD9/PD10 OSC IO;
	OSC_EXTHF_Software_Enable(TRUE); //enable EXTHF 
	OSC_EXTHF_Start_Delay_Config(EXT_START_DELAY_256);   //EXTHF start delay cycle;at lest 256
	
	/************add soft delay 4ms***********/
	delay_C = 0xA39;
	while (delay_C--); 
	while(OSC_Get_EXTHF_INT_Flag() != SET);    //wait EXTHF Flag
	/************over***********/
	
	/************system clock must be PLL clock source!!!!***********/
	OSC_SCK_Source_Config(SCLK_SOURCE_EXTHF);  //slect EXTHF to be system clock;
    OSC_PLL_Input_Source_Config(PLL_INPUT_EXTHF);        //slect EXTHF(16M) to be PLL clock;
    /************system clock must be PLL clock source!!!!***********/

	/* PLL frequency multiplier clock */
    OSC_PLL_Multiple_Value_Select(30,2,2);               //120MHZ

	OSC_PLL_Start_Delay_Config(PLL_START_DELAY_8192);
	OSC_PLL_Software_Enable(TRUE);
	OSC_PLL_RST();
	delay_C = 0x27f;
	while (delay_C--) ; //wait 1ms   
	while (OSC_Get_PLL_INT_Flag() != SET);
	/* system clock */
	OSC_SCK_Division_Config(SCLK_DIVISION_1);   //DIVISION 1:1
	OSC_SCK_Source_Config(SCLK_SOURCE_PLL);     //slect PLL to be system clock

	OSC_Clock_Failure_Check_Enable(TRUE);       //enable osc clock failure check;

	/* peripheral clock ;HFCLK*/
	OSC_HFCK_Division_Config(HFCK_DIVISION_1);
	OSC_HFCK_Source_Config(HFCK_SOURCE_EXTHF);    //slect EXTHF to be HFCLK
	OSC_HFCK_Enable(TRUE);                        //enable HFCLK

	PM_EXTLF_PIN_Selection_Config(PM_EXTLF_PIN2_IO_PORT);
	OSC_EXTLF_Software_Enable(TRUE);
	OSC_EXTLF_Start_Delay_Config(EXT_START_DELAY_256);

	OSC_LFCK_Division_Config(LFCK_DIVISION_1);	// Low  frequency LFCK DIVISIN 1:1 
	OSC_LFCK_Source_Config (LFCK_INPUT_EXTLF);  //slect EXTLF to be LFCLK
	OSC_LFCK_Enable (TRUE);					    //enable LFCLK


	OSC_SCLK_Output_Division_Config(SCLK_DIVISION_128);					//DIVISION 1/128
	OSC_SCLK_Output_Enable(TRUE);										//system clock out 
	GPIO_Write_Mode_Bits(GPIOA_SFR,GPIO_PIN_MASK_0,GPIO_MODE_RMP);      //PA0 mask map 
	GPIO_Pin_RMP_Config(GPIOA_SFR,GPIO_Pin_Num_0,GPIO_RMP_AF0_SYSTEM);	//output system clock from PA0 

}

//
void main()
{
	/*ûɲοKF32A151_demoʵⲿƵƵùܡ
	 * ʹⲿ16MΪϵͳʱԴⲿ32.768KHZΪͨöʱT0ʱԴ
	 * ʱT01һж
	 * PB13ӦD4ʱѭأD4˸
	 * ͬʱⲿʱӹϼһйϵͳԶлڲʱӣϵͳ
	 *
	 * ע:Ҫʹܱ򣬲ñ˸λ״̬ʹⲿӦá
	 */
	/*ⲿƵƵ*/
	OSC_EXTHLF_Config();  //ⲿ ƵƵãʱó120MHZ

	GPIO_Reset(GPIOB_SFR);//λGPIOBʹGPIOBʱ
	Demo_LEDInit(LED0);
	//͹Ķʱֵ
	LPTIMER_T0_Config(512,63); //ʱԴ32.768KHZ, ԤƵֵ1:64   512HZ512Σ1һж
	while(1)
	{
		Demo_LEDOn(LED0);
		delay_ms(1000);
		Demo_LEDOff(LED0);
		delay_ms(1000);
	}

}



void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

