/****************************************************************************************
 *
 * ļ: main.c
 * Ŀ: GPTimeBase_T1GT3
 *  :  V2.3
 *  :  20191116
 *     ChipON_AE/FAE_Group
 *     ļṩʵͨöʱʹһͨöʱĹòο̡
 *
 ****************************************************************************************/
#include "system_init.h"
/**
  *   GPIOx ʼá
  *  : GPIOx: ָGPIOڴṹָ룬ȡֵΪGPIOA_SFR~GPIOH_SFR
  *       GpioPin: ˿룬ȡֵΪGPIO_PIN_MASK_0~GPIO_PIN_MASK_15еһϡ
  *   ޡ
  */
void GPIOInit_Output_Config(GPIO_SFRmap* GPIOx,uint16_t GpioPin)
{
		/*ʼλGPIOx裬ʹGPIOxʱ*/
			GPIO_Reset(GPIOx);

		/*  PxyΪģʽ */
		GPIO_InitTypeDef GPIO_InitStructure;
		GPIO_Struct_Init(&GPIO_InitStructure);
		GPIO_InitStructure.m_Pin = GpioPin;
		GPIO_InitStructure.m_Speed = GPIO_LOW_SPEED;          //ʼ GPIOٶ
		GPIO_InitStructure.m_Mode = GPIO_MODE_OUT;            //ʼ GPIOΪ
		GPIO_InitStructure.m_PullUp = GPIO_NOPULL;            //ʼ GPIOǷ
		GPIO_InitStructure.m_PullDown = GPIO_NOPULL;          //ʼ GPIOǷ
		GPIO_Configuration(GPIOx,&GPIO_InitStructure);

		GPIO_Set_Output_Data_Bits(GPIOx,GpioPin,Bit_SET);	  //Ϊߵƽ
}



/**
  *   ʱʼùܡ
  *  : GPTIMx:  ȡֵT0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR/T18_SFR/
  *                       T19_SFR/T20_SFR/T21_SFR/T19_SFR/T22_SFR/T23_SFR
  *    Peripheral:  ȡֵöInterruptIndexежš
  *   ޡ
  * עʱѡģʽ
  */
void GPTime_Master(GPTIM_SFRmap* GPTIMx,InterruptIndex Peripheral)
{
	//------------------------ʱ -----------------------------//

	TIM_Reset(GPTIMx);													//ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(GPTIMx,TRUE);						//¿
	GPTIM_Updata_Enable(GPTIMx,TRUE);									//øʹ

	GPTIM_Master_Mode_Config(GPTIMx,GPTIM_MASTER_TXEN_SIGNAL);			//ģʽóTXENΪ

	GPTIM_Master_Slave_Snyc_Config(GPTIMx,TRUE);						//ͬ
	GPTIM_Work_Mode_Config(GPTIMx,GPTIM_TIMER_MODE);					//ʱģʽѡ
	GPTIM_Set_Counter(GPTIMx,0);										//ʱֵ
	GPTIM_Set_Period(GPTIMx,65535);								    	//ʱֵ
	GPTIM_Set_Prescaler(GPTIMx,11);									    //ʱԤƵֵ
	GPTIM_Counter_Mode_Config(GPTIMx,GPTIM_COUNT_UP_DOWN_OUF);			//-¼,жϱ־
	GPTIM_Clock_Config(GPTIMx,GPTIM_HFCLK);								//ѡƵʱ
	GPTIM_Overflow_INT_Enable(GPTIMx,TRUE);                             //ʹж
	GPTIM_Cmd(GPTIMx,TRUE);												//ʱʹ

	INT_Interrupt_Priority_Config(Peripheral,4,0);					    //ռȼ4,ȼ0
	INT_Interrupt_Enable(Peripheral,TRUE);								//жʹ
	INT_Clear_Interrupt_Flag(Peripheral);								//жϱ־


}

/**
  *   Ӷʱʼùܡ
  *  :  GPTIMx:  ȡֵT0_SFR/T1_SFR/T2_SFR/T3_SFR/T4_SFR/T18_SFR/
  *                       T19_SFR/T20_SFR/T21_SFR/T19_SFR/T22_SFR/T23_SFR
  *    Peripheral: ȡֵöInterruptIndexежš
  * TriggerSelectԴѡ
  *   ޡ
  * עӶʱѡſģʽ
  */
void GPTime_Slave(GPTIM_SFRmap* GPTIMx,InterruptIndex Peripheral,FunctionalState TriggerSelect)
{
	//------------------------Ӷʱ -----------------------------//
	TIM_Reset(GPTIMx);													//ʱ踴λʹʱ
	GPTIM_Updata_Immediately_Config(GPTIMx,TRUE);						//¿
	GPTIM_Updata_Enable(GPTIMx,TRUE);									//øʹ

	GPTIM_Work_Mode_Config(GPTIMx,GPTIM_TIMER_MODE);					//ʱģʽѡ
	GPTIM_Trigger_Select_Config(GPTIMx,TriggerSelect);			        //Դѡ
	GPTIM_Slave_Mode_Config(GPTIMx,GPTIM_SLAVE_GATED_MODE);				//ѡ񴥷ģʽſģʽ

	GPTIM_Master_Slave_Snyc_Config(GPTIMx,TRUE);						//ͬ
	GPTIM_Set_Counter(GPTIMx,0);										//ʱֵ
	GPTIM_Set_Period(GPTIMx,50000);									    //ʱֵ
	GPTIM_Set_Prescaler(GPTIMx,119);									//ʱԤƵֵ120
	GPTIM_Counter_Mode_Config(GPTIMx,GPTIM_COUNT_UP_OF);			    //ϼ,жϱ־
	GPTIM_Clock_Config(GPTIMx,GPTIM_HFCLK);								//ѡSCLKʱ

	GPTIM_Overflow_INT_Enable(GPTIMx,TRUE);								//жʹ
	INT_Interrupt_Enable(Peripheral,TRUE);								//жʹ
	INT_Clear_Interrupt_Flag(Peripheral);								//жϱ־
	INT_Interrupt_Priority_Config(Peripheral,5,0);						//ռȼ5,ȼ0
	GPTIM_Cmd(GPTIMx,TRUE);												//ʱʹ

	INT_Stack_Align_Config(INT_STACK_SINGLE_ALIGN);						//жԶջʹõֶ
	INT_All_Enable (TRUE);                                              //ж
}


//
void main()
{
	/*ûɲοKF32A151_demoʵʹһʱʹһʱ
	 * жʱT1ΪģʽʹܴʱT3
	 * T1ã/ʱT1ʹʱ120MΪƵʱӣ112Ƶ0.1usһΣ65536ſģʽʹT3
	 * T3ã/ʱT3ʹʱ120MΪƵʱӣ1120Ƶ1usһΣ5000050msһж
	 * PB13תD4400mS˸
	 *
	 *
     */
	//ϵͳʱ120M,Ƶʱ16M
	SystemInit();//ϵͳʱӳʼ
	/*PB13ʼΪߵƽ*/
	GPIOInit_Output_Config(GPIOB_SFR,GPIO_PIN_MASK_13);
	GPTime_Master(T1_SFR,INT_T1);//T1Ϊģʽ
    GPTime_Slave(T3_SFR,INT_T3,GPTIM_TRIGGER_T1);//T3ΪģʽѡT1Ϊʹź

    while(1)
    {
    }

}




void check_failed(uint8_t* file, uint32_t line)
{
	  /* ûԼĴʵֱļк,
	             : printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

	  while(1)
	  {
		  ;
	  }
}

