/************************************************************
*       Header file for the KungFu32  C
*       *       Microcontroller
*
*       Copyright 2012-2020 ChipON, All rights reserved
*************************************************************/

#ifndef  _KF32R2ALLOVER_H_
#define  _KF32R2ALLOVER_H_

struct all_bit{
		unsigned int _b0:1;
		unsigned int _b1:1;
		unsigned int _b2:1;
		unsigned int _b3:1;
		unsigned int _b4:1;
		unsigned int _b5:1;
		unsigned int _b6:1;
		unsigned int _b7:1;
		unsigned int _b8:1;
		unsigned int _b9:1;
		unsigned int _b10:1;
		unsigned int _b11:1;
		unsigned int _b12:1;
		unsigned int _b13:1;
		unsigned int _b14:1;
		unsigned int _b15:1;
		unsigned int _b16:1;
		unsigned int _b17:1;
		unsigned int _b18:1;
		unsigned int _b19:1;
		unsigned int _b20:1;
		unsigned int _b21:1;
		unsigned int _b22:1;
		unsigned int _b23:1;
		unsigned int _b24:1;
		unsigned int _b25:1;
		unsigned int _b26:1;
		unsigned int _b27:1;
		unsigned int _b28:1;
		unsigned int _b29:1;
		unsigned int _b30:1;
		unsigned int _b31:1;
};
// modelOSC

/** 0x4000 0000 OSC_CTL0 **/
union OSC_CTL0_REG{
	unsigned int reg;
	struct OSC_CTL0_BITS{
		unsigned int _PMWREN:1;
		unsigned int _SCKS:3;
		unsigned int _LFCKEN:1;
		unsigned int :1;
		unsigned int _LFCKS:1;
		unsigned int :1;
		unsigned int _HFCKEN:1;
		unsigned int _HFCKS:3;
		unsigned int _PLLCKS:1;
		unsigned int :3;
		unsigned int _SCKDIV:3;
		unsigned int :1;
		unsigned int _HFCKDIV:4;
		unsigned int _LFCKDIV:3;
		unsigned int :1;
		unsigned int _PLLDIV:1;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL0 (*((volatile union OSC_CTL0_REG *)0x40000000))
// model

/** 0x4000 0004 OSC_CTL1 **/
union OSC_CTL1_REG{
	unsigned int reg;
	struct OSC_CTL1_BITS{
		unsigned int :16;
		unsigned int _FSCM:1;
		unsigned int _FSCMGAP:3;
		unsigned int :1;
		unsigned int _FSCMS:3;
		unsigned int :1;
		unsigned int _CLKOUTS:3;
		unsigned int _CLKOE:1;
		unsigned int _CLKOUTDIV:3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL1 (*((volatile union OSC_CTL1_REG *)0x40000004))
// model

/** 0x4000 0008 OSC_INT **/
union OSC_INT_REG{
	unsigned int reg;
	struct OSC_INT_BITS{
		unsigned int _ILFIF:1;
		unsigned int _IHFIF:1;
		unsigned int _ELFIF:1;
		unsigned int _EHFIF:1;
		unsigned int _PLLIF:1;
		unsigned int :1;
		unsigned int _LP4MIF:1;
		unsigned int _CKFIF:1;
		unsigned int _ILFIE:1;
		unsigned int _IHFIE:1;
		unsigned int _ELFIE:1;
		unsigned int _EHFIE:1;
		unsigned int _PLLIE:1;
		unsigned int :1;
		unsigned int _LP4MIE:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_INT (*((volatile union OSC_INT_REG *)0x40000008))
// model

/** 0x4000 000C OSC_CTL2 **/
union OSC_CTL2_REG{
	unsigned int reg;
	struct OSC_CTL2_BITS{
		unsigned int _INTLFSWEN:1;
		unsigned int _INTHFSWEN:1;
		unsigned int _EXTLFSWEN:1;
		unsigned int _EXTHFSWEN:1;
		unsigned int _PLLSWEN:1;
		unsigned int :1;
		unsigned int _LP4MSWEN:1;
		unsigned int :1;
		unsigned int _ILFDLY:4;
		unsigned int _IHFDLY:4;
		unsigned int _ELFDLY:4;
		unsigned int _EHFDLY:4;
		unsigned int _PLLDLY:4;
		unsigned int _LPCKDLY:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OSC_CTL2 (*((volatile union OSC_CTL2_REG *)0x4000000C))
// modelQEI1

/** 0x4000 0080 QEI1_CTL0 **/
union QEI1_CTL0_REG{
	unsigned int reg;
	struct QEI1_CTL0_BITS{
		unsigned int _TXDIR:1;
		unsigned int _TXDIROUT:1;
		unsigned int _INDEX:1;
		unsigned int _TXCS:1;
		unsigned int _INDRES:1;
		unsigned int _QEIMOD:3;
		unsigned int _CNTERRIF:1;
		unsigned int _PHEIF:1;
		unsigned int _TXIF:1;
		unsigned int _LPCLK:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI1_CTL0 (*((volatile union QEI1_CTL0_REG *)0x40000080))
// model

/** 0x4000 0084 QEI1_CTL1 **/
union QEI1_CTL1_REG{
	unsigned int reg;
	struct QEI1_CTL1_BITS{
		unsigned int _SWPAB:1;
		unsigned int _QEICK:3;
		unsigned int _QEIOUT:1;
		unsigned int _QEICLK:2;
		unsigned int _MODEN:1;
		unsigned int _PHDFEN:1;
		unsigned int _PHSEL:4;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI1_CTL1 (*((volatile union QEI1_CTL1_REG *)0x40000084))
// modelT8

/** 0x4000 0088 T8_CNT **/
union T8_CNT_REG{
	unsigned int reg;
	struct T8_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T8_CNT (*((volatile union T8_CNT_REG *)0x40000088))
// model

/** 0x4000 008C T8_PPX **/
union T8_PPX_REG{
	unsigned int reg;
	struct T8_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T8_PPX (*((volatile union T8_PPX_REG *)0x4000008C))
// model

/** 0x4000 0090 T8_PRSC **/
union T8_PRSC_REG{
	unsigned int reg;
	struct T8_PRSC_BITS{
		unsigned int _TXPRSC:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T8_PRSC (*((volatile union T8_PRSC_REG *)0x40000090))
// modelQEI1

/** 0x4000 0094 QEI1_DIER **/
union QEI1_DIER_REG{
	unsigned int reg;
	struct QEI1_DIER_BITS{
		unsigned int _CNTERRIE:1;
		unsigned int _PHEIE:1;
		unsigned int _TXIE:1;
		unsigned int _CNTERRIC:1;
		unsigned int _PHEIC:1;
		unsigned int _TXIC:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI1_DIER (*((volatile union QEI1_DIER_REG *)0x40000094))
// modelT1

/** 0x4000 0100 T1_CNT **/
union T1_CNT_REG{
	unsigned int reg;
	struct T1_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CNT (*((volatile union T1_CNT_REG *)0x40000100))
// model

/** 0x4000 0104 T1_CTL1 **/
union T1_CTL1_REG{
	unsigned int reg;
	struct T1_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CTL1 (*((volatile union T1_CTL1_REG *)0x40000104))
// model

/** 0x4000 0108 T1_CTL2 **/
union T1_CTL2_REG{
	unsigned int reg;
	struct T1_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_CTL2 (*((volatile union T1_CTL2_REG *)0x40000108))
// model

/** 0x4000 010C T1_PRSC **/
union T1_PRSC_REG{
	unsigned int reg;
	struct T1_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_PRSC (*((volatile union T1_PRSC_REG *)0x4000010C))
// model

/** 0x4000 0110 T1_PPX **/
union T1_PPX_REG{
	unsigned int reg;
	struct T1_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_PPX (*((volatile union T1_PPX_REG *)0x40000110))
// model

/** 0x4000 0114 T1_UDTIMx **/
union T1_UDTIMx_REG{
	unsigned int reg;
	struct T1_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T1_UDTIMx (*((volatile union T1_UDTIMx_REG *)0x40000114))
// modelCCP1

/** 0x4000 0120 CCP1_C1 **/
union CCP1_C1_REG{
	unsigned int reg;
	struct CCP1_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C1 (*((volatile union CCP1_C1_REG *)0x40000120))
// model

/** 0x4000 0124 CCP1_C2 **/
union CCP1_C2_REG{
	unsigned int reg;
	struct CCP1_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C2 (*((volatile union CCP1_C2_REG *)0x40000124))
// model

/** 0x4000 0128 CCP1_C3 **/
union CCP1_C3_REG{
	unsigned int reg;
	struct CCP1_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C3 (*((volatile union CCP1_C3_REG *)0x40000128))
// model

/** 0x4000 012C CCP1_C4 **/
union CCP1_C4_REG{
	unsigned int reg;
	struct CCP1_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_C4 (*((volatile union CCP1_C4_REG *)0x4000012C))
// model

/** 0x4000 0130 CCP1_SRIC **/
union CCP1_SRIC_REG{
	unsigned int reg;
	struct CCP1_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_SRIC (*((volatile union CCP1_SRIC_REG *)0x40000130))
// model

/** 0x4000 0134 CCP1_DF **/
union CCP1_DF_REG{
	unsigned int reg;
	struct CCP1_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_DF (*((volatile union CCP1_DF_REG *)0x40000134))
// model

/** 0x4000 0140 CCP1_CTL1 **/
union CCP1_CTL1_REG{
	unsigned int reg;
	struct CCP1_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL1 (*((volatile union CCP1_CTL1_REG *)0x40000140))
// model

/** 0x4000 0144 CCP1_R1 **/
union CCP1_R1_REG{
	unsigned int reg;
	struct CCP1_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R1 (*((volatile union CCP1_R1_REG *)0x40000144))
// model

/** 0x4000 0148 CCP1_R2 **/
union CCP1_R2_REG{
	unsigned int reg;
	struct CCP1_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R2 (*((volatile union CCP1_R2_REG *)0x40000148))
// model

/** 0x4000 014C CCP1_R3 **/
union CCP1_R3_REG{
	unsigned int reg;
	struct CCP1_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R3 (*((volatile union CCP1_R3_REG *)0x4000014C))
// model

/** 0x4000 0150 CCP1_R4 **/
union CCP1_R4_REG{
	unsigned int reg;
	struct CCP1_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_R4 (*((volatile union CCP1_R4_REG *)0x40000150))
// model

/** 0x4000 0154 CCP1_CTL2 **/
union CCP1_CTL2_REG{
	unsigned int reg;
	struct CCP1_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL2 (*((volatile union CCP1_CTL2_REG *)0x40000154))
// model

/** 0x4000 0158 CCP1_CTL3 **/
union CCP1_CTL3_REG{
	unsigned int reg;
	struct CCP1_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_CTL3 (*((volatile union CCP1_CTL3_REG *)0x40000158))
// model

/** 0x4000 015C CCP1_EGIF **/
union CCP1_EGIF_REG{
	unsigned int reg;
	struct CCP1_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP1_EGIF (*((volatile union CCP1_EGIF_REG *)0x4000015C))
// modelT2

/** 0x4000 0180 T2_CNT **/
union T2_CNT_REG{
	unsigned int reg;
	struct T2_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CNT (*((volatile union T2_CNT_REG *)0x40000180))
// model

/** 0x4000 0184 T2_CTL1 **/
union T2_CTL1_REG{
	unsigned int reg;
	struct T2_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CTL1 (*((volatile union T2_CTL1_REG *)0x40000184))
// model

/** 0x4000 0188 T2_CTL2 **/
union T2_CTL2_REG{
	unsigned int reg;
	struct T2_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_CTL2 (*((volatile union T2_CTL2_REG *)0x40000188))
// model

/** 0x4000 018C T2_PRSC **/
union T2_PRSC_REG{
	unsigned int reg;
	struct T2_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_PRSC (*((volatile union T2_PRSC_REG *)0x4000018C))
// model

/** 0x4000 0190 T2_PPX **/
union T2_PPX_REG{
	unsigned int reg;
	struct T2_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_PPX (*((volatile union T2_PPX_REG *)0x40000190))
// model

/** 0x4000 0194 T2_UDTIMx **/
union T2_UDTIMx_REG{
	unsigned int reg;
	struct T2_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T2_UDTIMx (*((volatile union T2_UDTIMx_REG *)0x40000194))
// modelCCP2

/** 0x4000 01A0 CCP2_C1 **/
union CCP2_C1_REG{
	unsigned int reg;
	struct CCP2_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C1 (*((volatile union CCP2_C1_REG *)0x400001A0))
// model

/** 0x4000 01A4 CCP2_C2 **/
union CCP2_C2_REG{
	unsigned int reg;
	struct CCP2_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C2 (*((volatile union CCP2_C2_REG *)0x400001A4))
// model

/** 0x4000 01A8 CCP2_C3 **/
union CCP2_C3_REG{
	unsigned int reg;
	struct CCP2_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C3 (*((volatile union CCP2_C3_REG *)0x400001A8))
// model

/** 0x4000 01AC CCP2_C4 **/
union CCP2_C4_REG{
	unsigned int reg;
	struct CCP2_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_C4 (*((volatile union CCP2_C4_REG *)0x400001AC))
// model

/** 0x4000 01B0 CCP2_SRIC **/
union CCP2_SRIC_REG{
	unsigned int reg;
	struct CCP2_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_SRIC (*((volatile union CCP2_SRIC_REG *)0x400001B0))
// model

/** 0x4000 01B4 CCP2_DF **/
union CCP2_DF_REG{
	unsigned int reg;
	struct CCP2_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_DF (*((volatile union CCP2_DF_REG *)0x400001B4))
// model

/** 0x4000 01C0 CCP2_CTL1 **/
union CCP2_CTL1_REG{
	unsigned int reg;
	struct CCP2_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL1 (*((volatile union CCP2_CTL1_REG *)0x400001C0))
// model

/** 0x4000 01C4 CCP2_R1 **/
union CCP2_R1_REG{
	unsigned int reg;
	struct CCP2_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R1 (*((volatile union CCP2_R1_REG *)0x400001C4))
// model

/** 0x4000 01C8 CCP2_R2 **/
union CCP2_R2_REG{
	unsigned int reg;
	struct CCP2_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R2 (*((volatile union CCP2_R2_REG *)0x400001C8))
// model

/** 0x4000 01CC CCP2_R3 **/
union CCP2_R3_REG{
	unsigned int reg;
	struct CCP2_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R3 (*((volatile union CCP2_R3_REG *)0x400001CC))
// model

/** 0x4000 01D0 CCP2_R4 **/
union CCP2_R4_REG{
	unsigned int reg;
	struct CCP2_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_R4 (*((volatile union CCP2_R4_REG *)0x400001D0))
// model

/** 0x4000 01D4 CCP2_CTL2 **/
union CCP2_CTL2_REG{
	unsigned int reg;
	struct CCP2_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL2 (*((volatile union CCP2_CTL2_REG *)0x400001D4))
// model

/** 0x4000 01D8 CCP2_CTL3 **/
union CCP2_CTL3_REG{
	unsigned int reg;
	struct CCP2_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_CTL3 (*((volatile union CCP2_CTL3_REG *)0x400001D8))
// model

/** 0x4000 01DC CCP2_EGIF **/
union CCP2_EGIF_REG{
	unsigned int reg;
	struct CCP2_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP2_EGIF (*((volatile union CCP2_EGIF_REG *)0x400001DC))
// modelT3

/** 0x4000 0200 T3_CNT **/
union T3_CNT_REG{
	unsigned int reg;
	struct T3_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CNT (*((volatile union T3_CNT_REG *)0x40000200))
// model

/** 0x4000 0204 T3_CTL1 **/
union T3_CTL1_REG{
	unsigned int reg;
	struct T3_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CTL1 (*((volatile union T3_CTL1_REG *)0x40000204))
// model

/** 0x4000 0208 T3_CTL2 **/
union T3_CTL2_REG{
	unsigned int reg;
	struct T3_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_CTL2 (*((volatile union T3_CTL2_REG *)0x40000208))
// model

/** 0x4000 020C T3_PRSC **/
union T3_PRSC_REG{
	unsigned int reg;
	struct T3_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_PRSC (*((volatile union T3_PRSC_REG *)0x4000020C))
// model

/** 0x4000 0210 T3_PPX **/
union T3_PPX_REG{
	unsigned int reg;
	struct T3_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_PPX (*((volatile union T3_PPX_REG *)0x40000210))
// model

/** 0x4000 0214 T3_UDTIMx **/
union T3_UDTIMx_REG{
	unsigned int reg;
	struct T3_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T3_UDTIMx (*((volatile union T3_UDTIMx_REG *)0x40000214))
// modelCCP3

/** 0x4000 0220 CCP3_C1 **/
union CCP3_C1_REG{
	unsigned int reg;
	struct CCP3_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C1 (*((volatile union CCP3_C1_REG *)0x40000220))
// model

/** 0x4000 0224 CCP3_C2 **/
union CCP3_C2_REG{
	unsigned int reg;
	struct CCP3_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C2 (*((volatile union CCP3_C2_REG *)0x40000224))
// model

/** 0x4000 0228 CCP3_C3 **/
union CCP3_C3_REG{
	unsigned int reg;
	struct CCP3_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C3 (*((volatile union CCP3_C3_REG *)0x40000228))
// model

/** 0x4000 022C CCP3_C4 **/
union CCP3_C4_REG{
	unsigned int reg;
	struct CCP3_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_C4 (*((volatile union CCP3_C4_REG *)0x4000022C))
// model

/** 0x4000 0230 CCP3_SRIC **/
union CCP3_SRIC_REG{
	unsigned int reg;
	struct CCP3_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_SRIC (*((volatile union CCP3_SRIC_REG *)0x40000230))
// model

/** 0x4000 0234 CCP3_DF **/
union CCP3_DF_REG{
	unsigned int reg;
	struct CCP3_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_DF (*((volatile union CCP3_DF_REG *)0x40000234))
// model

/** 0x4000 0240 CCP3_CTL1 **/
union CCP3_CTL1_REG{
	unsigned int reg;
	struct CCP3_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL1 (*((volatile union CCP3_CTL1_REG *)0x40000240))
// model

/** 0x4000 0244 CCP3_R1 **/
union CCP3_R1_REG{
	unsigned int reg;
	struct CCP3_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R1 (*((volatile union CCP3_R1_REG *)0x40000244))
// model

/** 0x4000 0248 CCP3_R2 **/
union CCP3_R2_REG{
	unsigned int reg;
	struct CCP3_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R2 (*((volatile union CCP3_R2_REG *)0x40000248))
// model

/** 0x4000 024C CCP3_R3 **/
union CCP3_R3_REG{
	unsigned int reg;
	struct CCP3_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R3 (*((volatile union CCP3_R3_REG *)0x4000024C))
// model

/** 0x4000 0250 CCP3_R4 **/
union CCP3_R4_REG{
	unsigned int reg;
	struct CCP3_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_R4 (*((volatile union CCP3_R4_REG *)0x40000250))
// model

/** 0x4000 0254 CCP3_CTL2 **/
union CCP3_CTL2_REG{
	unsigned int reg;
	struct CCP3_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL2 (*((volatile union CCP3_CTL2_REG *)0x40000254))
// model

/** 0x4000 0258 CCP3_CTL3 **/
union CCP3_CTL3_REG{
	unsigned int reg;
	struct CCP3_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_CTL3 (*((volatile union CCP3_CTL3_REG *)0x40000258))
// model

/** 0x4000 025C CCP3_EGIF **/
union CCP3_EGIF_REG{
	unsigned int reg;
	struct CCP3_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP3_EGIF (*((volatile union CCP3_EGIF_REG *)0x4000025C))
// modelT4

/** 0x4000 0280 T4_CNT **/
union T4_CNT_REG{
	unsigned int reg;
	struct T4_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CNT (*((volatile union T4_CNT_REG *)0x40000280))
// model

/** 0x4000 0284 T4_CTL1 **/
union T4_CTL1_REG{
	unsigned int reg;
	struct T4_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CTL1 (*((volatile union T4_CTL1_REG *)0x40000284))
// model

/** 0x4000 0288 T4_CTL2 **/
union T4_CTL2_REG{
	unsigned int reg;
	struct T4_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_CTL2 (*((volatile union T4_CTL2_REG *)0x40000288))
// model

/** 0x4000 028C T4_PRSC **/
union T4_PRSC_REG{
	unsigned int reg;
	struct T4_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_PRSC (*((volatile union T4_PRSC_REG *)0x4000028C))
// model

/** 0x4000 0290 T4_PPX **/
union T4_PPX_REG{
	unsigned int reg;
	struct T4_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_PPX (*((volatile union T4_PPX_REG *)0x40000290))
// model

/** 0x4000 0294 T4_UDTIMx **/
union T4_UDTIMx_REG{
	unsigned int reg;
	struct T4_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T4_UDTIMx (*((volatile union T4_UDTIMx_REG *)0x40000294))
// modelCCP4

/** 0x4000 02A0 CCP4_C1 **/
union CCP4_C1_REG{
	unsigned int reg;
	struct CCP4_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C1 (*((volatile union CCP4_C1_REG *)0x400002A0))
// model

/** 0x4000 02A4 CCP4_C2 **/
union CCP4_C2_REG{
	unsigned int reg;
	struct CCP4_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C2 (*((volatile union CCP4_C2_REG *)0x400002A4))
// model

/** 0x4000 02A8 CCP4_C3 **/
union CCP4_C3_REG{
	unsigned int reg;
	struct CCP4_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C3 (*((volatile union CCP4_C3_REG *)0x400002A8))
// model

/** 0x4000 02AC CCP4_C4 **/
union CCP4_C4_REG{
	unsigned int reg;
	struct CCP4_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_C4 (*((volatile union CCP4_C4_REG *)0x400002AC))
// model

/** 0x4000 02B0 CCP4_SRIC **/
union CCP4_SRIC_REG{
	unsigned int reg;
	struct CCP4_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_SRIC (*((volatile union CCP4_SRIC_REG *)0x400002B0))
// model

/** 0x4000 02B4 CCP4_DF **/
union CCP4_DF_REG{
	unsigned int reg;
	struct CCP4_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_DF (*((volatile union CCP4_DF_REG *)0x400002B4))
// model

/** 0x4000 02C0 CCP4_CTL1 **/
union CCP4_CTL1_REG{
	unsigned int reg;
	struct CCP4_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL1 (*((volatile union CCP4_CTL1_REG *)0x400002C0))
// model

/** 0x4000 02C4 CCP4_R1 **/
union CCP4_R1_REG{
	unsigned int reg;
	struct CCP4_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R1 (*((volatile union CCP4_R1_REG *)0x400002C4))
// model

/** 0x4000 02C8 CCP4_R2 **/
union CCP4_R2_REG{
	unsigned int reg;
	struct CCP4_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R2 (*((volatile union CCP4_R2_REG *)0x400002C8))
// model

/** 0x4000 02CC CCP4_R3 **/
union CCP4_R3_REG{
	unsigned int reg;
	struct CCP4_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R3 (*((volatile union CCP4_R3_REG *)0x400002CC))
// model

/** 0x4000 02D0 CCP4_R4 **/
union CCP4_R4_REG{
	unsigned int reg;
	struct CCP4_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_R4 (*((volatile union CCP4_R4_REG *)0x400002D0))
// model

/** 0x4000 02D4 CCP4_CTL2 **/
union CCP4_CTL2_REG{
	unsigned int reg;
	struct CCP4_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL2 (*((volatile union CCP4_CTL2_REG *)0x400002D4))
// model

/** 0x4000 02D8 CCP4_CTL3 **/
union CCP4_CTL3_REG{
	unsigned int reg;
	struct CCP4_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_CTL3 (*((volatile union CCP4_CTL3_REG *)0x400002D8))
// model

/** 0x4000 02DC CCP4_EGIF **/
union CCP4_EGIF_REG{
	unsigned int reg;
	struct CCP4_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP4_EGIF (*((volatile union CCP4_EGIF_REG *)0x400002DC))
// modelT5

/** 0x4000 0300 T5_CNT **/
union T5_CNT_REG{
	unsigned int reg;
	struct T5_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CNT (*((volatile union T5_CNT_REG *)0x40000300))
// modelT6

/** 0x4000 0304 T6_CNT **/
union T6_CNT_REG{
	unsigned int reg;
	struct T6_CNT_BITS{
		unsigned int _TZCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CNT (*((volatile union T6_CNT_REG *)0x40000304))
// modelT5

/** 0x4000 0308 T5_PPX **/
union T5_PPX_REG{
	unsigned int reg;
	struct T5_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_PPX (*((volatile union T5_PPX_REG *)0x40000308))
// modelT6

/** 0x4000 030C T6_PPZ **/
union T6_PPZ_REG{
	unsigned int reg;
	struct T6_PPZ_BITS{
		unsigned int _PPZ:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_PPZ (*((volatile union T6_PPZ_REG *)0x4000030C))
// modelT5

/** 0x4000 0310 T5_PRSC **/
union T5_PRSC_REG{
	unsigned int reg;
	struct T5_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_PRSC (*((volatile union T5_PRSC_REG *)0x40000310))
// modelT6

/** 0x4000 0314 T6_PRSC **/
union T6_PRSC_REG{
	unsigned int reg;
	struct T6_PRSC_BITS{
		unsigned int _TZCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_PRSC (*((volatile union T6_PRSC_REG *)0x40000314))
// modelT5

/** 0x4000 0318 T5_CCR0 **/
union T5_CCR0_REG{
	unsigned int reg;
	struct T5_CCR0_BITS{
		unsigned int _TXCCR0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CCR0 (*((volatile union T5_CCR0_REG *)0x40000318))
// model

/** 0x4000 031C T5_CCR1 **/
union T5_CCR1_REG{
	unsigned int reg;
	struct T5_CCR1_BITS{
		unsigned int _TXCCR1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CCR1 (*((volatile union T5_CCR1_REG *)0x4000031C))
// modelT6

/** 0x4000 0320 T6_CCR0 **/
union T6_CCR0_REG{
	unsigned int reg;
	struct T6_CCR0_BITS{
		unsigned int _TZCCR0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CCR0 (*((volatile union T6_CCR0_REG *)0x40000320))
// modelT5

/** 0x4000 0324 T5_CTL **/
union T5_CTL_REG{
	unsigned int reg;
	struct T5_CTL_BITS{
		unsigned int _TXCS:1;
		unsigned int _TXSY:1;
		unsigned int _TXEN:1;
		unsigned int _TXCKBS:4;
		unsigned int _TXDIR:1;
		unsigned int _TXCLK:2;
		unsigned int _TXADAUTO:1;
		unsigned int _TXOFS0:1;
		unsigned int _TXOFS1:1;
		unsigned int _TXCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CTL (*((volatile union T5_CTL_REG *)0x40000324))
// modelT6

/** 0x4000 0328 T6_CTL **/
union T6_CTL_REG{
	unsigned int reg;
	struct T6_CTL_BITS{
		unsigned int _TZCS:1;
		unsigned int _TZSY:1;
		unsigned int _TZEN:1;
		unsigned int _TZCKBS:4;
		unsigned int _TZDIR:1;
		unsigned int _TZCLK:2;
		unsigned int _TZADAUTO:1;
		unsigned int _TZOFS0:1;
		unsigned int _TZOFS1:1;
		unsigned int _TZCMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CTL (*((volatile union T6_CTL_REG *)0x40000328))
// modelECCP5

/** 0x4000 032C ECCP5_PDCTL **/
union ECCP5_PDCTL_REG{
	unsigned int reg;
	struct ECCP5_PDCTL_BITS{
		unsigned int _CPE:2;
		unsigned int _CMPE:1;
		unsigned int _TI0EN:1;
		unsigned int _TI1EN:1;
		unsigned int _TI2EN:1;
		unsigned int :1;
		unsigned int _SMPEN:1;
		unsigned int _RDA:3;
		unsigned int :1;
		unsigned int _CPD:3;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PDCTL (*((volatile union ECCP5_PDCTL_REG *)0x4000032C))
// model

/** 0x4000 0330 ECCP5_PXASCTL **/
union ECCP5_PXASCTL_REG{
	unsigned int reg;
	struct ECCP5_PXASCTL_BITS{
		unsigned int _TXPXPASS:2;
		unsigned int _TZPXPASS:2;
		unsigned int _TXBKINS:1;
		unsigned int _TZBKINS:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXASCTL (*((volatile union ECCP5_PXASCTL_REG *)0x40000330))
// model

/** 0x4000 0334 T5_CCTCTL **/
union T5_CCTCTL_REG{
	unsigned int reg;
	struct T5_CCTCTL_BITS{
		unsigned int _CCTEN:1;
		unsigned int _CRSET:1;
		unsigned int _CCTSEL:2;
		unsigned int :8;
		unsigned int _TXCKSEL:2;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_CCTCTL (*((volatile union T5_CCTCTL_REG *)0x40000334))
// model

/** 0x4000 0338 T6_CCTCTL **/
union T6_CCTCTL_REG{
	unsigned int reg;
	struct T6_CCTCTL_BITS{
		unsigned int _CCTEN:1;
		unsigned int _CRSET:1;
		unsigned int _CCTSEL:2;
		unsigned int :8;
		unsigned int _TZCKSEL:2;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_CCTCTL (*((volatile union T6_CCTCTL_REG *)0x40000338))
// model

/** 0x4000 0340 ECCP5_COMH1 **/
union ECCP5_COMH1_REG{
	unsigned int reg;
	struct ECCP5_COMH1_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COMH1 (*((volatile union ECCP5_COMH1_REG *)0x40000340))
// model

/** 0x4000 0350 ECCP5_COMH2 **/
union ECCP5_COMH2_REG{
	unsigned int reg;
	struct ECCP5_COMH2_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COMH2 (*((volatile union ECCP5_COMH2_REG *)0x40000350))
// model

/** 0x4000 0360 ECCP5_COMH3 **/
union ECCP5_COMH3_REG{
	unsigned int reg;
	struct ECCP5_COMH3_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COMH3 (*((volatile union ECCP5_COMH3_REG *)0x40000360))
// model

/** 0x4000 0370 ECCP5_COMH4 **/
union ECCP5_COMH4_REG{
	unsigned int reg;
	struct ECCP5_COMH4_BITS{
		unsigned int _COMH:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COMH4 (*((volatile union ECCP5_COMH4_REG *)0x40000370))
// model

/** 0x4000 0344 ECCP5_COML1 **/
union ECCP5_COML1_REG{
	unsigned int reg;
	struct ECCP5_COML1_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COML1 (*((volatile union ECCP5_COML1_REG *)0x40000344))
// model

/** 0x4000 0354 ECCP5_COML2 **/
union ECCP5_COML2_REG{
	unsigned int reg;
	struct ECCP5_COML2_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COML2 (*((volatile union ECCP5_COML2_REG *)0x40000354))
// model

/** 0x4000 0364 ECCP5_COML3 **/
union ECCP5_COML3_REG{
	unsigned int reg;
	struct ECCP5_COML3_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COML3 (*((volatile union ECCP5_COML3_REG *)0x40000364))
// model

/** 0x4000 0374 ECCP5_COML4 **/
union ECCP5_COML4_REG{
	unsigned int reg;
	struct ECCP5_COML4_BITS{
		unsigned int _COML:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_COML4 (*((volatile union ECCP5_COML4_REG *)0x40000374))
// model

/** 0x4000 0348 ECCP5_FAUCTL1 **/
union ECCP5_FAUCTL1_REG{
	unsigned int reg;
	struct ECCP5_FAUCTL1_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_FAUCTL1 (*((volatile union ECCP5_FAUCTL1_REG *)0x40000348))
// model

/** 0x4000 0358 ECCP5_FAUCTL2 **/
union ECCP5_FAUCTL2_REG{
	unsigned int reg;
	struct ECCP5_FAUCTL2_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_FAUCTL2 (*((volatile union ECCP5_FAUCTL2_REG *)0x40000358))
// model

/** 0x4000 0368 ECCP5_FAUCTL3 **/
union ECCP5_FAUCTL3_REG{
	unsigned int reg;
	struct ECCP5_FAUCTL3_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_FAUCTL3 (*((volatile union ECCP5_FAUCTL3_REG *)0x40000368))
// model

/** 0x4000 0378 ECCP5_FAUCTL4 **/
union ECCP5_FAUCTL4_REG{
	unsigned int reg;
	struct ECCP5_FAUCTL4_BITS{
		unsigned int _FAUEN:1;
		unsigned int _FLTP:4;
		unsigned int _FLTEN:1;
		unsigned int _FAUIE:1;
		unsigned int _FAUIC:1;
		unsigned int _FAUIF:1;
		unsigned int _FVAL:3;
		unsigned int _FINV:2;
		unsigned int _TRST:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_FAUCTL4 (*((volatile union ECCP5_FAUCTL4_REG *)0x40000378))
// model

/** 0x4000 034C ECCP5_DITCTL **/
union ECCP5_DITCTL_REG{
	unsigned int reg;
	struct ECCP5_DITCTL_BITS{
		unsigned int _FRCVAL:5;
		unsigned int _DEDEN:1;
		unsigned int _DPEEN:1;
		unsigned int _DCOMEN:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_DITCTL (*((volatile union ECCP5_DITCTL_REG *)0x4000034C))
// model

/** 0x4000 035C ECCP5_CCRCTL **/
union ECCP5_CCRCTL_REG{
	unsigned int reg;
	struct ECCP5_CCRCTL_BITS{
		unsigned int _TXCCR0SEN:1;
		unsigned int _TXCCR1SEN:1;
		unsigned int _TZCCR0SEN:1;
		unsigned int _TXCCR0SEL:1;
		unsigned int _TXCCR1SEL:1;
		unsigned int _TZCCR0SEL:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CCRCTL (*((volatile union ECCP5_CCRCTL_REG *)0x4000035C))
// model

/** 0x4000 0380 ECCP5_CTL1 **/
union ECCP5_CTL1_REG{
	unsigned int reg;
	struct ECCP5_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CTL1 (*((volatile union ECCP5_CTL1_REG *)0x40000380))
// model

/** 0x4000 0384 ECCP5_R1 **/
union ECCP5_R1_REG{
	unsigned int reg;
	struct ECCP5_R1_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R1 (*((volatile union ECCP5_R1_REG *)0x40000384))
// model

/** 0x4000 0388 ECCP5_R2 **/
union ECCP5_R2_REG{
	unsigned int reg;
	struct ECCP5_R2_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R2 (*((volatile union ECCP5_R2_REG *)0x40000388))
// model

/** 0x4000 038C ECCP5_R3 **/
union ECCP5_R3_REG{
	unsigned int reg;
	struct ECCP5_R3_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R3 (*((volatile union ECCP5_R3_REG *)0x4000038C))
// model

/** 0x4000 0390 ECCP5_R4 **/
union ECCP5_R4_REG{
	unsigned int reg;
	struct ECCP5_R4_BITS{
		unsigned int _ECCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_R4 (*((volatile union ECCP5_R4_REG *)0x40000390))
// model

/** 0x4000 0394 ECCP5_PXUDCTL **/
union ECCP5_PXUDCTL_REG{
	unsigned int reg;
	struct ECCP5_PXUDCTL_BITS{
		unsigned int _PXUDEN0:1;
		unsigned int _PXUDEN1:1;
		unsigned int _PXUDEVT0:1;
		unsigned int _PXUDEVT1:1;
		unsigned int _PXUDEVT2:1;
		unsigned int _PXUDEVT3:1;
		unsigned int _PXMPEN:1;
		unsigned int _TXUDR:1;
		unsigned int _TXIFUDREN:1;
		unsigned int _TZUDR:1;
		unsigned int _TZIFUDREN:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXUDCTL (*((volatile union ECCP5_PXUDCTL_REG *)0x40000394))
// model

/** 0x4000 0398 ECCP5_CTL2 **/
union ECCP5_CTL2_REG{
	unsigned int reg;
	struct ECCP5_CTL2_BITS{
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:3;
		unsigned int _TXMSSYNC:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _TZSMS:3;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CTL2 (*((volatile union ECCP5_CTL2_REG *)0x40000398))
// model

/** 0x4000 039C ECCP5_PXDTCTL **/
union ECCP5_PXDTCTL_REG{
	unsigned int reg;
	struct ECCP5_PXDTCTL_BITS{
		unsigned int _PZDC:8;
		unsigned int _PXDC:8;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXDTCTL (*((volatile union ECCP5_PXDTCTL_REG *)0x4000039C))
// model

/** 0x4000 03A0 ECCP5_PWMXOC **/
union ECCP5_PWMXOC_REG{
	unsigned int reg;
	struct ECCP5_PWMXOC_BITS{
		unsigned int _PXOC1L:2;
		unsigned int _PXOC1H:2;
		unsigned int _PXOC2L:2;
		unsigned int _PXOC2H:2;
		unsigned int _PXOC3L:2;
		unsigned int _PXOC3H:2;
		unsigned int _PXOC4L:2;
		unsigned int _PXOC4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PWMXOC (*((volatile union ECCP5_PWMXOC_REG *)0x400003A0))
// model

/** 0x4000 03A4 ECCP5_PXATRCTL **/
union ECCP5_PXATRCTL_REG{
	unsigned int reg;
	struct ECCP5_PXATRCTL_BITS{
		unsigned int :8;
		unsigned int _PXCH1MOD:1;
		unsigned int _PXCH2MOD:1;
		unsigned int _PXCH3MOD:1;
		unsigned int _PXCH4MOD:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXATRCTL (*((volatile union ECCP5_PXATRCTL_REG *)0x400003A4))
// model

/** 0x4000 03A8 ECCP5_PXASCTL0 **/
union ECCP5_PXASCTL0_REG{
	unsigned int reg;
	struct ECCP5_PXASCTL0_BITS{
		unsigned int _PXASS1:2;
		unsigned int _PXASS2:2;
		unsigned int _PXASS3:2;
		unsigned int _PXASS4:2;
		unsigned int _PXASE1:1;
		unsigned int _PXASE2:1;
		unsigned int _PXASE3:1;
		unsigned int _PXASE4:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXASCTL0 (*((volatile union ECCP5_PXASCTL0_REG *)0x400003A8))
// model

/** 0x4000 03AC ECCP5_PXASCTL1 **/
union ECCP5_PXASCTL1_REG{
	unsigned int reg;
	struct ECCP5_PXASCTL1_BITS{
		unsigned int _PXSS1L:2;
		unsigned int _PXSS1H:2;
		unsigned int _PXSS2L:2;
		unsigned int _PXSS2H:2;
		unsigned int _PXSS3L:2;
		unsigned int _PXSS3H:2;
		unsigned int _PXSS4L:2;
		unsigned int _PXSS4H:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_PXASCTL1 (*((volatile union ECCP5_PXASCTL1_REG *)0x400003AC))
// model

/** 0x4000 03B0 ECCP5_ZPDCTL0 **/
union ECCP5_ZPDCTL0_REG{
	unsigned int reg;
	struct ECCP5_ZPDCTL0_BITS{
		unsigned int _ZPD1FLAG:1;
		unsigned int _ZPD2FLAG:1;
		unsigned int _ZPD3FLAG:1;
		unsigned int _ZPD4FLAG:1;
		unsigned int _ZPD1TWIN:1;
		unsigned int _ZPD2TWIN:1;
		unsigned int _ZPD3TWIN:1;
		unsigned int _ZPD4TWIN:1;
		unsigned int _ZCLK:4;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_ZPDCTL0 (*((volatile union ECCP5_ZPDCTL0_REG *)0x400003B0))
// model

/** 0x4000 03B4 ECCP5_ZPDCTL1 **/
union ECCP5_ZPDCTL1_REG{
	unsigned int reg;
	struct ECCP5_ZPDCTL1_BITS{
		unsigned int _ZPD1S:3;
		unsigned int _ZPD2S:3;
		unsigned int _ZPD3S:3;
		unsigned int _ZPD4S:3;
		unsigned int _ZPD1EN:1;
		unsigned int _ZPD2EN:1;
		unsigned int _ZPD3EN:1;
		unsigned int _ZPD4EN:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_ZPDCTL1 (*((volatile union ECCP5_ZPDCTL1_REG *)0x400003B4))
// model

/** 0x4000 03B8 ECCP5_ZPDPORT **/
union ECCP5_ZPDPORT_REG{
	unsigned int reg;
	struct ECCP5_ZPDPORT_BITS{
		unsigned int _ZPORT0:1;
		unsigned int _ZPORT1:1;
		unsigned int _ZPORT2:1;
		unsigned int _ZPORT3:1;
		unsigned int _ZPORT4:1;
		unsigned int _ZPORT5:1;
		unsigned int _ZPORT6:1;
		unsigned int _ZPORT7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_ZPDPORT (*((volatile union ECCP5_ZPDPORT_REG *)0x400003B8))
// model

/** 0x4000 03BC ECCP5_IE **/
union ECCP5_IE_REG{
	unsigned int reg;
	struct ECCP5_IE_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TZIE:1;
		unsigned int _TXIE:1;
		unsigned int _TZUIE:1;
		unsigned int _TXUIE:1;
		unsigned int _CPIE:1;
		unsigned int _PDIE:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_IE (*((volatile union ECCP5_IE_REG *)0x400003BC))
// model

/** 0x4000 03C0 ECCP5_EGIF **/
union ECCP5_EGIF_REG{
	unsigned int reg;
	struct ECCP5_EGIF_BITS{
		unsigned int _CPIF:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TZIF:1;
		unsigned int _TXIF:1;
		unsigned int _TZUIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PDIF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_EGIF (*((volatile union ECCP5_EGIF_REG *)0x400003C0))
// modelT5

/** 0x4000 03C4 T5_UDTIMX **/
union T5_UDTIMX_REG{
	unsigned int reg;
	struct T5_UDTIMX_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T5_UDTIMX (*((volatile union T5_UDTIMX_REG *)0x400003C4))
// modelT6

/** 0x4000 03C8 T6_UDTIMZ **/
union T6_UDTIMZ_REG{
	unsigned int reg;
	struct T6_UDTIMZ_BITS{
		unsigned int _UDCNT:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T6_UDTIMZ (*((volatile union T6_UDTIMZ_REG *)0x400003C8))
// modelECCP5

/** 0x4000 03CC ECCP5_DF **/
union ECCP5_DF_REG{
	unsigned int reg;
	struct ECCP5_DF_BITS{
		unsigned int _CH1DF:1;
		unsigned int _CH2DF:1;
		unsigned int _CH3DF:1;
		unsigned int _CH4DF:1;
		unsigned int _CLSDF:1;
		unsigned int _TRIGDF:1;
		unsigned int _TZUDF:1;
		unsigned int _TXUDF:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_DF (*((volatile union ECCP5_DF_REG *)0x400003CC))
// model

/** 0x4000 03D0 ECCP5_C1 **/
union ECCP5_C1_REG{
	unsigned int reg;
	struct ECCP5_C1_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C1 (*((volatile union ECCP5_C1_REG *)0x400003D0))
// model

/** 0x4000 03D4 ECCP5_C2 **/
union ECCP5_C2_REG{
	unsigned int reg;
	struct ECCP5_C2_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C2 (*((volatile union ECCP5_C2_REG *)0x400003D4))
// model

/** 0x4000 03D8 ECCP5_C3 **/
union ECCP5_C3_REG{
	unsigned int reg;
	struct ECCP5_C3_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C3 (*((volatile union ECCP5_C3_REG *)0x400003D8))
// model

/** 0x4000 03DC ECCP5_C4 **/
union ECCP5_C4_REG{
	unsigned int reg;
	struct ECCP5_C4_BITS{
		unsigned int _ECCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_C4 (*((volatile union ECCP5_C4_REG *)0x400003DC))
// model

/** 0x4000 03E4 ECCP5_DE **/
union ECCP5_DE_REG{
	unsigned int reg;
	struct ECCP5_DE_BITS{
		unsigned int _CH1DE:1;
		unsigned int _CH2DE:1;
		unsigned int _CH3DE:1;
		unsigned int _CH4DE:1;
		unsigned int _CLSDE:1;
		unsigned int _TXTDE:1;
		unsigned int _TZUDE:1;
		unsigned int _TXUDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_DE (*((volatile union ECCP5_DE_REG *)0x400003E4))
// model

/** 0x4000 03E8 ECCP5_SRIC **/
union ECCP5_SRIC_REG{
	unsigned int reg;
	struct ECCP5_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TZIC:1;
		unsigned int _TXIC:1;
		unsigned int _TZUIC:1;
		unsigned int _TXUIC:1;
		unsigned int _CPIC:1;
		unsigned int _PDIC:1;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_SRIC (*((volatile union ECCP5_SRIC_REG *)0x400003E8))
// model

/** 0x4000 03EC ECCP5_CTL3 **/
union ECCP5_CTL3_REG{
	unsigned int reg;
	struct ECCP5_CTL3_BITS{
		unsigned int _PXSPMST:1;
		unsigned int _TUNITE:1;
		unsigned int _PXRSEN:1;
		unsigned int _COMBEN:1;
		unsigned int _COMINV:2;
		unsigned int _CAPTST:1;
		unsigned int :2;
		unsigned int _CH0HM:1;
		unsigned int _CH1HM:1;
		unsigned int _CH2HM:1;
		unsigned int _CH3HM:1;
		unsigned int _TRGSEL:2;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECCP5_CTL3 (*((volatile union ECCP5_CTL3_REG *)0x400003EC))
// modelQEI0

/** 0x4000 0500 QEI0_CTL0 **/
union QEI0_CTL0_REG{
	unsigned int reg;
	struct QEI0_CTL0_BITS{
		unsigned int _TXDIR:1;
		unsigned int _TXDIROUT:1;
		unsigned int _INDEX:1;
		unsigned int _TXCS:1;
		unsigned int _INDRES:1;
		unsigned int _QEIMOD:3;
		unsigned int _CNTERRIF:1;
		unsigned int _PHEIF:1;
		unsigned int _TXIF:1;
		unsigned int _LPCLK:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI0_CTL0 (*((volatile union QEI0_CTL0_REG *)0x40000500))
// model

/** 0x4000 0504 QEI0_CTL1 **/
union QEI0_CTL1_REG{
	unsigned int reg;
	struct QEI0_CTL1_BITS{
		unsigned int _SWPAB:1;
		unsigned int _QEICK:3;
		unsigned int _QEIOUT:1;
		unsigned int _QEICLK:2;
		unsigned int _MODEN:1;
		unsigned int _PHDFEN:1;
		unsigned int _PHSEL:4;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI0_CTL1 (*((volatile union QEI0_CTL1_REG *)0x40000504))
// modelT7

/** 0x4000 0508 T7_CNT **/
union T7_CNT_REG{
	unsigned int reg;
	struct T7_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T7_CNT (*((volatile union T7_CNT_REG *)0x40000508))
// model

/** 0x4000 050C T7_PPX **/
union T7_PPX_REG{
	unsigned int reg;
	struct T7_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T7_PPX (*((volatile union T7_PPX_REG *)0x4000050C))
// model

/** 0x4000 0510 T7_PRSC **/
union T7_PRSC_REG{
	unsigned int reg;
	struct T7_PRSC_BITS{
		unsigned int _TXPRSC:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T7_PRSC (*((volatile union T7_PRSC_REG *)0x40000510))
// modelQEI0

/** 0x4000 0514 QEI0_DIER **/
union QEI0_DIER_REG{
	unsigned int reg;
	struct QEI0_DIER_BITS{
		unsigned int _CNTERRIE:1;
		unsigned int _PHEIE:1;
		unsigned int _TXIE:1;
		unsigned int _CNTERRIC:1;
		unsigned int _PHEIC:1;
		unsigned int _TXIC:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define QEI0_DIER (*((volatile union QEI0_DIER_REG *)0x40000514))
// modelADC0

/** 0x4000 0580 ADC0_CTL0 **/
union ADC0_CTL0_REG{
	unsigned int reg;
	struct ADC0_CTL0_BITS{
		unsigned int _EN:1;
		unsigned int _CLKS:2;
		unsigned int _LR:1;
		unsigned int :4;
		unsigned int _ADCCLKS:3;
		unsigned int :2;
		unsigned int _NDMAEN:1;
		unsigned int _TRIMIBIAS:1;
		unsigned int _BOSSSEL:1;
		unsigned int _BOSSSELCOMP:1;
		unsigned int _SCANEN:1;
		unsigned int _CONT:1;
		unsigned int _HPAUTO:1;
		unsigned int _DSEN:1;
		unsigned int _HPDSEN:1;
		unsigned int _HP0DMAEN:1;
		unsigned int _HP1DMAEN:1;
		unsigned int _HP2DMAEN:1;
		unsigned int _HP3DMAEN:1;
		unsigned int _DSNUM:3;
		unsigned int _WDEN:1;
		unsigned int _HPWDEN:1;
		unsigned int _WDSCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_CTL0 (*((volatile union ADC0_CTL0_REG *)0x40000580))
// model

/** 0x4000 0584 ADC0_CTL1 **/
union ADC0_CTL1_REG{
	unsigned int reg;
	struct ADC0_CTL1_BITS{
		unsigned int :2;
		unsigned int _START:1;
		unsigned int _HPSTART:1;
		unsigned int _NCH:7;
		unsigned int _EXTEN:1;
		unsigned int :5;
		unsigned int _REF0:1;
		unsigned int _REF1:1;
		unsigned int _REF2:1;
		unsigned int _HCH:7;
		unsigned int _HPEXTEN:1;
		unsigned int _DOUMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_CTL1 (*((volatile union ADC0_CTL1_REG *)0x40000584))
// model

/** 0x4000 0588 ADC0_SCANSQ0 **/
union ADC0_SCANSQ0_REG{
	unsigned int reg;
	struct ADC0_SCANSQ0_BITS{
		unsigned int _SSQ0:8;
		unsigned int _SSQ1:8;
		unsigned int _SSQ2:8;
		unsigned int _SSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ0 (*((volatile union ADC0_SCANSQ0_REG *)0x40000588))
// model

/** 0x4000 058C ADC0_SCANSQ1 **/
union ADC0_SCANSQ1_REG{
	unsigned int reg;
	struct ADC0_SCANSQ1_BITS{
		unsigned int _SSQ4:8;
		unsigned int _SSQ5:8;
		unsigned int _SSQ6:8;
		unsigned int _SSQ7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ1 (*((volatile union ADC0_SCANSQ1_REG *)0x4000058C))
// model

/** 0x4000 0590 ADC0_SCANSQ2 **/
union ADC0_SCANSQ2_REG{
	unsigned int reg;
	struct ADC0_SCANSQ2_BITS{
		unsigned int _SSQ8:8;
		unsigned int _SSQ9:8;
		unsigned int _SSQ10:8;
		unsigned int _SSQ11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ2 (*((volatile union ADC0_SCANSQ2_REG *)0x40000590))
// model

/** 0x4000 05C4 ADC0_SCANSQ3 **/
union ADC0_SCANSQ3_REG{
	unsigned int reg;
	struct ADC0_SCANSQ3_BITS{
		unsigned int _SSQ12:8;
		unsigned int _SSQ13:8;
		unsigned int _SSQ14:8;
		unsigned int _SSQ15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANSQ3 (*((volatile union ADC0_SCANSQ3_REG *)0x400005C4))
// model

/** 0x4000 0594 ADC0_HSCANSQ **/
union ADC0_HSCANSQ_REG{
	unsigned int reg;
	struct ADC0_HSCANSQ_BITS{
		unsigned int _HSSQ0:8;
		unsigned int _HSSQ1:8;
		unsigned int _HSSQ2:8;
		unsigned int _HSSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HSCANSQ (*((volatile union ADC0_HSCANSQ_REG *)0x40000594))
// model

/** 0x4000 0598 ADC0_WDH **/
union ADC0_WDH_REG{
	unsigned int reg;
	struct ADC0_WDH_BITS{
		unsigned int _WDH:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_WDH (*((volatile union ADC0_WDH_REG *)0x40000598))
// model

/** 0x4000 059C ADC0_WDL **/
union ADC0_WDL_REG{
	unsigned int reg;
	struct ADC0_WDL_BITS{
		unsigned int _WDL:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_WDL (*((volatile union ADC0_WDL_REG *)0x4000059C))
// model

/** 0x4000 05A0 ADC0_DATA **/
union ADC0_DATA_REG{
	unsigned int reg;
	struct ADC0_DATA_BITS{
		unsigned int _DATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_DATA (*((volatile union ADC0_DATA_REG *)0x400005A0))
// model

/** 0x4000 05A4 ADC0_HPDATA0 **/
union ADC0_HPDATA0_REG{
	unsigned int reg;
	struct ADC0_HPDATA0_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA0 (*((volatile union ADC0_HPDATA0_REG *)0x400005A4))
// model

/** 0x4000 05A8 ADC0_HPDATA1 **/
union ADC0_HPDATA1_REG{
	unsigned int reg;
	struct ADC0_HPDATA1_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA1 (*((volatile union ADC0_HPDATA1_REG *)0x400005A8))
// model

/** 0x4000 05AC ADC0_HPDATA2 **/
union ADC0_HPDATA2_REG{
	unsigned int reg;
	struct ADC0_HPDATA2_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA2 (*((volatile union ADC0_HPDATA2_REG *)0x400005AC))
// model

/** 0x4000 05B0 ADC0_HPDATA3 **/
union ADC0_HPDATA3_REG{
	unsigned int reg;
	struct ADC0_HPDATA3_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDATA3 (*((volatile union ADC0_HPDATA3_REG *)0x400005B0))
// model

/** 0x4000 05B4 ADC0_HPDOFF0 **/
union ADC0_HPDOFF0_REG{
	unsigned int reg;
	struct ADC0_HPDOFF0_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDOFF0 (*((volatile union ADC0_HPDOFF0_REG *)0x400005B4))
// model

/** 0x4000 05B8 ADC0_HPDOFF1 **/
union ADC0_HPDOFF1_REG{
	unsigned int reg;
	struct ADC0_HPDOFF1_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDOFF1 (*((volatile union ADC0_HPDOFF1_REG *)0x400005B8))
// model

/** 0x4000 05BC ADC0_HPDOFF2 **/
union ADC0_HPDOFF2_REG{
	unsigned int reg;
	struct ADC0_HPDOFF2_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDOFF2 (*((volatile union ADC0_HPDOFF2_REG *)0x400005BC))
// model

/** 0x4000 05C0 ADC0_HPDOFF3 **/
union ADC0_HPDOFF3_REG{
	unsigned int reg;
	struct ADC0_HPDOFF3_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_HPDOFF3 (*((volatile union ADC0_HPDOFF3_REG *)0x400005C0))
// model

/** 0x4000 05D0 ADC0_STATE **/
union ADC0_STATE_REG{
	unsigned int reg;
	struct ADC0_STATE_BITS{
		unsigned int _STARTIF:1;
		unsigned int _HPSTARTIF:1;
		unsigned int _ENDIF:1;
		unsigned int _HPENDIF:1;
		unsigned int _WDIF:1;
		unsigned int _ENDIC:1;
		unsigned int _HPENDIC:1;
		unsigned int _WDIC:1;
		unsigned int _ENDIE:1;
		unsigned int _HPENDIE:1;
		unsigned int _WDIE:1;
		unsigned int _EOCIF:1;
		unsigned int _EOCIC:1;
		unsigned int _EOCIE:1;
		unsigned int _CCR0N:1;
		unsigned int _CCR0H:1;
		unsigned int _CCR1N:1;
		unsigned int _CCR1H:1;
		unsigned int _CCR2N:1;
		unsigned int _CCR2H:1;
		unsigned int :7;
		unsigned int _TRIMIBIASOPA:1;
		unsigned int :2;
		unsigned int _TRIMERROR:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_STATE (*((volatile union ADC0_STATE_REG *)0x400005D0))
// model

/** 0x4000 05D4 ADC0_DELAY **/
union ADC0_DELAY_REG{
	unsigned int reg;
	struct ADC0_DELAY_BITS{
		unsigned int _FDELAY:6;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_DELAY (*((volatile union ADC0_DELAY_REG *)0x400005D4))
// model

/** 0x4000 05D8 ADC0_SCANCTL **/
union ADC0_SCANCTL_REG{
	unsigned int reg;
	struct ADC0_SCANCTL_BITS{
		unsigned int _SLEN:4;
		unsigned int _HSLEN:2;
		unsigned int :10;
		unsigned int _WDCH:7;
		unsigned int :1;
		unsigned int _SAMSEL:4;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC0_SCANCTL (*((volatile union ADC0_SCANCTL_REG *)0x400005D8))
// modelADC1

/** 0x4000 0600 ADC1_CTL0 **/
union ADC1_CTL0_REG{
	unsigned int reg;
	struct ADC1_CTL0_BITS{
		unsigned int _EN:1;
		unsigned int _CLKS:2;
		unsigned int _LR:1;
		unsigned int :4;
		unsigned int _ADCCLKS:3;
		unsigned int :2;
		unsigned int _NDMAEN:1;
		unsigned int _TRIMIBIAS:1;
		unsigned int _BOSSSEL:1;
		unsigned int _BOSSSELCOMP:1;
		unsigned int _SCANEN:1;
		unsigned int _CONT:1;
		unsigned int _HPAUTO:1;
		unsigned int _DSEN:1;
		unsigned int _HPDSEN:1;
		unsigned int _HP0DMAEN:1;
		unsigned int _HP1DMAEN:1;
		unsigned int _HP2DMAEN:1;
		unsigned int _HP3DMAEN:1;
		unsigned int _DSNUM:3;
		unsigned int _WDEN:1;
		unsigned int _HPWDEN:1;
		unsigned int _WDSCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_CTL0 (*((volatile union ADC1_CTL0_REG *)0x40000600))
// model

/** 0x4000 0604 ADC1_CTL1 **/
union ADC1_CTL1_REG{
	unsigned int reg;
	struct ADC1_CTL1_BITS{
		unsigned int :2;
		unsigned int _START:1;
		unsigned int _HPSTART:1;
		unsigned int _NCH:7;
		unsigned int _EXTEN:1;
		unsigned int :5;
		unsigned int _REF0:1;
		unsigned int _REF1:1;
		unsigned int _REF2:1;
		unsigned int _HCH:7;
		unsigned int _HPEXTEN:1;
		unsigned int _DOUMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_CTL1 (*((volatile union ADC1_CTL1_REG *)0x40000604))
// model

/** 0x4000 0608 ADC1_SCANSQ0 **/
union ADC1_SCANSQ0_REG{
	unsigned int reg;
	struct ADC1_SCANSQ0_BITS{
		unsigned int _SSQ0:8;
		unsigned int _SSQ1:8;
		unsigned int _SSQ2:8;
		unsigned int _SSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ0 (*((volatile union ADC1_SCANSQ0_REG *)0x40000608))
// model

/** 0x4000 060C ADC1_SCANSQ1 **/
union ADC1_SCANSQ1_REG{
	unsigned int reg;
	struct ADC1_SCANSQ1_BITS{
		unsigned int _SSQ4:8;
		unsigned int _SSQ5:8;
		unsigned int _SSQ6:8;
		unsigned int _SSQ7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ1 (*((volatile union ADC1_SCANSQ1_REG *)0x4000060C))
// model

/** 0x4000 0610 ADC1_SCANSQ2 **/
union ADC1_SCANSQ2_REG{
	unsigned int reg;
	struct ADC1_SCANSQ2_BITS{
		unsigned int _SSQ8:8;
		unsigned int _SSQ9:8;
		unsigned int _SSQ10:8;
		unsigned int _SSQ11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ2 (*((volatile union ADC1_SCANSQ2_REG *)0x40000610))
// model

/** 0x4000 0644 ADC1_SCANSQ3 **/
union ADC1_SCANSQ3_REG{
	unsigned int reg;
	struct ADC1_SCANSQ3_BITS{
		unsigned int _SSQ12:8;
		unsigned int _SSQ13:8;
		unsigned int _SSQ14:8;
		unsigned int _SSQ15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANSQ3 (*((volatile union ADC1_SCANSQ3_REG *)0x40000644))
// model

/** 0x4000 0614 ADC1_HSCANSQ **/
union ADC1_HSCANSQ_REG{
	unsigned int reg;
	struct ADC1_HSCANSQ_BITS{
		unsigned int _HSSQ0:8;
		unsigned int _HSSQ1:8;
		unsigned int _HSSQ2:8;
		unsigned int _HSSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HSCANSQ (*((volatile union ADC1_HSCANSQ_REG *)0x40000614))
// model

/** 0x4000 0618 ADC1_WDH **/
union ADC1_WDH_REG{
	unsigned int reg;
	struct ADC1_WDH_BITS{
		unsigned int _WDH:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_WDH (*((volatile union ADC1_WDH_REG *)0x40000618))
// model

/** 0x4000 061C ADC1_WDL **/
union ADC1_WDL_REG{
	unsigned int reg;
	struct ADC1_WDL_BITS{
		unsigned int _WDL:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_WDL (*((volatile union ADC1_WDL_REG *)0x4000061C))
// model

/** 0x4000 0620 ADC1_DATA **/
union ADC1_DATA_REG{
	unsigned int reg;
	struct ADC1_DATA_BITS{
		unsigned int _DATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_DATA (*((volatile union ADC1_DATA_REG *)0x40000620))
// model

/** 0x4000 0624 ADC1_HPDATA0 **/
union ADC1_HPDATA0_REG{
	unsigned int reg;
	struct ADC1_HPDATA0_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA0 (*((volatile union ADC1_HPDATA0_REG *)0x40000624))
// model

/** 0x4000 0628 ADC1_HPDATA1 **/
union ADC1_HPDATA1_REG{
	unsigned int reg;
	struct ADC1_HPDATA1_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA1 (*((volatile union ADC1_HPDATA1_REG *)0x40000628))
// model

/** 0x4000 062C ADC1_HPDATA2 **/
union ADC1_HPDATA2_REG{
	unsigned int reg;
	struct ADC1_HPDATA2_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA2 (*((volatile union ADC1_HPDATA2_REG *)0x4000062C))
// model

/** 0x4000 0630 ADC1_HPDATA3 **/
union ADC1_HPDATA3_REG{
	unsigned int reg;
	struct ADC1_HPDATA3_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDATA3 (*((volatile union ADC1_HPDATA3_REG *)0x40000630))
// model

/** 0x4000 0634 ADC1_HPDOFF0 **/
union ADC1_HPDOFF0_REG{
	unsigned int reg;
	struct ADC1_HPDOFF0_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDOFF0 (*((volatile union ADC1_HPDOFF0_REG *)0x40000634))
// model

/** 0x4000 0638 ADC1_HPDOFF1 **/
union ADC1_HPDOFF1_REG{
	unsigned int reg;
	struct ADC1_HPDOFF1_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDOFF1 (*((volatile union ADC1_HPDOFF1_REG *)0x40000638))
// model

/** 0x4000 063C ADC1_HPDOFF2 **/
union ADC1_HPDOFF2_REG{
	unsigned int reg;
	struct ADC1_HPDOFF2_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDOFF2 (*((volatile union ADC1_HPDOFF2_REG *)0x4000063C))
// model

/** 0x4000 0640 ADC1_HPDOFF3 **/
union ADC1_HPDOFF3_REG{
	unsigned int reg;
	struct ADC1_HPDOFF3_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_HPDOFF3 (*((volatile union ADC1_HPDOFF3_REG *)0x40000640))
// model

/** 0x4000 0650 ADC1_STATE **/
union ADC1_STATE_REG{
	unsigned int reg;
	struct ADC1_STATE_BITS{
		unsigned int _STARTIF:1;
		unsigned int _HPSTARTIF:1;
		unsigned int _ENDIF:1;
		unsigned int _HPENDIF:1;
		unsigned int _WDIF:1;
		unsigned int _ENDIC:1;
		unsigned int _HPENDIC:1;
		unsigned int _WDIC:1;
		unsigned int _ENDIE:1;
		unsigned int _HPENDIE:1;
		unsigned int _WDIE:1;
		unsigned int _EOCIF:1;
		unsigned int _EOCIC:1;
		unsigned int _EOCIE:1;
		unsigned int _CCR0N:1;
		unsigned int _CCR0H:1;
		unsigned int _CCR1N:1;
		unsigned int _CCR1H:1;
		unsigned int _CCR2N:1;
		unsigned int _CCR2H:1;
		unsigned int :7;
		unsigned int _TRIMIBIASOPA:1;
		unsigned int :2;
		unsigned int _TRIMERROR:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_STATE (*((volatile union ADC1_STATE_REG *)0x40000650))
// model

/** 0x4000 0658 ADC1_SCANCTL **/
union ADC1_SCANCTL_REG{
	unsigned int reg;
	struct ADC1_SCANCTL_BITS{
		unsigned int _SLEN:4;
		unsigned int _HSLEN:2;
		unsigned int :10;
		unsigned int _WDCH:7;
		unsigned int :1;
		unsigned int _SAMSEL:4;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC1_SCANCTL (*((volatile union ADC1_SCANCTL_REG *)0x40000658))
// modelADC2

/** 0x4000 0680 ADC2_CTL0 **/
union ADC2_CTL0_REG{
	unsigned int reg;
	struct ADC2_CTL0_BITS{
		unsigned int _EN:1;
		unsigned int _CLKS:2;
		unsigned int _LR:1;
		unsigned int :4;
		unsigned int _ADCCLKS:3;
		unsigned int :2;
		unsigned int _NDMAEN:1;
		unsigned int _TRIMIBIAS:1;
		unsigned int _BOSSSEL:1;
		unsigned int _BOSSSELCOMP:1;
		unsigned int _SCANEN:1;
		unsigned int _CONT:1;
		unsigned int _HPAUTO:1;
		unsigned int _DSEN:1;
		unsigned int _HPDSEN:1;
		unsigned int _HP0DMAEN:1;
		unsigned int _HP1DMAEN:1;
		unsigned int _HP2DMAEN:1;
		unsigned int _HP3DMAEN:1;
		unsigned int _DSNUM:3;
		unsigned int _WDEN:1;
		unsigned int _HPWDEN:1;
		unsigned int _WDSCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_CTL0 (*((volatile union ADC2_CTL0_REG *)0x40000680))
// model

/** 0x4000 0684 ADC2_CTL1 **/
union ADC2_CTL1_REG{
	unsigned int reg;
	struct ADC2_CTL1_BITS{
		unsigned int :2;
		unsigned int _START:1;
		unsigned int _HPSTART:1;
		unsigned int _NCH:7;
		unsigned int _EXTEN:1;
		unsigned int :5;
		unsigned int _REF0:1;
		unsigned int _REF1:1;
		unsigned int _REF2:1;
		unsigned int _HCH:7;
		unsigned int _HPEXTEN:1;
		unsigned int _DOUMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_CTL1 (*((volatile union ADC2_CTL1_REG *)0x40000684))
// model

/** 0x4000 0688 ADC2_SCANSQ0 **/
union ADC2_SCANSQ0_REG{
	unsigned int reg;
	struct ADC2_SCANSQ0_BITS{
		unsigned int _SSQ0:8;
		unsigned int _SSQ1:8;
		unsigned int _SSQ2:8;
		unsigned int _SSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ0 (*((volatile union ADC2_SCANSQ0_REG *)0x40000688))
// model

/** 0x4000 068C ADC2_SCANSQ1 **/
union ADC2_SCANSQ1_REG{
	unsigned int reg;
	struct ADC2_SCANSQ1_BITS{
		unsigned int _SSQ4:8;
		unsigned int _SSQ5:8;
		unsigned int _SSQ6:8;
		unsigned int _SSQ7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ1 (*((volatile union ADC2_SCANSQ1_REG *)0x4000068C))
// model

/** 0x4000 0690 ADC2_SCANSQ2 **/
union ADC2_SCANSQ2_REG{
	unsigned int reg;
	struct ADC2_SCANSQ2_BITS{
		unsigned int _SSQ8:8;
		unsigned int _SSQ9:8;
		unsigned int _SSQ10:8;
		unsigned int _SSQ11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ2 (*((volatile union ADC2_SCANSQ2_REG *)0x40000690))
// model

/** 0x4000 06C4 ADC2_SCANSQ3 **/
union ADC2_SCANSQ3_REG{
	unsigned int reg;
	struct ADC2_SCANSQ3_BITS{
		unsigned int _SSQ12:8;
		unsigned int _SSQ13:8;
		unsigned int _SSQ14:8;
		unsigned int _SSQ15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANSQ3 (*((volatile union ADC2_SCANSQ3_REG *)0x400006C4))
// model

/** 0x4000 0694 ADC2_HSCANSQ **/
union ADC2_HSCANSQ_REG{
	unsigned int reg;
	struct ADC2_HSCANSQ_BITS{
		unsigned int _HSSQ0:8;
		unsigned int _HSSQ1:8;
		unsigned int _HSSQ2:8;
		unsigned int _HSSQ3:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HSCANSQ (*((volatile union ADC2_HSCANSQ_REG *)0x40000694))
// model

/** 0x4000 0698 ADC2_WDH **/
union ADC2_WDH_REG{
	unsigned int reg;
	struct ADC2_WDH_BITS{
		unsigned int _WDH:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_WDH (*((volatile union ADC2_WDH_REG *)0x40000698))
// model

/** 0x4000 069C ADC2_WDL **/
union ADC2_WDL_REG{
	unsigned int reg;
	struct ADC2_WDL_BITS{
		unsigned int _WDL:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_WDL (*((volatile union ADC2_WDL_REG *)0x4000069C))
// model

/** 0x4000 06A0 ADC2_DATA **/
union ADC2_DATA_REG{
	unsigned int reg;
	struct ADC2_DATA_BITS{
		unsigned int _DATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_DATA (*((volatile union ADC2_DATA_REG *)0x400006A0))
// model

/** 0x4000 06A4 ADC2_HPDATA0 **/
union ADC2_HPDATA0_REG{
	unsigned int reg;
	struct ADC2_HPDATA0_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA0 (*((volatile union ADC2_HPDATA0_REG *)0x400006A4))
// model

/** 0x4000 06A8 ADC2_HPDATA1 **/
union ADC2_HPDATA1_REG{
	unsigned int reg;
	struct ADC2_HPDATA1_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA1 (*((volatile union ADC2_HPDATA1_REG *)0x400006A8))
// model

/** 0x4000 06AC ADC2_HPDATA2 **/
union ADC2_HPDATA2_REG{
	unsigned int reg;
	struct ADC2_HPDATA2_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA2 (*((volatile union ADC2_HPDATA2_REG *)0x400006AC))
// model

/** 0x4000 06B0 ADC2_HPDATA3 **/
union ADC2_HPDATA3_REG{
	unsigned int reg;
	struct ADC2_HPDATA3_BITS{
		unsigned int _HPDATA:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDATA3 (*((volatile union ADC2_HPDATA3_REG *)0x400006B0))
// model

/** 0x4000 06B4 ADC2_HPDOFF0 **/
union ADC2_HPDOFF0_REG{
	unsigned int reg;
	struct ADC2_HPDOFF0_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDOFF0 (*((volatile union ADC2_HPDOFF0_REG *)0x400006B4))
// model

/** 0x4000 06B8 ADC2_HPDOFF1 **/
union ADC2_HPDOFF1_REG{
	unsigned int reg;
	struct ADC2_HPDOFF1_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDOFF1 (*((volatile union ADC2_HPDOFF1_REG *)0x400006B8))
// model

/** 0x4000 06BC ADC2_HPDOFF2 **/
union ADC2_HPDOFF2_REG{
	unsigned int reg;
	struct ADC2_HPDOFF2_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDOFF2 (*((volatile union ADC2_HPDOFF2_REG *)0x400006BC))
// model

/** 0x4000 06C0 ADC2_HPDOFF3 **/
union ADC2_HPDOFF3_REG{
	unsigned int reg;
	struct ADC2_HPDOFF3_BITS{
		unsigned int _HPDOFF:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_HPDOFF3 (*((volatile union ADC2_HPDOFF3_REG *)0x400006C0))
// model

/** 0x4000 06D0 ADC2_STATE **/
union ADC2_STATE_REG{
	unsigned int reg;
	struct ADC2_STATE_BITS{
		unsigned int _STARTIF:1;
		unsigned int _HPSTARTIF:1;
		unsigned int _ENDIF:1;
		unsigned int _HPENDIF:1;
		unsigned int _WDIF:1;
		unsigned int _ENDIC:1;
		unsigned int _HPENDIC:1;
		unsigned int _WDIC:1;
		unsigned int _ENDIE:1;
		unsigned int _HPENDIE:1;
		unsigned int _WDIE:1;
		unsigned int _EOCIF:1;
		unsigned int _EOCIC:1;
		unsigned int _EOCIE:1;
		unsigned int _CCR0N:1;
		unsigned int _CCR0H:1;
		unsigned int _CCR1N:1;
		unsigned int _CCR1H:1;
		unsigned int _CCR2N:1;
		unsigned int _CCR2H:1;
		unsigned int :7;
		unsigned int _TRIMIBIASOPA:1;
		unsigned int :2;
		unsigned int _TRIMERROR:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_STATE (*((volatile union ADC2_STATE_REG *)0x400006D0))
// model

/** 0x4000 06D8 ADC2_SCANCTL **/
union ADC2_SCANCTL_REG{
	unsigned int reg;
	struct ADC2_SCANCTL_BITS{
		unsigned int _SLEN:4;
		unsigned int _HSLEN:2;
		unsigned int :10;
		unsigned int _WDCH:7;
		unsigned int :1;
		unsigned int _SAMSEL:4;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ADC2_SCANCTL (*((volatile union ADC2_SCANCTL_REG *)0x400006D8))
// modelDAC0

/** 0x4000 0700 DAC0_CTL **/
union DAC0_CTL_REG{
	unsigned int reg;
	struct DAC0_CTL_BITS{
		unsigned int _EN:1;
		unsigned int _DE:1;
		unsigned int :1;
		unsigned int _TRIGEN:1;
		unsigned int _TREVT:4;
		unsigned int _WAVE:2;
		unsigned int _MAS:4;
		unsigned int _SWTRIG:1;
		unsigned int _DF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CTL (*((volatile union DAC0_CTL_REG *)0x40000700))
// model

/** 0x4000 0704 DAC0_DAHD **/
union DAC0_DAHD_REG{
	unsigned int reg;
	struct DAC0_DAHD_BITS{
		unsigned int _DAHD:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_DAHD (*((volatile union DAC0_DAHD_REG *)0x40000704))
// model

/** 0x4000 0708 DAC0_DATA **/
union DAC0_DATA_REG{
	unsigned int reg;
	struct DAC0_DATA_BITS{
		unsigned int _DATA:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_DATA (*((volatile union DAC0_DATA_REG *)0x40000708))
// model

/** 0x4000 070C DAC0_CTL1 **/
union DAC0_CTL1_REG{
	unsigned int reg;
	struct DAC0_CTL1_BITS{
		unsigned int _SEL:1;
		unsigned int _RFS:2;
		unsigned int :1;
		unsigned int _CLK:2;
		unsigned int _BUFEN:1;
		unsigned int :1;
		unsigned int _DACOUTIOEN:1;
		unsigned int _CLKDIV:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CTL1 (*((volatile union DAC0_CTL1_REG *)0x4000070C))
// model

/** 0x4000 0714 DAC0_CAL **/
union DAC0_CAL_REG{
	unsigned int reg;
	struct DAC0_CAL_BITS{
		unsigned int :13;
		unsigned int _TRIMLO:1;
		unsigned int _TRIMHI:1;
		unsigned int _TRIMSTATE:1;
		unsigned int _TRIMN:6;
		unsigned int _TRIMNPOL:1;
		unsigned int :1;
		unsigned int _TRIMP:6;
		unsigned int _TRIMPPOL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC0_CAL (*((volatile union DAC0_CAL_REG *)0x40000714))
// modelDAC1

/** 0x4000 0780 DAC1_CTL **/
union DAC1_CTL_REG{
	unsigned int reg;
	struct DAC1_CTL_BITS{
		unsigned int _EN:1;
		unsigned int _DE:1;
		unsigned int :1;
		unsigned int _TRIGEN:1;
		unsigned int _TREVT:4;
		unsigned int _WAVE:2;
		unsigned int _MAS:4;
		unsigned int _SWTRIG:1;
		unsigned int _DF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_CTL (*((volatile union DAC1_CTL_REG *)0x40000780))
// model

/** 0x4000 0784 DAC1_DAHD **/
union DAC1_DAHD_REG{
	unsigned int reg;
	struct DAC1_DAHD_BITS{
		unsigned int _DAHD:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_DAHD (*((volatile union DAC1_DAHD_REG *)0x40000784))
// model

/** 0x4000 0788 DAC1_DATA **/
union DAC1_DATA_REG{
	unsigned int reg;
	struct DAC1_DATA_BITS{
		unsigned int _DATA:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_DATA (*((volatile union DAC1_DATA_REG *)0x40000788))
// model

/** 0x4000 078C DAC1_CTL1 **/
union DAC1_CTL1_REG{
	unsigned int reg;
	struct DAC1_CTL1_BITS{
		unsigned int _SEL:1;
		unsigned int _RFS:2;
		unsigned int :1;
		unsigned int _CLK:2;
		unsigned int _BUFEN:1;
		unsigned int :1;
		unsigned int _DACOUTIOEN:1;
		unsigned int _CLKDIV:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_CTL1 (*((volatile union DAC1_CTL1_REG *)0x4000078C))
// model

/** 0x4000 0794 DAC1_CAL **/
union DAC1_CAL_REG{
	unsigned int reg;
	struct DAC1_CAL_BITS{
		unsigned int :13;
		unsigned int _TRIMLO:1;
		unsigned int _TRIMHI:1;
		unsigned int _TRIMSTATE:1;
		unsigned int _TRIMN:6;
		unsigned int _TRIMNPOL:1;
		unsigned int :1;
		unsigned int _TRIMP:6;
		unsigned int _TRIMPPOL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC1_CAL (*((volatile union DAC1_CAL_REG *)0x40000794))
// modelDAC2

/** 0x4000 1D80 DAC2_CTL **/
union DAC2_CTL_REG{
	unsigned int reg;
	struct DAC2_CTL_BITS{
		unsigned int _EN:1;
		unsigned int _DE:1;
		unsigned int :1;
		unsigned int _TRIGEN:1;
		unsigned int _TREVT:4;
		unsigned int _WAVE:2;
		unsigned int _MAS:4;
		unsigned int _SWTRIG:1;
		unsigned int _DF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC2_CTL (*((volatile union DAC2_CTL_REG *)0x40001D80))
// model

/** 0x4000 1D84 DAC2_DAHD **/
union DAC2_DAHD_REG{
	unsigned int reg;
	struct DAC2_DAHD_BITS{
		unsigned int _DAHD:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC2_DAHD (*((volatile union DAC2_DAHD_REG *)0x40001D84))
// model

/** 0x4000 1D88 DAC2_DATA **/
union DAC2_DATA_REG{
	unsigned int reg;
	struct DAC2_DATA_BITS{
		unsigned int _DATA:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC2_DATA (*((volatile union DAC2_DATA_REG *)0x40001D88))
// model

/** 0x4000 1D8C DAC2_CTL1 **/
union DAC2_CTL1_REG{
	unsigned int reg;
	struct DAC2_CTL1_BITS{
		unsigned int _SEL:1;
		unsigned int _RFS:2;
		unsigned int :1;
		unsigned int _CLK:2;
		unsigned int _BUFEN:1;
		unsigned int :2;
		unsigned int _CLKDIV:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC2_CTL1 (*((volatile union DAC2_CTL1_REG *)0x40001D8C))
// model

/** 0x4000 1D94 DAC2_CAL **/
union DAC2_CAL_REG{
	unsigned int reg;
	struct DAC2_CAL_BITS{
		unsigned int _TPEN:1;
		unsigned int _TP:2;
		unsigned int :10;
		unsigned int _TRIMLO:1;
		unsigned int _TRIMHI:1;
		unsigned int _TRIMSTATE:1;
		unsigned int _TRIMN:6;
		unsigned int _TRIMNPOL:1;
		unsigned int :1;
		unsigned int _TRIMP:6;
		unsigned int _TRIMPPOL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC2_CAL (*((volatile union DAC2_CAL_REG *)0x40001D94))
// modelDAC3

/** 0x4000 1E00 DAC3_CTL **/
union DAC3_CTL_REG{
	unsigned int reg;
	struct DAC3_CTL_BITS{
		unsigned int _EN:1;
		unsigned int _DE:1;
		unsigned int :1;
		unsigned int _TRIGEN:1;
		unsigned int _TREVT:4;
		unsigned int _WAVE:2;
		unsigned int _MAS:4;
		unsigned int _SWTRIG:1;
		unsigned int _DF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC3_CTL (*((volatile union DAC3_CTL_REG *)0x40001E00))
// model

/** 0x4000 1E04 DAC3_DAHD **/
union DAC3_DAHD_REG{
	unsigned int reg;
	struct DAC3_DAHD_BITS{
		unsigned int _DAHD:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC3_DAHD (*((volatile union DAC3_DAHD_REG *)0x40001E04))
// model

/** 0x4000 1E08 DAC3_DATA **/
union DAC3_DATA_REG{
	unsigned int reg;
	struct DAC3_DATA_BITS{
		unsigned int _DATA:12;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC3_DATA (*((volatile union DAC3_DATA_REG *)0x40001E08))
// model

/** 0x4000 1E0C DAC3_CTL1 **/
union DAC3_CTL1_REG{
	unsigned int reg;
	struct DAC3_CTL1_BITS{
		unsigned int _SEL:1;
		unsigned int _RFS:2;
		unsigned int :1;
		unsigned int _CLK:2;
		unsigned int _BUFEN:1;
		unsigned int :2;
		unsigned int _CLKDIV:3;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC3_CTL1 (*((volatile union DAC3_CTL1_REG *)0x40001E0C))
// model

/** 0x4000 1E14 DAC3_CAL **/
union DAC3_CAL_REG{
	unsigned int reg;
	struct DAC3_CAL_BITS{
		unsigned int :13;
		unsigned int _TRIMLO:1;
		unsigned int _TRIMHI:1;
		unsigned int _TRIMSTATE:1;
		unsigned int _TRIMN:6;
		unsigned int _TRIMNPOL:1;
		unsigned int :1;
		unsigned int _TRIMP:6;
		unsigned int _TRIMPPOL:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DAC3_CAL (*((volatile union DAC3_CAL_REG *)0x40001E14))
// modelCMP

/** 0x4000 0800 CMP_CTL0 **/
union CMP_CTL0_REG{
	unsigned int reg;
	struct CMP_CTL0_BITS{
		unsigned int :1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int _WINCLKSEL:1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int :4;
		unsigned int _NMOD:4;
		unsigned int _PMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL0 (*((volatile union CMP_CTL0_REG *)0x40000800))
// model

/** 0x4000 0804 CMP_CTL1 **/
union CMP_CTL1_REG{
	unsigned int reg;
	struct CMP_CTL1_BITS{
		unsigned int :1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int _WINCLKSEL:1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int :4;
		unsigned int _NMOD:4;
		unsigned int _PMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL1 (*((volatile union CMP_CTL1_REG *)0x40000804))
// model

/** 0x4000 0808 CMP_CTL2 **/
union CMP_CTL2_REG{
	unsigned int reg;
	struct CMP_CTL2_BITS{
		unsigned int :1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int _WINCLKSEL:1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int :4;
		unsigned int _NMOD:4;
		unsigned int _PMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL2 (*((volatile union CMP_CTL2_REG *)0x40000808))
// model

/** 0x4000 080C CMP_CTL3 **/
union CMP_CTL3_REG{
	unsigned int reg;
	struct CMP_CTL3_BITS{
		unsigned int _EN:1;
		unsigned int _POL:1;
		unsigned int _WINEN:1;
		unsigned int _FLTEN:1;
		unsigned int _FLTCNT:3;
		unsigned int _WINCLKSEL:1;
		unsigned int _FLTDIV:8;
		unsigned int _FLTCS:2;
		unsigned int _IFREN:1;
		unsigned int _IFFEN:1;
		unsigned int :3;
		unsigned int _CMP3PSEL:1;
		unsigned int :1;
		unsigned int _NMOD:3;
		unsigned int _PMOD:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL3 (*((volatile union CMP_CTL3_REG *)0x4000080C))
// model

/** 0x4000 0810 CMP_CTL4 **/
union CMP_CTL4_REG{
	unsigned int reg;
	struct CMP_CTL4_BITS{
		unsigned int _C0EN:1;
		unsigned int _C1EN:1;
		unsigned int _C2EN:1;
		unsigned int _FLTINSEL:1;
		unsigned int _BEMFEN:1;
		unsigned int _HALLSEL:1;
		unsigned int _DELAYVOL:2;
		unsigned int _CMPOUTDSEL:2;
		unsigned int _IOEN:1;
		unsigned int :1;
		unsigned int _C0IE:1;
		unsigned int _C1IE:1;
		unsigned int _C2IE:1;
		unsigned int _C3IE:1;
		unsigned int _C0IC:1;
		unsigned int _C1IC:1;
		unsigned int _C2IC:1;
		unsigned int _C3IC:1;
		unsigned int _CMPOUTASEL:2;
		unsigned int _PWMCMP:1;
		unsigned int _CIFMS:1;
		unsigned int _C0IF:1;
		unsigned int _C1IF:1;
		unsigned int _C2IF:1;
		unsigned int _C3IF:1;
		unsigned int _C0OUT:1;
		unsigned int _C1OUT:1;
		unsigned int _C2OUT:1;
		unsigned int _C3OUT:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL4 (*((volatile union CMP_CTL4_REG *)0x40000810))
// model

/** 0x4000 0814 CMP_CTL5 **/
union CMP_CTL5_REG{
	unsigned int reg;
	struct CMP_CTL5_BITS{
		unsigned int _C0TRGSEL:2;
		unsigned int _C1TRGSEL:2;
		unsigned int _C2TRGSEL:2;
		unsigned int _C3TRGSEL:2;
		unsigned int _CMPLPEN:1;
		unsigned int :19;
		unsigned int _C0PSEL:2;
		unsigned int _MOTORSEL:1;
		unsigned int _INSCM:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_CTL5 (*((volatile union CMP_CTL5_REG *)0x40000814))
// model

/** 0x4000 0818 CMP_TRIM0 **/
union CMP_TRIM0_REG{
	unsigned int reg;
	struct CMP_TRIM0_BITS{
		unsigned int _C0TRIMNPOL:1;
		unsigned int _C0TRIMN:6;
		unsigned int _C0TRIMPPOL:1;
		unsigned int _C0TRIMP:6;
		unsigned int :16;
		unsigned int _CMPTRIMLOWEN:1;
		unsigned int _CMPTRIMHIGHEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_TRIM0 (*((volatile union CMP_TRIM0_REG *)0x40000818))
// model

/** 0x4000 081C CMP_TRIM1 **/
union CMP_TRIM1_REG{
	unsigned int reg;
	struct CMP_TRIM1_BITS{
		unsigned int _C1TRIMNPOL:1;
		unsigned int _C1TRIMN:6;
		unsigned int _C1TRIMPPOL:1;
		unsigned int _C1TRIMP:6;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_TRIM1 (*((volatile union CMP_TRIM1_REG *)0x4000081C))
// model

/** 0x4000 0820 CMP_TRIM2 **/
union CMP_TRIM2_REG{
	unsigned int reg;
	struct CMP_TRIM2_BITS{
		unsigned int _C2TRIMNPOL:1;
		unsigned int _C2TRIMN:6;
		unsigned int _C2TRIMPPOL:1;
		unsigned int _C2TRIMP:6;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_TRIM2 (*((volatile union CMP_TRIM2_REG *)0x40000820))
// model

/** 0x4000 0824 CMP_TRIM3 **/
union CMP_TRIM3_REG{
	unsigned int reg;
	struct CMP_TRIM3_BITS{
		unsigned int _C3TRIMNPOL:1;
		unsigned int _C3TRIMN:6;
		unsigned int _C3TRIMPPOL:1;
		unsigned int _C3TRIMP:6;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CMP_TRIM3 (*((volatile union CMP_TRIM3_REG *)0x40000824))
// modelT0

/** 0x4000 0880 T0_CNT **/
union T0_CNT_REG{
	unsigned int reg;
	struct T0_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CNT (*((volatile union T0_CNT_REG *)0x40000880))
// model

/** 0x4000 0884 T0_CTL1 **/
union T0_CTL1_REG{
	unsigned int reg;
	struct T0_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CTL1 (*((volatile union T0_CTL1_REG *)0x40000884))
// model

/** 0x4000 0888 T0_CTL2 **/
union T0_CTL2_REG{
	unsigned int reg;
	struct T0_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_CTL2 (*((volatile union T0_CTL2_REG *)0x40000888))
// model

/** 0x4000 088C T0_PRSC **/
union T0_PRSC_REG{
	unsigned int reg;
	struct T0_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_PRSC (*((volatile union T0_PRSC_REG *)0x4000088C))
// model

/** 0x4000 0890 T0_PPX **/
union T0_PPX_REG{
	unsigned int reg;
	struct T0_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_PPX (*((volatile union T0_PPX_REG *)0x40000890))
// model

/** 0x4000 0894 T0_UDTIMx **/
union T0_UDTIMx_REG{
	unsigned int reg;
	struct T0_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T0_UDTIMx (*((volatile union T0_UDTIMx_REG *)0x40000894))
// modelCCP0

/** 0x4000 08A0 CCP0_C1 **/
union CCP0_C1_REG{
	unsigned int reg;
	struct CCP0_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C1 (*((volatile union CCP0_C1_REG *)0x400008A0))
// model

/** 0x4000 08A4 CCP0_C2 **/
union CCP0_C2_REG{
	unsigned int reg;
	struct CCP0_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C2 (*((volatile union CCP0_C2_REG *)0x400008A4))
// model

/** 0x4000 08A8 CCP0_C3 **/
union CCP0_C3_REG{
	unsigned int reg;
	struct CCP0_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C3 (*((volatile union CCP0_C3_REG *)0x400008A8))
// model

/** 0x4000 08AC CCP0_C4 **/
union CCP0_C4_REG{
	unsigned int reg;
	struct CCP0_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_C4 (*((volatile union CCP0_C4_REG *)0x400008AC))
// model

/** 0x4000 08B0 CCP0_SRIC **/
union CCP0_SRIC_REG{
	unsigned int reg;
	struct CCP0_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_SRIC (*((volatile union CCP0_SRIC_REG *)0x400008B0))
// model

/** 0x4000 08B4 CCP0_DF **/
union CCP0_DF_REG{
	unsigned int reg;
	struct CCP0_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_DF (*((volatile union CCP0_DF_REG *)0x400008B4))
// model

/** 0x4000 08C0 CCP0_CTL1 **/
union CCP0_CTL1_REG{
	unsigned int reg;
	struct CCP0_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL1 (*((volatile union CCP0_CTL1_REG *)0x400008C0))
// model

/** 0x4000 08C4 CCP0_R1 **/
union CCP0_R1_REG{
	unsigned int reg;
	struct CCP0_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R1 (*((volatile union CCP0_R1_REG *)0x400008C4))
// model

/** 0x4000 08C8 CCP0_R2 **/
union CCP0_R2_REG{
	unsigned int reg;
	struct CCP0_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R2 (*((volatile union CCP0_R2_REG *)0x400008C8))
// model

/** 0x4000 08CC CCP0_R3 **/
union CCP0_R3_REG{
	unsigned int reg;
	struct CCP0_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R3 (*((volatile union CCP0_R3_REG *)0x400008CC))
// model

/** 0x4000 08D0 CCP0_R4 **/
union CCP0_R4_REG{
	unsigned int reg;
	struct CCP0_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_R4 (*((volatile union CCP0_R4_REG *)0x400008D0))
// model

/** 0x4000 08D4 CCP0_CTL2 **/
union CCP0_CTL2_REG{
	unsigned int reg;
	struct CCP0_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL2 (*((volatile union CCP0_CTL2_REG *)0x400008D4))
// model

/** 0x4000 08D8 CCP0_CTL3 **/
union CCP0_CTL3_REG{
	unsigned int reg;
	struct CCP0_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_CTL3 (*((volatile union CCP0_CTL3_REG *)0x400008D8))
// model

/** 0x4000 08DC CCP0_EGIF **/
union CCP0_EGIF_REG{
	unsigned int reg;
	struct CCP0_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP0_EGIF (*((volatile union CCP0_EGIF_REG *)0x400008DC))
// modelUSART0

/** 0x4000 0980 USART0_CTLR **/
union USART0_CTLR_REG{
	unsigned int reg;
	struct USART0_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLES:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_CTLR (*((volatile union USART0_CTLR_REG *)0x40000980))
// model

/** 0x4000 0984 USART0_BRGR **/
union USART0_BRGR_REG{
	unsigned int reg;
	struct USART0_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_BRGR (*((volatile union USART0_BRGR_REG *)0x40000984))
// model

/** 0x4000 0988 USART0_STR **/
union USART0_STR_REG{
	unsigned int reg;
	struct USART0_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TX1SEL:1;
		unsigned int _TX0SEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_STR (*((volatile union USART0_STR_REG *)0x40000988))
// model

/** 0x4000 098C USART0_TBUFR **/
union USART0_TBUFR_REG{
	unsigned int reg;
	struct USART0_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_TBUFR (*((volatile union USART0_TBUFR_REG *)0x4000098C))
// model

/** 0x4000 098C USART0_RBUFR **/
union USART0_RBUFR_REG{
	unsigned int reg;
	struct USART0_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_RBUFR (*((volatile union USART0_RBUFR_REG *)0x4000098C))
// model

/** 0x4000 0990 USART0_U7816R **/
union USART0_U7816R_REG{
	unsigned int reg;
	struct USART0_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int _TREPMS:1;
		unsigned int _CLKDIV:8;
		unsigned int :1;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_U7816R (*((volatile union USART0_U7816R_REG *)0x40000990))
// model

/** 0x4000 0994 USART0_IER **/
union USART0_IER_REG{
	unsigned int reg;
	struct USART0_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_IER (*((volatile union USART0_IER_REG *)0x40000994))
// model

/** 0x4000 0998 USART0_ADM **/
union USART0_ADM_REG{
	unsigned int reg;
	struct USART0_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART0_ADM (*((volatile union USART0_ADM_REG *)0x40000998))
// modelUSART1

/** 0x4000 0A00 USART1_CTLR **/
union USART1_CTLR_REG{
	unsigned int reg;
	struct USART1_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLES:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_CTLR (*((volatile union USART1_CTLR_REG *)0x40000A00))
// model

/** 0x4000 0A04 USART1_BRGR **/
union USART1_BRGR_REG{
	unsigned int reg;
	struct USART1_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_BRGR (*((volatile union USART1_BRGR_REG *)0x40000A04))
// model

/** 0x4000 0A08 USART1_STR **/
union USART1_STR_REG{
	unsigned int reg;
	struct USART1_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TX1SEL:1;
		unsigned int _TX0SEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_STR (*((volatile union USART1_STR_REG *)0x40000A08))
// model

/** 0x4000 0A0C USART1_TBUFR **/
union USART1_TBUFR_REG{
	unsigned int reg;
	struct USART1_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_TBUFR (*((volatile union USART1_TBUFR_REG *)0x40000A0C))
// model

/** 0x4000 0A0C USART1_RBUFR **/
union USART1_RBUFR_REG{
	unsigned int reg;
	struct USART1_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_RBUFR (*((volatile union USART1_RBUFR_REG *)0x40000A0C))
// model

/** 0x4000 0A10 USART1_U7816R **/
union USART1_U7816R_REG{
	unsigned int reg;
	struct USART1_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int _TREPMS:1;
		unsigned int _CLKDIV:8;
		unsigned int :1;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_U7816R (*((volatile union USART1_U7816R_REG *)0x40000A10))
// model

/** 0x4000 0A14 USART1_IER **/
union USART1_IER_REG{
	unsigned int reg;
	struct USART1_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_IER (*((volatile union USART1_IER_REG *)0x40000A14))
// model

/** 0x4000 0A18 USART1_ADM **/
union USART1_ADM_REG{
	unsigned int reg;
	struct USART1_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART1_ADM (*((volatile union USART1_ADM_REG *)0x40000A18))
// modelUSART2

/** 0x4000 0A80 USART2_CTLR **/
union USART2_CTLR_REG{
	unsigned int reg;
	struct USART2_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLES:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_CTLR (*((volatile union USART2_CTLR_REG *)0x40000A80))
// model

/** 0x4000 0A84 USART2_BRGR **/
union USART2_BRGR_REG{
	unsigned int reg;
	struct USART2_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_BRGR (*((volatile union USART2_BRGR_REG *)0x40000A84))
// model

/** 0x4000 0A88 USART2_STR **/
union USART2_STR_REG{
	unsigned int reg;
	struct USART2_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TX1SEL:1;
		unsigned int _TX0SEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_STR (*((volatile union USART2_STR_REG *)0x40000A88))
// model

/** 0x4000 0A8C USART2_TBUFR **/
union USART2_TBUFR_REG{
	unsigned int reg;
	struct USART2_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_TBUFR (*((volatile union USART2_TBUFR_REG *)0x40000A8C))
// model

/** 0x4000 0A8C USART2_RBUFR **/
union USART2_RBUFR_REG{
	unsigned int reg;
	struct USART2_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_RBUFR (*((volatile union USART2_RBUFR_REG *)0x40000A8C))
// model

/** 0x4000 0A90 USART2_U7816R **/
union USART2_U7816R_REG{
	unsigned int reg;
	struct USART2_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int _TREPMS:1;
		unsigned int _CLKDIV:8;
		unsigned int :1;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_U7816R (*((volatile union USART2_U7816R_REG *)0x40000A90))
// model

/** 0x4000 0A94 USART2_IER **/
union USART2_IER_REG{
	unsigned int reg;
	struct USART2_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_IER (*((volatile union USART2_IER_REG *)0x40000A94))
// model

/** 0x4000 0A98 USART2_ADM **/
union USART2_ADM_REG{
	unsigned int reg;
	struct USART2_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART2_ADM (*((volatile union USART2_ADM_REG *)0x40000A98))
// modelUSART4

/** 0x4000 0B80 USART4_CTLR **/
union USART4_CTLR_REG{
	unsigned int reg;
	struct USART4_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLES:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_CTLR (*((volatile union USART4_CTLR_REG *)0x40000B80))
// model

/** 0x4000 0B84 USART4_BRGR **/
union USART4_BRGR_REG{
	unsigned int reg;
	struct USART4_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_BRGR (*((volatile union USART4_BRGR_REG *)0x40000B84))
// model

/** 0x4000 0B88 USART4_STR **/
union USART4_STR_REG{
	unsigned int reg;
	struct USART4_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TX1SEL:1;
		unsigned int _TX0SEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_STR (*((volatile union USART4_STR_REG *)0x40000B88))
// model

/** 0x4000 0B8C USART4_TBUFR **/
union USART4_TBUFR_REG{
	unsigned int reg;
	struct USART4_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_TBUFR (*((volatile union USART4_TBUFR_REG *)0x40000B8C))
// model

/** 0x4000 0B8C USART4_RBUFR **/
union USART4_RBUFR_REG{
	unsigned int reg;
	struct USART4_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_RBUFR (*((volatile union USART4_RBUFR_REG *)0x40000B8C))
// model

/** 0x4000 0B90 USART4_U7816R **/
union USART4_U7816R_REG{
	unsigned int reg;
	struct USART4_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int _TREPMS:1;
		unsigned int _CLKDIV:8;
		unsigned int :1;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_U7816R (*((volatile union USART4_U7816R_REG *)0x40000B90))
// model

/** 0x4000 0B94 USART4_IER **/
union USART4_IER_REG{
	unsigned int reg;
	struct USART4_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_IER (*((volatile union USART4_IER_REG *)0x40000B94))
// model

/** 0x4000 0B98 USART4_ADM **/
union USART4_ADM_REG{
	unsigned int reg;
	struct USART4_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART4_ADM (*((volatile union USART4_ADM_REG *)0x40000B98))
// modelSPI0

/** 0x4000 0C00 SPI0_BRGR **/
union SPI0_BRGR_REG{
	unsigned int reg;
	struct SPI0_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_BRGR (*((volatile union SPI0_BRGR_REG *)0x40000C00))
// model

/** 0x4000 0C04 SPI0_CTLR **/
union SPI0_CTLR_REG{
	unsigned int reg;
	struct SPI0_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int _SSEL:2;
		unsigned int _I2SMD:1;
		unsigned int :1;
		unsigned int _MCKOS:1;
		unsigned int :1;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_CTLR (*((volatile union SPI0_CTLR_REG *)0x40000C04))
// model

/** 0x4000 0C08 SPI0_BUFR **/
union SPI0_BUFR_REG{
	unsigned int reg;
	struct SPI0_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_BUFR (*((volatile union SPI0_BUFR_REG *)0x40000C08))
// model

/** 0x4000 0C0C SPI0_STR **/
union SPI0_STR_REG{
	unsigned int reg;
	struct SPI0_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int :4;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int :1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI0_STR (*((volatile union SPI0_STR_REG *)0x40000C0C))
// modelSPI1

/** 0x4000 0C80 SPI1_BRGR **/
union SPI1_BRGR_REG{
	unsigned int reg;
	struct SPI1_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_BRGR (*((volatile union SPI1_BRGR_REG *)0x40000C80))
// model

/** 0x4000 0C84 SPI1_CTLR **/
union SPI1_CTLR_REG{
	unsigned int reg;
	struct SPI1_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int _SSEL:2;
		unsigned int _I2SMD:1;
		unsigned int :1;
		unsigned int _MCKOS:1;
		unsigned int :1;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_CTLR (*((volatile union SPI1_CTLR_REG *)0x40000C84))
// model

/** 0x4000 0C88 SPI1_BUFR **/
union SPI1_BUFR_REG{
	unsigned int reg;
	struct SPI1_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_BUFR (*((volatile union SPI1_BUFR_REG *)0x40000C88))
// model

/** 0x4000 0C8C SPI1_STR **/
union SPI1_STR_REG{
	unsigned int reg;
	struct SPI1_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int :4;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int :1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI1_STR (*((volatile union SPI1_STR_REG *)0x40000C8C))
// modelI2C0

/** 0x4000 0D00 I2C0_CTLR **/
union I2C0_CTLR_REG{
	unsigned int reg;
	struct I2C0_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :2;
		unsigned int _DHCNT:4;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int _SCLNOSTR:1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEN:1;
		unsigned int _A10MSKEN:1;
		unsigned int _I2CCKS:2;
		unsigned int _I2CCKDIV:2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _NMENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_CTLR (*((volatile union I2C0_CTLR_REG *)0x40000D00))
// model

/** 0x4000 0D04 I2C0_SR **/
union I2C0_SR_REG{
	unsigned int reg;
	struct I2C0_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :2;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int _BERRIF:1;
		unsigned int _OVERIF:1;
		unsigned int _BUSY:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_SR (*((volatile union I2C0_SR_REG *)0x40000D04))
// model

/** 0x4000 0D08 I2C0_BUFR **/
union I2C0_BUFR_REG{
	unsigned int reg;
	struct I2C0_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_BUFR (*((volatile union I2C0_BUFR_REG *)0x40000D08))
// model

/** 0x4000 0D0C I2C0_ADDR0 **/
union I2C0_ADDR0_REG{
	unsigned int reg;
	struct I2C0_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR0 (*((volatile union I2C0_ADDR0_REG *)0x40000D0C))
// model

/** 0x4000 0D10 I2C0_BRGR **/
union I2C0_BRGR_REG{
	unsigned int reg;
	struct I2C0_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_BRGR (*((volatile union I2C0_BRGR_REG *)0x40000D10))
// model

/** 0x4000 0D14 I2C0_ADDR1 **/
union I2C0_ADDR1_REG{
	unsigned int reg;
	struct I2C0_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR1 (*((volatile union I2C0_ADDR1_REG *)0x40000D14))
// model

/** 0x4000 0D18 I2C0_ADDR2 **/
union I2C0_ADDR2_REG{
	unsigned int reg;
	struct I2C0_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR2 (*((volatile union I2C0_ADDR2_REG *)0x40000D18))
// model

/** 0x4000 0D1C I2C0_ADDR3 **/
union I2C0_ADDR3_REG{
	unsigned int reg;
	struct I2C0_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_ADDR3 (*((volatile union I2C0_ADDR3_REG *)0x40000D1C))
// model

/** 0x4000 0D20 I2C0_IER **/
union I2C0_IER_REG{
	unsigned int reg;
	struct I2C0_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIE:1;
		unsigned int :3;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :4;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int _BERRIE:1;
		unsigned int _OVERIE:1;
		unsigned int :12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C0_IER (*((volatile union I2C0_IER_REG *)0x40000D20))
// modelI2C1

/** 0x4000 0D80 I2C1_CTLR **/
union I2C1_CTLR_REG{
	unsigned int reg;
	struct I2C1_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :2;
		unsigned int _DHCNT:4;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int _SCLNOSTR:1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEN:1;
		unsigned int _A10MSKEN:1;
		unsigned int _I2CCKS:2;
		unsigned int _I2CCKDIV:2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _NMENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_CTLR (*((volatile union I2C1_CTLR_REG *)0x40000D80))
// model

/** 0x4000 0D84 I2C1_SR **/
union I2C1_SR_REG{
	unsigned int reg;
	struct I2C1_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :2;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int _BERRIF:1;
		unsigned int _OVERIF:1;
		unsigned int _BUSY:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_SR (*((volatile union I2C1_SR_REG *)0x40000D84))
// model

/** 0x4000 0D88 I2C1_BUFR **/
union I2C1_BUFR_REG{
	unsigned int reg;
	struct I2C1_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_BUFR (*((volatile union I2C1_BUFR_REG *)0x40000D88))
// model

/** 0x4000 0D8C I2C1_ADDR0 **/
union I2C1_ADDR0_REG{
	unsigned int reg;
	struct I2C1_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR0 (*((volatile union I2C1_ADDR0_REG *)0x40000D8C))
// model

/** 0x4000 0D90 I2C1_BRGR **/
union I2C1_BRGR_REG{
	unsigned int reg;
	struct I2C1_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_BRGR (*((volatile union I2C1_BRGR_REG *)0x40000D90))
// model

/** 0x4000 0D94 I2C1_ADDR1 **/
union I2C1_ADDR1_REG{
	unsigned int reg;
	struct I2C1_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR1 (*((volatile union I2C1_ADDR1_REG *)0x40000D94))
// model

/** 0x4000 0D98 I2C1_ADDR2 **/
union I2C1_ADDR2_REG{
	unsigned int reg;
	struct I2C1_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR2 (*((volatile union I2C1_ADDR2_REG *)0x40000D98))
// model

/** 0x4000 0D9C I2C1_ADDR3 **/
union I2C1_ADDR3_REG{
	unsigned int reg;
	struct I2C1_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_ADDR3 (*((volatile union I2C1_ADDR3_REG *)0x40000D9C))
// model

/** 0x4000 0DA0 I2C1_IER **/
union I2C1_IER_REG{
	unsigned int reg;
	struct I2C1_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIE:1;
		unsigned int :3;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :4;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int _BERRIE:1;
		unsigned int _OVERIE:1;
		unsigned int :12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C1_IER (*((volatile union I2C1_IER_REG *)0x40000DA0))
// modelI2C2

/** 0x4000 0E00 I2C2_CTLR **/
union I2C2_CTLR_REG{
	unsigned int reg;
	struct I2C2_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :2;
		unsigned int _DHCNT:4;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int _SCLNOSTR:1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEN:1;
		unsigned int _A10MSKEN:1;
		unsigned int _I2CCKS:2;
		unsigned int _I2CCKDIV:2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _NMENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_CTLR (*((volatile union I2C2_CTLR_REG *)0x40000E00))
// model

/** 0x4000 0E04 I2C2_SR **/
union I2C2_SR_REG{
	unsigned int reg;
	struct I2C2_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :2;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int _BERRIF:1;
		unsigned int _OVERIF:1;
		unsigned int _BUSY:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_SR (*((volatile union I2C2_SR_REG *)0x40000E04))
// model

/** 0x4000 0E08 I2C2_BUFR **/
union I2C2_BUFR_REG{
	unsigned int reg;
	struct I2C2_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_BUFR (*((volatile union I2C2_BUFR_REG *)0x40000E08))
// model

/** 0x4000 0E0C I2C2_ADDR0 **/
union I2C2_ADDR0_REG{
	unsigned int reg;
	struct I2C2_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR0 (*((volatile union I2C2_ADDR0_REG *)0x40000E0C))
// model

/** 0x4000 0E10 I2C2_BRGR **/
union I2C2_BRGR_REG{
	unsigned int reg;
	struct I2C2_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_BRGR (*((volatile union I2C2_BRGR_REG *)0x40000E10))
// model

/** 0x4000 0E14 I2C2_ADDR1 **/
union I2C2_ADDR1_REG{
	unsigned int reg;
	struct I2C2_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR1 (*((volatile union I2C2_ADDR1_REG *)0x40000E14))
// model

/** 0x4000 0E18 I2C2_ADDR2 **/
union I2C2_ADDR2_REG{
	unsigned int reg;
	struct I2C2_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR2 (*((volatile union I2C2_ADDR2_REG *)0x40000E18))
// model

/** 0x4000 0E1C I2C2_ADDR3 **/
union I2C2_ADDR3_REG{
	unsigned int reg;
	struct I2C2_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_ADDR3 (*((volatile union I2C2_ADDR3_REG *)0x40000E1C))
// model

/** 0x4000 0E20 I2C2_IER **/
union I2C2_IER_REG{
	unsigned int reg;
	struct I2C2_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIE:1;
		unsigned int :3;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :4;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int _BERRIE:1;
		unsigned int _OVERIE:1;
		unsigned int :12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C2_IER (*((volatile union I2C2_IER_REG *)0x40000E20))
// modelRTC

/** 0x4000 0F00 RTC_CR **/
union RTC_CR_REG{
	unsigned int reg;
	struct RTC_CR_BITS{
		unsigned int _RTCEN:1;
		unsigned int _LD:1;
		unsigned int _RTOFF:1;
		unsigned int _CNF:1;
		unsigned int _HT:1;
		unsigned int _LIF:1;
		unsigned int _RESET:1;
		unsigned int :1;
		unsigned int _RTCTSCH:6;
		unsigned int _RTCCLKS:2;
		unsigned int _RTCTT:3;
		unsigned int _SUB1H:1;
		unsigned int _ADD1H:1;
		unsigned int _TSEN:1;
		unsigned int _TSEDGE:1;
		unsigned int _LPPINEN:1;
		unsigned int _RTCCAL:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_CR (*((volatile union RTC_CR_REG *)0x40000F00))
// model

/** 0x4000 0F04 RTC_ALRA **/
union RTC_ALRA_REG{
	unsigned int reg;
	struct RTC_ALRA_BITS{
		unsigned int _ALRSA:7;
		unsigned int _ASENA:1;
		unsigned int _ALRMA:7;
		unsigned int _AMENA:1;
		unsigned int _ALRHA:6;
		unsigned int _AMPMA:1;
		unsigned int _AHENA:1;
		unsigned int _ALRWA:3;
		unsigned int _AWENA:1;
		unsigned int :3;
		unsigned int _ALRENA:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_ALRA (*((volatile union RTC_ALRA_REG *)0x40000F04))
// model

/** 0x4000 0F08 RTC_TMR **/
union RTC_TMR_REG{
	unsigned int reg;
	struct RTC_TMR_BITS{
		unsigned int _SEC:7;
		unsigned int :1;
		unsigned int _MIN:7;
		unsigned int :1;
		unsigned int _HOUR:6;
		unsigned int _AMPM:1;
		unsigned int :1;
		unsigned int _WEK:3;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TMR (*((volatile union RTC_TMR_REG *)0x40000F08))
// model

/** 0x4000 0F0C RTC_DTR **/
union RTC_DTR_REG{
	unsigned int reg;
	struct RTC_DTR_BITS{
		unsigned int _DAY:6;
		unsigned int :2;
		unsigned int _MTH:5;
		unsigned int :3;
		unsigned int _YEAR:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_DTR (*((volatile union RTC_DTR_REG *)0x40000F0C))
// model

/** 0x4000 0F10 RTC_ALRB **/
union RTC_ALRB_REG{
	unsigned int reg;
	struct RTC_ALRB_BITS{
		unsigned int _ALRSB:7;
		unsigned int _ASENB:1;
		unsigned int _ALRMB:7;
		unsigned int _AMENB:1;
		unsigned int _ALRHB:6;
		unsigned int _AMPMB:1;
		unsigned int _AHENB:1;
		unsigned int _ALRWB:3;
		unsigned int _AWENB:1;
		unsigned int :3;
		unsigned int _ALRENB:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_ALRB (*((volatile union RTC_ALRB_REG *)0x40000F10))
// model

/** 0x4000 0F14 RTC_TMER **/
union RTC_TMER_REG{
	unsigned int reg;
	struct RTC_TMER_BITS{
		unsigned int _TMR0:16;
		unsigned int _TMR1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TMER (*((volatile union RTC_TMER_REG *)0x40000F14))
// model

/** 0x4000 0F18 RTC_TCR **/
union RTC_TCR_REG{
	unsigned int reg;
	struct RTC_TCR_BITS{
		unsigned int _TMR0C:4;
		unsigned int _TMR1C:4;
		unsigned int _TMR0EN:1;
		unsigned int _TMR1EN:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TCR (*((volatile union RTC_TCR_REG *)0x40000F18))
// model

/** 0x4000 0F1C RTC_IER **/
union RTC_IER_REG{
	unsigned int reg;
	struct RTC_IER_BITS{
		unsigned int _SECIE:1;
		unsigned int _MINIE:1;
		unsigned int _HOURIE:1;
		unsigned int _DAYIE:1;
		unsigned int _ALRAIE:1;
		unsigned int _ALRBIE:1;
		unsigned int _TTIE:1;
		unsigned int :1;
		unsigned int _RTCT0IE:1;
		unsigned int _RTCT1IE:1;
		unsigned int _TSOVFIE:1;
		unsigned int _TSIE:1;
		unsigned int :20;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_IER (*((volatile union RTC_IER_REG *)0x40000F1C))
// model

/** 0x4000 0F20 RTC_IFR **/
union RTC_IFR_REG{
	unsigned int reg;
	struct RTC_IFR_BITS{
		unsigned int _SECIF:1;
		unsigned int _MINIF:1;
		unsigned int _HOURIF:1;
		unsigned int _DAYIF:1;
		unsigned int _ALRAIF:1;
		unsigned int _ALRBIF:1;
		unsigned int _TTIF:1;
		unsigned int :1;
		unsigned int _RTCT0IF:1;
		unsigned int _RTCT1IF:1;
		unsigned int _TSOVFIF:1;
		unsigned int _TSIF:1;
		unsigned int :4;
		unsigned int _SECIC:1;
		unsigned int _MINIC:1;
		unsigned int _HOURIC:1;
		unsigned int _DAYIC:1;
		unsigned int _ALRAIC:1;
		unsigned int _ALRBIC:1;
		unsigned int _TTIC:1;
		unsigned int :1;
		unsigned int _RTCT0IC:1;
		unsigned int _RTCT1IC:1;
		unsigned int _TSOVFIC:1;
		unsigned int _TSIC:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_IFR (*((volatile union RTC_IFR_REG *)0x40000F20))
// model

/** 0x4000 0F24 RTC_TMBR **/
union RTC_TMBR_REG{
	unsigned int reg;
	struct RTC_TMBR_BITS{
		unsigned int _SECB:7;
		unsigned int :1;
		unsigned int _MINB:7;
		unsigned int :1;
		unsigned int _HOURB:6;
		unsigned int _AMPMB:1;
		unsigned int :1;
		unsigned int _WEKB:3;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_TMBR (*((volatile union RTC_TMBR_REG *)0x40000F24))
// model

/** 0x4000 0F28 RTC_DTBR **/
union RTC_DTBR_REG{
	unsigned int reg;
	struct RTC_DTBR_BITS{
		unsigned int _DAYB:6;
		unsigned int :2;
		unsigned int _MTHB:5;
		unsigned int :3;
		unsigned int _YEARB:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RTC_DTBR (*((volatile union RTC_DTBR_REG *)0x40000F28))
// modelCANFD6

/** 0x4000 2E80 CANFD6_CTLR0 **/
union CANFD6_CTLR0_REG{
	unsigned int reg;
	struct CANFD6_CTLR0_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _ISOFDCANEN:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _MBSIZE:2;
		unsigned int _FULLRXEN:1;
		unsigned int _ANSWEREN:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int :1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int _CANFDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_CTLR0 (*((volatile union CANFD6_CTLR0_REG *)0x40002E80))
// model

/** 0x4000 2E84 CANFD6_BRGR **/
union CANFD6_BRGR_REG{
	unsigned int reg;
	struct CANFD6_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _SJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int _BRSBRP:6;
		unsigned int _HTSEG1:4;
		unsigned int _HTSEG2:3;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_BRGR (*((volatile union CANFD6_BRGR_REG *)0x40002E84))
// model

/** 0x4000 2E88 CANFD6_RCR **/
union CANFD6_RCR_REG{
	unsigned int reg;
	struct CANFD6_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _DPRAMOF:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RCR (*((volatile union CANFD6_RCR_REG *)0x40002E88))
// model

/** 0x4000 2E8C CANFD6_EROR **/
union CANFD6_EROR_REG{
	unsigned int reg;
	struct CANFD6_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int _SOSFD:5;
		unsigned int _SFDEN:1;
		unsigned int _SFDMOD:1;
		unsigned int _DPRAMFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_EROR (*((volatile union CANFD6_EROR_REG *)0x40002E8C))
// model

/** 0x4000 2E90 CANFD6_CTLR2 **/
union CANFD6_CTLR2_REG{
	unsigned int reg;
	struct CANFD6_CTLR2_BITS{
		unsigned int _TDCV:7;
		unsigned int _TDC0EN:1;
		unsigned int _TDCEN:1;
		unsigned int _TDCAUT0:1;
		unsigned int _TDCS:2;
		unsigned int _TDCSR:2;
		unsigned int _TDC0:2;
		unsigned int _TDCVM:7;
		unsigned int :1;
		unsigned int _DESEL:1;
		unsigned int _AMCKDIV:2;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_CTLR2 (*((volatile union CANFD6_CTLR2_REG *)0x40002E90))
// model

/** 0x4000 2E94 CANFD6_MSKR **/
union CANFD6_MSKR_REG{
	unsigned int reg;
	struct CANFD6_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_MSKR (*((volatile union CANFD6_MSKR_REG *)0x40002E94))
// model

/** 0x4000 2E98 CANFD6_IER **/
union CANFD6_IER_REG{
	unsigned int reg;
	struct CANFD6_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CTXDE:1;
		unsigned int _CRXDE:1;
		unsigned int _RXBSTAIE:1;
		unsigned int _TRGMBIE:1;
		unsigned int _BOFFIE:1;
		unsigned int :1;
		unsigned int _ARBFAILIE:1;
		unsigned int _MOENDIE:1;
		unsigned int _CANRXIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int :2;
		unsigned int _MOENDIC:1;
		unsigned int _TRGMBIC:1;
		unsigned int _BOFFIC:1;
		unsigned int :1;
		unsigned int _LPCANGPIOSEL0:1;
		unsigned int _FAILCLR:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_IER (*((volatile union CANFD6_IER_REG *)0x40002E98))
// model

/** 0x4000 2E9C CANFD6_IFR **/
union CANFD6_IFR_REG{
	unsigned int reg;
	struct CANFD6_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CTXDF:1;
		unsigned int _CRXDF:1;
		unsigned int _RXBSTAIF:1;
		unsigned int _TRGMBIF:1;
		unsigned int _BOFFIF:1;
		unsigned int :1;
		unsigned int _MOENDIF:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_IFR (*((volatile union CANFD6_IFR_REG *)0x40002E9C))
// model

/** 0x4000 2EA0 CANFD6_RXDATA0 **/
union CANFD6_RXDATA0_REG{
	unsigned int reg;
	struct CANFD6_RXDATA0_BITS{
		unsigned int _RXDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA0 (*((volatile union CANFD6_RXDATA0_REG *)0x40002EA0))
// model

/** 0x4000 2EA4 CANFD6_RXDATA1 **/
union CANFD6_RXDATA1_REG{
	unsigned int reg;
	struct CANFD6_RXDATA1_BITS{
		unsigned int _RXDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA1 (*((volatile union CANFD6_RXDATA1_REG *)0x40002EA4))
// model

/** 0x4000 2EA8 CANFD6_RXDATA2 **/
union CANFD6_RXDATA2_REG{
	unsigned int reg;
	struct CANFD6_RXDATA2_BITS{
		unsigned int _RXDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA2 (*((volatile union CANFD6_RXDATA2_REG *)0x40002EA8))
// model

/** 0x4000 2EAC CANFD6_RXDATA3 **/
union CANFD6_RXDATA3_REG{
	unsigned int reg;
	struct CANFD6_RXDATA3_BITS{
		unsigned int _RXDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA3 (*((volatile union CANFD6_RXDATA3_REG *)0x40002EAC))
// model

/** 0x4000 2EB0 CANFD6_RXDATA4 **/
union CANFD6_RXDATA4_REG{
	unsigned int reg;
	struct CANFD6_RXDATA4_BITS{
		unsigned int _RXDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA4 (*((volatile union CANFD6_RXDATA4_REG *)0x40002EB0))
// model

/** 0x4000 2EB4 CANFD6_RXDATA5 **/
union CANFD6_RXDATA5_REG{
	unsigned int reg;
	struct CANFD6_RXDATA5_BITS{
		unsigned int _RXDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA5 (*((volatile union CANFD6_RXDATA5_REG *)0x40002EB4))
// model

/** 0x4000 2EB8 CANFD6_RXDATA6 **/
union CANFD6_RXDATA6_REG{
	unsigned int reg;
	struct CANFD6_RXDATA6_BITS{
		unsigned int _RXDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA6 (*((volatile union CANFD6_RXDATA6_REG *)0x40002EB8))
// model

/** 0x4000 2EBC CANFD6_RXDATA7 **/
union CANFD6_RXDATA7_REG{
	unsigned int reg;
	struct CANFD6_RXDATA7_BITS{
		unsigned int _RXDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA7 (*((volatile union CANFD6_RXDATA7_REG *)0x40002EBC))
// model

/** 0x4000 2EC0 CANFD6_RXDATA8 **/
union CANFD6_RXDATA8_REG{
	unsigned int reg;
	struct CANFD6_RXDATA8_BITS{
		unsigned int _RXDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA8 (*((volatile union CANFD6_RXDATA8_REG *)0x40002EC0))
// model

/** 0x4000 2EC4 CANFD6_RXDATA9 **/
union CANFD6_RXDATA9_REG{
	unsigned int reg;
	struct CANFD6_RXDATA9_BITS{
		unsigned int _RXDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA9 (*((volatile union CANFD6_RXDATA9_REG *)0x40002EC4))
// model

/** 0x4000 2EC8 CANFD6_RXDATA10 **/
union CANFD6_RXDATA10_REG{
	unsigned int reg;
	struct CANFD6_RXDATA10_BITS{
		unsigned int _RXDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA10 (*((volatile union CANFD6_RXDATA10_REG *)0x40002EC8))
// model

/** 0x4000 2ECC CANFD6_RXDATA11 **/
union CANFD6_RXDATA11_REG{
	unsigned int reg;
	struct CANFD6_RXDATA11_BITS{
		unsigned int _RXDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA11 (*((volatile union CANFD6_RXDATA11_REG *)0x40002ECC))
// model

/** 0x4000 2ED0 CANFD6_RXDATA12 **/
union CANFD6_RXDATA12_REG{
	unsigned int reg;
	struct CANFD6_RXDATA12_BITS{
		unsigned int _RXDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA12 (*((volatile union CANFD6_RXDATA12_REG *)0x40002ED0))
// model

/** 0x4000 2ED4 CANFD6_RXDATA13 **/
union CANFD6_RXDATA13_REG{
	unsigned int reg;
	struct CANFD6_RXDATA13_BITS{
		unsigned int _RXDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA13 (*((volatile union CANFD6_RXDATA13_REG *)0x40002ED4))
// model

/** 0x4000 2ED8 CANFD6_RXDATA14 **/
union CANFD6_RXDATA14_REG{
	unsigned int reg;
	struct CANFD6_RXDATA14_BITS{
		unsigned int _RXDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA14 (*((volatile union CANFD6_RXDATA14_REG *)0x40002ED8))
// model

/** 0x4000 2EDC CANFD6_RXDATA15 **/
union CANFD6_RXDATA15_REG{
	unsigned int reg;
	struct CANFD6_RXDATA15_BITS{
		unsigned int _RXDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA15 (*((volatile union CANFD6_RXDATA15_REG *)0x40002EDC))
// model

/** 0x4000 2EE0 CANFD6_RXDATA16 **/
union CANFD6_RXDATA16_REG{
	unsigned int reg;
	struct CANFD6_RXDATA16_BITS{
		unsigned int _RXDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA16 (*((volatile union CANFD6_RXDATA16_REG *)0x40002EE0))
// model

/** 0x4000 2EE4 CANFD6_RXDATA17 **/
union CANFD6_RXDATA17_REG{
	unsigned int reg;
	struct CANFD6_RXDATA17_BITS{
		unsigned int _RXDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_RXDATA17 (*((volatile union CANFD6_RXDATA17_REG *)0x40002EE4))
// model

/** 0x4000 2EE8 CANFD6_TIMER **/
union CANFD6_TIMER_REG{
	unsigned int reg;
	struct CANFD6_TIMER_BITS{
		unsigned int _CANTIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TIMER (*((volatile union CANFD6_TIMER_REG *)0x40002EE8))
// model

/** 0x4000 2EEC CANFD6_CRC **/
union CANFD6_CRC_REG{
	unsigned int reg;
	struct CANFD6_CRC_BITS{
		unsigned int _CRC:21;
		unsigned int :7;
		unsigned int _STUFFCNT:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_CRC (*((volatile union CANFD6_CRC_REG *)0x40002EEC))
// model

/** 0x4000 2EF4 CANFD6_CTLR1 **/
union CANFD6_CTLR1_REG{
	unsigned int reg;
	struct CANFD6_CTLR1_BITS{
		unsigned int _AMCKS:2;
		unsigned int _RXMUX:7;
		unsigned int _ST:1;
		unsigned int _FTCLKS:1;
		unsigned int _TSYN:1;
		unsigned int _MBNUM:1;
		unsigned int _MATCHMS:1;
		unsigned int _MBMSKEN:1;
		unsigned int _ARBMS:1;
		unsigned int _ARBSTART:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _TRGNUM:4;
		unsigned int _TRGMBSEL:7;
		unsigned int _TRGMBEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_CTLR1 (*((volatile union CANFD6_CTLR1_REG *)0x40002EF4))
// model

/** 0x4000 2EF8 CANFD6_AMSTA **/
union CANFD6_AMSTA_REG{
	unsigned int reg;
	struct CANFD6_AMSTA_BITS{
		unsigned int _MATWINNER:10;
		unsigned int _MATSTA:1;
		unsigned int _ROPSTA:1;
		unsigned int _RELRXALL:1;
		unsigned int _IDSELEN:1;
		unsigned int _RTRMEN:1;
		unsigned int _BETEN:1;
		unsigned int _ARBWINNER:10;
		unsigned int _ARBSTA0:1;
		unsigned int _ARBSTA1:1;
		unsigned int _TXCODE:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_AMSTA (*((volatile union CANFD6_AMSTA_REG *)0x40002EF8))
// model

/** 0x4000 2EFC CANFD6_TXDATA **/
union CANFD6_TXDATA_REG{
	unsigned int reg;
	struct CANFD6_TXDATA_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD6_TXDATA (*((volatile union CANFD6_TXDATA_REG *)0x40002EFC))
// modelCANFD7

/** 0x4000 2F00 CANFD7_CTLR0 **/
union CANFD7_CTLR0_REG{
	unsigned int reg;
	struct CANFD7_CTLR0_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _ISOFDCANEN:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _MBSIZE:2;
		unsigned int _FULLRXEN:1;
		unsigned int _ANSWEREN:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int :1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int _CANFDEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_CTLR0 (*((volatile union CANFD7_CTLR0_REG *)0x40002F00))
// model

/** 0x4000 2F04  CANFD7_BRGR **/
union  CANFD7_BRGR_REG{
	unsigned int reg;
	struct  CANFD7_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _SJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int _BRSBRP:6;
		unsigned int _HTSEG1:4;
		unsigned int _HTSEG2:3;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define  CANFD7_BRGR (*((volatile union  CANFD7_BRGR_REG *)0x40002F04))
// model

/** 0x4000 2F08 CANFD7_RCR **/
union CANFD7_RCR_REG{
	unsigned int reg;
	struct CANFD7_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _DPRAMOF:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RCR (*((volatile union CANFD7_RCR_REG *)0x40002F08))
// model

/** 0x4000 2F0C CANFD7_EROR **/
union CANFD7_EROR_REG{
	unsigned int reg;
	struct CANFD7_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int _SOSFD:5;
		unsigned int _SFDEN:1;
		unsigned int _SFDMOD:1;
		unsigned int _DPRAMFEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_EROR (*((volatile union CANFD7_EROR_REG *)0x40002F0C))
// model

/** 0x4000 2F10 CANFD7_CTLR2 **/
union CANFD7_CTLR2_REG{
	unsigned int reg;
	struct CANFD7_CTLR2_BITS{
		unsigned int _TDCV:7;
		unsigned int _TDCOEN:1;
		unsigned int _TDCEN:1;
		unsigned int _TDCAUT0:1;
		unsigned int _TDCS:2;
		unsigned int _TDCSR:2;
		unsigned int _TDC0:2;
		unsigned int _TDCVM:7;
		unsigned int :1;
		unsigned int _DESEL:1;
		unsigned int _AMCKDIV:2;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_CTLR2 (*((volatile union CANFD7_CTLR2_REG *)0x40002F10))
// model

/** 0x4000 2F14 CANFD7_MSKR **/
union CANFD7_MSKR_REG{
	unsigned int reg;
	struct CANFD7_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_MSKR (*((volatile union CANFD7_MSKR_REG *)0x40002F14))
// model

/** 0x4000 2F18 CANFD7_IER **/
union CANFD7_IER_REG{
	unsigned int reg;
	struct CANFD7_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CTXDE:1;
		unsigned int _CRXDE:1;
		unsigned int _RXBSTAIE:1;
		unsigned int _TRGMBIE:1;
		unsigned int _BOFFIE:1;
		unsigned int :1;
		unsigned int _ARBFAILIE:1;
		unsigned int _MOENDIE:1;
		unsigned int _CANRXIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int :2;
		unsigned int _MOENDIC:1;
		unsigned int _TRGMBIC:1;
		unsigned int _BOFFIC:1;
		unsigned int :2;
		unsigned int _FAILCLR:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_IER (*((volatile union CANFD7_IER_REG *)0x40002F18))
// model

/** 0x4000 2F1C CANFD7_IFR **/
union CANFD7_IFR_REG{
	unsigned int reg;
	struct CANFD7_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CTXDF:1;
		unsigned int _CRXDF:1;
		unsigned int _RXBSTAIF:1;
		unsigned int _TRGMBIF:1;
		unsigned int _BOFFIF:1;
		unsigned int :1;
		unsigned int _MOENDIF:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_IFR (*((volatile union CANFD7_IFR_REG *)0x40002F1C))
// model

/** 0x4000 2F20 CANFD7_RXDATA0 **/
union CANFD7_RXDATA0_REG{
	unsigned int reg;
	struct CANFD7_RXDATA0_BITS{
		unsigned int _RXDATA0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA0 (*((volatile union CANFD7_RXDATA0_REG *)0x40002F20))
// model

/** 0x4000 2F24 CANFD7_RXDATA1 **/
union CANFD7_RXDATA1_REG{
	unsigned int reg;
	struct CANFD7_RXDATA1_BITS{
		unsigned int _RXDATA1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA1 (*((volatile union CANFD7_RXDATA1_REG *)0x40002F24))
// model

/** 0x4000 2F28 CANFD7_RXDATA2 **/
union CANFD7_RXDATA2_REG{
	unsigned int reg;
	struct CANFD7_RXDATA2_BITS{
		unsigned int _RXDATA2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA2 (*((volatile union CANFD7_RXDATA2_REG *)0x40002F28))
// model

/** 0x4000 2F2C CANFD7_RXDATA3 **/
union CANFD7_RXDATA3_REG{
	unsigned int reg;
	struct CANFD7_RXDATA3_BITS{
		unsigned int _RXDATA3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA3 (*((volatile union CANFD7_RXDATA3_REG *)0x40002F2C))
// model

/** 0x4000 2F30 CANFD7_RXDATA4 **/
union CANFD7_RXDATA4_REG{
	unsigned int reg;
	struct CANFD7_RXDATA4_BITS{
		unsigned int _RXDATA4:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA4 (*((volatile union CANFD7_RXDATA4_REG *)0x40002F30))
// model

/** 0x4000 2F34 CANFD7_RXDATA5 **/
union CANFD7_RXDATA5_REG{
	unsigned int reg;
	struct CANFD7_RXDATA5_BITS{
		unsigned int _RXDATA5:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA5 (*((volatile union CANFD7_RXDATA5_REG *)0x40002F34))
// model

/** 0x4000 2F38 CANFD7_RXDATA6 **/
union CANFD7_RXDATA6_REG{
	unsigned int reg;
	struct CANFD7_RXDATA6_BITS{
		unsigned int _RXDATA6:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA6 (*((volatile union CANFD7_RXDATA6_REG *)0x40002F38))
// model

/** 0x4000 2F3C CANFD7_RXDATA7 **/
union CANFD7_RXDATA7_REG{
	unsigned int reg;
	struct CANFD7_RXDATA7_BITS{
		unsigned int _RXDATA7:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA7 (*((volatile union CANFD7_RXDATA7_REG *)0x40002F3C))
// model

/** 0x4000 2F40 CANFD7_RXDATA8 **/
union CANFD7_RXDATA8_REG{
	unsigned int reg;
	struct CANFD7_RXDATA8_BITS{
		unsigned int _RXDATA8:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA8 (*((volatile union CANFD7_RXDATA8_REG *)0x40002F40))
// model

/** 0x4000 2F44 CANFD7_RXDATA9 **/
union CANFD7_RXDATA9_REG{
	unsigned int reg;
	struct CANFD7_RXDATA9_BITS{
		unsigned int _RXDATA9:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA9 (*((volatile union CANFD7_RXDATA9_REG *)0x40002F44))
// model

/** 0x4000 2F48 CANFD7_RXDATA10 **/
union CANFD7_RXDATA10_REG{
	unsigned int reg;
	struct CANFD7_RXDATA10_BITS{
		unsigned int _RXDATA10:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA10 (*((volatile union CANFD7_RXDATA10_REG *)0x40002F48))
// model

/** 0x4000 2F4C CANFD7_RXDATA11 **/
union CANFD7_RXDATA11_REG{
	unsigned int reg;
	struct CANFD7_RXDATA11_BITS{
		unsigned int _RXDATA11:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA11 (*((volatile union CANFD7_RXDATA11_REG *)0x40002F4C))
// model

/** 0x4000 2F50 CANFD7_RXDATA12 **/
union CANFD7_RXDATA12_REG{
	unsigned int reg;
	struct CANFD7_RXDATA12_BITS{
		unsigned int _RXDATA12:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA12 (*((volatile union CANFD7_RXDATA12_REG *)0x40002F50))
// model

/** 0x4000 2F54 CANFD7_RXDATA13 **/
union CANFD7_RXDATA13_REG{
	unsigned int reg;
	struct CANFD7_RXDATA13_BITS{
		unsigned int _RXDATA13:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA13 (*((volatile union CANFD7_RXDATA13_REG *)0x40002F54))
// model

/** 0x4000 2F58 CANFD7_RXDATA14 **/
union CANFD7_RXDATA14_REG{
	unsigned int reg;
	struct CANFD7_RXDATA14_BITS{
		unsigned int _RXDATA14:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA14 (*((volatile union CANFD7_RXDATA14_REG *)0x40002F58))
// model

/** 0x4000 2F5C CANFD7_RXDATA15 **/
union CANFD7_RXDATA15_REG{
	unsigned int reg;
	struct CANFD7_RXDATA15_BITS{
		unsigned int _RXDATA15:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA15 (*((volatile union CANFD7_RXDATA15_REG *)0x40002F5C))
// model

/** 0x4000 2F60 CANFD7_RXDATA16 **/
union CANFD7_RXDATA16_REG{
	unsigned int reg;
	struct CANFD7_RXDATA16_BITS{
		unsigned int _RXDATA16:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA16 (*((volatile union CANFD7_RXDATA16_REG *)0x40002F60))
// model

/** 0x4000 2F64 CANFD7_RXDATA17 **/
union CANFD7_RXDATA17_REG{
	unsigned int reg;
	struct CANFD7_RXDATA17_BITS{
		unsigned int _RXDATA17:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_RXDATA17 (*((volatile union CANFD7_RXDATA17_REG *)0x40002F64))
// model

/** 0x4000 2F68 CANFD7_TIMER **/
union CANFD7_TIMER_REG{
	unsigned int reg;
	struct CANFD7_TIMER_BITS{
		unsigned int _CANTIMER:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TIMER (*((volatile union CANFD7_TIMER_REG *)0x40002F68))
// model

/** 0x4000 2F6C CANFD7_CRC **/
union CANFD7_CRC_REG{
	unsigned int reg;
	struct CANFD7_CRC_BITS{
		unsigned int _CRC:21;
		unsigned int :7;
		unsigned int _STUFFCNT:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_CRC (*((volatile union CANFD7_CRC_REG *)0x40002F6C))
// model

/** 0x4000 2F74 CANFD7_CTLR1 **/
union CANFD7_CTLR1_REG{
	unsigned int reg;
	struct CANFD7_CTLR1_BITS{
		unsigned int _AMCKS:2;
		unsigned int _RXMUX:7;
		unsigned int _ST:1;
		unsigned int _FTCLKS:1;
		unsigned int _TSYN:1;
		unsigned int _MBNUM:1;
		unsigned int _MATCHMS:1;
		unsigned int _MBMSKEN:1;
		unsigned int _ARBMS:1;
		unsigned int _ARBSTART:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _TRGNUM:4;
		unsigned int _TRGMBSEL:7;
		unsigned int _TRGMBEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_CTLR1 (*((volatile union CANFD7_CTLR1_REG *)0x40002F74))
// model

/** 0x4000 2F78 CANFD7_AMSTA **/
union CANFD7_AMSTA_REG{
	unsigned int reg;
	struct CANFD7_AMSTA_BITS{
		unsigned int _MATWINNER:10;
		unsigned int _MATSTA:1;
		unsigned int _ROPSTA:1;
		unsigned int _RELRXALL:1;
		unsigned int _IDSELEN:1;
		unsigned int _RTRMEN:1;
		unsigned int _BETEN:1;
		unsigned int _ARBWINNER:10;
		unsigned int _ARBSTA0:1;
		unsigned int _ARBSTA1:1;
		unsigned int _TXCODE:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_AMSTA (*((volatile union CANFD7_AMSTA_REG *)0x40002F78))
// model

/** 0x4000 2F7C CANFD7_TXDATA **/
union CANFD7_TXDATA_REG{
	unsigned int reg;
	struct CANFD7_TXDATA_BITS{
		unsigned int _TXDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CANFD7_TXDATA (*((volatile union CANFD7_TXDATA_REG *)0x40002F7C))
// modelIWDT

/** 0x4000 1200 IWDT_CTL **/
union IWDT_CTL_REG{
	unsigned int reg;
	struct IWDT_CTL_BITS{
		unsigned int _IWDTPS:4;
		unsigned int _IWDTOVF:12;
		unsigned int :13;
		unsigned int _CLKS:1;
		unsigned int :1;
		unsigned int _IWDTEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IWDT_CTL (*((volatile union IWDT_CTL_REG *)0x40001200))
// model

/** 0x4000 1204 IWDT_FD **/
union IWDT_FD_REG{
	unsigned int reg;
	struct IWDT_FD_BITS{
		unsigned int _IWDTFD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IWDT_FD (*((volatile union IWDT_FD_REG *)0x40001204))
// modelWWDT

/** 0x4000 1280 WWDT_CTL **/
union WWDT_CTL_REG{
	unsigned int reg;
	struct WWDT_CTL_BITS{
		unsigned int _WWDTEN:1;
		unsigned int _WWDTIE:1;
		unsigned int _WWDTIF:1;
		unsigned int _WPS:5;
		unsigned int _WW:7;
		unsigned int _WWDTIC:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CTL (*((volatile union WWDT_CTL_REG *)0x40001280))
// model

/** 0x4000 1284 WWDT_CNT **/
union WWDT_CNT_REG{
	unsigned int reg;
	struct WWDT_CNT_BITS{
		unsigned int _WT:7;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CNT (*((volatile union WWDT_CNT_REG *)0x40001284))
// model

/** 0x4000 1288 WWDT_CTL1 **/
union WWDT_CTL1_REG{
	unsigned int reg;
	struct WWDT_CTL1_BITS{
		unsigned int _CLKS:2;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define WWDT_CTL1 (*((volatile union WWDT_CTL1_REG *)0x40001288))
// modelBKP

/** 0x4000 1400 BKP_CTL **/
union BKP_CTL_REG{
	unsigned int reg;
	struct BKP_CTL_BITS{
		unsigned int _EXTLFEN:1;
		unsigned int _EXTHFBYP:1;
		unsigned int _EXTLFBYP:1;
		unsigned int _SAMCLKS:1;
		unsigned int _SYNC:1;
		unsigned int :11;
		unsigned int _TAMP1EN:1;
		unsigned int _TAMP2EN:1;
		unsigned int _TAMP3EN:1;
		unsigned int :1;
		unsigned int _TAMP1LVL:1;
		unsigned int _TAMP2LVL:1;
		unsigned int _TAMP3LVL:1;
		unsigned int :8;
		unsigned int _BKDRST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_CTL (*((volatile union BKP_CTL_REG *)0x40001400))
// model

/** 0x4000 1404 BKP_INT **/
union BKP_INT_REG{
	unsigned int reg;
	struct BKP_INT_BITS{
		unsigned int _TAMP1IC:1;
		unsigned int _TAMP2IC:1;
		unsigned int _TAMP3IC:1;
		unsigned int :5;
		unsigned int _TAMP1IE:1;
		unsigned int _TAMP2IE:1;
		unsigned int _TAMP3IE:1;
		unsigned int :5;
		unsigned int _TAMP1IF:1;
		unsigned int _TAMP2IF:1;
		unsigned int _TAMP3IF:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_INT (*((volatile union BKP_INT_REG *)0x40001404))
// model

/** 0x4000 1440 BKP_DATA0 **/
union BKP_DATA0_REG{
	unsigned int reg;
	struct BKP_DATA0_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA0 (*((volatile union BKP_DATA0_REG *)0x40001440))
// model

/** 0x4000 1444 BKP_DATA1 **/
union BKP_DATA1_REG{
	unsigned int reg;
	struct BKP_DATA1_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA1 (*((volatile union BKP_DATA1_REG *)0x40001444))
// model

/** 0x4000 1448 BKP_DATA2 **/
union BKP_DATA2_REG{
	unsigned int reg;
	struct BKP_DATA2_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA2 (*((volatile union BKP_DATA2_REG *)0x40001448))
// model

/** 0x4000 144C BKP_DATA3 **/
union BKP_DATA3_REG{
	unsigned int reg;
	struct BKP_DATA3_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA3 (*((volatile union BKP_DATA3_REG *)0x4000144C))
// model

/** 0x4000 1450 BKP_DATA4 **/
union BKP_DATA4_REG{
	unsigned int reg;
	struct BKP_DATA4_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA4 (*((volatile union BKP_DATA4_REG *)0x40001450))
// model

/** 0x4000 1454 BKP_DATA5 **/
union BKP_DATA5_REG{
	unsigned int reg;
	struct BKP_DATA5_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA5 (*((volatile union BKP_DATA5_REG *)0x40001454))
// model

/** 0x4000 1458 BKP_DATA6 **/
union BKP_DATA6_REG{
	unsigned int reg;
	struct BKP_DATA6_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA6 (*((volatile union BKP_DATA6_REG *)0x40001458))
// model

/** 0x4000 145C BKP_DATA7 **/
union BKP_DATA7_REG{
	unsigned int reg;
	struct BKP_DATA7_BITS{
		unsigned int _BKPDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define BKP_DATA7 (*((volatile union BKP_DATA7_REG *)0x4000145C))
// modelRST

/** 0x4000 1500 RST_CTL0 **/
union RST_CTL0_REG{
	unsigned int reg;
	struct RST_CTL0_BITS{
		unsigned int _GPIOARST:1;
		unsigned int _GPIOBRST:1;
		unsigned int _GPIOCRST:1;
		unsigned int _GPIODRST:1;
		unsigned int _GPIOERST:1;
		unsigned int _GPIOFRST:1;
		unsigned int _GPIOGRST:1;
		unsigned int _GPIOHRST:1;
		unsigned int :23;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL0 (*((volatile union RST_CTL0_REG *)0x40001500))
// model

/** 0x4000 1504 RST_CTL1 **/
union RST_CTL1_REG{
	unsigned int reg;
	struct RST_CTL1_BITS{
		unsigned int :1;
		unsigned int _QEI1RST:1;
		unsigned int _T1RST:1;
		unsigned int _T2RST:1;
		unsigned int _T3RST:1;
		unsigned int _T4RST:1;
		unsigned int _T5T6RST:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _QEI0RST:1;
		unsigned int _ADC0RST:1;
		unsigned int _ADC1RST:1;
		unsigned int _ADC2RST:1;
		unsigned int _DAC0RST:1;
		unsigned int _DAC1RST:1;
		unsigned int _CMPRST:1;
		unsigned int _T0RST:1;
		unsigned int :1;
		unsigned int _USART0RST:1;
		unsigned int _USART1RST:1;
		unsigned int _USART2RST:1;
		unsigned int :1;
		unsigned int _USART4RST:1;
		unsigned int _SPI0RST:1;
		unsigned int _SPI1RST:1;
		unsigned int _I2C0RST:1;
		unsigned int _I2C1RST:1;
		unsigned int _I2C2RST:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL1 (*((volatile union RST_CTL1_REG *)0x40001504))
// model

/** 0x4000 1508 RST_CTL2 **/
union RST_CTL2_REG{
	unsigned int reg;
	struct RST_CTL2_BITS{
		unsigned int :4;
		unsigned int :1;
		unsigned int _WWDTRST:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _EPWM11RST:1;
		unsigned int _EPWM12RST:1;
		unsigned int _EPWM13RST:1;
		unsigned int _EPWM16RST:1;
		unsigned int _DMA0RST:1;
		unsigned int :1;
		unsigned int _DMA1RST:1;
		unsigned int :1;
		unsigned int _T14RST:1;
		unsigned int :3;
		unsigned int :1;
		unsigned int _T18RST:1;
		unsigned int _T19RST:1;
		unsigned int :1;
		unsigned int _T21RST:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _DAC2RST:1;
		unsigned int _DAC3RST:1;
		unsigned int _USART5RST:1;
		unsigned int :1;
		unsigned int _USART7RST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL2 (*((volatile union RST_CTL2_REG *)0x40001508))
// model

/** 0x4000 150C RST_CTL3 **/
union RST_CTL3_REG{
	unsigned int reg;
	struct RST_CTL3_BITS{
		unsigned int :1;
		unsigned int _SPI2RST:1;
		unsigned int _SPI3RST:1;
		unsigned int :3;
		unsigned int :1;
		unsigned int _I2C3RST:1;
		unsigned int _HRCAP0RST:1;
		unsigned int _HRCAP1RST:1;
		unsigned int _HRCAP2RST:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _CRCRST:1;
		unsigned int _AESRST:1;
		unsigned int :1;
		unsigned int _EXICRST:1;
		unsigned int _CAN4RST:1;
		unsigned int :1;
		unsigned int _CFGLRST:1;
		unsigned int _OPRST:1;
		unsigned int _FLEXMUXRST:1;
		unsigned int _FDC0RST:1;
		unsigned int _FDC1RST:1;
		unsigned int _FDC2RST:1;
		unsigned int _FLEXRMRST:1;
		unsigned int _ECFGLRST:1;
		unsigned int _EWDTRST:1;
		unsigned int _RNGRST:1;
		unsigned int _CANFD6RST:1;
		unsigned int _CANFD7RST:1;
		unsigned int _RTCRST:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RST_CTL3 (*((volatile union RST_CTL3_REG *)0x4000150C))
// modelPM

/** 0x4000 1580 PM_CTL0 **/
union PM_CTL0_REG{
	unsigned int reg;
	struct PM_CTL0_BITS{
		unsigned int _LPMS:3;
		unsigned int _MEMSEL:1;
		unsigned int :1;
		unsigned int _LPREN:1;
		unsigned int _OCALLOCK:1;
		unsigned int _BKPWR:1;
		unsigned int _HSIEN:1;
		unsigned int :4;
		unsigned int _PHERIIOSEL:1;
		unsigned int _PORDELAYSEL:1;
		unsigned int _BKPPORDELAYSEL:1;
		unsigned int _IWDTRMSEL:1;
		unsigned int _LSECONF:1;
		unsigned int _LP4MEN:1;
		unsigned int _LPRAMSEL:1;
		unsigned int _DPRAMASEL:1;
		unsigned int _IWDTCLR:1;
		unsigned int _BKPREGCLR:1;
		unsigned int _LPBGON:1;
		unsigned int _LDO18EN:1;
		unsigned int _MRBGEN:1;
		unsigned int :2;
		unsigned int _LSEEN:1;
		unsigned int _LSIEN:1;
		unsigned int :1;
		unsigned int _IOLATCH:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL0 (*((volatile union PM_CTL0_REG *)0x40001580))
// model

/** 0x4000 1584 PM_CTL1 **/
union PM_CTL1_REG{
	unsigned int reg;
	struct PM_CTL1_BITS{
		unsigned int _PVDEN:1;
		unsigned int :1;
		unsigned int _PVDS:3;
		unsigned int _VREFEN:1;
		unsigned int _VREFSEL:2;
		unsigned int _LPDEBUG:1;
		unsigned int _P18LVLSENB:1;
		unsigned int _RAMECCEN:1;
		unsigned int _LPCANCLKS:1;
		unsigned int :4;
		unsigned int _LVL18OEN:1;
		unsigned int _PMCERRMS:1;
		unsigned int _PVDWKEN:1;
		unsigned int :8;
		unsigned int _P18OE:1;
		unsigned int _TSOE:1;
		unsigned int _TSEN:1;
		unsigned int _LPBOREN:1;
		unsigned int _BOREN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL1 (*((volatile union PM_CTL1_REG *)0x40001584))
// model

/** 0x4000 1588 PM_STA0 **/
union PM_STA0_REG{
	unsigned int reg;
	struct PM_STA0_BITS{
		unsigned int _LPRSTA:1;
		unsigned int _LPRUNF:1;
		unsigned int :21;
		unsigned int _NRRSTF:1;
		unsigned int _BKPPORIF:1;
		unsigned int _WSRSTF:1;
		unsigned int _BORF:1;
		unsigned int _PORF:1;
		unsigned int _WKPPINF:1;
		unsigned int :1;
		unsigned int _IWDTF:1;
		unsigned int _RSTFC:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STA0 (*((volatile union PM_STA0_REG *)0x40001588))
// model

/** 0x4000 158C PM_STA1 **/
union PM_STA1_REG{
	unsigned int reg;
	struct PM_STA1_BITS{
		unsigned int _PVDSTA:1;
		unsigned int :10;
		unsigned int _WKP6STA:1;
		unsigned int _WKP7STA:1;
		unsigned int _WKP8STA:1;
		unsigned int _WKP9STA:1;
		unsigned int _WKP10STA:1;
		unsigned int _WKP11STA:1;
		unsigned int _WKP12STA:1;
		unsigned int _STOPERROR:1;
		unsigned int _PMCERROR:1;
		unsigned int :2;
		unsigned int _POR18STA:1;
		unsigned int :3;
		unsigned int _PMCIF:1;
		unsigned int _WKP1STA:1;
		unsigned int _WKP2STA:1;
		unsigned int _WKP3STA:1;
		unsigned int _WKP4STA:1;
		unsigned int _WKP5STA:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STA1 (*((volatile union PM_STA1_REG *)0x4000158C))
// model

/** 0x4000 1590 PM_STAC **/
union PM_STAC_REG{
	unsigned int reg;
	struct PM_STAC_BITS{
		unsigned int :2;
		unsigned int _WKP6EN:1;
		unsigned int _WKP7EN:1;
		unsigned int _WKP8EN:1;
		unsigned int _WKP9EN:1;
		unsigned int _WKP10EN:1;
		unsigned int _WKP11EN:1;
		unsigned int _WKP12EN:1;
		unsigned int _WKP6P:1;
		unsigned int _WKP7P:1;
		unsigned int _WKP8P:1;
		unsigned int _WKP9P:1;
		unsigned int _WKP10P:1;
		unsigned int _WKP11P:1;
		unsigned int _WKP12P:1;
		unsigned int _WKP6SC:1;
		unsigned int _WKP7SC:1;
		unsigned int _WKP8SC:1;
		unsigned int _WKP9SC:1;
		unsigned int _WKP10SC:1;
		unsigned int _WKP11SC:1;
		unsigned int _WKP12SC:1;
		unsigned int :2;
		unsigned int _IWDTDBGEN:1;
		unsigned int _PMCIC:1;
		unsigned int _WKP1SC:1;
		unsigned int _WKP2SC:1;
		unsigned int _WKP3SC:1;
		unsigned int _WKP4SC:1;
		unsigned int _WKP5SC:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_STAC (*((volatile union PM_STAC_REG *)0x40001590))
// model

/** 0x4000 1594 PM_CTL2 **/
union PM_CTL2_REG{
	unsigned int reg;
	struct PM_CTL2_BITS{
		unsigned int _CANFD6LPEN:1;
		unsigned int _CCP0LPEN:1;
		unsigned int _EWDTLPEN:1;
		unsigned int _USART0LPEN:1;
		unsigned int _CANFD6CLKLPEN:1;
		unsigned int _CCP0CLKLPEN:1;
		unsigned int _EWDTCLKLPEN:1;
		unsigned int _USART0CLKLPEN:1;
		unsigned int _POR18SHD:1;
		unsigned int _VF12INF0:1;
		unsigned int _VF12INF1:1;
		unsigned int _VF12EN:1;
		unsigned int :2;
		unsigned int _RTCLPEN:1;
		unsigned int _RTCCLKLPEN:1;
		unsigned int _QEI0CLKLPEN:1;
		unsigned int _GPIOALPEN:1;
		unsigned int _QEI0LPEN:1;
		unsigned int _PMCIE:1;
		unsigned int :2;
		unsigned int _WKP1P:1;
		unsigned int _WKP2P:1;
		unsigned int _WKP3P:1;
		unsigned int _WKP4P:1;
		unsigned int _WKP5P:1;
		unsigned int _WKP1EN:1;
		unsigned int _WKP2EN:1;
		unsigned int _WKP3EN:1;
		unsigned int _WKP4EN:1;
		unsigned int _WKP5EN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CTL2 (*((volatile union PM_CTL2_REG *)0x40001594))
// model

/** 0x4000 1598 PM_CAL0 **/
union PM_CAL0_REG{
	unsigned int reg;
	struct PM_CAL0_BITS{
		unsigned int :20;
		unsigned int _BORSEL:2;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PM_CAL0 (*((volatile union PM_CAL0_REG *)0x40001598))
// modelDMA0

/** 0x4000 1600 DMA0_CTLR1 **/
union DMA0_CTLR1_REG{
	unsigned int reg;
	struct DMA0_CTLR1_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR1 (*((volatile union DMA0_CTLR1_REG *)0x40001600))
// model

/** 0x4000 1604 DMA0_CTLR2 **/
union DMA0_CTLR2_REG{
	unsigned int reg;
	struct DMA0_CTLR2_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR2 (*((volatile union DMA0_CTLR2_REG *)0x40001604))
// model

/** 0x4000 1608 DMA0_CTLR3 **/
union DMA0_CTLR3_REG{
	unsigned int reg;
	struct DMA0_CTLR3_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR3 (*((volatile union DMA0_CTLR3_REG *)0x40001608))
// model

/** 0x4000 160C DMA0_CTLR4 **/
union DMA0_CTLR4_REG{
	unsigned int reg;
	struct DMA0_CTLR4_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR4 (*((volatile union DMA0_CTLR4_REG *)0x4000160C))
// model

/** 0x4000 1610 DMA0_CTLR5 **/
union DMA0_CTLR5_REG{
	unsigned int reg;
	struct DMA0_CTLR5_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR5 (*((volatile union DMA0_CTLR5_REG *)0x40001610))
// model

/** 0x4000 1614 DMA0_CTLR6 **/
union DMA0_CTLR6_REG{
	unsigned int reg;
	struct DMA0_CTLR6_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR6 (*((volatile union DMA0_CTLR6_REG *)0x40001614))
// model

/** 0x4000 1618 DMA0_CTLR7 **/
union DMA0_CTLR7_REG{
	unsigned int reg;
	struct DMA0_CTLR7_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CTLR7 (*((volatile union DMA0_CTLR7_REG *)0x40001618))
// model

/** 0x4000 1620 DMA0_PADDR1 **/
union DMA0_PADDR1_REG{
	unsigned int reg;
	struct DMA0_PADDR1_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR1 (*((volatile union DMA0_PADDR1_REG *)0x40001620))
// model

/** 0x4000 1624 DMA0_PADDR2 **/
union DMA0_PADDR2_REG{
	unsigned int reg;
	struct DMA0_PADDR2_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR2 (*((volatile union DMA0_PADDR2_REG *)0x40001624))
// model

/** 0x4000 1628 DMA0_PADDR3 **/
union DMA0_PADDR3_REG{
	unsigned int reg;
	struct DMA0_PADDR3_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR3 (*((volatile union DMA0_PADDR3_REG *)0x40001628))
// model

/** 0x4000 162C DMA0_PADDR4 **/
union DMA0_PADDR4_REG{
	unsigned int reg;
	struct DMA0_PADDR4_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR4 (*((volatile union DMA0_PADDR4_REG *)0x4000162C))
// model

/** 0x4000 1630 DMA0_PADDR5 **/
union DMA0_PADDR5_REG{
	unsigned int reg;
	struct DMA0_PADDR5_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR5 (*((volatile union DMA0_PADDR5_REG *)0x40001630))
// model

/** 0x4000 1634 DMA0_PADDR6 **/
union DMA0_PADDR6_REG{
	unsigned int reg;
	struct DMA0_PADDR6_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR6 (*((volatile union DMA0_PADDR6_REG *)0x40001634))
// model

/** 0x4000 1638 DMA0_PADDR7 **/
union DMA0_PADDR7_REG{
	unsigned int reg;
	struct DMA0_PADDR7_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_PADDR7 (*((volatile union DMA0_PADDR7_REG *)0x40001638))
// model

/** 0x4000 1640 DMA0_MADDR1 **/
union DMA0_MADDR1_REG{
	unsigned int reg;
	struct DMA0_MADDR1_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR1 (*((volatile union DMA0_MADDR1_REG *)0x40001640))
// model

/** 0x4000 1644 DMA0_MADDR2 **/
union DMA0_MADDR2_REG{
	unsigned int reg;
	struct DMA0_MADDR2_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR2 (*((volatile union DMA0_MADDR2_REG *)0x40001644))
// model

/** 0x4000 1648 DMA0_MADDR3 **/
union DMA0_MADDR3_REG{
	unsigned int reg;
	struct DMA0_MADDR3_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR3 (*((volatile union DMA0_MADDR3_REG *)0x40001648))
// model

/** 0x4000 164C DMA0_MADDR4 **/
union DMA0_MADDR4_REG{
	unsigned int reg;
	struct DMA0_MADDR4_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR4 (*((volatile union DMA0_MADDR4_REG *)0x4000164C))
// model

/** 0x4000 1650 DMA0_MADDR5 **/
union DMA0_MADDR5_REG{
	unsigned int reg;
	struct DMA0_MADDR5_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR5 (*((volatile union DMA0_MADDR5_REG *)0x40001650))
// model

/** 0x4000 1654 DMA0_MADDR6 **/
union DMA0_MADDR6_REG{
	unsigned int reg;
	struct DMA0_MADDR6_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR6 (*((volatile union DMA0_MADDR6_REG *)0x40001654))
// model

/** 0x4000 1658 DMA0_MADDR7 **/
union DMA0_MADDR7_REG{
	unsigned int reg;
	struct DMA0_MADDR7_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_MADDR7 (*((volatile union DMA0_MADDR7_REG *)0x40001658))
// model

/** 0x4000 1660 DMA0_CPAR1 **/
union DMA0_CPAR1_REG{
	unsigned int reg;
	struct DMA0_CPAR1_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR1 (*((volatile union DMA0_CPAR1_REG *)0x40001660))
// model

/** 0x4000 1664 DMA0_CPAR2 **/
union DMA0_CPAR2_REG{
	unsigned int reg;
	struct DMA0_CPAR2_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR2 (*((volatile union DMA0_CPAR2_REG *)0x40001664))
// model

/** 0x4000 1668 DMA0_CPAR3 **/
union DMA0_CPAR3_REG{
	unsigned int reg;
	struct DMA0_CPAR3_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR3 (*((volatile union DMA0_CPAR3_REG *)0x40001668))
// model

/** 0x4000 166C DMA0_CPAR4 **/
union DMA0_CPAR4_REG{
	unsigned int reg;
	struct DMA0_CPAR4_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR4 (*((volatile union DMA0_CPAR4_REG *)0x4000166C))
// model

/** 0x4000 1670 DMA0_CPAR5 **/
union DMA0_CPAR5_REG{
	unsigned int reg;
	struct DMA0_CPAR5_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR5 (*((volatile union DMA0_CPAR5_REG *)0x40001670))
// model

/** 0x4000 1674 DMA0_CPAR6 **/
union DMA0_CPAR6_REG{
	unsigned int reg;
	struct DMA0_CPAR6_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR6 (*((volatile union DMA0_CPAR6_REG *)0x40001674))
// model

/** 0x4000 1678 DMA0_CPAR7 **/
union DMA0_CPAR7_REG{
	unsigned int reg;
	struct DMA0_CPAR7_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CPAR7 (*((volatile union DMA0_CPAR7_REG *)0x40001678))
// model

/** 0x4000 1680 DMA0_CMAR1 **/
union DMA0_CMAR1_REG{
	unsigned int reg;
	struct DMA0_CMAR1_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR1 (*((volatile union DMA0_CMAR1_REG *)0x40001680))
// model

/** 0x4000 1684 DMA0_CMAR2 **/
union DMA0_CMAR2_REG{
	unsigned int reg;
	struct DMA0_CMAR2_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR2 (*((volatile union DMA0_CMAR2_REG *)0x40001684))
// model

/** 0x4000 1688 DMA0_CMAR3 **/
union DMA0_CMAR3_REG{
	unsigned int reg;
	struct DMA0_CMAR3_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR3 (*((volatile union DMA0_CMAR3_REG *)0x40001688))
// model

/** 0x4000 168C DMA0_CMAR4 **/
union DMA0_CMAR4_REG{
	unsigned int reg;
	struct DMA0_CMAR4_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR4 (*((volatile union DMA0_CMAR4_REG *)0x4000168C))
// model

/** 0x4000 1690 DMA0_CMAR5 **/
union DMA0_CMAR5_REG{
	unsigned int reg;
	struct DMA0_CMAR5_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR5 (*((volatile union DMA0_CMAR5_REG *)0x40001690))
// model

/** 0x4000 1694 DMA0_CMAR6 **/
union DMA0_CMAR6_REG{
	unsigned int reg;
	struct DMA0_CMAR6_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR6 (*((volatile union DMA0_CMAR6_REG *)0x40001694))
// model

/** 0x4000 1698 DMA0_CMAR7 **/
union DMA0_CMAR7_REG{
	unsigned int reg;
	struct DMA0_CMAR7_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_CMAR7 (*((volatile union DMA0_CMAR7_REG *)0x40001698))
// model

/** 0x4000 16A0 DMA0_NCT1 **/
union DMA0_NCT1_REG{
	unsigned int reg;
	struct DMA0_NCT1_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT1 (*((volatile union DMA0_NCT1_REG *)0x400016A0))
// model

/** 0x4000 16A4 DMA0_NCT2 **/
union DMA0_NCT2_REG{
	unsigned int reg;
	struct DMA0_NCT2_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT2 (*((volatile union DMA0_NCT2_REG *)0x400016A4))
// model

/** 0x4000 16A8 DMA0_NCT3 **/
union DMA0_NCT3_REG{
	unsigned int reg;
	struct DMA0_NCT3_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT3 (*((volatile union DMA0_NCT3_REG *)0x400016A8))
// model

/** 0x4000 16AC DMA0_NCT4 **/
union DMA0_NCT4_REG{
	unsigned int reg;
	struct DMA0_NCT4_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT4 (*((volatile union DMA0_NCT4_REG *)0x400016AC))
// model

/** 0x4000 16B0 DMA0_NCT5 **/
union DMA0_NCT5_REG{
	unsigned int reg;
	struct DMA0_NCT5_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT5 (*((volatile union DMA0_NCT5_REG *)0x400016B0))
// model

/** 0x4000 16B4 DMA0_NCT6 **/
union DMA0_NCT6_REG{
	unsigned int reg;
	struct DMA0_NCT6_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT6 (*((volatile union DMA0_NCT6_REG *)0x400016B4))
// model

/** 0x4000 16B8 DMA0_NCT7 **/
union DMA0_NCT7_REG{
	unsigned int reg;
	struct DMA0_NCT7_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_NCT7 (*((volatile union DMA0_NCT7_REG *)0x400016B8))
// model

/** 0x4000 16C0 DMA0_LIFR **/
union DMA0_LIFR_REG{
	unsigned int reg;
	struct DMA0_LIFR_BITS{
		unsigned int _FTIF1:1;
		unsigned int _HTIF1:1;
		unsigned int _ETIF1:1;
		unsigned int _FTIF2:1;
		unsigned int _HTIF2:1;
		unsigned int _ETIF2:1;
		unsigned int _FTIF3:1;
		unsigned int _HTIF3:1;
		unsigned int _ETIF3:1;
		unsigned int _FTIF4:1;
		unsigned int _HTIF4:1;
		unsigned int _ETIF4:1;
		unsigned int _FTIF5:1;
		unsigned int _HTIF5:1;
		unsigned int _ETIF5:1;
		unsigned int _FTIF6:1;
		unsigned int _HTIF6:1;
		unsigned int _ETIF6:1;
		unsigned int _FTIF7:1;
		unsigned int _HTIF7:1;
		unsigned int _ETIF7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_LIFR (*((volatile union DMA0_LIFR_REG *)0x400016C0))
// model

/** 0x4000 16C4 DMA0_LIER **/
union DMA0_LIER_REG{
	unsigned int reg;
	struct DMA0_LIER_BITS{
		unsigned int _FTIE1:1;
		unsigned int _HTIE1:1;
		unsigned int _ETIE1:1;
		unsigned int _FTIE2:1;
		unsigned int _HTIE2:1;
		unsigned int _ETIE2:1;
		unsigned int _FTIE3:1;
		unsigned int _HTIE3:1;
		unsigned int _ETIE3:1;
		unsigned int _FTIE4:1;
		unsigned int _HTIE4:1;
		unsigned int _ETIE4:1;
		unsigned int _FTIE5:1;
		unsigned int _HTIE5:1;
		unsigned int _ETIE5:1;
		unsigned int _FTIE6:1;
		unsigned int _HTIE6:1;
		unsigned int _ETIE6:1;
		unsigned int _FTIE7:1;
		unsigned int _HTIE7:1;
		unsigned int _ETIE7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA0_LIER (*((volatile union DMA0_LIER_REG *)0x400016C4))
// modelDMA1

/** 0x4000 1700 DMA1_CTLR1 **/
union DMA1_CTLR1_REG{
	unsigned int reg;
	struct DMA1_CTLR1_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR1 (*((volatile union DMA1_CTLR1_REG *)0x40001700))
// model

/** 0x4000 1704 DMA1_CTLR2 **/
union DMA1_CTLR2_REG{
	unsigned int reg;
	struct DMA1_CTLR2_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR2 (*((volatile union DMA1_CTLR2_REG *)0x40001704))
// model

/** 0x4000 1708 DMA1_CTLR3 **/
union DMA1_CTLR3_REG{
	unsigned int reg;
	struct DMA1_CTLR3_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR3 (*((volatile union DMA1_CTLR3_REG *)0x40001708))
// model

/** 0x4000 170C DMA1_CTLR4 **/
union DMA1_CTLR4_REG{
	unsigned int reg;
	struct DMA1_CTLR4_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR4 (*((volatile union DMA1_CTLR4_REG *)0x4000170C))
// model

/** 0x4000 1710 DMA1_CTLR5 **/
union DMA1_CTLR5_REG{
	unsigned int reg;
	struct DMA1_CTLR5_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR5 (*((volatile union DMA1_CTLR5_REG *)0x40001710))
// model

/** 0x4000 1714 DMA1_CTLR6 **/
union DMA1_CTLR6_REG{
	unsigned int reg;
	struct DMA1_CTLR6_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR6 (*((volatile union DMA1_CTLR6_REG *)0x40001714))
// model

/** 0x4000 1718 DMA1_CTLR7 **/
union DMA1_CTLR7_REG{
	unsigned int reg;
	struct DMA1_CTLR7_BITS{
		unsigned int _DMAEN:1;
		unsigned int :1;
		unsigned int _DMAMODES:1;
		unsigned int _BLKM:1;
		unsigned int _DDIR:1;
		unsigned int _LPM:1;
		unsigned int _MINC:1;
		unsigned int _PINC:1;
		unsigned int _MDS:2;
		unsigned int _PDS:2;
		unsigned int _ONESHOT:1;
		unsigned int _CPL:2;
		unsigned int _M2M:1;
		unsigned int _NUMODT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CTLR7 (*((volatile union DMA1_CTLR7_REG *)0x40001718))
// model

/** 0x4000 1720 DMA1_PADDR1 **/
union DMA1_PADDR1_REG{
	unsigned int reg;
	struct DMA1_PADDR1_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR1 (*((volatile union DMA1_PADDR1_REG *)0x40001720))
// model

/** 0x4000 1724 DMA1_PADDR2 **/
union DMA1_PADDR2_REG{
	unsigned int reg;
	struct DMA1_PADDR2_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR2 (*((volatile union DMA1_PADDR2_REG *)0x40001724))
// model

/** 0x4000 1728 DMA1_PADDR3 **/
union DMA1_PADDR3_REG{
	unsigned int reg;
	struct DMA1_PADDR3_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR3 (*((volatile union DMA1_PADDR3_REG *)0x40001728))
// model

/** 0x4000 172C DMA1_PADDR4 **/
union DMA1_PADDR4_REG{
	unsigned int reg;
	struct DMA1_PADDR4_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR4 (*((volatile union DMA1_PADDR4_REG *)0x4000172C))
// model

/** 0x4000 1730 DMA1_PADDR5 **/
union DMA1_PADDR5_REG{
	unsigned int reg;
	struct DMA1_PADDR5_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR5 (*((volatile union DMA1_PADDR5_REG *)0x40001730))
// model

/** 0x4000 1734 DMA1_PADDR6 **/
union DMA1_PADDR6_REG{
	unsigned int reg;
	struct DMA1_PADDR6_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR6 (*((volatile union DMA1_PADDR6_REG *)0x40001734))
// model

/** 0x4000 1738 DMA1_PADDR7 **/
union DMA1_PADDR7_REG{
	unsigned int reg;
	struct DMA1_PADDR7_BITS{
		unsigned int _PADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_PADDR7 (*((volatile union DMA1_PADDR7_REG *)0x40001738))
// model

/** 0x4000 1740 DMA1_MADDR1 **/
union DMA1_MADDR1_REG{
	unsigned int reg;
	struct DMA1_MADDR1_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR1 (*((volatile union DMA1_MADDR1_REG *)0x40001740))
// model

/** 0x4000 1744 DMA1_MADDR2 **/
union DMA1_MADDR2_REG{
	unsigned int reg;
	struct DMA1_MADDR2_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR2 (*((volatile union DMA1_MADDR2_REG *)0x40001744))
// model

/** 0x4000 1748 DMA1_MADDR3 **/
union DMA1_MADDR3_REG{
	unsigned int reg;
	struct DMA1_MADDR3_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR3 (*((volatile union DMA1_MADDR3_REG *)0x40001748))
// model

/** 0x4000 174C DMA1_MADDR4 **/
union DMA1_MADDR4_REG{
	unsigned int reg;
	struct DMA1_MADDR4_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR4 (*((volatile union DMA1_MADDR4_REG *)0x4000174C))
// model

/** 0x4000 1750 DMA1_MADDR5 **/
union DMA1_MADDR5_REG{
	unsigned int reg;
	struct DMA1_MADDR5_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR5 (*((volatile union DMA1_MADDR5_REG *)0x40001750))
// model

/** 0x4000 1754 DMA1_MADDR6 **/
union DMA1_MADDR6_REG{
	unsigned int reg;
	struct DMA1_MADDR6_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR6 (*((volatile union DMA1_MADDR6_REG *)0x40001754))
// model

/** 0x4000 1758 DMA1_MADDR7 **/
union DMA1_MADDR7_REG{
	unsigned int reg;
	struct DMA1_MADDR7_BITS{
		unsigned int _MADDR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_MADDR7 (*((volatile union DMA1_MADDR7_REG *)0x40001758))
// model

/** 0x4000 1760 DMA1_CPAR1 **/
union DMA1_CPAR1_REG{
	unsigned int reg;
	struct DMA1_CPAR1_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR1 (*((volatile union DMA1_CPAR1_REG *)0x40001760))
// model

/** 0x4000 1764 DMA1_CPAR2 **/
union DMA1_CPAR2_REG{
	unsigned int reg;
	struct DMA1_CPAR2_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR2 (*((volatile union DMA1_CPAR2_REG *)0x40001764))
// model

/** 0x4000 1768 DMA1_CPAR3 **/
union DMA1_CPAR3_REG{
	unsigned int reg;
	struct DMA1_CPAR3_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR3 (*((volatile union DMA1_CPAR3_REG *)0x40001768))
// model

/** 0x4000 176C DMA1_CPAR4 **/
union DMA1_CPAR4_REG{
	unsigned int reg;
	struct DMA1_CPAR4_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR4 (*((volatile union DMA1_CPAR4_REG *)0x4000176C))
// model

/** 0x4000 1770 DMA1_CPAR5 **/
union DMA1_CPAR5_REG{
	unsigned int reg;
	struct DMA1_CPAR5_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR5 (*((volatile union DMA1_CPAR5_REG *)0x40001770))
// model

/** 0x4000 1774 DMA1_CPAR6 **/
union DMA1_CPAR6_REG{
	unsigned int reg;
	struct DMA1_CPAR6_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR6 (*((volatile union DMA1_CPAR6_REG *)0x40001774))
// model

/** 0x4000 1778 DMA1_CPAR7 **/
union DMA1_CPAR7_REG{
	unsigned int reg;
	struct DMA1_CPAR7_BITS{
		unsigned int _CPAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CPAR7 (*((volatile union DMA1_CPAR7_REG *)0x40001778))
// model

/** 0x4000 1780 DMA1_CMAR1 **/
union DMA1_CMAR1_REG{
	unsigned int reg;
	struct DMA1_CMAR1_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR1 (*((volatile union DMA1_CMAR1_REG *)0x40001780))
// model

/** 0x4000 1784 DMA1_CMAR2 **/
union DMA1_CMAR2_REG{
	unsigned int reg;
	struct DMA1_CMAR2_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR2 (*((volatile union DMA1_CMAR2_REG *)0x40001784))
// model

/** 0x4000 1788 DMA1_CMAR3 **/
union DMA1_CMAR3_REG{
	unsigned int reg;
	struct DMA1_CMAR3_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR3 (*((volatile union DMA1_CMAR3_REG *)0x40001788))
// model

/** 0x4000 178C DMA1_CMAR4 **/
union DMA1_CMAR4_REG{
	unsigned int reg;
	struct DMA1_CMAR4_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR4 (*((volatile union DMA1_CMAR4_REG *)0x4000178C))
// model

/** 0x4000 1790 DMA1_CMAR5 **/
union DMA1_CMAR5_REG{
	unsigned int reg;
	struct DMA1_CMAR5_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR5 (*((volatile union DMA1_CMAR5_REG *)0x40001790))
// model

/** 0x4000 1794 DMA1_CMAR6 **/
union DMA1_CMAR6_REG{
	unsigned int reg;
	struct DMA1_CMAR6_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR6 (*((volatile union DMA1_CMAR6_REG *)0x40001794))
// model

/** 0x4000 1798 DMA1_CMAR7 **/
union DMA1_CMAR7_REG{
	unsigned int reg;
	struct DMA1_CMAR7_BITS{
		unsigned int _CMAR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_CMAR7 (*((volatile union DMA1_CMAR7_REG *)0x40001798))
// model

/** 0x4000 17A0 DMA1_NCT1 **/
union DMA1_NCT1_REG{
	unsigned int reg;
	struct DMA1_NCT1_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT1 (*((volatile union DMA1_NCT1_REG *)0x400017A0))
// model

/** 0x4000 17A4 DMA1_NCT2 **/
union DMA1_NCT2_REG{
	unsigned int reg;
	struct DMA1_NCT2_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT2 (*((volatile union DMA1_NCT2_REG *)0x400017A4))
// model

/** 0x4000 17A8 DMA1_NCT13 **/
union DMA1_NCT13_REG{
	unsigned int reg;
	struct DMA1_NCT13_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT13 (*((volatile union DMA1_NCT13_REG *)0x400017A8))
// model

/** 0x4000 17AC DMA1_NCT4 **/
union DMA1_NCT4_REG{
	unsigned int reg;
	struct DMA1_NCT4_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT4 (*((volatile union DMA1_NCT4_REG *)0x400017AC))
// model

/** 0x4000 17B0 DMA1_NCT5 **/
union DMA1_NCT5_REG{
	unsigned int reg;
	struct DMA1_NCT5_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT5 (*((volatile union DMA1_NCT5_REG *)0x400017B0))
// model

/** 0x4000 17B4 DMA1_NCT6 **/
union DMA1_NCT6_REG{
	unsigned int reg;
	struct DMA1_NCT6_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT6 (*((volatile union DMA1_NCT6_REG *)0x400017B4))
// model

/** 0x4000 17B8 DMA1_NCT7 **/
union DMA1_NCT7_REG{
	unsigned int reg;
	struct DMA1_NCT7_BITS{
		unsigned int :16;
		unsigned int _NCT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_NCT7 (*((volatile union DMA1_NCT7_REG *)0x400017B8))
// model

/** 0x4000 17C0 DMA1_LIFR **/
union DMA1_LIFR_REG{
	unsigned int reg;
	struct DMA1_LIFR_BITS{
		unsigned int _FTIF1:1;
		unsigned int _HTIF1:1;
		unsigned int _ETIF1:1;
		unsigned int _FTIF2:1;
		unsigned int _HTIF2:1;
		unsigned int _ETIF2:1;
		unsigned int _FTIF3:1;
		unsigned int _HTIF3:1;
		unsigned int _ETIF3:1;
		unsigned int _FTIF4:1;
		unsigned int _HTIF4:1;
		unsigned int _ETIF4:1;
		unsigned int _FTIF5:1;
		unsigned int _HTIF5:1;
		unsigned int _ETIF5:1;
		unsigned int _FTIF6:1;
		unsigned int _HTIF6:1;
		unsigned int _ETIF6:1;
		unsigned int _FTIF7:1;
		unsigned int _HTIF7:1;
		unsigned int _ETIF7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_LIFR (*((volatile union DMA1_LIFR_REG *)0x400017C0))
// model

/** 0x4000 17C4 DMA1_LIER **/
union DMA1_LIER_REG{
	unsigned int reg;
	struct DMA1_LIER_BITS{
		unsigned int _FTIE1:1;
		unsigned int _HTIE1:1;
		unsigned int _ETIE1:1;
		unsigned int _FTIE2:1;
		unsigned int _HTIE2:1;
		unsigned int _ETIE2:1;
		unsigned int _FTIE3:1;
		unsigned int _HTIE3:1;
		unsigned int _ETIE3:1;
		unsigned int _FTIE4:1;
		unsigned int _HTIE4:1;
		unsigned int _ETIE4:1;
		unsigned int _FTIE5:1;
		unsigned int _HTIE5:1;
		unsigned int _ETIE5:1;
		unsigned int _FTIE6:1;
		unsigned int _HTIE6:1;
		unsigned int _ETIE6:1;
		unsigned int _FTIE7:1;
		unsigned int _HTIE7:1;
		unsigned int _ETIE7:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_LIER (*((volatile union DMA1_LIER_REG *)0x400017C4))
// model

/** 0x4000 17C8 DMA1_REMAP **/
union DMA1_REMAP_REG{
	unsigned int reg;
	struct DMA1_REMAP_BITS{
		unsigned int _REMAP0:1;
		unsigned int _REMAP1:1;
		unsigned int _REMAP2:1;
		unsigned int _REMAP3:1;
		unsigned int _REMAP4:1;
		unsigned int _REMAP5:1;
		unsigned int _REMAP6:1;
		unsigned int _REMAP7:1;
		unsigned int _REMAP8:1;
		unsigned int _REMAP9:1;
		unsigned int _REMAP10:1;
		unsigned int _REMAP11:1;
		unsigned int _REMAP12:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define DMA1_REMAP (*((volatile union DMA1_REMAP_REG *)0x400017C8))
// modelT14

/** 0x4000 1800 T14_CNT **/
union T14_CNT_REG{
	unsigned int reg;
	struct T14_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CNT (*((volatile union T14_CNT_REG *)0x40001800))
// model

/** 0x4000 1804 T14_CTL1 **/
union T14_CTL1_REG{
	unsigned int reg;
	struct T14_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int _TRGSEL:2;
		unsigned int _TCKSEL:2;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CTL1 (*((volatile union T14_CTL1_REG *)0x40001804))
// model

/** 0x4000 1808 T14_CTL2 **/
union T14_CTL2_REG{
	unsigned int reg;
	struct T14_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:2;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _PXSPMST:1;
		unsigned int _PXSPM:1;
		unsigned int _TXTRG:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_CTL2 (*((volatile union T14_CTL2_REG *)0x40001808))
// model

/** 0x4000 180C T14_PRSC **/
union T14_PRSC_REG{
	unsigned int reg;
	struct T14_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_PRSC (*((volatile union T14_PRSC_REG *)0x4000180C))
// model

/** 0x4000 1810 T14_PPX **/
union T14_PPX_REG{
	unsigned int reg;
	struct T14_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_PPX (*((volatile union T14_PPX_REG *)0x40001810))
// model

/** 0x4000 1814 T14_DIER **/
union T14_DIER_REG{
	unsigned int reg;
	struct T14_DIER_BITS{
		unsigned int _TXUIE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXTDE:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_DIER (*((volatile union T14_DIER_REG *)0x40001814))
// model

/** 0x4000 1818 T14_SR **/
union T14_SR_REG{
	unsigned int reg;
	struct T14_SR_BITS{
		unsigned int _TXUIF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_SR (*((volatile union T14_SR_REG *)0x40001818))
// model

/** 0x4000 181C T14_SRIC **/
union T14_SRIC_REG{
	unsigned int reg;
	struct T14_SRIC_BITS{
		unsigned int _TXUIC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXIC:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T14_SRIC (*((volatile union T14_SRIC_REG *)0x4000181C))
// modelT11

/** 0x4000 1A00 T11_CNT **/
union T11_CNT_REG{
	unsigned int reg;
	struct T11_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_CNT (*((volatile union T11_CNT_REG *)0x40001A00))
// model

/** 0x4000 1A04 T11_PHS **/
union T11_PHS_REG{
	unsigned int reg;
	struct T11_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_PHS (*((volatile union T11_PHS_REG *)0x40001A04))
// model

/** 0x4000 1A08 T11_PPX **/
union T11_PPX_REG{
	unsigned int reg;
	struct T11_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_PPX (*((volatile union T11_PPX_REG *)0x40001A08))
// model

/** 0x4000 1A0C T11_PRSC **/
union T11_PRSC_REG{
	unsigned int reg;
	struct T11_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_PRSC (*((volatile union T11_PRSC_REG *)0x40001A0C))
// model

/** 0x4000 1A10 T11_CTL **/
union T11_CTL_REG{
	unsigned int reg;
	struct T11_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK0:1;
		unsigned int _TXCLK1:1;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS0:1;
		unsigned int _TXCMS1:1;
		unsigned int _TXCMS2:1;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL0:1;
		unsigned int _SYNCOSEL1:1;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int :1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int _LINKEN:1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T11_CTL (*((volatile union T11_CTL_REG *)0x40001A10))
// modelEPWM11

/** 0x4000 1A14 EPWM11_RA **/
union EPWM11_RA_REG{
	unsigned int reg;
	struct EPWM11_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RA (*((volatile union EPWM11_RA_REG *)0x40001A14))
// model

/** 0x4000 1A18 EPWM11_RB **/
union EPWM11_RB_REG{
	unsigned int reg;
	struct EPWM11_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RB (*((volatile union EPWM11_RB_REG *)0x40001A18))
// model

/** 0x4000 1A1C EPWM11_CTLA **/
union EPWM11_CTLA_REG{
	unsigned int reg;
	struct EPWM11_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _OTSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_CTLA (*((volatile union EPWM11_CTLA_REG *)0x40001A1C))
// model

/** 0x4000 1A20 EPWM11_CTLB **/
union EPWM11_CTLB_REG{
	unsigned int reg;
	struct EPWM11_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_CTLB (*((volatile union EPWM11_CTLB_REG *)0x40001A20))
// model

/** 0x4000 1A24 EPWM11_DBCTL **/
union EPWM11_DBCTL_REG{
	unsigned int reg;
	struct EPWM11_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DBCTL (*((volatile union EPWM11_DBCTL_REG *)0x40001A24))
// model

/** 0x4000 1A28 EPWM11_DBT **/
union EPWM11_DBT_REG{
	unsigned int reg;
	struct EPWM11_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DBT (*((volatile union EPWM11_DBT_REG *)0x40001A28))
// model

/** 0x4000 1A2C EPWM11_PCCTL **/
union EPWM11_PCCTL_REG{
	unsigned int reg;
	struct EPWM11_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_PCCTL (*((volatile union EPWM11_PCCTL_REG *)0x40001A2C))
// model

/** 0x4000 1A30 EPWM11_PXASCTL **/
union EPWM11_PXASCTL_REG{
	unsigned int reg;
	struct EPWM11_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_PXASCTL (*((volatile union EPWM11_PXASCTL_REG *)0x40001A30))
// model

/** 0x4000 1A34 EPWM11_ETCTL **/
union EPWM11_ETCTL_REG{
	unsigned int reg;
	struct EPWM11_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int _SELA:2;
		unsigned int _FRCA:1;
		unsigned int _APP:2;
		unsigned int _AT:2;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int _SELB:2;
		unsigned int _FRCB:1;
		unsigned int _BPP:2;
		unsigned int _BT:2;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_ETCTL (*((volatile union EPWM11_ETCTL_REG *)0x40001A34))
// model

/** 0x4000 1A38 EPWM11_IE **/
union EPWM11_IE_REG{
	unsigned int reg;
	struct EPWM11_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_IE (*((volatile union EPWM11_IE_REG *)0x40001A38))
// model

/** 0x4000 1A3C EPWM11_IF **/
union EPWM11_IF_REG{
	unsigned int reg;
	struct EPWM11_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_IF (*((volatile union EPWM11_IF_REG *)0x40001A3C))
// model

/** 0x4000 1A40 EPWM11_IC **/
union EPWM11_IC_REG{
	unsigned int reg;
	struct EPWM11_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_IC (*((volatile union EPWM11_IC_REG *)0x40001A40))
// model

/** 0x4000 1A44 EPWM11_DE **/
union EPWM11_DE_REG{
	unsigned int reg;
	struct EPWM11_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DE (*((volatile union EPWM11_DE_REG *)0x40001A44))
// model

/** 0x4000 1A48 EPWM11_DF **/
union EPWM11_DF_REG{
	unsigned int reg;
	struct EPWM11_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_DF (*((volatile union EPWM11_DF_REG *)0x40001A48))
// model

/** 0x4000 1A50 EPWM11_HRPWMCTL **/
union EPWM11_HRPWMCTL_REG{
	unsigned int reg;
	struct EPWM11_HRPWMCTL_BITS{
		unsigned int _HRPEN:1;
		unsigned int _HRPOUTB:1;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_HRPWMCTL (*((volatile union EPWM11_HRPWMCTL_REG *)0x40001A50))
// model

/** 0x4000 1A54 EPWM11_HRCMP **/
union EPWM11_HRCMP_REG{
	unsigned int reg;
	struct EPWM11_HRCMP_BITS{
		unsigned int _HRCMP:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_HRCMP (*((volatile union EPWM11_HRCMP_REG *)0x40001A54))
// model

/** 0x4000 1A58 EPWM11_CAP **/
union EPWM11_CAP_REG{
	unsigned int reg;
	struct EPWM11_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_CAP (*((volatile union EPWM11_CAP_REG *)0x40001A58))
// model

/** 0x4000 1A5C  EPWM11_RC **/
union  EPWM11_RC_REG{
	unsigned int reg;
	struct  EPWM11_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define  EPWM11_RC (*((volatile union  EPWM11_RC_REG *)0x40001A5C))
// model

/** 0x4000 1A60 EPWM11_RD **/
union EPWM11_RD_REG{
	unsigned int reg;
	struct EPWM11_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_RD (*((volatile union EPWM11_RD_REG *)0x40001A60))
// model

/** 0x4000 1A64 EPWM11_UDCTL **/
union EPWM11_UDCTL_REG{
	unsigned int reg;
	struct EPWM11_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM11_UDCTL (*((volatile union EPWM11_UDCTL_REG *)0x40001A64))
// modelT12

/** 0x4000 1300 T12_CNT **/
union T12_CNT_REG{
	unsigned int reg;
	struct T12_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_CNT (*((volatile union T12_CNT_REG *)0x40001300))
// model

/** 0x4000 1304 T12_PHS **/
union T12_PHS_REG{
	unsigned int reg;
	struct T12_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_PHS (*((volatile union T12_PHS_REG *)0x40001304))
// model

/** 0x4000 1308 T12_PPX **/
union T12_PPX_REG{
	unsigned int reg;
	struct T12_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_PPX (*((volatile union T12_PPX_REG *)0x40001308))
// model

/** 0x4000 130C T12_PRSC **/
union T12_PRSC_REG{
	unsigned int reg;
	struct T12_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_PRSC (*((volatile union T12_PRSC_REG *)0x4000130C))
// model

/** 0x4000 1310 T12_CTL **/
union T12_CTL_REG{
	unsigned int reg;
	struct T12_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK0:1;
		unsigned int _TXCLK1:1;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS0:1;
		unsigned int _TXCMS1:1;
		unsigned int _TXCMS2:1;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL0:1;
		unsigned int _SYNCOSEL1:1;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int :1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int _LINKEN:1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T12_CTL (*((volatile union T12_CTL_REG *)0x40001310))
// modelEPWM12

/** 0x4000 1314 EPWM12_RA **/
union EPWM12_RA_REG{
	unsigned int reg;
	struct EPWM12_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RA (*((volatile union EPWM12_RA_REG *)0x40001314))
// model

/** 0x4000 1318 EPWM12_RB **/
union EPWM12_RB_REG{
	unsigned int reg;
	struct EPWM12_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RB (*((volatile union EPWM12_RB_REG *)0x40001318))
// model

/** 0x4000 131C EPWM12_CTLA **/
union EPWM12_CTLA_REG{
	unsigned int reg;
	struct EPWM12_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _OTSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_CTLA (*((volatile union EPWM12_CTLA_REG *)0x4000131C))
// model

/** 0x4000 1320 EPWM12_CTLB **/
union EPWM12_CTLB_REG{
	unsigned int reg;
	struct EPWM12_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_CTLB (*((volatile union EPWM12_CTLB_REG *)0x40001320))
// model

/** 0x4000 1324 EPWM12_DBCTL **/
union EPWM12_DBCTL_REG{
	unsigned int reg;
	struct EPWM12_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DBCTL (*((volatile union EPWM12_DBCTL_REG *)0x40001324))
// model

/** 0x4000 1328 EPWM12_DBT **/
union EPWM12_DBT_REG{
	unsigned int reg;
	struct EPWM12_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DBT (*((volatile union EPWM12_DBT_REG *)0x40001328))
// model

/** 0x4000 132C EPWM12_PCCTL **/
union EPWM12_PCCTL_REG{
	unsigned int reg;
	struct EPWM12_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_PCCTL (*((volatile union EPWM12_PCCTL_REG *)0x4000132C))
// model

/** 0x4000 1330 EPWM12_PXASCTL **/
union EPWM12_PXASCTL_REG{
	unsigned int reg;
	struct EPWM12_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_PXASCTL (*((volatile union EPWM12_PXASCTL_REG *)0x40001330))
// model

/** 0x4000 1334 EPWM12_ETCTL **/
union EPWM12_ETCTL_REG{
	unsigned int reg;
	struct EPWM12_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int _SELA:2;
		unsigned int _FRCA:1;
		unsigned int _APP:2;
		unsigned int _AT:2;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int _SELB:2;
		unsigned int _FRCB:1;
		unsigned int _BPP:2;
		unsigned int _BT:2;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_ETCTL (*((volatile union EPWM12_ETCTL_REG *)0x40001334))
// model

/** 0x4000 1338 EPWM12_IE **/
union EPWM12_IE_REG{
	unsigned int reg;
	struct EPWM12_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_IE (*((volatile union EPWM12_IE_REG *)0x40001338))
// model

/** 0x4000 133C EPWM12_IF **/
union EPWM12_IF_REG{
	unsigned int reg;
	struct EPWM12_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_IF (*((volatile union EPWM12_IF_REG *)0x4000133C))
// model

/** 0x4000 1340 EPWM12_IC **/
union EPWM12_IC_REG{
	unsigned int reg;
	struct EPWM12_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_IC (*((volatile union EPWM12_IC_REG *)0x40001340))
// model

/** 0x4000 1344 EPWM12_DE **/
union EPWM12_DE_REG{
	unsigned int reg;
	struct EPWM12_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DE (*((volatile union EPWM12_DE_REG *)0x40001344))
// model

/** 0x4000 1348 EPWM12_DF **/
union EPWM12_DF_REG{
	unsigned int reg;
	struct EPWM12_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_DF (*((volatile union EPWM12_DF_REG *)0x40001348))
// model

/** 0x4000 1350 EPWM12_HRPWMCTL **/
union EPWM12_HRPWMCTL_REG{
	unsigned int reg;
	struct EPWM12_HRPWMCTL_BITS{
		unsigned int _HRPEN:1;
		unsigned int _HRPOUTB:1;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRPWMCTL (*((volatile union EPWM12_HRPWMCTL_REG *)0x40001350))
// model

/** 0x4000 1354 EPWM12_HRCMP **/
union EPWM12_HRCMP_REG{
	unsigned int reg;
	struct EPWM12_HRCMP_BITS{
		unsigned int _HRCMP:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_HRCMP (*((volatile union EPWM12_HRCMP_REG *)0x40001354))
// model

/** 0x4000 1358 EPWM12_CAP **/
union EPWM12_CAP_REG{
	unsigned int reg;
	struct EPWM12_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_CAP (*((volatile union EPWM12_CAP_REG *)0x40001358))
// model

/** 0x4000 135C  EPWM12_RC **/
union  EPWM12_RC_REG{
	unsigned int reg;
	struct  EPWM12_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define  EPWM12_RC (*((volatile union  EPWM12_RC_REG *)0x4000135C))
// model

/** 0x4000 1360 EPWM12_RD **/
union EPWM12_RD_REG{
	unsigned int reg;
	struct EPWM12_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_RD (*((volatile union EPWM12_RD_REG *)0x40001360))
// model

/** 0x4000 1364 EPWM12_UDCTL **/
union EPWM12_UDCTL_REG{
	unsigned int reg;
	struct EPWM12_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM12_UDCTL (*((volatile union EPWM12_UDCTL_REG *)0x40001364))
// modelT13

/** 0x4000 1380 T13_CNT **/
union T13_CNT_REG{
	unsigned int reg;
	struct T13_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_CNT (*((volatile union T13_CNT_REG *)0x40001380))
// model

/** 0x4000 1384 T13_PHS **/
union T13_PHS_REG{
	unsigned int reg;
	struct T13_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_PHS (*((volatile union T13_PHS_REG *)0x40001384))
// model

/** 0x4000 1388 T13_PPX **/
union T13_PPX_REG{
	unsigned int reg;
	struct T13_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_PPX (*((volatile union T13_PPX_REG *)0x40001388))
// model

/** 0x4000 138C T13_PRSC **/
union T13_PRSC_REG{
	unsigned int reg;
	struct T13_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_PRSC (*((volatile union T13_PRSC_REG *)0x4000138C))
// model

/** 0x4000 1390 T13_CTL **/
union T13_CTL_REG{
	unsigned int reg;
	struct T13_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK0:1;
		unsigned int _TXCLK1:1;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS0:1;
		unsigned int _TXCMS1:1;
		unsigned int _TXCMS2:1;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL0:1;
		unsigned int _SYNCOSEL1:1;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int :1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int _LINKEN:1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T13_CTL (*((volatile union T13_CTL_REG *)0x40001390))
// modelEPWM13

/** 0x4000 1394 EPWM13_RA **/
union EPWM13_RA_REG{
	unsigned int reg;
	struct EPWM13_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RA (*((volatile union EPWM13_RA_REG *)0x40001394))
// model

/** 0x4000 1398 EPWM13_RB **/
union EPWM13_RB_REG{
	unsigned int reg;
	struct EPWM13_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RB (*((volatile union EPWM13_RB_REG *)0x40001398))
// model

/** 0x4000 139C EPWM13_CTLA **/
union EPWM13_CTLA_REG{
	unsigned int reg;
	struct EPWM13_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _OTSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_CTLA (*((volatile union EPWM13_CTLA_REG *)0x4000139C))
// model

/** 0x4000 13A0 EPWM13_CTLB **/
union EPWM13_CTLB_REG{
	unsigned int reg;
	struct EPWM13_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_CTLB (*((volatile union EPWM13_CTLB_REG *)0x400013A0))
// model

/** 0x4000 13A4 EPWM13_DBCTL **/
union EPWM13_DBCTL_REG{
	unsigned int reg;
	struct EPWM13_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DBCTL (*((volatile union EPWM13_DBCTL_REG *)0x400013A4))
// model

/** 0x4000 13A8 EPWM13_DBT **/
union EPWM13_DBT_REG{
	unsigned int reg;
	struct EPWM13_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DBT (*((volatile union EPWM13_DBT_REG *)0x400013A8))
// model

/** 0x4000 13AC EPWM13_PCCTL **/
union EPWM13_PCCTL_REG{
	unsigned int reg;
	struct EPWM13_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_PCCTL (*((volatile union EPWM13_PCCTL_REG *)0x400013AC))
// model

/** 0x4000 13B0 EPWM13_PXASCTL **/
union EPWM13_PXASCTL_REG{
	unsigned int reg;
	struct EPWM13_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_PXASCTL (*((volatile union EPWM13_PXASCTL_REG *)0x400013B0))
// model

/** 0x4000 13B4 EPWM13_ETCTL **/
union EPWM13_ETCTL_REG{
	unsigned int reg;
	struct EPWM13_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int _SELA:2;
		unsigned int _FRCA:1;
		unsigned int _APP:2;
		unsigned int _AT:2;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int _SELB:2;
		unsigned int _FRCB:1;
		unsigned int _BPP:2;
		unsigned int _BT:2;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_ETCTL (*((volatile union EPWM13_ETCTL_REG *)0x400013B4))
// model

/** 0x4000 13B8 EPWM13_IE **/
union EPWM13_IE_REG{
	unsigned int reg;
	struct EPWM13_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_IE (*((volatile union EPWM13_IE_REG *)0x400013B8))
// model

/** 0x4000 13BC EPWM13_IF **/
union EPWM13_IF_REG{
	unsigned int reg;
	struct EPWM13_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_IF (*((volatile union EPWM13_IF_REG *)0x400013BC))
// model

/** 0x4000 13C0 EPWM13_IC **/
union EPWM13_IC_REG{
	unsigned int reg;
	struct EPWM13_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_IC (*((volatile union EPWM13_IC_REG *)0x400013C0))
// model

/** 0x4000 13C4 EPWM13_DE **/
union EPWM13_DE_REG{
	unsigned int reg;
	struct EPWM13_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DE (*((volatile union EPWM13_DE_REG *)0x400013C4))
// model

/** 0x4000 13C8 EPWM13_DF **/
union EPWM13_DF_REG{
	unsigned int reg;
	struct EPWM13_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_DF (*((volatile union EPWM13_DF_REG *)0x400013C8))
// model

/** 0x4000 13D0 EPWM13_HRPWMCTL **/
union EPWM13_HRPWMCTL_REG{
	unsigned int reg;
	struct EPWM13_HRPWMCTL_BITS{
		unsigned int _HRPEN:1;
		unsigned int _HRPOUTB:1;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRPWMCTL (*((volatile union EPWM13_HRPWMCTL_REG *)0x400013D0))
// model

/** 0x4000 13D4 EPWM13_HRCMP **/
union EPWM13_HRCMP_REG{
	unsigned int reg;
	struct EPWM13_HRCMP_BITS{
		unsigned int _HRCMP:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_HRCMP (*((volatile union EPWM13_HRCMP_REG *)0x400013D4))
// model

/** 0x4000 13D8 EPWM13_CAP **/
union EPWM13_CAP_REG{
	unsigned int reg;
	struct EPWM13_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_CAP (*((volatile union EPWM13_CAP_REG *)0x400013D8))
// model

/** 0x4000 13DC  EPWM13_RC **/
union  EPWM13_RC_REG{
	unsigned int reg;
	struct  EPWM13_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define  EPWM13_RC (*((volatile union  EPWM13_RC_REG *)0x400013DC))
// model

/** 0x4000 13E0 EPWM13_RD **/
union EPWM13_RD_REG{
	unsigned int reg;
	struct EPWM13_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_RD (*((volatile union EPWM13_RD_REG *)0x400013E0))
// model

/** 0x4000 13E4 EPWM13_UDCTL **/
union EPWM13_UDCTL_REG{
	unsigned int reg;
	struct EPWM13_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM13_UDCTL (*((volatile union EPWM13_UDCTL_REG *)0x400013E4))
// modelT16

/** 0x4000 2E00 T16_CNT **/
union T16_CNT_REG{
	unsigned int reg;
	struct T16_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_CNT (*((volatile union T16_CNT_REG *)0x40002E00))
// model

/** 0x4000 2E04 T16_PHS **/
union T16_PHS_REG{
	unsigned int reg;
	struct T16_PHS_BITS{
		unsigned int _TXPHS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_PHS (*((volatile union T16_PHS_REG *)0x40002E04))
// model

/** 0x4000 2E08 T16_PPX **/
union T16_PPX_REG{
	unsigned int reg;
	struct T16_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_PPX (*((volatile union T16_PPX_REG *)0x40002E08))
// model

/** 0x4000 2E0C T16_PRSC **/
union T16_PRSC_REG{
	unsigned int reg;
	struct T16_PRSC_BITS{
		unsigned int _TXPRSC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_PRSC (*((volatile union T16_PRSC_REG *)0x40002E0C))
// model

/** 0x4000 2E10 T16_CTL **/
union T16_CTL_REG{
	unsigned int reg;
	struct T16_CTL_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int _TXGATE:1;
		unsigned int _TXSY:1;
		unsigned int _TXCLK0:1;
		unsigned int _TXCLK1:1;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS0:1;
		unsigned int _TXCMS1:1;
		unsigned int _TXCMS2:1;
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXUR:1;
		unsigned int _SYNCI:1;
		unsigned int _PHSEN:1;
		unsigned int _SYNCOSEL0:1;
		unsigned int _SYNCOSEL1:1;
		unsigned int _SWFSYNC:1;
		unsigned int _PHSDIR:1;
		unsigned int _TXMAX:1;
		unsigned int :1;
		unsigned int _CAPSEL:1;
		unsigned int _CAPEN:1;
		unsigned int _AQLOCKA:1;
		unsigned int _AQLOCKB:1;
		unsigned int _DBLOCK:1;
		unsigned int _PCLOCK:1;
		unsigned int _ETLOCK:1;
		unsigned int _HRLOCK:1;
		unsigned int _UDSYNEN:1;
		unsigned int _LINKEN:1;
		unsigned int _BLINKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T16_CTL (*((volatile union T16_CTL_REG *)0x40002E10))
// modelEPWM16

/** 0x4000 2E14 EPWM16_RA **/
union EPWM16_RA_REG{
	unsigned int reg;
	struct EPWM16_RA_BITS{
		unsigned int _EPWMRA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_RA (*((volatile union EPWM16_RA_REG *)0x40002E14))
// model

/** 0x4000 2E18 EPWM16_RB **/
union EPWM16_RB_REG{
	unsigned int reg;
	struct EPWM16_RB_BITS{
		unsigned int _EPWMRB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_RB (*((volatile union EPWM16_RB_REG *)0x40002E18))
// model

/** 0x4000 2E1C EPWM16_CTLA **/
union EPWM16_CTLA_REG{
	unsigned int reg;
	struct EPWM16_CTLA_BITS{
		unsigned int _AZRO:2;
		unsigned int _APRD:2;
		unsigned int _ACAU:2;
		unsigned int _ACAD:2;
		unsigned int _ACBU:2;
		unsigned int _ACBD:2;
		unsigned int _CSFA:2;
		unsigned int _ACTSFA:2;
		unsigned int _OTSFA:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_CTLA (*((volatile union EPWM16_CTLA_REG *)0x40002E1C))
// model

/** 0x4000 2E20 EPWM16_CTLB **/
union EPWM16_CTLB_REG{
	unsigned int reg;
	struct EPWM16_CTLB_BITS{
		unsigned int _BZRO:2;
		unsigned int _BPRD:2;
		unsigned int _BCAU:2;
		unsigned int _BCAD:2;
		unsigned int _BCBU:2;
		unsigned int _BCBD:2;
		unsigned int _CSFB:2;
		unsigned int _ACTSFB:2;
		unsigned int _OTSFB:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_CTLB (*((volatile union EPWM16_CTLB_REG *)0x40002E20))
// model

/** 0x4000 2E24 EPWM16_DBCTL **/
union EPWM16_DBCTL_REG{
	unsigned int reg;
	struct EPWM16_DBCTL_BITS{
		unsigned int _OUTMODE:2;
		unsigned int _POLSEL:2;
		unsigned int _INMODE:2;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_DBCTL (*((volatile union EPWM16_DBCTL_REG *)0x40002E24))
// model

/** 0x4000 2E28 EPWM16_DBT **/
union EPWM16_DBT_REG{
	unsigned int reg;
	struct EPWM16_DBT_BITS{
		unsigned int _FDBT:16;
		unsigned int _RDBT:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_DBT (*((volatile union EPWM16_DBT_REG *)0x40002E28))
// model

/** 0x4000 2E2C EPWM16_PCCTL **/
union EPWM16_PCCTL_REG{
	unsigned int reg;
	struct EPWM16_PCCTL_BITS{
		unsigned int _CHPEN:1;
		unsigned int _OSHTWTH:4;
		unsigned int _CHPDUTY:3;
		unsigned int _CHPFREQ:3;
		unsigned int :21;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_PCCTL (*((volatile union EPWM16_PCCTL_REG *)0x40002E2C))
// model

/** 0x4000 2E30 EPWM16_PXASCTL **/
union EPWM16_PXASCTL_REG{
	unsigned int reg;
	struct EPWM16_PXASCTL_BITS{
		unsigned int _PXASS:3;
		unsigned int _PXASE:1;
		unsigned int _PXSSB:2;
		unsigned int _PXSSA:2;
		unsigned int _PXRSEN:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_PXASCTL (*((volatile union EPWM16_PXASCTL_REG *)0x40002E30))
// model

/** 0x4000 2E34 EPWM16_ETCTL **/
union EPWM16_ETCTL_REG{
	unsigned int reg;
	struct EPWM16_ETCTL_BITS{
		unsigned int _TOADENA:1;
		unsigned int _SELA:2;
		unsigned int _FRCA:1;
		unsigned int _APP:2;
		unsigned int _AT:2;
		unsigned int _ATSEL:2;
		unsigned int :6;
		unsigned int _TOADENB:1;
		unsigned int _SELB:2;
		unsigned int _FRCB:1;
		unsigned int _BPP:2;
		unsigned int _BT:2;
		unsigned int _BTSEL:2;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_ETCTL (*((volatile union EPWM16_ETCTL_REG *)0x40002E34))
// model

/** 0x4000 2E38 EPWM16_IE **/
union EPWM16_IE_REG{
	unsigned int reg;
	struct EPWM16_IE_BITS{
		unsigned int _TXTIE0:1;
		unsigned int _TXTIE1:1;
		unsigned int _TXGIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXIE:1;
		unsigned int _TXBIE:1;
		unsigned int _TXAIE:1;
		unsigned int _TXCIE:1;
		unsigned int _TXDIE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_IE (*((volatile union EPWM16_IE_REG *)0x40002E38))
// model

/** 0x4000 2E3C EPWM16_IF **/
union EPWM16_IF_REG{
	unsigned int reg;
	struct EPWM16_IF_BITS{
		unsigned int _TXTIF0:1;
		unsigned int _TXTIF1:1;
		unsigned int _TXGIF:1;
		unsigned int _TXUIF:1;
		unsigned int _TXIF:1;
		unsigned int _TXBIF:1;
		unsigned int _TXAIF:1;
		unsigned int _TXCIF:1;
		unsigned int _TXDIF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_IF (*((volatile union EPWM16_IF_REG *)0x40002E3C))
// model

/** 0x4000 2E40 EPWM16_IC **/
union EPWM16_IC_REG{
	unsigned int reg;
	struct EPWM16_IC_BITS{
		unsigned int _TXTIC0:1;
		unsigned int _TXTIC1:1;
		unsigned int _TXGIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int _TXBIC:1;
		unsigned int _TXAIC:1;
		unsigned int _TXCIC:1;
		unsigned int _TXDIC:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_IC (*((volatile union EPWM16_IC_REG *)0x40002E40))
// model

/** 0x4000 2E44 EPWM16_DE **/
union EPWM16_DE_REG{
	unsigned int reg;
	struct EPWM16_DE_BITS{
		unsigned int _TXTDE0:1;
		unsigned int _TXTDE1:1;
		unsigned int _TXGDE:1;
		unsigned int _TXUDE:1;
		unsigned int _TXDE:1;
		unsigned int _TXBDE:1;
		unsigned int _TXADE:1;
		unsigned int _TXCDE:1;
		unsigned int _TXDDE:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_DE (*((volatile union EPWM16_DE_REG *)0x40002E44))
// model

/** 0x4000 2E48 EPWM16_DF **/
union EPWM16_DF_REG{
	unsigned int reg;
	struct EPWM16_DF_BITS{
		unsigned int _TXTDF0:1;
		unsigned int _TXTDF1:1;
		unsigned int _TXGDF:1;
		unsigned int _TXUDF:1;
		unsigned int _TXDF:1;
		unsigned int _TXBDF:1;
		unsigned int _TXADF:1;
		unsigned int _TXCDF:1;
		unsigned int _TXDDF:1;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_DF (*((volatile union EPWM16_DF_REG *)0x40002E48))
// model

/** 0x4000 2E50 EPWM16_HRPWMCTL **/
union EPWM16_HRPWMCTL_REG{
	unsigned int reg;
	struct EPWM16_HRPWMCTL_BITS{
		unsigned int _HRPEN:1;
		unsigned int _HRPOUTB:1;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_HRPWMCTL (*((volatile union EPWM16_HRPWMCTL_REG *)0x40002E50))
// model

/** 0x4000 2E54 EPWM16_HRCMP **/
union EPWM16_HRCMP_REG{
	unsigned int reg;
	struct EPWM16_HRCMP_BITS{
		unsigned int _HRCMP:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_HRCMP (*((volatile union EPWM16_HRCMP_REG *)0x40002E54))
// model

/** 0x4000 2E58 EPWM16_CAP **/
union EPWM16_CAP_REG{
	unsigned int reg;
	struct EPWM16_CAP_BITS{
		unsigned int _CAP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_CAP (*((volatile union EPWM16_CAP_REG *)0x40002E58))
// model

/** 0x4000 2E5C  EPWM16_RC **/
union  EPWM16_RC_REG{
	unsigned int reg;
	struct  EPWM16_RC_BITS{
		unsigned int _EPWMRC:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define  EPWM16_RC (*((volatile union  EPWM16_RC_REG *)0x40002E5C))
// model

/** 0x4000 2E60 EPWM16_RD **/
union EPWM16_RD_REG{
	unsigned int reg;
	struct EPWM16_RD_BITS{
		unsigned int _EPWMRD:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_RD (*((volatile union EPWM16_RD_REG *)0x40002E60))
// model

/** 0x4000 2E64 EPWM16_UDCTL **/
union EPWM16_UDCTL_REG{
	unsigned int reg;
	struct EPWM16_UDCTL_BITS{
		unsigned int _PPUDEN:1;
		unsigned int _PPUDSEL:2;
		unsigned int _PRUDEN:1;
		unsigned int _PRUDSEL:2;
		unsigned int _CMAUDEN:1;
		unsigned int _CMAUDSEL:2;
		unsigned int _CMBUDEN:1;
		unsigned int _CMBUDSEL:2;
		unsigned int _CMCUDEN:1;
		unsigned int _CMCUDSEL:2;
		unsigned int _CMDUDEN:1;
		unsigned int _CMDUDSEL:2;
		unsigned int _EAUDEN:1;
		unsigned int _EAUDSEL:2;
		unsigned int _EBUDEN:1;
		unsigned int _EBUDSEL:2;
		unsigned int _HRPUDEN:1;
		unsigned int _HRPUDSEL:2;
		unsigned int _GBUDEN:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EPWM16_UDCTL (*((volatile union EPWM16_UDCTL_REG *)0x40002E64))
// modelHRCAP0

/** 0x4000 2400 HC0_CTL **/
union HC0_CTL_REG{
	unsigned int reg;
	struct HC0_CTL_BITS{
		unsigned int _HCINSEL:1;
		unsigned int _RISEINTE:1;
		unsigned int _FALLINTE:1;
		unsigned int _OVERINTE:1;
		unsigned int _SOFTRESET:1;
		unsigned int _CLKSEL:2;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_CTL (*((volatile union HC0_CTL_REG *)0x40002400))
// model

/** 0x4000 2404 HC0_COUNTER **/
union HC0_COUNTER_REG{
	unsigned int reg;
	struct HC0_COUNTER_BITS{
		unsigned int _COUNTER:16;
		unsigned int _COUNTERSR:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_COUNTER (*((volatile union HC0_COUNTER_REG *)0x40002404))
// model

/** 0x4000 2408 HC0_RISE0 **/
union HC0_RISE0_REG{
	unsigned int reg;
	struct HC0_RISE0_BITS{
		unsigned int _RISE0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_RISE0 (*((volatile union HC0_RISE0_REG *)0x40002408))
// model

/** 0x4000 240C HC0_RISE1 **/
union HC0_RISE1_REG{
	unsigned int reg;
	struct HC0_RISE1_BITS{
		unsigned int _RISE1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_RISE1 (*((volatile union HC0_RISE1_REG *)0x4000240C))
// model

/** 0x4000 2410 HC0_FALL0 **/
union HC0_FALL0_REG{
	unsigned int reg;
	struct HC0_FALL0_BITS{
		unsigned int _FALL0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_FALL0 (*((volatile union HC0_FALL0_REG *)0x40002410))
// model

/** 0x4000 2414 HC0_FALL1 **/
union HC0_FALL1_REG{
	unsigned int reg;
	struct HC0_FALL1_BITS{
		unsigned int _FALL1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_FALL1 (*((volatile union HC0_FALL1_REG *)0x40002414))
// model

/** 0x4000 2418 HC0_HRRISE0 **/
union HC0_HRRISE0_REG{
	unsigned int reg;
	struct HC0_HRRISE0_BITS{
		unsigned int _HRRISE0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_HRRISE0 (*((volatile union HC0_HRRISE0_REG *)0x40002418))
// model

/** 0x4000 241C HC0_HRRISE1 **/
union HC0_HRRISE1_REG{
	unsigned int reg;
	struct HC0_HRRISE1_BITS{
		unsigned int _HRRISE1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_HRRISE1 (*((volatile union HC0_HRRISE1_REG *)0x4000241C))
// model

/** 0x4000 2420 HC0_HRFALL0 **/
union HC0_HRFALL0_REG{
	unsigned int reg;
	struct HC0_HRFALL0_BITS{
		unsigned int _HRFALL0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_HRFALL0 (*((volatile union HC0_HRFALL0_REG *)0x40002420))
// model

/** 0x4000 2424 HC0_HRFALL1 **/
union HC0_HRFALL1_REG{
	unsigned int reg;
	struct HC0_HRFALL1_BITS{
		unsigned int _HRFALL1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_HRFALL1 (*((volatile union HC0_HRFALL1_REG *)0x40002424))
// model

/** 0x4000 2428 HC0_SR **/
union HC0_SR_REG{
	unsigned int reg;
	struct HC0_SR_BITS{
		unsigned int :1;
		unsigned int _RISEIF:1;
		unsigned int _FALLIF:1;
		unsigned int _COUNTEROVF:1;
		unsigned int _RISEOVF:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_SR (*((volatile union HC0_SR_REG *)0x40002428))
// model

/** 0x4000 242C HC0_SRIC **/
union HC0_SRIC_REG{
	unsigned int reg;
	struct HC0_SRIC_BITS{
		unsigned int :1;
		unsigned int _RISEIC:1;
		unsigned int _FALLIC:1;
		unsigned int _COUNTEROVC:1;
		unsigned int _RISEOVC:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_SRIC (*((volatile union HC0_SRIC_REG *)0x4000242C))
// model

/** 0x4000 2430 HC0_IFRC **/
union HC0_IFRC_REG{
	unsigned int reg;
	struct HC0_IFRC_BITS{
		unsigned int :1;
		unsigned int _RISEIFRC:1;
		unsigned int _FALLIFRC:1;
		unsigned int _COUNTEROVFRC:1;
		unsigned int :28;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC0_IFRC (*((volatile union HC0_IFRC_REG *)0x40002430))
// modelHRCAP1

/** 0x4000 2480 HC1_CTL **/
union HC1_CTL_REG{
	unsigned int reg;
	struct HC1_CTL_BITS{
		unsigned int _HCINSEL:1;
		unsigned int _RISEINTE:1;
		unsigned int _FALLINTE:1;
		unsigned int _OVERINTE:1;
		unsigned int _SOFTRESET:1;
		unsigned int _CLKSEL:2;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_CTL (*((volatile union HC1_CTL_REG *)0x40002480))
// model

/** 0x4000 2484 HC1_COUNTER **/
union HC1_COUNTER_REG{
	unsigned int reg;
	struct HC1_COUNTER_BITS{
		unsigned int _COUNTER:16;
		unsigned int _COUNTERSR:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_COUNTER (*((volatile union HC1_COUNTER_REG *)0x40002484))
// model

/** 0x4000 2488 HC1_RISE0 **/
union HC1_RISE0_REG{
	unsigned int reg;
	struct HC1_RISE0_BITS{
		unsigned int _RISE0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_RISE0 (*((volatile union HC1_RISE0_REG *)0x40002488))
// model

/** 0x4000 248C HC1_RISE1 **/
union HC1_RISE1_REG{
	unsigned int reg;
	struct HC1_RISE1_BITS{
		unsigned int _RISE1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_RISE1 (*((volatile union HC1_RISE1_REG *)0x4000248C))
// model

/** 0x4000 2490 HC1_FALL0 **/
union HC1_FALL0_REG{
	unsigned int reg;
	struct HC1_FALL0_BITS{
		unsigned int _FALL0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_FALL0 (*((volatile union HC1_FALL0_REG *)0x40002490))
// model

/** 0x4000 2494 HC1_FALL1 **/
union HC1_FALL1_REG{
	unsigned int reg;
	struct HC1_FALL1_BITS{
		unsigned int _FALL1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_FALL1 (*((volatile union HC1_FALL1_REG *)0x40002494))
// model

/** 0x4000 2498 HC1_HRRISE0 **/
union HC1_HRRISE0_REG{
	unsigned int reg;
	struct HC1_HRRISE0_BITS{
		unsigned int _HRRISE0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_HRRISE0 (*((volatile union HC1_HRRISE0_REG *)0x40002498))
// model

/** 0x4000 249C HC1_HRRISE1 **/
union HC1_HRRISE1_REG{
	unsigned int reg;
	struct HC1_HRRISE1_BITS{
		unsigned int _HRRISE1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_HRRISE1 (*((volatile union HC1_HRRISE1_REG *)0x4000249C))
// model

/** 0x4000 24A0 HC1_HRFALL0 **/
union HC1_HRFALL0_REG{
	unsigned int reg;
	struct HC1_HRFALL0_BITS{
		unsigned int _HRFALL0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_HRFALL0 (*((volatile union HC1_HRFALL0_REG *)0x400024A0))
// model

/** 0x4000 24A4 HC1_HRFALL1 **/
union HC1_HRFALL1_REG{
	unsigned int reg;
	struct HC1_HRFALL1_BITS{
		unsigned int _HRFALL1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_HRFALL1 (*((volatile union HC1_HRFALL1_REG *)0x400024A4))
// model

/** 0x4000 24A8 HC1_SR **/
union HC1_SR_REG{
	unsigned int reg;
	struct HC1_SR_BITS{
		unsigned int :1;
		unsigned int _RISEIF:1;
		unsigned int _FALLIF:1;
		unsigned int _COUNTEROVF:1;
		unsigned int _RISEOVF:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_SR (*((volatile union HC1_SR_REG *)0x400024A8))
// model

/** 0x4000 24AC HC1_SRIC **/
union HC1_SRIC_REG{
	unsigned int reg;
	struct HC1_SRIC_BITS{
		unsigned int :1;
		unsigned int _RISEIC:1;
		unsigned int _FALLIC:1;
		unsigned int _COUNTEROVC:1;
		unsigned int _RISEOVC:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_SRIC (*((volatile union HC1_SRIC_REG *)0x400024AC))
// model

/** 0x4000 24B0 HC1_IFRC **/
union HC1_IFRC_REG{
	unsigned int reg;
	struct HC1_IFRC_BITS{
		unsigned int :1;
		unsigned int _RISEIFRC:1;
		unsigned int _FALLIFRC:1;
		unsigned int _COUNTEROVFRC:1;
		unsigned int :28;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC1_IFRC (*((volatile union HC1_IFRC_REG *)0x400024B0))
// modelHRCAP2

/** 0x4000 2500 HC2_CTL **/
union HC2_CTL_REG{
	unsigned int reg;
	struct HC2_CTL_BITS{
		unsigned int _HCINSEL:1;
		unsigned int _RISEINTE:1;
		unsigned int _FALLINTE:1;
		unsigned int _OVERINTE:1;
		unsigned int _SOFTRESET:1;
		unsigned int _CLKSEL:2;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_CTL (*((volatile union HC2_CTL_REG *)0x40002500))
// model

/** 0x4000 2504 HC2_COUNTER **/
union HC2_COUNTER_REG{
	unsigned int reg;
	struct HC2_COUNTER_BITS{
		unsigned int _COUNTER:16;
		unsigned int _COUNTERSR:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_COUNTER (*((volatile union HC2_COUNTER_REG *)0x40002504))
// model

/** 0x4000 2508 HC2_RISE0 **/
union HC2_RISE0_REG{
	unsigned int reg;
	struct HC2_RISE0_BITS{
		unsigned int _RISE0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_RISE0 (*((volatile union HC2_RISE0_REG *)0x40002508))
// model

/** 0x4000 250C HC2_RISE1 **/
union HC2_RISE1_REG{
	unsigned int reg;
	struct HC2_RISE1_BITS{
		unsigned int _RISE1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_RISE1 (*((volatile union HC2_RISE1_REG *)0x4000250C))
// model

/** 0x4000 2510 HC2_FALL0 **/
union HC2_FALL0_REG{
	unsigned int reg;
	struct HC2_FALL0_BITS{
		unsigned int _FALL0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_FALL0 (*((volatile union HC2_FALL0_REG *)0x40002510))
// model

/** 0x4000 2514 HC2_FALL1 **/
union HC2_FALL1_REG{
	unsigned int reg;
	struct HC2_FALL1_BITS{
		unsigned int _FALL1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_FALL1 (*((volatile union HC2_FALL1_REG *)0x40002514))
// model

/** 0x4000 2518 HC2_HRRISE0 **/
union HC2_HRRISE0_REG{
	unsigned int reg;
	struct HC2_HRRISE0_BITS{
		unsigned int _HRRISE0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_HRRISE0 (*((volatile union HC2_HRRISE0_REG *)0x40002518))
// model

/** 0x4000 251C HC2_HRRISE1 **/
union HC2_HRRISE1_REG{
	unsigned int reg;
	struct HC2_HRRISE1_BITS{
		unsigned int _HRRISE1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_HRRISE1 (*((volatile union HC2_HRRISE1_REG *)0x4000251C))
// model

/** 0x4000 2520 HC2_HRFALL0 **/
union HC2_HRFALL0_REG{
	unsigned int reg;
	struct HC2_HRFALL0_BITS{
		unsigned int _HRFALL0:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_HRFALL0 (*((volatile union HC2_HRFALL0_REG *)0x40002520))
// model

/** 0x4000 2524 HC2_HRFALL1 **/
union HC2_HRFALL1_REG{
	unsigned int reg;
	struct HC2_HRFALL1_BITS{
		unsigned int _HRFALL1:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_HRFALL1 (*((volatile union HC2_HRFALL1_REG *)0x40002524))
// model

/** 0x4000 2528 HC2_SR **/
union HC2_SR_REG{
	unsigned int reg;
	struct HC2_SR_BITS{
		unsigned int :1;
		unsigned int _RISEIF:1;
		unsigned int _FALLIF:1;
		unsigned int _COUNTEROVF:1;
		unsigned int _RISEOVF:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_SR (*((volatile union HC2_SR_REG *)0x40002528))
// model

/** 0x4000 252C HC2_SRIC **/
union HC2_SRIC_REG{
	unsigned int reg;
	struct HC2_SRIC_BITS{
		unsigned int :1;
		unsigned int _RISEIC:1;
		unsigned int _FALLIC:1;
		unsigned int _COUNTEROVC:1;
		unsigned int _RISEOVC:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_SRIC (*((volatile union HC2_SRIC_REG *)0x4000252C))
// model

/** 0x4000 2530 HC2_IFRC **/
union HC2_IFRC_REG{
	unsigned int reg;
	struct HC2_IFRC_BITS{
		unsigned int :1;
		unsigned int _RISEIFRC:1;
		unsigned int _FALLIFRC:1;
		unsigned int _COUNTEROVFRC:1;
		unsigned int :28;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define HC2_IFRC (*((volatile union HC2_IFRC_REG *)0x40002530))
// modelRNG

/** 0x4000 2F80 RNG_CTL **/
union RNG_CTL_REG{
	unsigned int reg;
	struct RNG_CTL_BITS{
		unsigned int _RNGEN:1;
		unsigned int _RNGSEL:1;
		unsigned int _CLKS:2;
		unsigned int _CLKDIV:4;
		unsigned int _TSEEDEN:1;
		unsigned int _TSEEDGO:1;
		unsigned int :2;
		unsigned int _HIPOW:1;
		unsigned int _RECEN:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RNG_CTL (*((volatile union RNG_CTL_REG *)0x40002F80))
// model

/** 0x4000 2F84 RNG_STATE **/
union RNG_STATE_REG{
	unsigned int reg;
	struct RNG_STATE_BITS{
		unsigned int _DEIF:1;
		unsigned int _DRIF:1;
		unsigned int _TSRIF:1;
		unsigned int :1;
		unsigned int _DEIC:1;
		unsigned int _DRIC:1;
		unsigned int _TSRIC:1;
		unsigned int :1;
		unsigned int _DEIE:1;
		unsigned int _DRIE:1;
		unsigned int _TSRIE:1;
		unsigned int :1;
		unsigned int _HSPD0:1;
		unsigned int _HSPD1:1;
		unsigned int :1;
		unsigned int _DEIS:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RNG_STATE (*((volatile union RNG_STATE_REG *)0x40002F84))
// model

/** 0x4000 2F88 RNG_SEED **/
union RNG_SEED_REG{
	unsigned int reg;
	struct RNG_SEED_BITS{
		unsigned int _SEED:32;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RNG_SEED (*((volatile union RNG_SEED_REG *)0x40002F88))
// model

/** 0x4000 2F8C RNG_DR **/
union RNG_DR_REG{
	unsigned int reg;
	struct RNG_DR_BITS{
		unsigned int _DR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define RNG_DR (*((volatile union RNG_DR_REG *)0x40002F8C))
// modelT18

/** 0x4000 1A80 T18_CNT **/
union T18_CNT_REG{
	unsigned int reg;
	struct T18_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_CNT (*((volatile union T18_CNT_REG *)0x40001A80))
// model

/** 0x4000 1A84 T18_CTL1 **/
union T18_CTL1_REG{
	unsigned int reg;
	struct T18_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK0:1;
		unsigned int _TXCLK1:1;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS0:1;
		unsigned int _TXCMS1:1;
		unsigned int _TXCMS2:1;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_CTL1 (*((volatile union T18_CTL1_REG *)0x40001A84))
// model

/** 0x4000 1A88 T18_CTL2 **/
union T18_CTL2_REG{
	unsigned int reg;
	struct T18_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_CTL2 (*((volatile union T18_CTL2_REG *)0x40001A88))
// model

/** 0x4000 1A8C T18_PRSC **/
union T18_PRSC_REG{
	unsigned int reg;
	struct T18_PRSC_BITS{
		unsigned int _TXCKS:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_PRSC (*((volatile union T18_PRSC_REG *)0x40001A8C))
// model

/** 0x4000 1A90 T18_PPX **/
union T18_PPX_REG{
	unsigned int reg;
	struct T18_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_PPX (*((volatile union T18_PPX_REG *)0x40001A90))
// model

/** 0x4000 1A94 T18_UDTIMx **/
union T18_UDTIMx_REG{
	unsigned int reg;
	struct T18_UDTIMx_BITS{
		unsigned int _TXUD0:1;
		unsigned int _TXUD1:1;
		unsigned int _TXUD2:1;
		unsigned int _TXUD3:1;
		unsigned int _TXUD4:1;
		unsigned int _TXUD5:1;
		unsigned int _TXUD6:1;
		unsigned int _TXUD7:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T18_UDTIMx (*((volatile union T18_UDTIMx_REG *)0x40001A94))
// modelCCP18

/** 0x4000 1AA0 CCP18_C1 **/
union CCP18_C1_REG{
	unsigned int reg;
	struct CCP18_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C1 (*((volatile union CCP18_C1_REG *)0x40001AA0))
// model

/** 0x4000 1AA4 CCP18_C2 **/
union CCP18_C2_REG{
	unsigned int reg;
	struct CCP18_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C2 (*((volatile union CCP18_C2_REG *)0x40001AA4))
// model

/** 0x4000 1AA8 CCP18_C3 **/
union CCP18_C3_REG{
	unsigned int reg;
	struct CCP18_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C3 (*((volatile union CCP18_C3_REG *)0x40001AA8))
// model

/** 0x4000 1AAC CCP18_C4 **/
union CCP18_C4_REG{
	unsigned int reg;
	struct CCP18_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_C4 (*((volatile union CCP18_C4_REG *)0x40001AAC))
// model

/** 0x4000 1AB0 CCP18_SRIC **/
union CCP18_SRIC_REG{
	unsigned int reg;
	struct CCP18_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_SRIC (*((volatile union CCP18_SRIC_REG *)0x40001AB0))
// model

/** 0x4000 1AB4 CCP18_DF **/
union CCP18_DF_REG{
	unsigned int reg;
	struct CCP18_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_DF (*((volatile union CCP18_DF_REG *)0x40001AB4))
// model

/** 0x4000 1AC0 CCP18_CTL1 **/
union CCP18_CTL1_REG{
	unsigned int reg;
	struct CCP18_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_CTL1 (*((volatile union CCP18_CTL1_REG *)0x40001AC0))
// model

/** 0x4000 1AC4 CCP18_R1 **/
union CCP18_R1_REG{
	unsigned int reg;
	struct CCP18_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R1 (*((volatile union CCP18_R1_REG *)0x40001AC4))
// model

/** 0x4000 1AC8 CCP18_R2 **/
union CCP18_R2_REG{
	unsigned int reg;
	struct CCP18_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R2 (*((volatile union CCP18_R2_REG *)0x40001AC8))
// model

/** 0x4000 1ACC CCP18_R3 **/
union CCP18_R3_REG{
	unsigned int reg;
	struct CCP18_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R3 (*((volatile union CCP18_R3_REG *)0x40001ACC))
// model

/** 0x4000 1AD0 CCP18_R4 **/
union CCP18_R4_REG{
	unsigned int reg;
	struct CCP18_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_R4 (*((volatile union CCP18_R4_REG *)0x40001AD0))
// model

/** 0x4000 1AD4 CCP18_CTL2 **/
union CCP18_CTL2_REG{
	unsigned int reg;
	struct CCP18_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_CTL2 (*((volatile union CCP18_CTL2_REG *)0x40001AD4))
// model

/** 0x4000 1AD8 CCP18_CTL3 **/
union CCP18_CTL3_REG{
	unsigned int reg;
	struct CCP18_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_CTL3 (*((volatile union CCP18_CTL3_REG *)0x40001AD8))
// model

/** 0x4000 1ADC CCP18_EGIF **/
union CCP18_EGIF_REG{
	unsigned int reg;
	struct CCP18_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP18_EGIF (*((volatile union CCP18_EGIF_REG *)0x40001ADC))
// modelT19

/** 0x4000 1B00 T19_CNT **/
union T19_CNT_REG{
	unsigned int reg;
	struct T19_CNT_BITS{
		unsigned int _TXCNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_CNT (*((volatile union T19_CNT_REG *)0x40001B00))
// model

/** 0x4000 1B04 T19_CTL1 **/
union T19_CTL1_REG{
	unsigned int reg;
	struct T19_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_CTL1 (*((volatile union T19_CTL1_REG *)0x40001B04))
// model

/** 0x4000 1B08 T19_CTL2 **/
union T19_CTL2_REG{
	unsigned int reg;
	struct T19_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGRSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_CTL2 (*((volatile union T19_CTL2_REG *)0x40001B08))
// model

/** 0x4000 1B0C T19_PRSC **/
union T19_PRSC_REG{
	unsigned int reg;
	struct T19_PRSC_BITS{
		unsigned int _TXCKS0:1;
		unsigned int _TXCKS1:1;
		unsigned int _TXCKS2:1;
		unsigned int _TXCKS3:1;
		unsigned int _TXCKS4:1;
		unsigned int _TXCKS5:1;
		unsigned int _TXCKS6:1;
		unsigned int _TXCKS7:1;
		unsigned int _TXCKS8:1;
		unsigned int _TXCKS9:1;
		unsigned int _TXCKS10:1;
		unsigned int _TXCKS11:1;
		unsigned int _TXCKS12:1;
		unsigned int _TXCKS13:1;
		unsigned int _TXCKS14:1;
		unsigned int _TXCKS15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_PRSC (*((volatile union T19_PRSC_REG *)0x40001B0C))
// model

/** 0x4000 1B10 T19_PPX **/
union T19_PPX_REG{
	unsigned int reg;
	struct T19_PPX_BITS{
		unsigned int _PPX:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_PPX (*((volatile union T19_PPX_REG *)0x40001B10))
// model

/** 0x4000 1B14 T19_UDTIMx **/
union T19_UDTIMx_REG{
	unsigned int reg;
	struct T19_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T19_UDTIMx (*((volatile union T19_UDTIMx_REG *)0x40001B14))
// modelCCP19

/** 0x4000 1B20 CCP19_C1 **/
union CCP19_C1_REG{
	unsigned int reg;
	struct CCP19_C1_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C1 (*((volatile union CCP19_C1_REG *)0x40001B20))
// model

/** 0x4000 1B24 CCP19_C2 **/
union CCP19_C2_REG{
	unsigned int reg;
	struct CCP19_C2_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C2 (*((volatile union CCP19_C2_REG *)0x40001B24))
// model

/** 0x4000 1B28 CCP19_C3 **/
union CCP19_C3_REG{
	unsigned int reg;
	struct CCP19_C3_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C3 (*((volatile union CCP19_C3_REG *)0x40001B28))
// model

/** 0x4000 1B2C CCP19_C4 **/
union CCP19_C4_REG{
	unsigned int reg;
	struct CCP19_C4_BITS{
		unsigned int _CCPXCY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_C4 (*((volatile union CCP19_C4_REG *)0x40001B2C))
// model

/** 0x4000 1B30 CCP19_SRIC **/
union CCP19_SRIC_REG{
	unsigned int reg;
	struct CCP19_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_SRIC (*((volatile union CCP19_SRIC_REG *)0x40001B30))
// model

/** 0x4000 1B34 CCP19_DF **/
union CCP19_DF_REG{
	unsigned int reg;
	struct CCP19_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_DF (*((volatile union CCP19_DF_REG *)0x40001B34))
// model

/** 0x4000 1B40 CCP19_CTL1 **/
union CCP19_CTL1_REG{
	unsigned int reg;
	struct CCP19_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_CTL1 (*((volatile union CCP19_CTL1_REG *)0x40001B40))
// model

/** 0x4000 1B44 CCP19_R1 **/
union CCP19_R1_REG{
	unsigned int reg;
	struct CCP19_R1_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R1 (*((volatile union CCP19_R1_REG *)0x40001B44))
// model

/** 0x4000 1B48 CCP19_R2 **/
union CCP19_R2_REG{
	unsigned int reg;
	struct CCP19_R2_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R2 (*((volatile union CCP19_R2_REG *)0x40001B48))
// model

/** 0x4000 1B4C CCP19_R3 **/
union CCP19_R3_REG{
	unsigned int reg;
	struct CCP19_R3_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R3 (*((volatile union CCP19_R3_REG *)0x40001B4C))
// model

/** 0x4000 1B50 CCP19_R4 **/
union CCP19_R4_REG{
	unsigned int reg;
	struct CCP19_R4_BITS{
		unsigned int _CCPXRY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_R4 (*((volatile union CCP19_R4_REG *)0x40001B50))
// model

/** 0x4000 1B54 CCP19_CTL2 **/
union CCP19_CTL2_REG{
	unsigned int reg;
	struct CCP19_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_CTL2 (*((volatile union CCP19_CTL2_REG *)0x40001B54))
// model

/** 0x4000 1B58 CCP19_CTL3 **/
union CCP19_CTL3_REG{
	unsigned int reg;
	struct CCP19_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_CTL3 (*((volatile union CCP19_CTL3_REG *)0x40001B58))
// model

/** 0x4000 1B5C CCP19_EGIF **/
union CCP19_EGIF_REG{
	unsigned int reg;
	struct CCP19_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP19_EGIF (*((volatile union CCP19_EGIF_REG *)0x40001B5C))
// modelT21

/** 0x4000 1C00 T21_CNT **/
union T21_CNT_REG{
	unsigned int reg;
	struct T21_CNT_BITS{
		unsigned int _TXCNT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_CNT (*((volatile union T21_CNT_REG *)0x40001C00))
// model

/** 0x4000 1C04 T21_CTL1 **/
union T21_CTL1_REG{
	unsigned int reg;
	struct T21_CTL1_BITS{
		unsigned int _TXEN:1;
		unsigned int _TXCS:1;
		unsigned int :1;
		unsigned int _TXSY:1;
		unsigned int :1;
		unsigned int _TXCLK:2;
		unsigned int _TXDIR:1;
		unsigned int _TXCMS:3;
		unsigned int :1;
		unsigned int _TXIE:1;
		unsigned int _TXIF:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_CTL1 (*((volatile union T21_CTL1_REG *)0x40001C04))
// model

/** 0x4000 1C08 T21_CTL2 **/
union T21_CTL2_REG{
	unsigned int reg;
	struct T21_CTL2_BITS{
		unsigned int _TXUDEN:1;
		unsigned int _TXUDEVT:1;
		unsigned int _TXMMS:3;
		unsigned int _TXSMS:3;
		unsigned int _TXTS:4;
		unsigned int _TXMSSYNC:1;
		unsigned int _TXUR:1;
		unsigned int _TRGSEL:2;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_CTL2 (*((volatile union T21_CTL2_REG *)0x40001C08))
// model

/** 0x4000 1C0C T21_PRSC **/
union T21_PRSC_REG{
	unsigned int reg;
	struct T21_PRSC_BITS{
		unsigned int _TXCKS:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_PRSC (*((volatile union T21_PRSC_REG *)0x40001C0C))
// model

/** 0x4000 1C10 T21_PPX **/
union T21_PPX_REG{
	unsigned int reg;
	struct T21_PPX_BITS{
		unsigned int _PPX:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_PPX (*((volatile union T21_PPX_REG *)0x40001C10))
// model

/** 0x4000 1C14 T21_UDTIMx **/
union T21_UDTIMx_REG{
	unsigned int reg;
	struct T21_UDTIMx_BITS{
		unsigned int _TXUD:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define T21_UDTIMx (*((volatile union T21_UDTIMx_REG *)0x40001C14))
// modelCCP21

/** 0x4000 1C20 CCP21_C1 **/
union CCP21_C1_REG{
	unsigned int reg;
	struct CCP21_C1_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C1 (*((volatile union CCP21_C1_REG *)0x40001C20))
// model

/** 0x4000 1C24 CCP21_C2 **/
union CCP21_C2_REG{
	unsigned int reg;
	struct CCP21_C2_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C2 (*((volatile union CCP21_C2_REG *)0x40001C24))
// model

/** 0x4000 1C28 CCP21_C3 **/
union CCP21_C3_REG{
	unsigned int reg;
	struct CCP21_C3_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C3 (*((volatile union CCP21_C3_REG *)0x40001C28))
// model

/** 0x4000 1C2C CCP21_C4 **/
union CCP21_C4_REG{
	unsigned int reg;
	struct CCP21_C4_BITS{
		unsigned int _CCPXCY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_C4 (*((volatile union CCP21_C4_REG *)0x40001C2C))
// model

/** 0x4000 1C30 CCP21_SRIC **/
union CCP21_SRIC_REG{
	unsigned int reg;
	struct CCP21_SRIC_BITS{
		unsigned int _CC1IC:1;
		unsigned int _CC2IC:1;
		unsigned int _CC3IC:1;
		unsigned int _CC4IC:1;
		unsigned int _TXTIC:1;
		unsigned int _TXUIC:1;
		unsigned int _TXIC:1;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_SRIC (*((volatile union CCP21_SRIC_REG *)0x40001C30))
// model

/** 0x4000 1C34 CCP21_DF **/
union CCP21_DF_REG{
	unsigned int reg;
	struct CCP21_DF_BITS{
		unsigned int _CC1DF:1;
		unsigned int _CC2DF:1;
		unsigned int _CC3DF:1;
		unsigned int _CC4DF:1;
		unsigned int _TXTDF:1;
		unsigned int _TXUDF:1;
		unsigned int :26;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_DF (*((volatile union CCP21_DF_REG *)0x40001C34))
// model

/** 0x4000 1C40 CCP21_CTL1 **/
union CCP21_CTL1_REG{
	unsigned int reg;
	struct CCP21_CTL1_BITS{
		unsigned int _CH1M:4;
		unsigned int _CH2M:4;
		unsigned int _CH3M:4;
		unsigned int _CH4M:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_CTL1 (*((volatile union CCP21_CTL1_REG *)0x40001C40))
// model

/** 0x4000 1C44 CCP21_R1 **/
union CCP21_R1_REG{
	unsigned int reg;
	struct CCP21_R1_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R1 (*((volatile union CCP21_R1_REG *)0x40001C44))
// model

/** 0x4000 1C48 CCP21_R2 **/
union CCP21_R2_REG{
	unsigned int reg;
	struct CCP21_R2_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R2 (*((volatile union CCP21_R2_REG *)0x40001C48))
// model

/** 0x4000 1C4C CCP21_R3 **/
union CCP21_R3_REG{
	unsigned int reg;
	struct CCP21_R3_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R3 (*((volatile union CCP21_R3_REG *)0x40001C4C))
// model

/** 0x4000 1C50 CCP21_R4 **/
union CCP21_R4_REG{
	unsigned int reg;
	struct CCP21_R4_BITS{
		unsigned int _CCPXRY:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_R4 (*((volatile union CCP21_R4_REG *)0x40001C50))
// model

/** 0x4000 1C54 CCP21_CTL2 **/
union CCP21_CTL2_REG{
	unsigned int reg;
	struct CCP21_CTL2_BITS{
		unsigned int _PXOC1:2;
		unsigned int _PXOC2:2;
		unsigned int _PXOC3:2;
		unsigned int _PXOC4:2;
		unsigned int _TCKSEL:2;
		unsigned int _PXASS:2;
		unsigned int _PXOC1CE:1;
		unsigned int _PXOC2CE:1;
		unsigned int _PXOC3CE:1;
		unsigned int _PXOC4CE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_CTL2 (*((volatile union CCP21_CTL2_REG *)0x40001C54))
// model

/** 0x4000 1C58 CCP21_CTL3 **/
union CCP21_CTL3_REG{
	unsigned int reg;
	struct CCP21_CTL3_BITS{
		unsigned int _CC1IE:1;
		unsigned int _CC2IE:1;
		unsigned int _CC3IE:1;
		unsigned int _CC4IE:1;
		unsigned int _TXTIE:1;
		unsigned int _TXUIE:1;
		unsigned int _TXUDE:1;
		unsigned int _CC1DE:1;
		unsigned int _CC2DE:1;
		unsigned int _CC3DE:1;
		unsigned int _CC4DE:1;
		unsigned int _TXTDE:1;
		unsigned int _PXSPM:1;
		unsigned int _PXXORM:1;
		unsigned int _PXPWMI:1;
		unsigned int _PXSPMST:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_CTL3 (*((volatile union CCP21_CTL3_REG *)0x40001C58))
// model

/** 0x4000 1C5C CCP21_EGIF **/
union CCP21_EGIF_REG{
	unsigned int reg;
	struct CCP21_EGIF_BITS{
		unsigned int _UARTRXEN:1;
		unsigned int _CC1G:1;
		unsigned int _CC2G:1;
		unsigned int _CC3G:1;
		unsigned int _CC4G:1;
		unsigned int _TXTRG:1;
		unsigned int _CC1IF:1;
		unsigned int _CC2IF:1;
		unsigned int _CC3IF:1;
		unsigned int _CC4IF:1;
		unsigned int _TXTIF:1;
		unsigned int _TXUIF:1;
		unsigned int _PXSEL:1;
		unsigned int _POSSEL:1;
		unsigned int :18;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CCP21_EGIF (*((volatile union CCP21_EGIF_REG *)0x40001C5C))
// modelUSART5

/** 0x4000 1E80 USART5_CTLR **/
union USART5_CTLR_REG{
	unsigned int reg;
	struct USART5_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLES:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_CTLR (*((volatile union USART5_CTLR_REG *)0x40001E80))
// model

/** 0x4000 1E84 USART5_BRGR **/
union USART5_BRGR_REG{
	unsigned int reg;
	struct USART5_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_BRGR (*((volatile union USART5_BRGR_REG *)0x40001E84))
// model

/** 0x4000 1E88 USART5_STR **/
union USART5_STR_REG{
	unsigned int reg;
	struct USART5_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TX1SEL:1;
		unsigned int _TX0SEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_STR (*((volatile union USART5_STR_REG *)0x40001E88))
// model

/** 0x4000 1E8C USART5_TBUFR **/
union USART5_TBUFR_REG{
	unsigned int reg;
	struct USART5_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_TBUFR (*((volatile union USART5_TBUFR_REG *)0x40001E8C))
// model

/** 0x4000 1E8C USART5_RBUFR **/
union USART5_RBUFR_REG{
	unsigned int reg;
	struct USART5_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_RBUFR (*((volatile union USART5_RBUFR_REG *)0x40001E8C))
// model

/** 0x4000 1E90 USART5_U7816R **/
union USART5_U7816R_REG{
	unsigned int reg;
	struct USART5_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int _TREPMS:1;
		unsigned int _CLKDIV:8;
		unsigned int :1;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_U7816R (*((volatile union USART5_U7816R_REG *)0x40001E90))
// model

/** 0x4000 1E94 USART5_IER **/
union USART5_IER_REG{
	unsigned int reg;
	struct USART5_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_IER (*((volatile union USART5_IER_REG *)0x40001E94))
// model

/** 0x4000 1E98 USART5_ADM **/
union USART5_ADM_REG{
	unsigned int reg;
	struct USART5_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART5_ADM (*((volatile union USART5_ADM_REG *)0x40001E98))
// modelUSART7

/** 0x4000 1F80 USART7_CTLR **/
union USART7_CTLR_REG{
	unsigned int reg;
	struct USART7_CTLR_BITS{
		unsigned int _USARTEN:1;
		unsigned int _BRCKS:2;
		unsigned int _SCKPS:1;
		unsigned int _TCONV:1;
		unsigned int _RCONV:1;
		unsigned int _DINV:1;
		unsigned int _WUEN:1;
		unsigned int _CSRS:1;
		unsigned int _ADREN:1;
		unsigned int :1;
		unsigned int _ABRDEN:1;
		unsigned int _RIDLES:1;
		unsigned int _SENDB:1;
		unsigned int _SYNC:1;
		unsigned int _TXEN:1;
		unsigned int _RXEN:1;
		unsigned int _TIDLEEN:1;
		unsigned int _STPW:1;
		unsigned int _TX9SEL:1;
		unsigned int _PARM:1;
		unsigned int _DT9EN:1;
		unsigned int _TRGSEL:2;
		unsigned int _CTSE:1;
		unsigned int _RTSE:1;
		unsigned int _BKPWS:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _IRDAEN:1;
		unsigned int _RESHD:1;
		unsigned int _SLMEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_CTLR (*((volatile union USART7_CTLR_REG *)0x40001F80))
// model

/** 0x4000 1F84 USART7_BRGR **/
union USART7_BRGR_REG{
	unsigned int reg;
	struct USART7_BRGR_BITS{
		unsigned int _BRGM:16;
		unsigned int _BRGF1:4;
		unsigned int _BRGF2:4;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_BRGR (*((volatile union USART7_BRGR_REG *)0x40001F84))
// model

/** 0x4000 1F88 USART7_STR **/
union USART7_STR_REG{
	unsigned int reg;
	struct USART7_STR_BITS{
		unsigned int _OVFEIF:1;
		unsigned int _PAREIF:1;
		unsigned int _FREIF:1;
		unsigned int _BRIF:1;
		unsigned int _ABTOIF:1;
		unsigned int _WUIF:1;
		unsigned int _TEIF:1;
		unsigned int _REIF:1;
		unsigned int _CTSIF:1;
		unsigned int _RCFR:1;
		unsigned int _TXFR:1;
		unsigned int _RDRIF:1;
		unsigned int _TFEIF:1;
		unsigned int _TXEIF:1;
		unsigned int _UADMIF:1;
		unsigned int _IDLFIF:1;
		unsigned int _OVFEIC:1;
		unsigned int _PAREIC:1;
		unsigned int _FREIC:1;
		unsigned int _BRIC:1;
		unsigned int _ABTOIC:1;
		unsigned int _WUIC:1;
		unsigned int _TEIC:1;
		unsigned int _REIC:1;
		unsigned int _CTSIC:1;
		unsigned int _UADMIC:1;
		unsigned int _IDLEIC:1;
		unsigned int _TFEIF1:1;
		unsigned int _CTSSEL:1;
		unsigned int _RXDSEL:1;
		unsigned int _TX1SEL:1;
		unsigned int _TX0SEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_STR (*((volatile union USART7_STR_REG *)0x40001F88))
// model

/** 0x4000 1F8C USART7_TBUFR **/
union USART7_TBUFR_REG{
	unsigned int reg;
	struct USART7_TBUFR_BITS{
		unsigned int _TBUF:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_TBUFR (*((volatile union USART7_TBUFR_REG *)0x40001F8C))
// model

/** 0x4000 1F8C USART7_RBUFR **/
union USART7_RBUFR_REG{
	unsigned int reg;
	struct USART7_RBUFR_BITS{
		unsigned int _RBUF:9;
		unsigned int :23;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_RBUFR (*((volatile union USART7_RBUFR_REG *)0x40001F8C))
// model

/** 0x4000 1F90 USART7_U7816R **/
union USART7_U7816R_REG{
	unsigned int reg;
	struct USART7_U7816R_BITS{
		unsigned int _7816EN:1;
		unsigned int _CLKOUT:1;
		unsigned int _ERSW:2;
		unsigned int _PSEL:1;
		unsigned int _BGTEN:1;
		unsigned int :2;
		unsigned int _TREPEN:1;
		unsigned int _RREPEN:1;
		unsigned int _TXRE:2;
		unsigned int _RXRE:2;
		unsigned int _TREPMS:1;
		unsigned int _CLKDIV:8;
		unsigned int :1;
		unsigned int _EGT:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_U7816R (*((volatile union USART7_U7816R_REG *)0x40001F90))
// model

/** 0x4000 1F94 USART7_IER **/
union USART7_IER_REG{
	unsigned int reg;
	struct USART7_IER_BITS{
		unsigned int _OVFEIE:1;
		unsigned int _PAREIE:1;
		unsigned int _FREIE:1;
		unsigned int _BRIE:1;
		unsigned int _ABTOIE:1;
		unsigned int _WUIE:1;
		unsigned int _TEIE:1;
		unsigned int _REIE:1;
		unsigned int _CTSIE:1;
		unsigned int _RDRIE:1;
		unsigned int _TFEIE:1;
		unsigned int _TXEIE:1;
		unsigned int _IDLEIE:1;
		unsigned int :3;
		unsigned int _URCDE:1;
		unsigned int _UTXDE:1;
		unsigned int _UADMIE:1;
		unsigned int :13;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_IER (*((volatile union USART7_IER_REG *)0x40001F94))
// model

/** 0x4000 1F98 USART7_ADM **/
union USART7_ADM_REG{
	unsigned int reg;
	struct USART7_ADM_BITS{
		unsigned int _ADM:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define USART7_ADM (*((volatile union USART7_ADM_REG *)0x40001F98))
// modelSPI2

/** 0x4000 2080 SPI2_BRGR **/
union SPI2_BRGR_REG{
	unsigned int reg;
	struct SPI2_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_BRGR (*((volatile union SPI2_BRGR_REG *)0x40002080))
// model

/** 0x4000 2084 SPI2_CTLR **/
union SPI2_CTLR_REG{
	unsigned int reg;
	struct SPI2_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int _SSEL:2;
		unsigned int _I2SMD:1;
		unsigned int :1;
		unsigned int _MCKOS:1;
		unsigned int :1;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_CTLR (*((volatile union SPI2_CTLR_REG *)0x40002084))
// model

/** 0x4000 2088 SPI2_BUFR **/
union SPI2_BUFR_REG{
	unsigned int reg;
	struct SPI2_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_BUFR (*((volatile union SPI2_BUFR_REG *)0x40002088))
// model

/** 0x4000 208C SPI2_STR **/
union SPI2_STR_REG{
	unsigned int reg;
	struct SPI2_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int :4;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int :1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI2_STR (*((volatile union SPI2_STR_REG *)0x4000208C))
// modelSPI3

/** 0x4000 2100 SPI3_BRGR **/
union SPI3_BRGR_REG{
	unsigned int reg;
	struct SPI3_BRGR_BITS{
		unsigned int _SPIBRG:16;
		unsigned int _I2SDIV:8;
		unsigned int _MCKEN:1;
		unsigned int _I2SODD:1;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_BRGR (*((volatile union SPI3_BRGR_REG *)0x40002100))
// model

/** 0x4000 2104 SPI3_CTLR **/
union SPI3_CTLR_REG{
	unsigned int reg;
	struct SPI3_CTLR_BITS{
		unsigned int _SPIEN:1;
		unsigned int _SPIMS:3;
		unsigned int _SPICKS:2;
		unsigned int _SPIDS:1;
		unsigned int _SPIIOS:1;
		unsigned int _SPICKP:1;
		unsigned int _SPICKE:1;
		unsigned int :2;
		unsigned int _SPIBS:2;
		unsigned int _SSEL:2;
		unsigned int _I2SMD:1;
		unsigned int :1;
		unsigned int _MCKOS:1;
		unsigned int :1;
		unsigned int _I2SMC:2;
		unsigned int _I2SSS:2;
		unsigned int _PCMS:1;
		unsigned int _I2SCKS:2;
		unsigned int _PCMCKP:1;
		unsigned int :4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_CTLR (*((volatile union SPI3_CTLR_REG *)0x40002104))
// model

/** 0x4000 2108 SPI3_BUFR **/
union SPI3_BUFR_REG{
	unsigned int reg;
	struct SPI3_BUFR_BITS{
		unsigned int _SPIBUF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_BUFR (*((volatile union SPI3_BUFR_REG *)0x40002108))
// model

/** 0x4000 210C SPI3_STR **/
union SPI3_STR_REG{
	unsigned int reg;
	struct SPI3_STR_BITS{
		unsigned int _SPIBUSY:1;
		unsigned int _RNE:1;
		unsigned int _TNE:1;
		unsigned int _CHSIDE:1;
		unsigned int _ROVFIF:1;
		unsigned int _TOVFIF:1;
		unsigned int _UDRIF:1;
		unsigned int :4;
		unsigned int _UDRIE:1;
		unsigned int _ROVFIE:1;
		unsigned int _TOVFIE:1;
		unsigned int _RNEIE:1;
		unsigned int _TNEIE:1;
		unsigned int _ROVFIC:1;
		unsigned int _TOVFIC:1;
		unsigned int _UDRIC:1;
		unsigned int :1;
		unsigned int _SRCDE:1;
		unsigned int _STXDE:1;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SPI3_STR (*((volatile union SPI3_STR_REG *)0x4000210C))
// modelI2C3

/** 0x4000 2380 I2C3_CTLR **/
union I2C3_CTLR_REG{
	unsigned int reg;
	struct I2C3_CTLR_BITS{
		unsigned int _I2CEN:1;
		unsigned int _BADR10:1;
		unsigned int :2;
		unsigned int _DHCNT:4;
		unsigned int _SEN:1;
		unsigned int :1;
		unsigned int _PEN:1;
		unsigned int _SCLNOSTR:1;
		unsigned int _ACKEN:1;
		unsigned int _ACKDT:1;
		unsigned int _GCEN:1;
		unsigned int _A10MSKEN:1;
		unsigned int _I2CCKS:2;
		unsigned int _I2CCKDIV:2;
		unsigned int _MTHALL:1;
		unsigned int _ENASCL:1;
		unsigned int _NMENA:1;
		unsigned int :1;
		unsigned int _SMBUS:1;
		unsigned int _SMBT:1;
		unsigned int _ARPEN:1;
		unsigned int _ALERT:1;
		unsigned int :3;
		unsigned int _ADRL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_CTLR (*((volatile union I2C3_CTLR_REG *)0x40002380))
// model

/** 0x4000 2384 I2C3_SR **/
union I2C3_SR_REG{
	unsigned int reg;
	struct I2C3_SR_BITS{
		unsigned int _SIF:1;
		unsigned int _PIF:1;
		unsigned int _ADDR:1;
		unsigned int _ADD10:1;
		unsigned int _DATA:1;
		unsigned int _AFIF:1;
		unsigned int _ARBLIF:1;
		unsigned int _RNW:1;
		unsigned int _SMBAIF:1;
		unsigned int _SMBHIF:1;
		unsigned int _SMBDIF:1;
		unsigned int _ISIF:1;
		unsigned int _RCBF:1;
		unsigned int _TXBE:1;
		unsigned int :2;
		unsigned int _IRCDF:1;
		unsigned int _ITXDF:1;
		unsigned int _BERRIF:1;
		unsigned int _OVERIF:1;
		unsigned int _BUSY:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_SR (*((volatile union I2C3_SR_REG *)0x40002384))
// model

/** 0x4000 2388 I2C3_BUFR **/
union I2C3_BUFR_REG{
	unsigned int reg;
	struct I2C3_BUFR_BITS{
		unsigned int _I2CBUF:10;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_BUFR (*((volatile union I2C3_BUFR_REG *)0x40002388))
// model

/** 0x4000 238C I2C3_ADDR0 **/
union I2C3_ADDR0_REG{
	unsigned int reg;
	struct I2C3_ADDR0_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR0 (*((volatile union I2C3_ADDR0_REG *)0x4000238C))
// model

/** 0x4000 2390 I2C3_BRGR **/
union I2C3_BRGR_REG{
	unsigned int reg;
	struct I2C3_BRGR_BITS{
		unsigned int _I2CBRGH:16;
		unsigned int _I2CBRGL:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_BRGR (*((volatile union I2C3_BRGR_REG *)0x40002390))
// model

/** 0x4000 2394 I2C3_ADDR1 **/
union I2C3_ADDR1_REG{
	unsigned int reg;
	struct I2C3_ADDR1_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR1 (*((volatile union I2C3_ADDR1_REG *)0x40002394))
// model

/** 0x4000 2398 I2C3_ADDR2 **/
union I2C3_ADDR2_REG{
	unsigned int reg;
	struct I2C3_ADDR2_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR2 (*((volatile union I2C3_ADDR2_REG *)0x40002398))
// model

/** 0x4000 239C I2C3_ADDR3 **/
union I2C3_ADDR3_REG{
	unsigned int reg;
	struct I2C3_ADDR3_BITS{
		unsigned int _I2CADD:10;
		unsigned int :6;
		unsigned int _I2CMSK:10;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_ADDR3 (*((volatile union I2C3_ADDR3_REG *)0x4000239C))
// model

/** 0x4000 23A0 I2C3_IER **/
union I2C3_IER_REG{
	unsigned int reg;
	struct I2C3_IER_BITS{
		unsigned int _SIE:1;
		unsigned int _PIE:1;
		unsigned int :3;
		unsigned int _AFIE:1;
		unsigned int _ARBLIE:1;
		unsigned int :1;
		unsigned int _SMBAIE:1;
		unsigned int _SMBHIE:1;
		unsigned int _SMBDIE:1;
		unsigned int _ISIE:1;
		unsigned int :4;
		unsigned int _IRCDE:1;
		unsigned int _ITXDE:1;
		unsigned int _BERRIE:1;
		unsigned int _OVERIE:1;
		unsigned int :12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define I2C3_IER (*((volatile union I2C3_IER_REG *)0x400023A0))
// modelPLL

/** 0x4000 2580 PLL_CTL **/
union PLL_CTL_REG{
	unsigned int reg;
	struct PLL_CTL_BITS{
		unsigned int _PDRST:1;
		unsigned int :1;
		unsigned int _M:14;
		unsigned int _N:4;
		unsigned int _OD:2;
		unsigned int :9;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PLL_CTL (*((volatile union PLL_CTL_REG *)0x40002580))
// modelPCLK

/** 0x4000 2640 PCLK_CTL0 **/
union PCLK_CTL0_REG{
	unsigned int reg;
	struct PCLK_CTL0_BITS{
		unsigned int _GPIOACLKEN:1;
		unsigned int _GPIOBCLKEN:1;
		unsigned int _GPIOCCLKEN:1;
		unsigned int _GPIODCLKEN:1;
		unsigned int _GPIOECLKEN:1;
		unsigned int _GPIOFCLKEN:1;
		unsigned int _GPIOGCLKEN:1;
		unsigned int _GPIOHCLKEN:1;
		unsigned int :23;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL0 (*((volatile union PCLK_CTL0_REG *)0x40002640))
// model

/** 0x4000 2644 PCLK_CTL1 **/
union PCLK_CTL1_REG{
	unsigned int reg;
	struct PCLK_CTL1_BITS{
		unsigned int :1;
		unsigned int _QEI1CLKEN:1;
		unsigned int _T1CLKEN:1;
		unsigned int _T2CLKEN:1;
		unsigned int _T3CLKEN:1;
		unsigned int _T4CLKEN:1;
		unsigned int _T5T6CLKEN:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _QEI0CLKEN:1;
		unsigned int _ADC0CLKEN:1;
		unsigned int _ADC1CLKEN:1;
		unsigned int _ADC2CLKEN:1;
		unsigned int _DAC0CLKEN:1;
		unsigned int _DAC1CLKEN:1;
		unsigned int _CMPCLKEN:1;
		unsigned int _T0CLKEN:1;
		unsigned int :1;
		unsigned int _USART0CLKEN:1;
		unsigned int _USART1CLKEN:1;
		unsigned int _USART2CLKEN:1;
		unsigned int :1;
		unsigned int _USART4CLKEN:1;
		unsigned int _SPI0CLKEN:1;
		unsigned int _SPI1CLKEN:1;
		unsigned int _I2C0CLKEN:1;
		unsigned int _I2C1CLKEN:1;
		unsigned int _I2C2CLKEN:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL1 (*((volatile union PCLK_CTL1_REG *)0x40002644))
// model

/** 0x4000 2648 PCLK_CTL2 **/
union PCLK_CTL2_REG{
	unsigned int reg;
	struct PCLK_CTL2_BITS{
		unsigned int :4;
		unsigned int :1;
		unsigned int _WWDTCLKEN:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _EPWM11CLKEN:1;
		unsigned int _EPWM12CLKEN:1;
		unsigned int _EPWM13CLKEN:1;
		unsigned int _EPWM16CLKEN:1;
		unsigned int _DMA0CLKEN:1;
		unsigned int :1;
		unsigned int _DMA1CLKEN:1;
		unsigned int :1;
		unsigned int _T14CLKEN:1;
		unsigned int :3;
		unsigned int :1;
		unsigned int _T18CLKEN:1;
		unsigned int _T19CLKEN:1;
		unsigned int :1;
		unsigned int _T21CLKEN:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _DAC2CLKEN:1;
		unsigned int _DAC3CLKEN:1;
		unsigned int _USART5CLKEN:1;
		unsigned int :1;
		unsigned int _USART7CLKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL2 (*((volatile union PCLK_CTL2_REG *)0x40002648))
// model

/** 0x4000 264C PCLK_CTL3 **/
union PCLK_CTL3_REG{
	unsigned int reg;
	struct PCLK_CTL3_BITS{
		unsigned int :1;
		unsigned int _SPI2CLKEN:1;
		unsigned int _SPI3CLKEN:1;
		unsigned int :3;
		unsigned int :1;
		unsigned int _I2C3CLKEN:1;
		unsigned int _HRCAP0CLKEN:1;
		unsigned int _HRCAP1CLKEN:1;
		unsigned int _HRCAP2CLKEN:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _CRCCLKEN:1;
		unsigned int _AESCLKEN:1;
		unsigned int :1;
		unsigned int _EXICCLKEN:1;
		unsigned int _CAN4CLKEN:1;
		unsigned int :1;
		unsigned int _CFGLCLKEN:1;
		unsigned int _OPCLKEN:1;
		unsigned int _FLEXMUXCLKEN:1;
		unsigned int _FDC0CLKEN:1;
		unsigned int _FDC1CLKEN:1;
		unsigned int _FDC2CLKEN:1;
		unsigned int _FLEXRMCLKEN:1;
		unsigned int _ECFLGPCLKEN:1;
		unsigned int _EWDTCLKEN:1;
		unsigned int _RNGCLKEN:1;
		unsigned int _CANFD6CLKEN:1;
		unsigned int _CANFD7CLKEN:1;
		unsigned int _RTCCLKEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define PCLK_CTL3 (*((volatile union PCLK_CTL3_REG *)0x4000264C))
// modelCRC

/** 0X4000 2680 CRC_CTL **/
union CRC_CTL_REG{
	unsigned int reg;
	struct CRC_CTL_BITS{
		unsigned int _RSET:1;
		unsigned int :1;
		unsigned int _DATASIZE:2;
		unsigned int :1;
		unsigned int _DATAREV:1;
		unsigned int :1;
		unsigned int _RSLTREV:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_CTL (*((volatile union CRC_CTL_REG *)0x40002680))
// model

/** 0X4000 2684 CRC_DATA **/
union CRC_DATA_REG{
	unsigned int reg;
	struct CRC_DATA_BITS{
		unsigned int _CRCDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_DATA (*((volatile union CRC_DATA_REG *)0x40002684))
// model

/** 0X4000 2688 CRC_RSLT **/
union CRC_RSLT_REG{
	unsigned int reg;
	struct CRC_RSLT_BITS{
		unsigned int _CRCRSLT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_RSLT (*((volatile union CRC_RSLT_REG *)0x40002688))
// model

/** 0X4000 268C CRC_INIT **/
union CRC_INIT_REG{
	unsigned int reg;
	struct CRC_INIT_BITS{
		unsigned int _CRCINIT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_INIT (*((volatile union CRC_INIT_REG *)0x4000268C))
// model

/** 0X4000 2690 CRC_PLN **/
union CRC_PLN_REG{
	unsigned int reg;
	struct CRC_PLN_BITS{
		unsigned int _CRCPLN:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_PLN (*((volatile union CRC_PLN_REG *)0x40002690))
// model

/** 0X4000 2694 CRC_RXOR **/
union CRC_RXOR_REG{
	unsigned int reg;
	struct CRC_RXOR_BITS{
		unsigned int _CRCRXOR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_RXOR (*((volatile union CRC_RXOR_REG *)0x40002694))
// model

/** 0X4000 2698 CRC_IDATA **/
union CRC_IDATA_REG{
	unsigned int reg;
	struct CRC_IDATA_BITS{
		unsigned int _CRCIDATA:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_IDATA (*((volatile union CRC_IDATA_REG *)0x40002698))
// model

/** 0X4000 269C CRC_TEMP **/
union CRC_TEMP_REG{
	unsigned int reg;
	struct CRC_TEMP_BITS{
		unsigned int _CRCTEMP:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CRC_TEMP (*((volatile union CRC_TEMP_REG *)0x4000269C))
// modelAES

/** 0x4000 2700 AES_CTL **/
union AES_CTL_REG{
	unsigned int reg;
	struct AES_CTL_BITS{
		unsigned int _AESEN:1;
		unsigned int _AESLIKE:1;
		unsigned int _ENCRYPT:1;
		unsigned int _SB0XINV:1;
		unsigned int _KEYLEN:3;
		unsigned int :1;
		unsigned int _RNDNUM:5;
		unsigned int _DIV:3;
		unsigned int _CKS:2;
		unsigned int :2;
		unsigned int _CBCEN:1;
		unsigned int :9;
		unsigned int _HSMODE:1;
		unsigned int _AESRUN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_CTL (*((volatile union AES_CTL_REG *)0x40002700))
// model

/** 0X4000 2704 AES_INT **/
union AES_INT_REG{
	unsigned int reg;
	struct AES_INT_BITS{
		unsigned int _AESFIE:1;
		unsigned int _AESFIC:1;
		unsigned int _AESFIF:1;
		unsigned int :29;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INT (*((volatile union AES_INT_REG *)0x40002704))
// model

/** 0X4000 2710 AES_INPUT0 **/
union AES_INPUT0_REG{
	unsigned int reg;
	struct AES_INPUT0_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT0 (*((volatile union AES_INPUT0_REG *)0x40002710))
// model

/** 0X4000 2714 AES_INPUT1 **/
union AES_INPUT1_REG{
	unsigned int reg;
	struct AES_INPUT1_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT1 (*((volatile union AES_INPUT1_REG *)0x40002714))
// model

/** 0X4000 2718 AES_INPUT2 **/
union AES_INPUT2_REG{
	unsigned int reg;
	struct AES_INPUT2_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT2 (*((volatile union AES_INPUT2_REG *)0x40002718))
// model

/** 0X4000 271C AES_INPUT3 **/
union AES_INPUT3_REG{
	unsigned int reg;
	struct AES_INPUT3_BITS{
		unsigned int _AESINPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_INPUT3 (*((volatile union AES_INPUT3_REG *)0x4000271C))
// model

/** 0X4000 2720 AES_OUTPUT0 **/
union AES_OUTPUT0_REG{
	unsigned int reg;
	struct AES_OUTPUT0_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT0 (*((volatile union AES_OUTPUT0_REG *)0x40002720))
// model

/** 0X4000 2724 AES_OUTPUT1 **/
union AES_OUTPUT1_REG{
	unsigned int reg;
	struct AES_OUTPUT1_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT1 (*((volatile union AES_OUTPUT1_REG *)0x40002724))
// model

/** 0X4000 2728 AES_OUTPUT2 **/
union AES_OUTPUT2_REG{
	unsigned int reg;
	struct AES_OUTPUT2_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT2 (*((volatile union AES_OUTPUT2_REG *)0x40002728))
// model

/** 0X4000 272C AES_OUTPUT3 **/
union AES_OUTPUT3_REG{
	unsigned int reg;
	struct AES_OUTPUT3_BITS{
		unsigned int _AESOUTPUT:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define AES_OUTPUT3 (*((volatile union AES_OUTPUT3_REG *)0x4000272C))
// modelEXIC

/** 0X4000 2800 EXIC_CTL0 **/
union EXIC_CTL0_REG{
	unsigned int reg;
	struct EXIC_CTL0_BITS{
		unsigned int _EXICEN:1;
		unsigned int _CSEN:1;
		unsigned int _DCSEL:1;
		unsigned int _WRITEEN:1;
		unsigned int _READEN:1;
		unsigned int :3;
		unsigned int _TDMAEN:1;
		unsigned int _RDMAEN:1;
		unsigned int :6;
		unsigned int _WENDEN:1;
		unsigned int _RENDIE:1;
		unsigned int :10;
		unsigned int _WRITE1EN:1;
		unsigned int _READ1EN:1;
		unsigned int _DATATR:1;
		unsigned int _MODESEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EXIC_CTL0 (*((volatile union EXIC_CTL0_REG *)0x40002800))
// model

/** 0X4000 2804 EXIC_CTL1 **/
union EXIC_CTL1_REG{
	unsigned int reg;
	struct EXIC_CTL1_BITS{
		unsigned int _EXICCS:2;
		unsigned int :2;
		unsigned int _PULSEWIDTH:4;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EXIC_CTL1 (*((volatile union EXIC_CTL1_REG *)0x40002804))
// model

/** 0X4000 2808 EXIC_STATE **/
union EXIC_STATE_REG{
	unsigned int reg;
	struct EXIC_STATE_BITS{
		unsigned int _WENDIF:1;
		unsigned int _RENDIF:1;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EXIC_STATE (*((volatile union EXIC_STATE_REG *)0x40002808))
// model

/** 0X4000 2810 EXIC_WRITEBUF **/
union EXIC_WRITEBUF_REG{
	unsigned int reg;
	struct EXIC_WRITEBUF_BITS{
		unsigned int _WRITEBUF:18;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EXIC_WRITEBUF (*((volatile union EXIC_WRITEBUF_REG *)0x40002810))
// model

/** 0X4000 2814 EXIC_READBUF **/
union EXIC_READBUF_REG{
	unsigned int reg;
	struct EXIC_READBUF_BITS{
		unsigned int _READBUF:18;
		unsigned int :14;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EXIC_READBUF (*((volatile union EXIC_READBUF_REG *)0x40002814))
// modelCAN4

/** 0x4000 2880 CAN4_CTLR **/
union CAN4_CTLR_REG{
	unsigned int reg;
	struct CAN4_CTLR_BITS{
		unsigned int _RSMOD:1;
		unsigned int _SILENT:1;
		unsigned int _LBACK:1;
		unsigned int _SLEEP:1;
		unsigned int _FILTEREXT:1;
		unsigned int _CANCKS:2;
		unsigned int _CANEN:1;
		unsigned int _TXR:1;
		unsigned int _ATX:1;
		unsigned int _RELRX:1;
		unsigned int _RELF:1;
		unsigned int _LBSEL:1;
		unsigned int _BOFFREC:1;
		unsigned int _CKMODE:1;
		unsigned int _RELRXALL:1;
		unsigned int _RXBSTA:1;
		unsigned int _DOSTA:1;
		unsigned int _TXBSTA:1;
		unsigned int _TCSTA:1;
		unsigned int _RXSTA:1;
		unsigned int _TXSTA:1;
		unsigned int _CERROR:1;
		unsigned int _BOFF:1;
		unsigned int _CANRMC:7;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_CTLR (*((volatile union CAN4_CTLR_REG *)0x40002880))
// model

/** 0x4000 2884 CAN4_BRGR **/
union CAN4_BRGR_REG{
	unsigned int reg;
	struct CAN4_BRGR_BITS{
		unsigned int _CANBRP:6;
		unsigned int _SJW:2;
		unsigned int _TSEG1:4;
		unsigned int _TSEG2:3;
		unsigned int _SAM:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_BRGR (*((volatile union CAN4_BRGR_REG *)0x40002884))
// model

/** 0x4000 2888 CAN4_RCR **/
union CAN4_RCR_REG{
	unsigned int reg;
	struct CAN4_RCR_BITS{
		unsigned int _CANALC:5;
		unsigned int :3;
		unsigned int _CANSEG:5;
		unsigned int _CANDIR:1;
		unsigned int _CANERRC:2;
		unsigned int _RAMMB:6;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_RCR (*((volatile union CAN4_RCR_REG *)0x40002888))
// model

/** 0x4000 288C CAN4_EROR **/
union CAN4_EROR_REG{
	unsigned int reg;
	struct CAN4_EROR_BITS{
		unsigned int _CANRXE:8;
		unsigned int _CANTXE:8;
		unsigned int _CANEWL:8;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_EROR (*((volatile union CAN4_EROR_REG *)0x4000288C))
// model

/** 0x4000 2890 CAN4_ACRR **/
union CAN4_ACRR_REG{
	unsigned int reg;
	struct CAN4_ACRR_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_ACRR (*((volatile union CAN4_ACRR_REG *)0x40002890))
// model

/** 0x4000 2894 CAN4_MSKR **/
union CAN4_MSKR_REG{
	unsigned int reg;
	struct CAN4_MSKR_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_MSKR (*((volatile union CAN4_MSKR_REG *)0x40002894))
// model

/** 0x4000 2898 CAN4_IER **/
union CAN4_IER_REG{
	unsigned int reg;
	struct CAN4_IER_BITS{
		unsigned int _CANRXIE:1;
		unsigned int _CANTXIE:1;
		unsigned int _EAIE:1;
		unsigned int _DOVFIE:1;
		unsigned int _WUIE:1;
		unsigned int _ENIE:1;
		unsigned int _ALIE:1;
		unsigned int _BEIE:1;
		unsigned int _CANTXDE:1;
		unsigned int _CANRXDE:1;
		unsigned int _CANRFIE:1;
		unsigned int :1;
		unsigned int _BOFFIE:1;
		unsigned int :3;
		unsigned int _CANRFIC:1;
		unsigned int _CANTXIC:1;
		unsigned int _EAIC:1;
		unsigned int _DOVFIC:1;
		unsigned int _WUIC:1;
		unsigned int _ENIC:1;
		unsigned int _ALIC:1;
		unsigned int _BEIC:1;
		unsigned int :4;
		unsigned int _BOFFIC:1;
		unsigned int :3;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_IER (*((volatile union CAN4_IER_REG *)0x40002898))
// model

/** 0x4000 289C CAN4_IFR **/
union CAN4_IFR_REG{
	unsigned int reg;
	struct CAN4_IFR_BITS{
		unsigned int _CANRXIF:1;
		unsigned int _CANTXIF:1;
		unsigned int _EAIF:1;
		unsigned int _DOVFIF:1;
		unsigned int _WUIF:1;
		unsigned int _ENIF:1;
		unsigned int _ALIF:1;
		unsigned int _BEIF:1;
		unsigned int _CANTXDF:1;
		unsigned int _CANRXDF:1;
		unsigned int _CANRFIF:1;
		unsigned int :1;
		unsigned int _BOFFIF:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_IFR (*((volatile union CAN4_IFR_REG *)0x4000289C))
// model

/** 0x4000 28A0 CAN4_INFR **/
union CAN4_INFR_REG{
	unsigned int reg;
	struct CAN4_INFR_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_INFR (*((volatile union CAN4_INFR_REG *)0x400028A0))
// model

/** 0x4000 28A4 CAN4_TX0R **/
union CAN4_TX0R_REG{
	unsigned int reg;
	struct CAN4_TX0R_BITS{
		unsigned int _CANTX0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_TX0R (*((volatile union CAN4_TX0R_REG *)0x400028A4))
// model

/** 0x4000 28A8 CAN4_TX1R **/
union CAN4_TX1R_REG{
	unsigned int reg;
	struct CAN4_TX1R_BITS{
		unsigned int _CANTX1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_TX1R (*((volatile union CAN4_TX1R_REG *)0x400028A8))
// model

/** 0x4000 28AC CAN4_TX2R **/
union CAN4_TX2R_REG{
	unsigned int reg;
	struct CAN4_TX2R_BITS{
		unsigned int _CANTX2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_TX2R (*((volatile union CAN4_TX2R_REG *)0x400028AC))
// model

/** 0x4000 28B0 CAN4_RXDATA0 **/
union CAN4_RXDATA0_REG{
	unsigned int reg;
	struct CAN4_RXDATA0_BITS{
		unsigned int _DLC:4;
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _IDE:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_RXDATA0 (*((volatile union CAN4_RXDATA0_REG *)0x400028B0))
// model

/** 0x4000 28B4 CAN4_RXDATA1 **/
union CAN4_RXDATA1_REG{
	unsigned int reg;
	struct CAN4_RXDATA1_BITS{
		unsigned int :2;
		unsigned int _RTR:1;
		unsigned int _ID0:1;
		unsigned int _ID1:1;
		unsigned int _ID2:1;
		unsigned int _ID3:1;
		unsigned int _ID4:1;
		unsigned int _ID5:1;
		unsigned int _ID6:1;
		unsigned int _ID7:1;
		unsigned int _ID8:1;
		unsigned int _ID9:1;
		unsigned int _ID10:1;
		unsigned int _ID11:1;
		unsigned int _ID12:1;
		unsigned int _ID13:1;
		unsigned int _ID14:1;
		unsigned int _ID15:1;
		unsigned int _ID16:1;
		unsigned int _ID17:1;
		unsigned int _ID18:1;
		unsigned int _ID19:1;
		unsigned int _ID20:1;
		unsigned int _ID21:1;
		unsigned int _ID22:1;
		unsigned int _ID23:1;
		unsigned int _ID24:1;
		unsigned int _ID25:1;
		unsigned int _ID26:1;
		unsigned int _ID27:1;
		unsigned int _ID28:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_RXDATA1 (*((volatile union CAN4_RXDATA1_REG *)0x400028B4))
// model

/** 0x4000 28B8 CAN4_RXDATA2 **/
union CAN4_RXDATA2_REG{
	unsigned int reg;
	struct CAN4_RXDATA2_BITS{
		unsigned int :7;
		unsigned int _CANRXDT3:1;
		unsigned int :7;
		unsigned int _CANRXDT2:1;
		unsigned int :7;
		unsigned int _CANRXDT1:1;
		unsigned int :7;
		unsigned int _CANRXDT0:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_RXDATA2 (*((volatile union CAN4_RXDATA2_REG *)0x400028B8))
// model

/** 0x4000 28BC CAN4_RXDATA3 **/
union CAN4_RXDATA3_REG{
	unsigned int reg;
	struct CAN4_RXDATA3_BITS{
		unsigned int :7;
		unsigned int _CANRXDT7:1;
		unsigned int :7;
		unsigned int _CANRXDT6:1;
		unsigned int :7;
		unsigned int _CANRXDT5:1;
		unsigned int :7;
		unsigned int _CANRXDT4:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_RXDATA3 (*((volatile union CAN4_RXDATA3_REG *)0x400028BC))
// model

/** 0x4000 2900 CAN4_ACR1R **/
union CAN4_ACR1R_REG{
	unsigned int reg;
	struct CAN4_ACR1R_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_ACR1R (*((volatile union CAN4_ACR1R_REG *)0x40002900))
// model

/** 0x4000 2904 CAN4_MSK1R **/
union CAN4_MSK1R_REG{
	unsigned int reg;
	struct CAN4_MSK1R_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_MSK1R (*((volatile union CAN4_MSK1R_REG *)0x40002904))
// model

/** 0x4000 2908 CAN4_ACR2R **/
union CAN4_ACR2R_REG{
	unsigned int reg;
	struct CAN4_ACR2R_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_ACR2R (*((volatile union CAN4_ACR2R_REG *)0x40002908))
// model

/** 0x4000 290C CAN4_MSK2R **/
union CAN4_MSK2R_REG{
	unsigned int reg;
	struct CAN4_MSK2R_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_MSK2R (*((volatile union CAN4_MSK2R_REG *)0x4000290C))
// model

/** 0x4000 2910 CAN4_ACR3R **/
union CAN4_ACR3R_REG{
	unsigned int reg;
	struct CAN4_ACR3R_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_ACR3R (*((volatile union CAN4_ACR3R_REG *)0x40002910))
// model

/** 0x4000 2914 CAN4_MSK3R **/
union CAN4_MSK3R_REG{
	unsigned int reg;
	struct CAN4_MSK3R_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_MSK3R (*((volatile union CAN4_MSK3R_REG *)0x40002914))
// model

/** 0x4000 2918 CAN4_ACR4R **/
union CAN4_ACR4R_REG{
	unsigned int reg;
	struct CAN4_ACR4R_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_ACR4R (*((volatile union CAN4_ACR4R_REG *)0x40002918))
// model

/** 0x4000 291C CAN4_MSK4R **/
union CAN4_MSK4R_REG{
	unsigned int reg;
	struct CAN4_MSK4R_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_MSK4R (*((volatile union CAN4_MSK4R_REG *)0x4000291C))
// model

/** 0x4000 2920 CAN4_ACR5R **/
union CAN4_ACR5R_REG{
	unsigned int reg;
	struct CAN4_ACR5R_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_ACR5R (*((volatile union CAN4_ACR5R_REG *)0x40002920))
// model

/** 0x4000 2924 CAN4_MSK5R **/
union CAN4_MSK5R_REG{
	unsigned int reg;
	struct CAN4_MSK5R_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_MSK5R (*((volatile union CAN4_MSK5R_REG *)0x40002924))
// model

/** 0x4000 2928 CAN4_ACR6R **/
union CAN4_ACR6R_REG{
	unsigned int reg;
	struct CAN4_ACR6R_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_ACR6R (*((volatile union CAN4_ACR6R_REG *)0x40002928))
// model

/** 0x4000 292C CAN4_MSK6R **/
union CAN4_MSK6R_REG{
	unsigned int reg;
	struct CAN4_MSK6R_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_MSK6R (*((volatile union CAN4_MSK6R_REG *)0x4000292C))
// model

/** 0x4000 2930 CAN4_ACR7R **/
union CAN4_ACR7R_REG{
	unsigned int reg;
	struct CAN4_ACR7R_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_ACR7R (*((volatile union CAN4_ACR7R_REG *)0x40002930))
// model

/** 0x4000 2934 CAN4_MSK7R **/
union CAN4_MSK7R_REG{
	unsigned int reg;
	struct CAN4_MSK7R_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_MSK7R (*((volatile union CAN4_MSK7R_REG *)0x40002934))
// model

/** 0x4000 2938 CAN4_ACR8R **/
union CAN4_ACR8R_REG{
	unsigned int reg;
	struct CAN4_ACR8R_BITS{
		unsigned int _ACR:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_ACR8R (*((volatile union CAN4_ACR8R_REG *)0x40002938))
// model

/** 0x4000 293C CAN4_MSK8R **/
union CAN4_MSK8R_REG{
	unsigned int reg;
	struct CAN4_MSK8R_BITS{
		unsigned int _MSK:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CAN4_MSK8R (*((volatile union CAN4_MSK8R_REG *)0x4000293C))
// modelCFGL

/** 0x4000 2980 CFGL1_CTL0 **/
union CFGL1_CTL0_REG{
	unsigned int reg;
	struct CFGL1_CTL0_BITS{
		unsigned int _TPSEL:3;
		unsigned int _REGIN:1;
		unsigned int _D1S:3;
		unsigned int :1;
		unsigned int _D2S:3;
		unsigned int :1;
		unsigned int _D3S:3;
		unsigned int :1;
		unsigned int _D4S:3;
		unsigned int :1;
		unsigned int _G1POL:1;
		unsigned int _G2POL:1;
		unsigned int _G3POL:1;
		unsigned int _G4POL:1;
		unsigned int _POL:1;
		unsigned int _MD:3;
		unsigned int _INTN:1;
		unsigned int _INTP:1;
		unsigned int _OE:1;
		unsigned int _EN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CFGL1_CTL0 (*((volatile union CFGL1_CTL0_REG *)0x40002980))
// model

/** 0x4000 2984 CFGL1_CTL1 **/
union CFGL1_CTL1_REG{
	unsigned int reg;
	struct CFGL1_CTL1_BITS{
		unsigned int _G1D1N:1;
		unsigned int _G1D1T:1;
		unsigned int _G1D2N:1;
		unsigned int _G1D2T:1;
		unsigned int _G1D3N:1;
		unsigned int _G1D3T:1;
		unsigned int _G1D4N:1;
		unsigned int _G1D4T:1;
		unsigned int _G2D1N:1;
		unsigned int _G2D1T:1;
		unsigned int _G2D2N:1;
		unsigned int _G2D2T:1;
		unsigned int _G2D3N:1;
		unsigned int _G2D3T:1;
		unsigned int _G2D4N:1;
		unsigned int _G2D4T:1;
		unsigned int _G3D1N:1;
		unsigned int _G3D1T:1;
		unsigned int _G3D2N:1;
		unsigned int _G3D2T:1;
		unsigned int _G3D3N:1;
		unsigned int _G3D3T:1;
		unsigned int _G3D4N:1;
		unsigned int _G3D4T:1;
		unsigned int _G4D1N:1;
		unsigned int _G4D1T:1;
		unsigned int _G4D2N:1;
		unsigned int _G4D2T:1;
		unsigned int _G4D3N:1;
		unsigned int _G4D3T:1;
		unsigned int _G4D4N:1;
		unsigned int _G4D4T:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CFGL1_CTL1 (*((volatile union CFGL1_CTL1_REG *)0x40002984))
// model

/** 0x4000 2988 CFGL2_CTL0 **/
union CFGL2_CTL0_REG{
	unsigned int reg;
	struct CFGL2_CTL0_BITS{
		unsigned int _TPSEL:3;
		unsigned int _REGIN:1;
		unsigned int _D1S:3;
		unsigned int :1;
		unsigned int _D2S:3;
		unsigned int :1;
		unsigned int _D3S:3;
		unsigned int :1;
		unsigned int _D4S:3;
		unsigned int :1;
		unsigned int _G1POL:1;
		unsigned int _G2POL:1;
		unsigned int _G3POL:1;
		unsigned int _G4POL:1;
		unsigned int _POL:1;
		unsigned int _MD:3;
		unsigned int _INTN:1;
		unsigned int _INTP:1;
		unsigned int _OE:1;
		unsigned int _EN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CFGL2_CTL0 (*((volatile union CFGL2_CTL0_REG *)0x40002988))
// model

/** 0x4000 298C CFGL2_CTL1 **/
union CFGL2_CTL1_REG{
	unsigned int reg;
	struct CFGL2_CTL1_BITS{
		unsigned int _G1D1N:1;
		unsigned int _G1D1T:1;
		unsigned int _G1D2N:1;
		unsigned int _G1D2T:1;
		unsigned int _G1D3N:1;
		unsigned int _G1D3T:1;
		unsigned int _G1D4N:1;
		unsigned int _G1D4T:1;
		unsigned int _G2D1N:1;
		unsigned int _G2D1T:1;
		unsigned int _G2D2N:1;
		unsigned int _G2D2T:1;
		unsigned int _G2D3N:1;
		unsigned int _G2D3T:1;
		unsigned int _G2D4N:1;
		unsigned int _G2D4T:1;
		unsigned int _G3D1N:1;
		unsigned int _G3D1T:1;
		unsigned int _G3D2N:1;
		unsigned int _G3D2T:1;
		unsigned int _G3D3N:1;
		unsigned int _G3D3T:1;
		unsigned int _G3D4N:1;
		unsigned int _G3D4T:1;
		unsigned int _G4D1N:1;
		unsigned int _G4D1T:1;
		unsigned int _G4D2N:1;
		unsigned int _G4D2T:1;
		unsigned int _G4D3N:1;
		unsigned int _G4D3T:1;
		unsigned int _G4D4N:1;
		unsigned int _G4D4T:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CFGL2_CTL1 (*((volatile union CFGL2_CTL1_REG *)0x4000298C))
// model

/** 0x4000 2990 CFGL_IFR **/
union CFGL_IFR_REG{
	unsigned int reg;
	struct CFGL_IFR_BITS{
		unsigned int _CFGL1OUT:1;
		unsigned int _CFGL2OUT:1;
		unsigned int _CFGL1C:1;
		unsigned int :5;
		unsigned int _CFGL1IF:1;
		unsigned int _CFGL2IF:1;
		unsigned int :18;
		unsigned int _CFGL1IE:1;
		unsigned int _CFGL2IE:1;
		unsigned int _CFGL1SYNCEN:1;
		unsigned int _CFGL2SYNCEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CFGL_IFR (*((volatile union CFGL_IFR_REG *)0x40002990))
// modelOP

/** 0x4000 2A00 OP_CTL0 **/
union OP_CTL0_REG{
	unsigned int reg;
	struct OP_CTL0_BITS{
		unsigned int _OP0EN:1;
		unsigned int _OP1EN:1;
		unsigned int _OP2EN:1;
		unsigned int _OP3EN:1;
		unsigned int _OP0OUTEN:1;
		unsigned int _OP1OUTEN:1;
		unsigned int _OP2OUTEN:1;
		unsigned int _OP3OUTEN:1;
		unsigned int _OP0GAIN2X:1;
		unsigned int _OP0GAIN4X:1;
		unsigned int _OP0GAIN8X:1;
		unsigned int _OP0GAIN16X:1;
		unsigned int _OP0GAIN32X:1;
		unsigned int _OP0GAIN64X:1;
		unsigned int _OP1GAIN2X:1;
		unsigned int _OP1GAIN4X:1;
		unsigned int _OP1GAIN8X:1;
		unsigned int _OP1GAIN16X:1;
		unsigned int _OP1GAIN32X:1;
		unsigned int _OP1GAIN64X:1;
		unsigned int _OP2GAIN2X:1;
		unsigned int _OP2GAIN4X:1;
		unsigned int _OP2GAIN8X:1;
		unsigned int _OP2GAIN16X:1;
		unsigned int _OP2GAIN32X:1;
		unsigned int _OP2GAIN64X:1;
		unsigned int _OP3GAIN2X:1;
		unsigned int _OP3GAIN4X:1;
		unsigned int _OP3GAIN8X:1;
		unsigned int _OP3GAIN16X:1;
		unsigned int _OP3GAIN32X:1;
		unsigned int _OP3GAIN64X:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OP_CTL0 (*((volatile union OP_CTL0_REG *)0x40002A00))
// model

/** 0X4000 2A04 OP_CTL1 **/
union OP_CTL1_REG{
	unsigned int reg;
	struct OP_CTL1_BITS{
		unsigned int _ENCMP3:1;
		unsigned int _ENOPVCOM:1;
		unsigned int _OPVCOMOUTEN:1;
		unsigned int _VCOMPSEL:2;
		unsigned int _ENOP0INSHORT:1;
		unsigned int _ENOP1INSHORT:1;
		unsigned int _ENOP2INSHORT:1;
		unsigned int _ENOP3INSHORT:1;
		unsigned int :7;
		unsigned int _OP0TOCU:1;
		unsigned int _OP0TOCV:1;
		unsigned int _OP0TOCW:1;
		unsigned int _OP1TOCU:1;
		unsigned int _OP1TOCV:1;
		unsigned int _OP1TOCW:1;
		unsigned int _OP2TOCU:1;
		unsigned int _OP2TOCV:1;
		unsigned int _OP2TOCW:1;
		unsigned int _OP3TOCU:1;
		unsigned int _OP3TOCV:1;
		unsigned int _OP3TOCW:1;
		unsigned int _OP010KSEL:1;
		unsigned int _OP110KSEL:1;
		unsigned int _OP210KSEL:1;
		unsigned int _OP310KSEL:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OP_CTL1 (*((volatile union OP_CTL1_REG *)0x40002A04))
// model

/** 0X4000 2A08 OP0_TRIM **/
union OP0_TRIM_REG{
	unsigned int reg;
	struct OP0_TRIM_BITS{
		unsigned int _OP0TRIMNPOL:1;
		unsigned int _OP0TRIMN:6;
		unsigned int _OP0TRIMPPOL:1;
		unsigned int _OP0TRIMP:6;
		unsigned int :10;
		unsigned int _OP0TRIMOUT:1;
		unsigned int :5;
		unsigned int _OPTRIMLOWEN:1;
		unsigned int _OPTRIMHIEN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OP0_TRIM (*((volatile union OP0_TRIM_REG *)0x40002A08))
// model

/** 0X4000 2A0C OP1_TRIM **/
union OP1_TRIM_REG{
	unsigned int reg;
	struct OP1_TRIM_BITS{
		unsigned int _OP1TRIMNPOL:1;
		unsigned int _OP1TRIMN:6;
		unsigned int _OP1TRIMPPOL:1;
		unsigned int _OP1TRIMP:6;
		unsigned int :10;
		unsigned int _OP1TRIMOUT:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OP1_TRIM (*((volatile union OP1_TRIM_REG *)0x40002A0C))
// model

/** 0X4000 2A10 OP2_TRIM **/
union OP2_TRIM_REG{
	unsigned int reg;
	struct OP2_TRIM_BITS{
		unsigned int _OP2TRIMNPOL:1;
		unsigned int _OP2TRIMN:6;
		unsigned int _OP2TRIMPPOL:1;
		unsigned int _OP2TRIMP:6;
		unsigned int :10;
		unsigned int _OP2TRIMOUT:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OP2_TRIM (*((volatile union OP2_TRIM_REG *)0x40002A10))
// model

/** 0X4000 2A14 OP3_TRIM **/
union OP3_TRIM_REG{
	unsigned int reg;
	struct OP3_TRIM_BITS{
		unsigned int _OP3TRIMNPOL:1;
		unsigned int _OP3TRIMN:6;
		unsigned int _OP3TRIMPPOL:1;
		unsigned int _OP3TRIMP:6;
		unsigned int :10;
		unsigned int _OP0TRIMOUT:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define OP3_TRIM (*((volatile union OP3_TRIM_REG *)0x40002A14))
// modelEWDT

/** 0X4000 2B00 EWDT_CTL **/
union EWDT_CTL_REG{
	unsigned int reg;
	struct EWDT_CTL_BITS{
		unsigned int _EWDTEN:1;
		unsigned int _WT40IE:1;
		unsigned int _WT40IF:1;
		unsigned int _WPS:5;
		unsigned int _WW:7;
		unsigned int _WT40IC:1;
		unsigned int _EWDTINEN:1;
		unsigned int _EWDTINPOL:1;
		unsigned int _CLKS:2;
		unsigned int :1;
		unsigned int _EWDTRSTIE:1;
		unsigned int _EWDTRSTIC:1;
		unsigned int _EWDTRSTIF:1;
		unsigned int _OUTSEL:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EWDT_CTL (*((volatile union EWDT_CTL_REG *)0x40002B00))
// model

/** 0X4000 2B04 EWDT_CNT **/
union EWDT_CNT_REG{
	unsigned int reg;
	struct EWDT_CNT_BITS{
		unsigned int _WT:7;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define EWDT_CNT (*((volatile union EWDT_CNT_REG *)0x40002B04))
// modelFDC0

/** 0X4000 2B80 FDC0_CTL **/
union FDC0_CTL_REG{
	unsigned int reg;
	struct FDC0_CTL_BITS{
		unsigned int _FDCEN:1;
		unsigned int _POEN:1;
		unsigned int _LDOK:1;
		unsigned int _CONT:1;
		unsigned int _MDLIF:1;
		unsigned int _MDLIE:1;
		unsigned int _TRGSEL:1;
		unsigned int _MULSEL:6;
		unsigned int _PRESC:3;
		unsigned int _FDCDE:1;
		unsigned int _SWTRIG:1;
		unsigned int _FDCEIE:1;
		unsigned int _LDMOD:2;
		unsigned int _BBMODE:1;
		unsigned int _CMODE:1;
		unsigned int _MDLIC:1;
		unsigned int _CLKSEL:2;
		unsigned int _TCLR:1;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CTL (*((volatile union FDC0_CTL_REG *)0x40002B80))
// model

/** 0X4000 2B84 FDC0_MOD **/
union FDC0_MOD_REG{
	unsigned int reg;
	struct FDC0_MOD_BITS{
		unsigned int _MOD:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_MOD (*((volatile union FDC0_MOD_REG *)0x40002B84))
// model

/** 0X4000 2B88 FDC0_CNT **/
union FDC0_CNT_REG{
	unsigned int reg;
	struct FDC0_CNT_BITS{
		unsigned int _CNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CNT (*((volatile union FDC0_CNT_REG *)0x40002B88))
// model

/** 0X4000 2B8C FDC0_IDLY **/
union FDC0_IDLY_REG{
	unsigned int reg;
	struct FDC0_IDLY_BITS{
		unsigned int _IDLY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_IDLY (*((volatile union FDC0_IDLY_REG *)0x40002B8C))
// model

/** 0X4000 2B90 FDC0_CH0CTL **/
union FDC0_CH0CTL_REG{
	unsigned int reg;
	struct FDC0_CH0CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH0CTL (*((volatile union FDC0_CH0CTL_REG *)0x40002B90))
// model

/** 0X4000 2B94 FDC0_CH1CTL **/
union FDC0_CH1CTL_REG{
	unsigned int reg;
	struct FDC0_CH1CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH1CTL (*((volatile union FDC0_CH1CTL_REG *)0x40002B94))
// model

/** 0X4000 2B98 FDC0_CH2CTL **/
union FDC0_CH2CTL_REG{
	unsigned int reg;
	struct FDC0_CH2CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH2CTL (*((volatile union FDC0_CH2CTL_REG *)0x40002B98))
// model

/** 0X4000 2B9C FDC0_CH3CTL **/
union FDC0_CH3CTL_REG{
	unsigned int reg;
	struct FDC0_CH3CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH3CTL (*((volatile union FDC0_CH3CTL_REG *)0x40002B9C))
// model

/** 0X4000 2BB0 FDC0_CH0DLY0 **/
union FDC0_CH0DLY0_REG{
	unsigned int reg;
	struct FDC0_CH0DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH0DLY0 (*((volatile union FDC0_CH0DLY0_REG *)0x40002BB0))
// model

/** 0X4000 2BB4 FDC0_CH0DLY1 **/
union FDC0_CH0DLY1_REG{
	unsigned int reg;
	struct FDC0_CH0DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH0DLY1 (*((volatile union FDC0_CH0DLY1_REG *)0x40002BB4))
// model

/** 0X4000 2BB8 FDC0_CH0DLY2 **/
union FDC0_CH0DLY2_REG{
	unsigned int reg;
	struct FDC0_CH0DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH0DLY2 (*((volatile union FDC0_CH0DLY2_REG *)0x40002BB8))
// model

/** 0X4000 2BC0 FDC0_CH1DLY0 **/
union FDC0_CH1DLY0_REG{
	unsigned int reg;
	struct FDC0_CH1DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH1DLY0 (*((volatile union FDC0_CH1DLY0_REG *)0x40002BC0))
// model

/** 0X4000 2BC4 FDC0_CH1DLY1 **/
union FDC0_CH1DLY1_REG{
	unsigned int reg;
	struct FDC0_CH1DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH1DLY1 (*((volatile union FDC0_CH1DLY1_REG *)0x40002BC4))
// model

/** 0X4000 2BC8 FDC0_CH1DLY2 **/
union FDC0_CH1DLY2_REG{
	unsigned int reg;
	struct FDC0_CH1DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH1DLY2 (*((volatile union FDC0_CH1DLY2_REG *)0x40002BC8))
// model

/** 0X4000 2BD0 FDC0_CH2DLY0 **/
union FDC0_CH2DLY0_REG{
	unsigned int reg;
	struct FDC0_CH2DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH2DLY0 (*((volatile union FDC0_CH2DLY0_REG *)0x40002BD0))
// model

/** 0X4000 2BD4 FDC0_CH2DLY1 **/
union FDC0_CH2DLY1_REG{
	unsigned int reg;
	struct FDC0_CH2DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH2DLY1 (*((volatile union FDC0_CH2DLY1_REG *)0x40002BD4))
// model

/** 0X4000 2BD8 FDC0_CH2DLY2 **/
union FDC0_CH2DLY2_REG{
	unsigned int reg;
	struct FDC0_CH2DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH2DLY2 (*((volatile union FDC0_CH2DLY2_REG *)0x40002BD8))
// model

/** 0X4000 2BE0 FDC0_CH3DLY0 **/
union FDC0_CH3DLY0_REG{
	unsigned int reg;
	struct FDC0_CH3DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH3DLY0 (*((volatile union FDC0_CH3DLY0_REG *)0x40002BE0))
// model

/** 0X4000 2BE4 FDC0_CH3DLY1 **/
union FDC0_CH3DLY1_REG{
	unsigned int reg;
	struct FDC0_CH3DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH3DLY1 (*((volatile union FDC0_CH3DLY1_REG *)0x40002BE4))
// model

/** 0X4000 2BE8 FDC0_CH3DLY2 **/
union FDC0_CH3DLY2_REG{
	unsigned int reg;
	struct FDC0_CH3DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_CH3DLY2 (*((volatile union FDC0_CH3DLY2_REG *)0x40002BE8))
// model

/** 0X4000 2BF0 FDC0_PO0DLY **/
union FDC0_PO0DLY_REG{
	unsigned int reg;
	struct FDC0_PO0DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_PO0DLY (*((volatile union FDC0_PO0DLY_REG *)0x40002BF0))
// model

/** 0X4000 2BF4 FDC0_PO1DLY **/
union FDC0_PO1DLY_REG{
	unsigned int reg;
	struct FDC0_PO1DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_PO1DLY (*((volatile union FDC0_PO1DLY_REG *)0x40002BF4))
// model

/** 0X4000 2BF8 FDC0_PO2DLY **/
union FDC0_PO2DLY_REG{
	unsigned int reg;
	struct FDC0_PO2DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_PO2DLY (*((volatile union FDC0_PO2DLY_REG *)0x40002BF8))
// model

/** 0X4000 2BFC FDC0_PO3DLY **/
union FDC0_PO3DLY_REG{
	unsigned int reg;
	struct FDC0_PO3DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC0_PO3DLY (*((volatile union FDC0_PO3DLY_REG *)0x40002BFC))
// modelFDC1

/** 0X4000 2C00 FDC1_CTL **/
union FDC1_CTL_REG{
	unsigned int reg;
	struct FDC1_CTL_BITS{
		unsigned int _FDCEN:1;
		unsigned int _POEN:1;
		unsigned int _LDOK:1;
		unsigned int _CONT:1;
		unsigned int _MDLIF:1;
		unsigned int _MDLIE:1;
		unsigned int _TRGSEL:1;
		unsigned int _MULSEL:6;
		unsigned int _PRESC:3;
		unsigned int _FDCDE:1;
		unsigned int _SWTRIG:1;
		unsigned int _FDCEIE:1;
		unsigned int _LDMOD:2;
		unsigned int _BBMODE:1;
		unsigned int _CMODE:1;
		unsigned int _MDLIC:1;
		unsigned int _CLKSEL:2;
		unsigned int _TCLR:1;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CTL (*((volatile union FDC1_CTL_REG *)0x40002C00))
// model

/** 0X4000 2C04 FDC1_MOD **/
union FDC1_MOD_REG{
	unsigned int reg;
	struct FDC1_MOD_BITS{
		unsigned int _MOD:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_MOD (*((volatile union FDC1_MOD_REG *)0x40002C04))
// model

/** 0X4000 2C08 FDC1_CNT **/
union FDC1_CNT_REG{
	unsigned int reg;
	struct FDC1_CNT_BITS{
		unsigned int _CNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CNT (*((volatile union FDC1_CNT_REG *)0x40002C08))
// model

/** 0X4000 2C0C FDC1_IDLY **/
union FDC1_IDLY_REG{
	unsigned int reg;
	struct FDC1_IDLY_BITS{
		unsigned int _IDLY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_IDLY (*((volatile union FDC1_IDLY_REG *)0x40002C0C))
// model

/** 0X4000 2C10 FDC1_CH0CTL **/
union FDC1_CH0CTL_REG{
	unsigned int reg;
	struct FDC1_CH0CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH0CTL (*((volatile union FDC1_CH0CTL_REG *)0x40002C10))
// model

/** 0X4000 2C14 FDC1_CH1CTL **/
union FDC1_CH1CTL_REG{
	unsigned int reg;
	struct FDC1_CH1CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH1CTL (*((volatile union FDC1_CH1CTL_REG *)0x40002C14))
// model

/** 0X4000 2C18 FDC1_CH2CTL **/
union FDC1_CH2CTL_REG{
	unsigned int reg;
	struct FDC1_CH2CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH2CTL (*((volatile union FDC1_CH2CTL_REG *)0x40002C18))
// model

/** 0X4000 2C1C FDC1_CH3CTL **/
union FDC1_CH3CTL_REG{
	unsigned int reg;
	struct FDC1_CH3CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH3CTL (*((volatile union FDC1_CH3CTL_REG *)0x40002C1C))
// model

/** 0X4000 2C30 FDC1_CH0DLY0 **/
union FDC1_CH0DLY0_REG{
	unsigned int reg;
	struct FDC1_CH0DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH0DLY0 (*((volatile union FDC1_CH0DLY0_REG *)0x40002C30))
// model

/** 0X4000 2C34 FDC1_CH0DLY1 **/
union FDC1_CH0DLY1_REG{
	unsigned int reg;
	struct FDC1_CH0DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH0DLY1 (*((volatile union FDC1_CH0DLY1_REG *)0x40002C34))
// model

/** 0X4000 2C38 FDC1_CH0DLY2 **/
union FDC1_CH0DLY2_REG{
	unsigned int reg;
	struct FDC1_CH0DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH0DLY2 (*((volatile union FDC1_CH0DLY2_REG *)0x40002C38))
// model

/** 0X4000 2C40 FDC1_CH1DLY0 **/
union FDC1_CH1DLY0_REG{
	unsigned int reg;
	struct FDC1_CH1DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH1DLY0 (*((volatile union FDC1_CH1DLY0_REG *)0x40002C40))
// model

/** 0X4000 2C44 FDC1_CH1DLY1 **/
union FDC1_CH1DLY1_REG{
	unsigned int reg;
	struct FDC1_CH1DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH1DLY1 (*((volatile union FDC1_CH1DLY1_REG *)0x40002C44))
// model

/** 0X4000 2C48 FDC1_CH1DLY2 **/
union FDC1_CH1DLY2_REG{
	unsigned int reg;
	struct FDC1_CH1DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH1DLY2 (*((volatile union FDC1_CH1DLY2_REG *)0x40002C48))
// model

/** 0X4000 2C50 FDC1_CH2DLY0 **/
union FDC1_CH2DLY0_REG{
	unsigned int reg;
	struct FDC1_CH2DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH2DLY0 (*((volatile union FDC1_CH2DLY0_REG *)0x40002C50))
// model

/** 0X4000 2C54 FDC1_CH2DLY1 **/
union FDC1_CH2DLY1_REG{
	unsigned int reg;
	struct FDC1_CH2DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH2DLY1 (*((volatile union FDC1_CH2DLY1_REG *)0x40002C54))
// model

/** 0X4000 2C58 FDC1_CH2DLY2 **/
union FDC1_CH2DLY2_REG{
	unsigned int reg;
	struct FDC1_CH2DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH2DLY2 (*((volatile union FDC1_CH2DLY2_REG *)0x40002C58))
// model

/** 0X4000 2C60 FDC1_CH3DLY0 **/
union FDC1_CH3DLY0_REG{
	unsigned int reg;
	struct FDC1_CH3DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH3DLY0 (*((volatile union FDC1_CH3DLY0_REG *)0x40002C60))
// model

/** 0X4000 2C64 FDC1_CH3DLY1 **/
union FDC1_CH3DLY1_REG{
	unsigned int reg;
	struct FDC1_CH3DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH3DLY1 (*((volatile union FDC1_CH3DLY1_REG *)0x40002C64))
// model

/** 0X4000 2C68 FDC1_CH3DLY2 **/
union FDC1_CH3DLY2_REG{
	unsigned int reg;
	struct FDC1_CH3DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_CH3DLY2 (*((volatile union FDC1_CH3DLY2_REG *)0x40002C68))
// model

/** 0X4000 2C70 FDC1_PO0DLY **/
union FDC1_PO0DLY_REG{
	unsigned int reg;
	struct FDC1_PO0DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_PO0DLY (*((volatile union FDC1_PO0DLY_REG *)0x40002C70))
// model

/** 0X4000 2C74 FDC1_PO1DLY **/
union FDC1_PO1DLY_REG{
	unsigned int reg;
	struct FDC1_PO1DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_PO1DLY (*((volatile union FDC1_PO1DLY_REG *)0x40002C74))
// model

/** 0X4000 2C78 FDC1_PO2DLY **/
union FDC1_PO2DLY_REG{
	unsigned int reg;
	struct FDC1_PO2DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_PO2DLY (*((volatile union FDC1_PO2DLY_REG *)0x40002C78))
// model

/** 0X4000 2C7C FDC1_PO3DLY **/
union FDC1_PO3DLY_REG{
	unsigned int reg;
	struct FDC1_PO3DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC1_PO3DLY (*((volatile union FDC1_PO3DLY_REG *)0x40002C7C))
// modelFDC2

/** 0X4000 2C80 FDC2_CTL **/
union FDC2_CTL_REG{
	unsigned int reg;
	struct FDC2_CTL_BITS{
		unsigned int _FDCEN:1;
		unsigned int _POEN:1;
		unsigned int _LDOK:1;
		unsigned int _CONT:1;
		unsigned int _MDLIF:1;
		unsigned int _MDLIE:1;
		unsigned int _TRGSEL:1;
		unsigned int _MULSEL:6;
		unsigned int _PRESC:3;
		unsigned int _FDCDE:1;
		unsigned int _SWTRIG:1;
		unsigned int _FDCEIE:1;
		unsigned int _LDMOD:2;
		unsigned int _BBMODE:1;
		unsigned int _CMODE:1;
		unsigned int _MDLIC:1;
		unsigned int _CLKSEL:2;
		unsigned int _TCLR:1;
		unsigned int :5;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CTL (*((volatile union FDC2_CTL_REG *)0x40002C80))
// model

/** 0X4000 2C84 FDC2_MOD **/
union FDC2_MOD_REG{
	unsigned int reg;
	struct FDC2_MOD_BITS{
		unsigned int _MOD:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_MOD (*((volatile union FDC2_MOD_REG *)0x40002C84))
// model

/** 0X4000 2C88 FDC2_CNT **/
union FDC2_CNT_REG{
	unsigned int reg;
	struct FDC2_CNT_BITS{
		unsigned int _CNT:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CNT (*((volatile union FDC2_CNT_REG *)0x40002C88))
// model

/** 0X4000 2C8C FDC2_IDLY **/
union FDC2_IDLY_REG{
	unsigned int reg;
	struct FDC2_IDLY_BITS{
		unsigned int _IDLY:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_IDLY (*((volatile union FDC2_IDLY_REG *)0x40002C8C))
// model

/** 0X4000 2C90 FDC2_CH0CTL **/
union FDC2_CH0CTL_REG{
	unsigned int reg;
	struct FDC2_CH0CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH0CTL (*((volatile union FDC2_CH0CTL_REG *)0x40002C90))
// model

/** 0X4000 2C94 FDC2_CH1CTL **/
union FDC2_CH1CTL_REG{
	unsigned int reg;
	struct FDC2_CH1CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH1CTL (*((volatile union FDC2_CH1CTL_REG *)0x40002C94))
// model

/** 0X4000 2C98 FDC2_CH2CTL **/
union FDC2_CH2CTL_REG{
	unsigned int reg;
	struct FDC2_CH2CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH2CTL (*((volatile union FDC2_CH2CTL_REG *)0x40002C98))
// model

/** 0X4000 2C9C FDC2_CH3CTL **/
union FDC2_CH3CTL_REG{
	unsigned int reg;
	struct FDC2_CH3CTL_BITS{
		unsigned int _PREN0:1;
		unsigned int _PREN1:1;
		unsigned int _PREN2:1;
		unsigned int _PREN3:1;
		unsigned int _PREN4:1;
		unsigned int _TOS0:1;
		unsigned int _TOS1:1;
		unsigned int _TOS2:1;
		unsigned int _TOS3:1;
		unsigned int _TOS4:1;
		unsigned int _CF0:1;
		unsigned int _CF1:1;
		unsigned int _CF2:1;
		unsigned int _CF3:1;
		unsigned int _CF4:1;
		unsigned int _ERR0:1;
		unsigned int _ERR1:1;
		unsigned int _ERR2:1;
		unsigned int _ERR3:1;
		unsigned int _ERR4:1;
		unsigned int _ERRIC0:1;
		unsigned int _ERRIC1:1;
		unsigned int _ERRIC2:1;
		unsigned int _ERRIC3:1;
		unsigned int _ERRIC4:1;
		unsigned int :7;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH3CTL (*((volatile union FDC2_CH3CTL_REG *)0x40002C9C))
// model

/** 0X4000 2CB0 FDC2_CH0DLY0 **/
union FDC2_CH0DLY0_REG{
	unsigned int reg;
	struct FDC2_CH0DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH0DLY0 (*((volatile union FDC2_CH0DLY0_REG *)0x40002CB0))
// model

/** 0X4000 2CB4 FDC2_CH0DLY1 **/
union FDC2_CH0DLY1_REG{
	unsigned int reg;
	struct FDC2_CH0DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH0DLY1 (*((volatile union FDC2_CH0DLY1_REG *)0x40002CB4))
// model

/** 0X4000 2CB8 FDC2_CH0DLY2 **/
union FDC2_CH0DLY2_REG{
	unsigned int reg;
	struct FDC2_CH0DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH0DLY2 (*((volatile union FDC2_CH0DLY2_REG *)0x40002CB8))
// model

/** 0X4000 2CC0 FDC2_CH1DLY0 **/
union FDC2_CH1DLY0_REG{
	unsigned int reg;
	struct FDC2_CH1DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH1DLY0 (*((volatile union FDC2_CH1DLY0_REG *)0x40002CC0))
// model

/** 0X4000 2CC4 FDC2_CH1DLY1 **/
union FDC2_CH1DLY1_REG{
	unsigned int reg;
	struct FDC2_CH1DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH1DLY1 (*((volatile union FDC2_CH1DLY1_REG *)0x40002CC4))
// model

/** 0X4000 2CC8 FDC2_CH1DLY2 **/
union FDC2_CH1DLY2_REG{
	unsigned int reg;
	struct FDC2_CH1DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH1DLY2 (*((volatile union FDC2_CH1DLY2_REG *)0x40002CC8))
// model

/** 0X4000 2CD0 FDC2_CH2DLY0 **/
union FDC2_CH2DLY0_REG{
	unsigned int reg;
	struct FDC2_CH2DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH2DLY0 (*((volatile union FDC2_CH2DLY0_REG *)0x40002CD0))
// model

/** 0X4000 2CD4 FDC2_CH2DLY1 **/
union FDC2_CH2DLY1_REG{
	unsigned int reg;
	struct FDC2_CH2DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH2DLY1 (*((volatile union FDC2_CH2DLY1_REG *)0x40002CD4))
// model

/** 0X4000 2CD8 FDC2_CH2DLY2 **/
union FDC2_CH2DLY2_REG{
	unsigned int reg;
	struct FDC2_CH2DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH2DLY2 (*((volatile union FDC2_CH2DLY2_REG *)0x40002CD8))
// model

/** 0X4000 2CE0 FDC2_CH3DLY0 **/
union FDC2_CH3DLY0_REG{
	unsigned int reg;
	struct FDC2_CH3DLY0_BITS{
		unsigned int _DLY0:16;
		unsigned int _DLY1:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH3DLY0 (*((volatile union FDC2_CH3DLY0_REG *)0x40002CE0))
// model

/** 0X4000 2CE4 FDC2_CH3DLY1 **/
union FDC2_CH3DLY1_REG{
	unsigned int reg;
	struct FDC2_CH3DLY1_BITS{
		unsigned int _DLY2:16;
		unsigned int _DLY3:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH3DLY1 (*((volatile union FDC2_CH3DLY1_REG *)0x40002CE4))
// model

/** 0X4000 2CE8 FDC2_CH3DLY2 **/
union FDC2_CH3DLY2_REG{
	unsigned int reg;
	struct FDC2_CH3DLY2_BITS{
		unsigned int _DLY4:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_CH3DLY2 (*((volatile union FDC2_CH3DLY2_REG *)0x40002CE8))
// model

/** 0X4000 2CF0 FDC2_PO0DLY **/
union FDC2_PO0DLY_REG{
	unsigned int reg;
	struct FDC2_PO0DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_PO0DLY (*((volatile union FDC2_PO0DLY_REG *)0x40002CF0))
// model

/** 0X4000 2CF4 FDC2_PO1DLY **/
union FDC2_PO1DLY_REG{
	unsigned int reg;
	struct FDC2_PO1DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_PO1DLY (*((volatile union FDC2_PO1DLY_REG *)0x40002CF4))
// model

/** 0X4000 2CF8 FDC2_PO2DLY **/
union FDC2_PO2DLY_REG{
	unsigned int reg;
	struct FDC2_PO2DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_PO2DLY (*((volatile union FDC2_PO2DLY_REG *)0x40002CF8))
// model

/** 0X4000 2CFC FDC2_PO3DLY **/
union FDC2_PO3DLY_REG{
	unsigned int reg;
	struct FDC2_PO3DLY_BITS{
		unsigned int _DLYL:16;
		unsigned int _DLYH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FDC2_PO3DLY (*((volatile union FDC2_PO3DLY_REG *)0x40002CFC))
// modelFlexMUX

/** 0X4000 2D00 FlexMUX_SOU **/
union FlexMUX_SOU_REG{
	unsigned int reg;
	struct FlexMUX_SOU_BITS{
		unsigned int _SEL1:7;
		unsigned int _CH1EN:1;
		unsigned int _SEL2:7;
		unsigned int _CH2EN:1;
		unsigned int _SEL3:7;
		unsigned int _CH3EN:1;
		unsigned int _SEL4:7;
		unsigned int _CH4EN:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexMUX_SOU (*((volatile union FlexMUX_SOU_REG *)0x40002D00))
// model

/** 0X4000 2D04 FlexMUX_TAR **/
union FlexMUX_TAR_REG{
	unsigned int reg;
	struct FlexMUX_TAR_BITS{
		unsigned int _FMUXEN:1;
		unsigned int _CH1DE:1;
		unsigned int _CH2DE:1;
		unsigned int _CH3DE:1;
		unsigned int _CH4DE:1;
		unsigned int _CH1DIV:2;
		unsigned int _CH2DIV:2;
		unsigned int _CH3DIV:2;
		unsigned int _CH4DIV:2;
		unsigned int _CH1SEL:2;
		unsigned int _CH2SEL:2;
		unsigned int _CH3SEL:2;
		unsigned int _CH4SEL:2;
		unsigned int _TCKS:2;
		unsigned int :9;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexMUX_TAR (*((volatile union FlexMUX_TAR_REG *)0x40002D04))
// modelFlexRM

/** 0X4000 2D80 FlexRM_CTL **/
union FlexRM_CTL_REG{
	unsigned int reg;
	struct FlexRM_CTL_BITS{
		unsigned int _G0EN:1;
		unsigned int _G1EN:1;
		unsigned int _G2EN:1;
		unsigned int _G3EN:1;
		unsigned int _G4EN:1;
		unsigned int _G5EN:1;
		unsigned int _G6EN:1;
		unsigned int _G7EN:1;
		unsigned int _G8EN:1;
		unsigned int _G9EN:1;
		unsigned int _G10EN:1;
		unsigned int _G11EN:1;
		unsigned int _CH0TRSEL:1;
		unsigned int _CH1TRSEL:1;
		unsigned int _CH2TRSEL:1;
		unsigned int _CH3TRSEL:1;
		unsigned int _CH4TRSEL:1;
		unsigned int _CH5TRSEL:1;
		unsigned int _CH6TRSEL:1;
		unsigned int _CH7TRSEL:1;
		unsigned int _CH8TRSEL:1;
		unsigned int _CH9TRSEL:1;
		unsigned int _CH10TRSEL:1;
		unsigned int _CH11TRSEL:1;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_CTL (*((volatile union FlexRM_CTL_REG *)0x40002D80))
// model

/** 0X4000 2D84 FlexRM_GPSR0 **/
union FlexRM_GPSR0_REG{
	unsigned int reg;
	struct FlexRM_GPSR0_BITS{
		unsigned int _G0PS:4;
		unsigned int _G1PS:4;
		unsigned int _G2PS:4;
		unsigned int _G3PS:4;
		unsigned int _G4PS:4;
		unsigned int _G5PS:4;
		unsigned int _G6PS:4;
		unsigned int _G7PS:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GPSR0 (*((volatile union FlexRM_GPSR0_REG *)0x40002D84))
// model

/** 0X4000 2D88 FlexRM_GPSR1 **/
union FlexRM_GPSR1_REG{
	unsigned int reg;
	struct FlexRM_GPSR1_BITS{
		unsigned int _G8PS:4;
		unsigned int _G9PS:4;
		unsigned int _G10PS:4;
		unsigned int _G11PS:4;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GPSR1 (*((volatile union FlexRM_GPSR1_REG *)0x40002D88))
// model

/** 0X4000 2D8C FlexRM_GCSR0 **/
union FlexRM_GCSR0_REG{
	unsigned int reg;
	struct FlexRM_GCSR0_BITS{
		unsigned int _CH0OS:4;
		unsigned int _G0CIS:4;
		unsigned int _CH1OS:4;
		unsigned int _G1CIS:4;
		unsigned int _CH2OS:4;
		unsigned int _G2CIS:4;
		unsigned int _CH3OS:4;
		unsigned int _G3CIS:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GCSR0 (*((volatile union FlexRM_GCSR0_REG *)0x40002D8C))
// model

/** 0X4000 2D90 FlexRM_GCSR1 **/
union FlexRM_GCSR1_REG{
	unsigned int reg;
	struct FlexRM_GCSR1_BITS{
		unsigned int _G4COS:4;
		unsigned int _CH4OS:4;
		unsigned int _G5COS:4;
		unsigned int _CH5OS:4;
		unsigned int _G6COS:4;
		unsigned int _CH6OS:4;
		unsigned int _G7COS:4;
		unsigned int _CH7OS:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GCSR1 (*((volatile union FlexRM_GCSR1_REG *)0x40002D90))
// model

/** 0X4000 2D94 FlexRM_GCSR2 **/
union FlexRM_GCSR2_REG{
	unsigned int reg;
	struct FlexRM_GCSR2_BITS{
		unsigned int _G8COS:4;
		unsigned int _CH8OS:4;
		unsigned int _G9COS:4;
		unsigned int _CH9OS:4;
		unsigned int _G10COS:4;
		unsigned int _CH10OS:4;
		unsigned int _G11COS:4;
		unsigned int _CH11OS:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FlexRM_GCSR2 (*((volatile union FlexRM_GCSR2_REG *)0x40002D94))
// modelECFGL

/** 0X4000 2A80 ECFGL0_CTL **/
union ECFGL0_CTL_REG{
	unsigned int reg;
	struct ECFGL0_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL0_CTL (*((volatile union ECFGL0_CTL_REG *)0x40002A80))
// model

/** 0X4000 2A84 ECFGL1_CTL **/
union ECFGL1_CTL_REG{
	unsigned int reg;
	struct ECFGL1_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL1_CTL (*((volatile union ECFGL1_CTL_REG *)0x40002A84))
// model

/** 0X4000 2A88 ECFGL2_CTL **/
union ECFGL2_CTL_REG{
	unsigned int reg;
	struct ECFGL2_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL2_CTL (*((volatile union ECFGL2_CTL_REG *)0x40002A88))
// model

/** 0X4000 2A8C ECFGL3_CTL **/
union ECFGL3_CTL_REG{
	unsigned int reg;
	struct ECFGL3_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL3_CTL (*((volatile union ECFGL3_CTL_REG *)0x40002A8C))
// model

/** 0X4000 2A90 ECFGL4_CTL **/
union ECFGL4_CTL_REG{
	unsigned int reg;
	struct ECFGL4_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL4_CTL (*((volatile union ECFGL4_CTL_REG *)0x40002A90))
// model

/** 0X4000 2A94 ECFGL5_CTL **/
union ECFGL5_CTL_REG{
	unsigned int reg;
	struct ECFGL5_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL5_CTL (*((volatile union ECFGL5_CTL_REG *)0x40002A94))
// model

/** 0X4000 2A98 ECFGL6_CTL **/
union ECFGL6_CTL_REG{
	unsigned int reg;
	struct ECFGL6_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL6_CTL (*((volatile union ECFGL6_CTL_REG *)0x40002A98))
// model

/** 0X4000 2A9C ECFGL7_CTL **/
union ECFGL7_CTL_REG{
	unsigned int reg;
	struct ECFGL7_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL7_CTL (*((volatile union ECFGL7_CTL_REG *)0x40002A9C))
// model

/** 0X4000 2AA0 ECFGL8_CTL **/
union ECFGL8_CTL_REG{
	unsigned int reg;
	struct ECFGL8_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL8_CTL (*((volatile union ECFGL8_CTL_REG *)0x40002AA0))
// model

/** 0X4000 2AA4 ECFGL9_CTL **/
union ECFGL9_CTL_REG{
	unsigned int reg;
	struct ECFGL9_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL9_CTL (*((volatile union ECFGL9_CTL_REG *)0x40002AA4))
// model

/** 0X4000 2AA8 ECFGL10_CTL **/
union ECFGL10_CTL_REG{
	unsigned int reg;
	struct ECFGL10_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL10_CTL (*((volatile union ECFGL10_CTL_REG *)0x40002AA8))
// model

/** 0X4000 2AAC ECFGL11_CTL **/
union ECFGL11_CTL_REG{
	unsigned int reg;
	struct ECFGL11_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL11_CTL (*((volatile union ECFGL11_CTL_REG *)0x40002AAC))
// model

/** 0X4000 2AB0 ECFGL12_CTL **/
union ECFGL12_CTL_REG{
	unsigned int reg;
	struct ECFGL12_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL12_CTL (*((volatile union ECFGL12_CTL_REG *)0x40002AB0))
// model

/** 0X4000 2AB4 ECFGL13_CTL **/
union ECFGL13_CTL_REG{
	unsigned int reg;
	struct ECFGL13_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL13_CTL (*((volatile union ECFGL13_CTL_REG *)0x40002AB4))
// model

/** 0X4000 2AB8 ECFGL14_CTL **/
union ECFGL14_CTL_REG{
	unsigned int reg;
	struct ECFGL14_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL14_CTL (*((volatile union ECFGL14_CTL_REG *)0x40002AB8))
// model

/** 0X4000 2ABC ECFGL15_CTL **/
union ECFGL15_CTL_REG{
	unsigned int reg;
	struct ECFGL15_CTL_BITS{
		unsigned int _MUX0SEL:2;
		unsigned int _MUX1SEL:2;
		unsigned int _MUX2SEL:1;
		unsigned int _MUX3SEL:1;
		unsigned int _MUX4SEL:1;
		unsigned int :1;
		unsigned int _FUNSEL:4;
		unsigned int _EN:1;
		unsigned int :19;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL15_CTL (*((volatile union ECFGL15_CTL_REG *)0x40002ABC))
// model

/** 0X4000 2AC0 ECFGL_SOFTSEL **/
union ECFGL_SOFTSEL_REG{
	unsigned int reg;
	struct ECFGL_SOFTSEL_BITS{
		unsigned int _ECFGL0MUX2SOFTSEL:1;
		unsigned int _ECFGL1MUX2SOFTSEL:1;
		unsigned int _ECFGL2MUX2SOFTSEL:1;
		unsigned int _ECFGL3MUX2SOFTSEL:1;
		unsigned int _ECFGL4MUX2SOFTSEL:1;
		unsigned int _ECFGL5MUX2SOFTSEL:1;
		unsigned int _ECFGL6MUX2SOFTSEL:1;
		unsigned int _ECFGL7MUX2SOFTSEL:1;
		unsigned int _ECFGL8MUX2SOFTSEL:1;
		unsigned int _ECFGL9MUX2SOFTSEL:1;
		unsigned int _ECFGL10MUX2SOFTSEL:1;
		unsigned int _ECFGL11MUX2SOFTSEL:1;
		unsigned int _ECFGL12MUX2SOFTSEL:1;
		unsigned int _ECFGL13MUX2SOFTSEL:1;
		unsigned int _ECFGL14MUX2SOFTSEL:1;
		unsigned int _ECFGL15MUX2SOFTSEL:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL_SOFTSEL (*((volatile union ECFGL_SOFTSEL_REG *)0x40002AC0))
// model

/** 0X4000 2AC4 ECFGL_FCLK **/
union ECFGL_FCLK_REG{
	unsigned int reg;
	struct ECFGL_FCLK_BITS{
		unsigned int _FCLKSEL:3;
		unsigned int :1;
		unsigned int _FCLKDIV:3;
		unsigned int :25;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL_FCLK (*((volatile union ECFGL_FCLK_REG *)0x40002AC4))
// model

/** 0X4000 2AC8 ECFGL_IC **/
union ECFGL_IC_REG{
	unsigned int reg;
	struct ECFGL_IC_BITS{
		unsigned int _ECFGLIC:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL_IC (*((volatile union ECFGL_IC_REG *)0x40002AC8))
// model

/** 0X4000 2ACC ECFGL_IF **/
union ECFGL_IF_REG{
	unsigned int reg;
	struct ECFGL_IF_BITS{
		unsigned int _ECFGLIF:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL_IF (*((volatile union ECFGL_IF_REG *)0x40002ACC))
// model

/** 0X4000 2AD0 ECFGL_RFCTL **/
union ECFGL_RFCTL_REG{
	unsigned int reg;
	struct ECFGL_RFCTL_BITS{
		unsigned int _ECFGLR:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL_RFCTL (*((volatile union ECFGL_RFCTL_REG *)0x40002AD0))
// model

/** 0X4000 2AD4 ECFGL_FFCTL **/
union ECFGL_FFCTL_REG{
	unsigned int reg;
	struct ECFGL_FFCTL_BITS{
		unsigned int _ECFGLF:16;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL_FFCTL (*((volatile union ECFGL_FFCTL_REG *)0x40002AD4))
// model

/** 0X4000 2AD8 ECFGL_ADC **/
union ECFGL_ADC_REG{
	unsigned int reg;
	struct ECFGL_ADC_BITS{
		unsigned int _ADCTRISEL:4;
		unsigned int _ADCTRIEN:1;
		unsigned int :27;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL_ADC (*((volatile union ECFGL_ADC_REG *)0x40002AD8))
// model

/** 0X4000 2ADC ECFGL_OUT **/
union ECFGL_OUT_REG{
	unsigned int reg;
	struct ECFGL_OUT_BITS{
		unsigned int _ECFGL0OUT:1;
		unsigned int _ECFGL1OUT:1;
		unsigned int _ECFGL2OUT:1;
		unsigned int _ECFGL3OUT:1;
		unsigned int _ECFGL4OUT:1;
		unsigned int _ECFGL5OUT:1;
		unsigned int _ECFGL6OUT:1;
		unsigned int _ECFGL7OUT:1;
		unsigned int _ECFGL8OUT:1;
		unsigned int _ECFGL9OUT:1;
		unsigned int _ECFGL10OUT:1;
		unsigned int _ECFGL11OUT:1;
		unsigned int _ECFGL12OUT:1;
		unsigned int _ECFGL13OUT:1;
		unsigned int _ECFGL14OUT:1;
		unsigned int _ECFGL15OUT:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ECFGL_OUT (*((volatile union ECFGL_OUT_REG *)0x40002ADC))
// modelINT

/** 0x4020 0000 INT_CTL0 **/
union INT_CTL0_REG{
	unsigned int reg;
	struct INT_CTL0_BITS{
		unsigned int _AIE:1;
		unsigned int _PRIGROUP:2;
		unsigned int :1;
		unsigned int _INTPENDING:1;
		unsigned int _INTPREEMPT:1;
		unsigned int _FAULTMASK:1;
		unsigned int _DSALIGN:1;
		unsigned int :4;
		unsigned int _PRIBASE:4;
		unsigned int _INTPEND:7;
		unsigned int :1;
		unsigned int _INTACT:7;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_CTL0 (*((volatile union INT_CTL0_REG *)0x40200000))
// model

/** 0x4020 0004 INT_EIE0 **/
union INT_EIE0_REG{
	unsigned int reg;
	struct INT_EIE0_BITS{
		unsigned int :3;
		unsigned int _HADRFAULTIE:1;
		unsigned int _ECCIE:1;
		unsigned int _STACKIE:1;
		unsigned int _ARIFAULTIE:1;
		unsigned int :3;
		unsigned int :1;
		unsigned int _SVCIE:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _SOFTSVIE:1;
		unsigned int _SYSTICKIE:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE0 (*((volatile union INT_EIE0_REG *)0x40200004))
// model

/** 0x4020 000C INT_EIE1 **/
union INT_EIE1_REG{
	unsigned int reg;
	struct INT_EIE1_BITS{
		unsigned int _WWDTIE:1;
		unsigned int _EINT16IE:1;
		unsigned int _EINT0IE:1;
		unsigned int _EINT1IE:1;
		unsigned int _EINT2IE:1;
		unsigned int _EINT3IE:1;
		unsigned int _EINT4IE:1;
		unsigned int _EINT9TO5IE:1;
		unsigned int _EINT15TO10IE:1;
		unsigned int _T1IE:1;
		unsigned int _T3IE:1;
		unsigned int _T5IE:1;
		unsigned int _T6IE:1;
		unsigned int _QEI0IE:1;
		unsigned int _QEI1IE:1;
		unsigned int _ECFGLIE:1;
		unsigned int _CAN4IE:1;
		unsigned int _T14IE:1;
		unsigned int _RNGIE:1;
		unsigned int _FDC2IE:1;
		unsigned int _EXICIE:1;
		unsigned int _ADC0IE:1;
		unsigned int _ADC1IE:1;
		unsigned int _CFGLIE:1;
		unsigned int _T11IE:1;
		unsigned int _T0IE:1;
		unsigned int _DMA0IE:1;
		unsigned int _CMPIE:1;
		unsigned int _USART0IE:1;
		unsigned int _USART1IE:1;
		unsigned int _SPI0IE:1;
		unsigned int _SPI1IE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE1 (*((volatile union INT_EIE1_REG *)0x4020000C))
// model

/** 0x4020 0014 INT_EIE2 **/
union INT_EIE2_REG{
	unsigned int reg;
	struct INT_EIE2_BITS{
		unsigned int _DMA1IE:1;
		unsigned int _EINT19TO17IE:1;
		unsigned int _CANFD6IE:1;
		unsigned int _CANFD7IE:1;
		unsigned int _FDC0IE:1;
		unsigned int _FDC1IE:1;
		unsigned int _EINT31TO20IE:1;
		unsigned int _ECCIE:1;
		unsigned int _OSCIE:1;
		unsigned int _I2C0IE:1;
		unsigned int _I2C1IE:1;
		unsigned int _I2C2IE:1;
		unsigned int _T12IE:1;
		unsigned int _T2IE:1;
		unsigned int _T4IE:1;
		unsigned int _T13IE:1;
		unsigned int _USART2IE:1;
		unsigned int _T16IE:1;
		unsigned int _USART4IE:1;
		unsigned int _SPI2IE:1;
		unsigned int _SPI3IE:1;
		unsigned int _ADC2IE:1;
		unsigned int _T18IE:1;
		unsigned int _T19IE:1;
		unsigned int _HRCAP0IE:1;
		unsigned int _WKPIE:1;
		unsigned int _HRCAP1IE:1;
		unsigned int _T21IE:1;
		unsigned int _I2C3IE:1;
		unsigned int _USART5IE:1;
		unsigned int _HRCAP2IE:1;
		unsigned int _USART7IE:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIE2 (*((volatile union INT_EIE2_REG *)0x40200014))
// model

/** 0x4020 001C INT_EIF0 **/
union INT_EIF0_REG{
	unsigned int reg;
	struct INT_EIF0_BITS{
		unsigned int :2;
		unsigned int _NMIIF:1;
		unsigned int _HARDFAULTIF:1;
		unsigned int _ECCIF:1;
		unsigned int _STACKIF:1;
		unsigned int _ARIFAULTIF:1;
		unsigned int :3;
		unsigned int :1;
		unsigned int _SVCIF:1;
		unsigned int :1;
		unsigned int :1;
		unsigned int _SOFTSVIF:1;
		unsigned int _SYSTICKIF:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF0 (*((volatile union INT_EIF0_REG *)0x4020001C))
// model

/** 0x4020 0024 INT_EIF1 **/
union INT_EIF1_REG{
	unsigned int reg;
	struct INT_EIF1_BITS{
		unsigned int _WWDTIF:1;
		unsigned int _EINT16IF:1;
		unsigned int _EINT0IF:1;
		unsigned int _EINT1IF:1;
		unsigned int _EINT2IF:1;
		unsigned int _EINT3IF:1;
		unsigned int _EINT4IF:1;
		unsigned int _EINT9TO5IF:1;
		unsigned int _EINT15TO10IF:1;
		unsigned int _T1IF:1;
		unsigned int _T3IF:1;
		unsigned int _T5IF:1;
		unsigned int _T6IF:1;
		unsigned int _QEI0IF:1;
		unsigned int _QEI1IF:1;
		unsigned int _ECFGLIF:1;
		unsigned int _CAN4IF:1;
		unsigned int _T14IF:1;
		unsigned int _RNGIF:1;
		unsigned int _FDC2IF:1;
		unsigned int _EXICIF:1;
		unsigned int _ADC0IF:1;
		unsigned int _ADC1IF:1;
		unsigned int _CFGLIF:1;
		unsigned int _T11IF:1;
		unsigned int _T0IF:1;
		unsigned int _DMA0IF:1;
		unsigned int _CMPIF:1;
		unsigned int _USART0IF:1;
		unsigned int _USART1IF:1;
		unsigned int _SPI0IF:1;
		unsigned int _SPI1IF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF1 (*((volatile union INT_EIF1_REG *)0x40200024))
// model

/** 0x4020 002C INT_EIF2 **/
union INT_EIF2_REG{
	unsigned int reg;
	struct INT_EIF2_BITS{
		unsigned int _DMA1IF:1;
		unsigned int _EINT19TO17IF:1;
		unsigned int _CANFD6IF:1;
		unsigned int _CANFD7IF:1;
		unsigned int _FDC0IF:1;
		unsigned int _FDC1IF:1;
		unsigned int _EINT31TO20IF:1;
		unsigned int _ECCIF:1;
		unsigned int _OSCIF:1;
		unsigned int _I2C0IF:1;
		unsigned int _I2C1IF:1;
		unsigned int _I2C2IF:1;
		unsigned int _T12IF:1;
		unsigned int _T2IF:1;
		unsigned int _T4IF:1;
		unsigned int _T13IF:1;
		unsigned int _USART2IF:1;
		unsigned int _T16IF:1;
		unsigned int _USART4IF:1;
		unsigned int _SPI2IF:1;
		unsigned int _SPI3IF:1;
		unsigned int _ADC2IF:1;
		unsigned int _T18IF:1;
		unsigned int _T19IF:1;
		unsigned int _HRCAP0IF:1;
		unsigned int _WKPIF:1;
		unsigned int _HRCAP1IF:1;
		unsigned int _T21IF:1;
		unsigned int _I2C3IF:1;
		unsigned int _USART5IF:1;
		unsigned int _HRCAP2IF:1;
		unsigned int _USART7IF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EIF2 (*((volatile union INT_EIF2_REG *)0x4020002C))
// model

/** 0x4020 0034 INT_IP0 **/
union INT_IP0_REG{
	unsigned int reg;
	struct INT_IP0_BITS{
		unsigned int _PRI4:8;
		unsigned int _PRI5:8;
		unsigned int _PRI6:8;
		unsigned int _PRI7:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP0 (*((volatile union INT_IP0_REG *)0x40200034))
// model

/** 0x4020 0038 INT_IP1 **/
union INT_IP1_REG{
	unsigned int reg;
	struct INT_IP1_BITS{
		unsigned int _PRI8:8;
		unsigned int _PRI9:8;
		unsigned int _PRI10:8;
		unsigned int _PRI11:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP1 (*((volatile union INT_IP1_REG *)0x40200038))
// model

/** 0x4020 003C INT_IP2 **/
union INT_IP2_REG{
	unsigned int reg;
	struct INT_IP2_BITS{
		unsigned int _PRI12:8;
		unsigned int _PRI13:8;
		unsigned int _PRI14:8;
		unsigned int _PRI15:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP2 (*((volatile union INT_IP2_REG *)0x4020003C))
// model

/** 0x4020 0040 INT_IP3 **/
union INT_IP3_REG{
	unsigned int reg;
	struct INT_IP3_BITS{
		unsigned int _PR16:8;
		unsigned int _PRI17:8;
		unsigned int _PRI18:8;
		unsigned int _PRI19:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP3 (*((volatile union INT_IP3_REG *)0x40200040))
// model

/** 0x4020 0044 INT_IP4 **/
union INT_IP4_REG{
	unsigned int reg;
	struct INT_IP4_BITS{
		unsigned int _PRI20:8;
		unsigned int _PRI21:8;
		unsigned int _PRI22:8;
		unsigned int _PRI23:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP4 (*((volatile union INT_IP4_REG *)0x40200044))
// model

/** 0x4020 0048 INT_IP5 **/
union INT_IP5_REG{
	unsigned int reg;
	struct INT_IP5_BITS{
		unsigned int _PRI24:8;
		unsigned int _PRI25:8;
		unsigned int _PRI26:8;
		unsigned int _PRI27:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP5 (*((volatile union INT_IP5_REG *)0x40200048))
// model

/** 0x4020 004C INT_IP6 **/
union INT_IP6_REG{
	unsigned int reg;
	struct INT_IP6_BITS{
		unsigned int _PRI28:8;
		unsigned int _PRI29:8;
		unsigned int _PRI30:8;
		unsigned int _PRI31:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP6 (*((volatile union INT_IP6_REG *)0x4020004C))
// model

/** 0x4020 0050 INT_IP7 **/
union INT_IP7_REG{
	unsigned int reg;
	struct INT_IP7_BITS{
		unsigned int _PRI32:8;
		unsigned int _PRI33:8;
		unsigned int _PRI34:8;
		unsigned int _PRI35:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP7 (*((volatile union INT_IP7_REG *)0x40200050))
// model

/** 0x4020 0054 INT_IP8 **/
union INT_IP8_REG{
	unsigned int reg;
	struct INT_IP8_BITS{
		unsigned int _PRI36:8;
		unsigned int _PRI37:8;
		unsigned int _PRI38:8;
		unsigned int _PRI39:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP8 (*((volatile union INT_IP8_REG *)0x40200054))
// model

/** 0x4020 0058 INT_IP9 **/
union INT_IP9_REG{
	unsigned int reg;
	struct INT_IP9_BITS{
		unsigned int _PRI40:8;
		unsigned int _PRI41:8;
		unsigned int _PRI42:8;
		unsigned int _PRI43:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP9 (*((volatile union INT_IP9_REG *)0x40200058))
// model

/** 0x4020 005C INT_IP10 **/
union INT_IP10_REG{
	unsigned int reg;
	struct INT_IP10_BITS{
		unsigned int _PRI44:8;
		unsigned int _PRI45:8;
		unsigned int _PRI46:8;
		unsigned int _PRI47:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP10 (*((volatile union INT_IP10_REG *)0x4020005C))
// model

/** 0x4020 0060 INT_IP11 **/
union INT_IP11_REG{
	unsigned int reg;
	struct INT_IP11_BITS{
		unsigned int _PRI48:8;
		unsigned int _PRI49:8;
		unsigned int _PRI50:8;
		unsigned int _PRI51:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP11 (*((volatile union INT_IP11_REG *)0x40200060))
// model

/** 0x4020 0064 INT_IP12 **/
union INT_IP12_REG{
	unsigned int reg;
	struct INT_IP12_BITS{
		unsigned int _PRI52:8;
		unsigned int _PRI53:8;
		unsigned int _PRI54:8;
		unsigned int _PRI55:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP12 (*((volatile union INT_IP12_REG *)0x40200064))
// model

/** 0x4020 0068 INT_IP13 **/
union INT_IP13_REG{
	unsigned int reg;
	struct INT_IP13_BITS{
		unsigned int _PRI56:8;
		unsigned int _PRI57:8;
		unsigned int _PRI58:8;
		unsigned int _PRI59:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP13 (*((volatile union INT_IP13_REG *)0x40200068))
// model

/** 0x4020 006C INT_IP14 **/
union INT_IP14_REG{
	unsigned int reg;
	struct INT_IP14_BITS{
		unsigned int _PRI60:8;
		unsigned int _PRI61:8;
		unsigned int _PRI62:8;
		unsigned int _PRI63:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP14 (*((volatile union INT_IP14_REG *)0x4020006C))
// model

/** 0x4020 0070 INT_IP15 **/
union INT_IP15_REG{
	unsigned int reg;
	struct INT_IP15_BITS{
		unsigned int _PRI64:8;
		unsigned int _PRI65:8;
		unsigned int _PRI66:8;
		unsigned int _PRI67:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP15 (*((volatile union INT_IP15_REG *)0x40200070))
// model

/** 0x4020 0074 INT_IP16 **/
union INT_IP16_REG{
	unsigned int reg;
	struct INT_IP16_BITS{
		unsigned int _PRI68:8;
		unsigned int _PRI69:8;
		unsigned int _PRI70:8;
		unsigned int _PRI71:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP16 (*((volatile union INT_IP16_REG *)0x40200074))
// model

/** 0x4020 0078 INT_IP17 **/
union INT_IP17_REG{
	unsigned int reg;
	struct INT_IP17_BITS{
		unsigned int _PRI72:8;
		unsigned int _PRI73:8;
		unsigned int _PRI74:8;
		unsigned int _PRI75:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP17 (*((volatile union INT_IP17_REG *)0x40200078))
// model

/** 0x4020 007C INT_IP18 **/
union INT_IP18_REG{
	unsigned int reg;
	struct INT_IP18_BITS{
		unsigned int _PRI76:8;
		unsigned int _PRI77:8;
		unsigned int _PRI78:8;
		unsigned int _PRI79:8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_IP18 (*((volatile union INT_IP18_REG *)0x4020007C))
// model

/** 0x4020 0080 INT_EINTMASK **/
union INT_EINTMASK_REG{
	unsigned int reg;
	struct INT_EINTMASK_BITS{
		unsigned int _EINTM:22;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTMASK (*((volatile union INT_EINTMASK_REG *)0x40200080))
// model

/** 0x4020 0084 INT_EINTRISE **/
union INT_EINTRISE_REG{
	unsigned int reg;
	struct INT_EINTRISE_BITS{
		unsigned int _EINTRI:22;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTRISE (*((volatile union INT_EINTRISE_REG *)0x40200084))
// model

/** 0x4020 0088 INT_EINTFALL **/
union INT_EINTFALL_REG{
	unsigned int reg;
	struct INT_EINTFALL_BITS{
		unsigned int _EINTFA:22;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTFALL (*((volatile union INT_EINTFALL_REG *)0x40200088))
// model

/** 0x4020 008C INT_EINTF **/
union INT_EINTF_REG{
	unsigned int reg;
	struct INT_EINTF_BITS{
		unsigned int _EINTIF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTF (*((volatile union INT_EINTF_REG *)0x4020008C))
// model

/** 0x4020 0090 INT_EINTEL **/
union INT_EINTEL_REG{
	unsigned int reg;
	struct INT_EINTEL_BITS{
		unsigned int _EINTEL:22;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTEL (*((volatile union INT_EINTEL_REG *)0x40200090))
// model

/** 0x4020 0094 INT_EINTSS0 **/
union INT_EINTSS0_REG{
	unsigned int reg;
	struct INT_EINTSS0_BITS{
		unsigned int _EINTSOU0:4;
		unsigned int _EINTSOU1:4;
		unsigned int _EINTSOU2:4;
		unsigned int _EINTSOU3:4;
		unsigned int _EINTSOU4:4;
		unsigned int _EINTSOU5:4;
		unsigned int _EINTSOU6:4;
		unsigned int _EINTSOU7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTSS0 (*((volatile union INT_EINTSS0_REG *)0x40200094))
// model

/** 0x4020 0098 INT_EINTSS1 **/
union INT_EINTSS1_REG{
	unsigned int reg;
	struct INT_EINTSS1_BITS{
		unsigned int _EINTSOU8:4;
		unsigned int _EINTSOU9:4;
		unsigned int _EINTSOU10:4;
		unsigned int _EINTSOU11:4;
		unsigned int _EINTSOU12:4;
		unsigned int _EINTSOU13:4;
		unsigned int _EINTSOU14:4;
		unsigned int _EINTSOU15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_EINTSS1 (*((volatile union INT_EINTSS1_REG *)0x40200098))
// model

/** 0x4020 009C INT_CTL1 **/
union INT_CTL1_REG{
	unsigned int reg;
	struct INT_CTL1_BITS{
		unsigned int _INTDELY:8;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_CTL1 (*((volatile union INT_CTL1_REG *)0x4020009C))
// modelSystick

/** 0x4020 00A0 ST_CTL **/
union ST_CTL_REG{
	unsigned int reg;
	struct ST_CTL_BITS{
		unsigned int _STEN:1;
		unsigned int _TICKINTEN:1;
		unsigned int _STCLKS:1;
		unsigned int :13;
		unsigned int _COUNTZERO:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CTL (*((volatile union ST_CTL_REG *)0x402000A0))
// model

/** 0x4020 00A4 ST_RELOAD **/
union ST_RELOAD_REG{
	unsigned int reg;
	struct ST_RELOAD_BITS{
		unsigned int _STRELOAD:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_RELOAD (*((volatile union ST_RELOAD_REG *)0x402000A4))
// model

/** 0x4020 00A8 ST_CV **/
union ST_CV_REG{
	unsigned int reg;
	struct ST_CV_BITS{
		unsigned int _STCV:24;
		unsigned int :8;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CV (*((volatile union ST_CV_REG *)0x402000A8))
// model

/** 0x4020 00AC ST_CALI **/
union ST_CALI_REG{
	unsigned int reg;
	struct ST_CALI_BITS{
		unsigned int _STCALIB:24;
		unsigned int :6;
		unsigned int _SKEW:1;
		unsigned int _STCLKREF:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define ST_CALI (*((volatile union ST_CALI_REG *)0x402000AC))
// modelSystem

/** 0x4020 00B0 SYS_PSW **/
union SYS_PSW_REG{
	unsigned int reg;
	struct SYS_PSW_BITS{
		unsigned int :28;
		unsigned int _V:1;
		unsigned int _C:1;
		unsigned int _Z:1;
		unsigned int _N:1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_PSW (*((volatile union SYS_PSW_REG *)0x402000B0))
// model

/** 0x4020 00B4 SYS_MCTL **/
union SYS_MCTL_REG{
	unsigned int reg;
	struct SYS_MCTL_BITS{
		unsigned int :1;
		unsigned int _SLEEPONEXIT:1;
		unsigned int _SLEEPDEEP:1;
		unsigned int :1;
		unsigned int _SLPONMOD:1;
		unsigned int :4;
		unsigned int _STACKALIGN:1;
		unsigned int :5;
		unsigned int _SUSTA:1;
		unsigned int _SPSEL:1;
		unsigned int :15;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MCTL (*((volatile union SYS_MCTL_REG *)0x402000B4))
// model

/** 0x4020 00B8 SYS_ARCTL **/
union SYS_ARCTL_REG{
	unsigned int reg;
	struct SYS_ARCTL_BITS{
		unsigned int :2;
		unsigned int _SYSTEMRST:1;
		unsigned int :1;
		unsigned int _CDMAR:1;
		unsigned int _CDMAAM:1;
		unsigned int _CRWDC:1;
		unsigned int _CDMADC:1;
		unsigned int _CDBUGBS:1;
		unsigned int _CDMALDC:2;
		unsigned int :5;
		unsigned int _ARKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_ARCTL (*((volatile union SYS_ARCTL_REG *)0x402000B8))
// model

/** 0x4020 00BC SYS_VECTOFF **/
union SYS_VECTOFF_REG{
	unsigned int reg;
	struct SYS_VECTOFF_BITS{
		unsigned int _TBLOFF:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_VECTOFF (*((volatile union SYS_VECTOFF_REG *)0x402000BC))
// model

/** 0x4020 00C0 CACHE_CTLR **/
union CACHE_CTLR_REG{
	unsigned int reg;
	struct CACHE_CTLR_BITS{
		unsigned int _CACHEEN:1;
		unsigned int _CACHERST:1;
		unsigned int _ICWR2LEN:1;
		unsigned int _ICRD2LEN:1;
		unsigned int _CECCEN:1;
		unsigned int _FECCERRIE:1;
		unsigned int _CECCERRIE:1;
		unsigned int _RECCERRIE:1;
		unsigned int _FECCERRFLAG:1;
		unsigned int _CECCERRFLAG:1;
		unsigned int :22;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define CACHE_CTLR (*((volatile union CACHE_CTLR_REG *)0x402000C0))
// model

/** 0x4020 00C4 SYS_RAMSPA **/
union SYS_RAMSPA_REG{
	unsigned int reg;
	struct SYS_RAMSPA_BITS{
		unsigned int _RAMSPA:26;
		unsigned int :6;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_RAMSPA (*((volatile union SYS_RAMSPA_REG *)0x402000C4))
// model

/** 0x4020 00C8 SYS_MEMCTL **/
union SYS_MEMCTL_REG{
	unsigned int reg;
	struct SYS_MEMCTL_BITS{
		unsigned int _MEMM:2;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MEMCTL (*((volatile union SYS_MEMCTL_REG *)0x402000C8))
// model

/** 0x4020 00CC SYS_MSPSPA **/
union SYS_MSPSPA_REG{
	unsigned int reg;
	struct SYS_MSPSPA_BITS{
		unsigned int _MSPSPAL:16;
		unsigned int _MSPSPAH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_MSPSPA (*((volatile union SYS_MSPSPA_REG *)0x402000CC))
// model

/** 0x4020 00D0 SYS_PSPSPA **/
union SYS_PSPSPA_REG{
	unsigned int reg;
	struct SYS_PSPSPA_BITS{
		unsigned int _PSPSPAL:16;
		unsigned int _PSPSPAH:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define SYS_PSPSPA (*((volatile union SYS_PSPSPA_REG *)0x402000D0))
// modelINT

/** 0x4020 00D4 INT_ELVLNET **/
union INT_ELVLNET_REG{
	unsigned int reg;
	struct INT_ELVLNET_BITS{
		unsigned int _ELVLNEG:22;
		unsigned int :10;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define INT_ELVLNET (*((volatile union INT_ELVLNET_REG *)0x402000D4))
// modelFlash

/** 0X4020 0114 FLASH_CFG **/
union FLASH_CFG_REG{
	unsigned int reg;
	struct FLASH_CFG_BITS{
		unsigned int _TCFG:4;
		unsigned int :2;
		unsigned int _PREFETCHEN:1;
		unsigned int _ECCREADEN:1;
		unsigned int :24;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CFG (*((volatile union FLASH_CFG_REG *)0x40200114))
// model

/** 0X4020 0120 FLASH_STATE **/
union FLASH_STATE_REG{
	unsigned int reg;
	struct FLASH_STATE_BITS{
		unsigned int :1;
		unsigned int _SIGDONE:1;
		unsigned int :30;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_STATE (*((volatile union FLASH_STATE_REG *)0x40200120))
// model

/** 0X4020 0138 FLASH_CSSTART **/
union FLASH_CSSTART_REG{
	unsigned int reg;
	struct FLASH_CSSTART_BITS{
		unsigned int :4;
		unsigned int _CKSTADDR:16;
		unsigned int :12;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSSTART (*((volatile union FLASH_CSSTART_REG *)0x40200138))
// model

/** 0X4020 013C FLASH_CSSTOP **/
union FLASH_CSSTOP_REG{
	unsigned int reg;
	struct FLASH_CSSTOP_BITS{
		unsigned int :4;
		unsigned int _CKSPADDR:16;
		unsigned int _SIGG0:1;
		unsigned int :11;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSSTOP (*((volatile union FLASH_CSSTOP_REG *)0x4020013C))
// model

/** 0X4020 0140 FLASH_CSRES0 **/
union FLASH_CSRES0_REG{
	unsigned int reg;
	struct FLASH_CSRES0_BITS{
		unsigned int _CKSPRES0:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES0 (*((volatile union FLASH_CSRES0_REG *)0x40200140))
// model

/** 0X4020 0144 FLASH_CSRES1 **/
union FLASH_CSRES1_REG{
	unsigned int reg;
	struct FLASH_CSRES1_BITS{
		unsigned int _CKSPRES1:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES1 (*((volatile union FLASH_CSRES1_REG *)0x40200144))
// model

/** 0X4020 0148 FLASH_CSRES2 **/
union FLASH_CSRES2_REG{
	unsigned int reg;
	struct FLASH_CSRES2_BITS{
		unsigned int _CKSPRES2:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES2 (*((volatile union FLASH_CSRES2_REG *)0x40200148))
// model

/** 0X4020 014C FLASH_CSRES3 **/
union FLASH_CSRES3_REG{
	unsigned int reg;
	struct FLASH_CSRES3_BITS{
		unsigned int _CKSPRES3:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define FLASH_CSRES3 (*((volatile union FLASH_CSRES3_REG *)0x4020014C))
// modelGPIOA

/** 0x5000 0000 GPIOA_PIR **/
union GPIOA_PIR_REG{
	unsigned int reg;
	struct GPIOA_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PIR (*((volatile union GPIOA_PIR_REG *)0x50000000))
// model

/** 0x5000 0004 GPIOA_POR **/
union GPIOA_POR_REG{
	unsigned int reg;
	struct GPIOA_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_POR (*((volatile union GPIOA_POR_REG *)0x50000004))
// model

/** 0x5000 0008 GPIOA_PUR **/
union GPIOA_PUR_REG{
	unsigned int reg;
	struct GPIOA_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PUR (*((volatile union GPIOA_PUR_REG *)0x50000008))
// model

/** 0x5000 000C GPIOA_PDR **/
union GPIOA_PDR_REG{
	unsigned int reg;
	struct GPIOA_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PDR (*((volatile union GPIOA_PDR_REG *)0x5000000C))
// model

/** 0x5000 0010 GPIOA_PODR **/
union GPIOA_PODR_REG{
	unsigned int reg;
	struct GPIOA_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PODR (*((volatile union GPIOA_PODR_REG *)0x50000010))
// model

/** 0x5000 0014 GPIOA_PMOD **/
union GPIOA_PMOD_REG{
	unsigned int reg;
	struct GPIOA_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_PMOD (*((volatile union GPIOA_PMOD_REG *)0x50000014))
// model

/** 0x5000 0018 GPIOA_OMOD **/
union GPIOA_OMOD_REG{
	unsigned int reg;
	struct GPIOA_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_OMOD (*((volatile union GPIOA_OMOD_REG *)0x50000018))
// model

/** 0x5000 001C GPIOA_LOCK **/
union GPIOA_LOCK_REG{
	unsigned int reg;
	struct GPIOA_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_LOCK (*((volatile union GPIOA_LOCK_REG *)0x5000001C))
// model

/** 0x5000 0020 GPIOA_RMPL **/
union GPIOA_RMPL_REG{
	unsigned int reg;
	struct GPIOA_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_RMPL (*((volatile union GPIOA_RMPL_REG *)0x50000020))
// model

/** 0x5000 0024 GPIOA_RMPH **/
union GPIOA_RMPH_REG{
	unsigned int reg;
	struct GPIOA_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_RMPH (*((volatile union GPIOA_RMPH_REG *)0x50000024))
// model

/** 0x5000 0034 GPIOA_RMP_MSB **/
union GPIOA_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOA_RMP_MSB_BITS{
		unsigned int _RMP_MSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOA_RMP_MSB (*((volatile union GPIOA_RMP_MSB_REG *)0x50000034))
// modelGPIOB

/** 0x5000 0040 GPIOB_PIR **/
union GPIOB_PIR_REG{
	unsigned int reg;
	struct GPIOB_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PIR (*((volatile union GPIOB_PIR_REG *)0x50000040))
// model

/** 0x5000 0044 GPIOB_POR **/
union GPIOB_POR_REG{
	unsigned int reg;
	struct GPIOB_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_POR (*((volatile union GPIOB_POR_REG *)0x50000044))
// model

/** 0x5000 0048 GPIOB_PUR **/
union GPIOB_PUR_REG{
	unsigned int reg;
	struct GPIOB_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PUR (*((volatile union GPIOB_PUR_REG *)0x50000048))
// model

/** 0x5000 004C GPIOB_PDR **/
union GPIOB_PDR_REG{
	unsigned int reg;
	struct GPIOB_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PDR (*((volatile union GPIOB_PDR_REG *)0x5000004C))
// model

/** 0x5000 0050 GPIOB_PODR **/
union GPIOB_PODR_REG{
	unsigned int reg;
	struct GPIOB_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PODR (*((volatile union GPIOB_PODR_REG *)0x50000050))
// model

/** 0x5000 0054 GPIOB_PMOD **/
union GPIOB_PMOD_REG{
	unsigned int reg;
	struct GPIOB_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_PMOD (*((volatile union GPIOB_PMOD_REG *)0x50000054))
// model

/** 0x5000 0058 GPIOB_OMOD **/
union GPIOB_OMOD_REG{
	unsigned int reg;
	struct GPIOB_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_OMOD (*((volatile union GPIOB_OMOD_REG *)0x50000058))
// model

/** 0x5000 005C GPIOB_LOCK **/
union GPIOB_LOCK_REG{
	unsigned int reg;
	struct GPIOB_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_LOCK (*((volatile union GPIOB_LOCK_REG *)0x5000005C))
// model

/** 0x5000 0060 GPIOB_RMPL **/
union GPIOB_RMPL_REG{
	unsigned int reg;
	struct GPIOB_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_RMPL (*((volatile union GPIOB_RMPL_REG *)0x50000060))
// model

/** 0x5000 0064 GPIOB_RMPH **/
union GPIOB_RMPH_REG{
	unsigned int reg;
	struct GPIOB_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_RMPH (*((volatile union GPIOB_RMPH_REG *)0x50000064))
// model

/** 0x5000 0068 GPIOB_UHS **/
union GPIOB_UHS_REG{
	unsigned int reg;
	struct GPIOB_UHS_BITS{
		unsigned int _UHSEN0:1;
		unsigned int _UHSEN1:1;
		unsigned int _UHSEN2:1;
		unsigned int _UHSEN3:1;
		unsigned int :28;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_UHS (*((volatile union GPIOB_UHS_REG *)0x50000068))
// model

/** 0x5000 0074 GPIOB_RMP_MSB **/
union GPIOB_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOB_RMP_MSB_BITS{
		unsigned int _RMP_MSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOB_RMP_MSB (*((volatile union GPIOB_RMP_MSB_REG *)0x50000074))
// modelGPIOC

/** 0x5000 0080 GPIOC_PIR **/
union GPIOC_PIR_REG{
	unsigned int reg;
	struct GPIOC_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PIR (*((volatile union GPIOC_PIR_REG *)0x50000080))
// model

/** 0x5000 0084 GPIOC_POR **/
union GPIOC_POR_REG{
	unsigned int reg;
	struct GPIOC_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_POR (*((volatile union GPIOC_POR_REG *)0x50000084))
// model

/** 0x5000 0088 GPIOC_PUR **/
union GPIOC_PUR_REG{
	unsigned int reg;
	struct GPIOC_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PUR (*((volatile union GPIOC_PUR_REG *)0x50000088))
// model

/** 0x5000 008C GPIOC_PDR **/
union GPIOC_PDR_REG{
	unsigned int reg;
	struct GPIOC_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PDR (*((volatile union GPIOC_PDR_REG *)0x5000008C))
// model

/** 0x5000 0090 GPIOC_PODR **/
union GPIOC_PODR_REG{
	unsigned int reg;
	struct GPIOC_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PODR (*((volatile union GPIOC_PODR_REG *)0x50000090))
// model

/** 0x5000 0094 GPIOC_PMOD **/
union GPIOC_PMOD_REG{
	unsigned int reg;
	struct GPIOC_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_PMOD (*((volatile union GPIOC_PMOD_REG *)0x50000094))
// model

/** 0x5000 0098 GPIOC_OMOD **/
union GPIOC_OMOD_REG{
	unsigned int reg;
	struct GPIOC_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_OMOD (*((volatile union GPIOC_OMOD_REG *)0x50000098))
// model

/** 0x5000 009C GPIOC_LOCK **/
union GPIOC_LOCK_REG{
	unsigned int reg;
	struct GPIOC_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_LOCK (*((volatile union GPIOC_LOCK_REG *)0x5000009C))
// model

/** 0x5000 00A0 GPIOC_RMPL **/
union GPIOC_RMPL_REG{
	unsigned int reg;
	struct GPIOC_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_RMPL (*((volatile union GPIOC_RMPL_REG *)0x500000A0))
// model

/** 0x5000 00A4 GPIOC_RMPH **/
union GPIOC_RMPH_REG{
	unsigned int reg;
	struct GPIOC_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_RMPH (*((volatile union GPIOC_RMPH_REG *)0x500000A4))
// model

/** 0x5000 00B4 GPIOC_RMP_MSB **/
union GPIOC_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOC_RMP_MSB_BITS{
		unsigned int _RMP_MSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOC_RMP_MSB (*((volatile union GPIOC_RMP_MSB_REG *)0x500000B4))
// modelGPIOD

/** 0x5000 00C0 GPIOD_PIR **/
union GPIOD_PIR_REG{
	unsigned int reg;
	struct GPIOD_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PIR (*((volatile union GPIOD_PIR_REG *)0x500000C0))
// model

/** 0x5000 00C4 GPIOD_POR **/
union GPIOD_POR_REG{
	unsigned int reg;
	struct GPIOD_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_POR (*((volatile union GPIOD_POR_REG *)0x500000C4))
// model

/** 0x5000 00C8 GPIOD_PUR **/
union GPIOD_PUR_REG{
	unsigned int reg;
	struct GPIOD_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PUR (*((volatile union GPIOD_PUR_REG *)0x500000C8))
// model

/** 0x5000 00CC GPIOD_PDR **/
union GPIOD_PDR_REG{
	unsigned int reg;
	struct GPIOD_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PDR (*((volatile union GPIOD_PDR_REG *)0x500000CC))
// model

/** 0x5000 00D0 GPIOD_PODR **/
union GPIOD_PODR_REG{
	unsigned int reg;
	struct GPIOD_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PODR (*((volatile union GPIOD_PODR_REG *)0x500000D0))
// model

/** 0x5000 00D4 GPIOD_PMOD **/
union GPIOD_PMOD_REG{
	unsigned int reg;
	struct GPIOD_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_PMOD (*((volatile union GPIOD_PMOD_REG *)0x500000D4))
// model

/** 0x5000 00D8 GPIOD_OMOD **/
union GPIOD_OMOD_REG{
	unsigned int reg;
	struct GPIOD_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_OMOD (*((volatile union GPIOD_OMOD_REG *)0x500000D8))
// model

/** 0x5000 00DC GPIOD_LOCK **/
union GPIOD_LOCK_REG{
	unsigned int reg;
	struct GPIOD_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_LOCK (*((volatile union GPIOD_LOCK_REG *)0x500000DC))
// model

/** 0x5000 00E0 GPIOD_RMPL **/
union GPIOD_RMPL_REG{
	unsigned int reg;
	struct GPIOD_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_RMPL (*((volatile union GPIOD_RMPL_REG *)0x500000E0))
// model

/** 0x5000 00E4 GPIOD_RMPH **/
union GPIOD_RMPH_REG{
	unsigned int reg;
	struct GPIOD_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_RMPH (*((volatile union GPIOD_RMPH_REG *)0x500000E4))
// model

/** 0x5000 00F4 GPIOD_RMP_MSB **/
union GPIOD_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOD_RMP_MSB_BITS{
		unsigned int _RMP_MSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOD_RMP_MSB (*((volatile union GPIOD_RMP_MSB_REG *)0x500000F4))
// modelGPIOE

/** 0x5000 0100 GPIOE_PIR **/
union GPIOE_PIR_REG{
	unsigned int reg;
	struct GPIOE_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PIR (*((volatile union GPIOE_PIR_REG *)0x50000100))
// model

/** 0x5000 0104 GPIOE_POR **/
union GPIOE_POR_REG{
	unsigned int reg;
	struct GPIOE_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_POR (*((volatile union GPIOE_POR_REG *)0x50000104))
// model

/** 0x5000 0108 GPIOE_PUR **/
union GPIOE_PUR_REG{
	unsigned int reg;
	struct GPIOE_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PUR (*((volatile union GPIOE_PUR_REG *)0x50000108))
// model

/** 0x5000 010C GPIOE_PDR **/
union GPIOE_PDR_REG{
	unsigned int reg;
	struct GPIOE_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PDR (*((volatile union GPIOE_PDR_REG *)0x5000010C))
// model

/** 0x5000 0110 GPIOE_PODR **/
union GPIOE_PODR_REG{
	unsigned int reg;
	struct GPIOE_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PODR (*((volatile union GPIOE_PODR_REG *)0x50000110))
// model

/** 0x5000 0114 GPIOE_PMOD **/
union GPIOE_PMOD_REG{
	unsigned int reg;
	struct GPIOE_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_PMOD (*((volatile union GPIOE_PMOD_REG *)0x50000114))
// model

/** 0x5000 0118 GPIOE_OMOD **/
union GPIOE_OMOD_REG{
	unsigned int reg;
	struct GPIOE_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_OMOD (*((volatile union GPIOE_OMOD_REG *)0x50000118))
// model

/** 0x5000 011C GPIOE_LOCK **/
union GPIOE_LOCK_REG{
	unsigned int reg;
	struct GPIOE_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_LOCK (*((volatile union GPIOE_LOCK_REG *)0x5000011C))
// model

/** 0x5000 0120 GPIOE_RMPL **/
union GPIOE_RMPL_REG{
	unsigned int reg;
	struct GPIOE_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_RMPL (*((volatile union GPIOE_RMPL_REG *)0x50000120))
// model

/** 0x5000 0124 GPIOE_RMPH **/
union GPIOE_RMPH_REG{
	unsigned int reg;
	struct GPIOE_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_RMPH (*((volatile union GPIOE_RMPH_REG *)0x50000124))
// model

/** 0x5000 0134 GPIOE_RMP_MSB **/
union GPIOE_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOE_RMP_MSB_BITS{
		unsigned int _RMP_MSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOE_RMP_MSB (*((volatile union GPIOE_RMP_MSB_REG *)0x50000134))
// modelGPIOF

/** 0x5000 0140 GPIOF_PIR **/
union GPIOF_PIR_REG{
	unsigned int reg;
	struct GPIOF_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PIR (*((volatile union GPIOF_PIR_REG *)0x50000140))
// model

/** 0x5000 0144 GPIOF_POR **/
union GPIOF_POR_REG{
	unsigned int reg;
	struct GPIOF_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_POR (*((volatile union GPIOF_POR_REG *)0x50000144))
// model

/** 0x5000 0148 GPIOF_PUR **/
union GPIOF_PUR_REG{
	unsigned int reg;
	struct GPIOF_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PUR (*((volatile union GPIOF_PUR_REG *)0x50000148))
// model

/** 0x5000 014C GPIOF_PDR **/
union GPIOF_PDR_REG{
	unsigned int reg;
	struct GPIOF_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PDR (*((volatile union GPIOF_PDR_REG *)0x5000014C))
// model

/** 0x5000 0150 GPIOF_PODR **/
union GPIOF_PODR_REG{
	unsigned int reg;
	struct GPIOF_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PODR (*((volatile union GPIOF_PODR_REG *)0x50000150))
// model

/** 0x5000 0154 GPIOF_PMOD **/
union GPIOF_PMOD_REG{
	unsigned int reg;
	struct GPIOF_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_PMOD (*((volatile union GPIOF_PMOD_REG *)0x50000154))
// model

/** 0x5000 0158 GPIOF_OMOD **/
union GPIOF_OMOD_REG{
	unsigned int reg;
	struct GPIOF_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_OMOD (*((volatile union GPIOF_OMOD_REG *)0x50000158))
// model

/** 0x5000 015C GPIOF_LOCK **/
union GPIOF_LOCK_REG{
	unsigned int reg;
	struct GPIOF_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_LOCK (*((volatile union GPIOF_LOCK_REG *)0x5000015C))
// model

/** 0x5000 0160 GPIOF_RMPL **/
union GPIOF_RMPL_REG{
	unsigned int reg;
	struct GPIOF_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_RMPL (*((volatile union GPIOF_RMPL_REG *)0x50000160))
// model

/** 0x5000 0164 GPIOF_RMPH **/
union GPIOF_RMPH_REG{
	unsigned int reg;
	struct GPIOF_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_RMPH (*((volatile union GPIOF_RMPH_REG *)0x50000164))
// model

/** 0x5000 0174 GPIOF_RMP_MSB **/
union GPIOF_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOF_RMP_MSB_BITS{
		unsigned int _RMP_MSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOF_RMP_MSB (*((volatile union GPIOF_RMP_MSB_REG *)0x50000174))
// modelIONMI

/** 0x5000 017C IONMI_CTLR **/
union IONMI_CTLR_REG{
	unsigned int reg;
	struct IONMI_CTLR_BITS{
		unsigned int _IONMIEN:1;
		unsigned int _FLTWR:3;
		unsigned int _FCKDIV:3;
		unsigned int :1;
		unsigned int _IRQMS:3;
		unsigned int _FLTEN:1;
		unsigned int _FLTCKS:1;
		unsigned int _IONMIIC:1;
		unsigned int _IONMIIF:1;
		unsigned int :17;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define IONMI_CTLR (*((volatile union IONMI_CTLR_REG *)0x5000017C))
// modelGPIOG

/** 0x5000 0180 GPIOG_PIR **/
union GPIOG_PIR_REG{
	unsigned int reg;
	struct GPIOG_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PIR (*((volatile union GPIOG_PIR_REG *)0x50000180))
// model

/** 0x5000 0184 GPIOG_POR **/
union GPIOG_POR_REG{
	unsigned int reg;
	struct GPIOG_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_POR (*((volatile union GPIOG_POR_REG *)0x50000184))
// model

/** 0x5000 0188 GPIOG_PUR **/
union GPIOG_PUR_REG{
	unsigned int reg;
	struct GPIOG_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PUR (*((volatile union GPIOG_PUR_REG *)0x50000188))
// model

/** 0x5000 018C GPIOG_PDR **/
union GPIOG_PDR_REG{
	unsigned int reg;
	struct GPIOG_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PDR (*((volatile union GPIOG_PDR_REG *)0x5000018C))
// model

/** 0x5000 0190 GPIOG_PODR **/
union GPIOG_PODR_REG{
	unsigned int reg;
	struct GPIOG_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PODR (*((volatile union GPIOG_PODR_REG *)0x50000190))
// model

/** 0x5000 0194 GPIOG_PMOD **/
union GPIOG_PMOD_REG{
	unsigned int reg;
	struct GPIOG_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_PMOD (*((volatile union GPIOG_PMOD_REG *)0x50000194))
// model

/** 0x5000 0198 GPIOG_OMOD **/
union GPIOG_OMOD_REG{
	unsigned int reg;
	struct GPIOG_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_OMOD (*((volatile union GPIOG_OMOD_REG *)0x50000198))
// model

/** 0x5000 019C GPIOG_LOCK **/
union GPIOG_LOCK_REG{
	unsigned int reg;
	struct GPIOG_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_LOCK (*((volatile union GPIOG_LOCK_REG *)0x5000019C))
// model

/** 0x5000 01A0 GPIOG_RMPL **/
union GPIOG_RMPL_REG{
	unsigned int reg;
	struct GPIOG_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_RMPL (*((volatile union GPIOG_RMPL_REG *)0x500001A0))
// model

/** 0x5000 01A4 GPIOG_RMPH **/
union GPIOG_RMPH_REG{
	unsigned int reg;
	struct GPIOG_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_RMPH (*((volatile union GPIOG_RMPH_REG *)0x500001A4))
// model

/** 0x5000 01B4 GPIOG_RMP_MSB **/
union GPIOG_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOG_RMP_MSB_BITS{
		unsigned int _RMP_MSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOG_RMP_MSB (*((volatile union GPIOG_RMP_MSB_REG *)0x500001B4))
// modelGPIOH

/** 0x5000 01C0 GPIOH_PIR **/
union GPIOH_PIR_REG{
	unsigned int reg;
	struct GPIOH_PIR_BITS{
		unsigned int _PXPIR0:1;
		unsigned int _PXPIR1:1;
		unsigned int _PXPIR2:1;
		unsigned int _PXPIR3:1;
		unsigned int _PXPIR4:1;
		unsigned int _PXPIR5:1;
		unsigned int _PXPIR6:1;
		unsigned int _PXPIR7:1;
		unsigned int _PXPIR8:1;
		unsigned int _PXPIR9:1;
		unsigned int _PXPIR10:1;
		unsigned int _PXPIR11:1;
		unsigned int _PXPIR12:1;
		unsigned int _PXPIR13:1;
		unsigned int _PXPIR14:1;
		unsigned int _PXPIR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PIR (*((volatile union GPIOH_PIR_REG *)0x500001C0))
// model

/** 0x5000 01C4 GPIOH_POR **/
union GPIOH_POR_REG{
	unsigned int reg;
	struct GPIOH_POR_BITS{
		unsigned int _PXPOR0:1;
		unsigned int _PXPOR1:1;
		unsigned int _PXPOR2:1;
		unsigned int _PXPOR3:1;
		unsigned int _PXPOR4:1;
		unsigned int _PXPOR5:1;
		unsigned int _PXPOR6:1;
		unsigned int _PXPOR7:1;
		unsigned int _PXPOR8:1;
		unsigned int _PXPOR9:1;
		unsigned int _PXPOR10:1;
		unsigned int _PXPOR11:1;
		unsigned int _PXPOR12:1;
		unsigned int _PXPOR13:1;
		unsigned int _PXPOR14:1;
		unsigned int _PXPOR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_POR (*((volatile union GPIOH_POR_REG *)0x500001C4))
// model

/** 0x5000 01C8 GPIOH_PUR **/
union GPIOH_PUR_REG{
	unsigned int reg;
	struct GPIOH_PUR_BITS{
		unsigned int _PXPUR0:1;
		unsigned int _PXPUR1:1;
		unsigned int _PXPUR2:1;
		unsigned int _PXPUR3:1;
		unsigned int _PXPUR4:1;
		unsigned int _PXPUR5:1;
		unsigned int _PXPUR6:1;
		unsigned int _PXPUR7:1;
		unsigned int _PXPUR8:1;
		unsigned int _PXPUR9:1;
		unsigned int _PXPUR10:1;
		unsigned int _PXPUR11:1;
		unsigned int _PXPUR12:1;
		unsigned int _PXPUR13:1;
		unsigned int _PXPUR14:1;
		unsigned int _PXPUR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PUR (*((volatile union GPIOH_PUR_REG *)0x500001C8))
// model

/** 0x5000 01CC GPIOH_PDR **/
union GPIOH_PDR_REG{
	unsigned int reg;
	struct GPIOH_PDR_BITS{
		unsigned int _PXPDR0:1;
		unsigned int _PXPDR1:1;
		unsigned int _PXPDR2:1;
		unsigned int _PXPDR3:1;
		unsigned int _PXPDR4:1;
		unsigned int _PXPDR5:1;
		unsigned int _PXPDR6:1;
		unsigned int _PXPDR7:1;
		unsigned int _PXPDR8:1;
		unsigned int _PXPDR9:1;
		unsigned int _PXPDR10:1;
		unsigned int _PXPDR11:1;
		unsigned int _PXPDR12:1;
		unsigned int _PXPDR13:1;
		unsigned int _PXPDR14:1;
		unsigned int _PXPDR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PDR (*((volatile union GPIOH_PDR_REG *)0x500001CC))
// model

/** 0x5000 01D0 GPIOH_PODR **/
union GPIOH_PODR_REG{
	unsigned int reg;
	struct GPIOH_PODR_BITS{
		unsigned int _PXPODR0:1;
		unsigned int _PXPODR1:1;
		unsigned int _PXPODR2:1;
		unsigned int _PXPODR3:1;
		unsigned int _PXPODR4:1;
		unsigned int _PXPODR5:1;
		unsigned int _PXPODR6:1;
		unsigned int _PXPODR7:1;
		unsigned int _PXPODR8:1;
		unsigned int _PXPODR9:1;
		unsigned int _PXPODR10:1;
		unsigned int _PXPODR11:1;
		unsigned int _PXPODR12:1;
		unsigned int _PXPODR13:1;
		unsigned int _PXPODR14:1;
		unsigned int _PXPODR15:1;
		unsigned int :16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PODR (*((volatile union GPIOH_PODR_REG *)0x500001D0))
// model

/** 0x5000 01D4 GPIOH_PMOD **/
union GPIOH_PMOD_REG{
	unsigned int reg;
	struct GPIOH_PMOD_BITS{
		unsigned int _PXPMD0:2;
		unsigned int _PXPMD1:2;
		unsigned int _PXPMD2:2;
		unsigned int _PXPMD3:2;
		unsigned int _PXPMD4:2;
		unsigned int _PXPMD5:2;
		unsigned int _PXPMD6:2;
		unsigned int _PXPMD7:2;
		unsigned int _PXPMD8:2;
		unsigned int _PXPMD9:2;
		unsigned int _PXPMD10:2;
		unsigned int _PXPMD11:2;
		unsigned int _PXPMD12:2;
		unsigned int _PXPMD13:2;
		unsigned int _PXPMD14:2;
		unsigned int _PXPMD15:2;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_PMOD (*((volatile union GPIOH_PMOD_REG *)0x500001D4))
// model

/** 0x5000 01D8 GPIOH_OMOD **/
union GPIOH_OMOD_REG{
	unsigned int reg;
	struct GPIOH_OMOD_BITS{
		unsigned int _PXOMD0:1;
		unsigned int :1;
		unsigned int _PXOMD1:1;
		unsigned int :1;
		unsigned int _PXOMD2:1;
		unsigned int :1;
		unsigned int _PXOMD3:1;
		unsigned int :1;
		unsigned int _PXOMD4:1;
		unsigned int :1;
		unsigned int _PXOMD5:1;
		unsigned int :1;
		unsigned int _PXOMD6:1;
		unsigned int :1;
		unsigned int _PXOMD7:1;
		unsigned int :1;
		unsigned int _PXOMD8:1;
		unsigned int :1;
		unsigned int _PXOMD9:1;
		unsigned int :1;
		unsigned int _PXOMD10:1;
		unsigned int :1;
		unsigned int _PXOMD11:1;
		unsigned int :1;
		unsigned int _PXOMD12:1;
		unsigned int :1;
		unsigned int _PXOMD13:1;
		unsigned int :1;
		unsigned int _PXOMD14:1;
		unsigned int :1;
		unsigned int _PXOMD15:1;
		unsigned int :1;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_OMOD (*((volatile union GPIOH_OMOD_REG *)0x500001D8))
// model

/** 0x5000 01DC GPIOH_LOCK **/
union GPIOH_LOCK_REG{
	unsigned int reg;
	struct GPIOH_LOCK_BITS{
		unsigned int _PXLCK0:1;
		unsigned int _PXLCK1:1;
		unsigned int _PXLCK2:1;
		unsigned int _PXLCK3:1;
		unsigned int _PXLCK4:1;
		unsigned int _PXLCK5:1;
		unsigned int _PXLCK6:1;
		unsigned int _PXLCK7:1;
		unsigned int _PXLCK8:1;
		unsigned int _PXLCK9:1;
		unsigned int _PXLCK10:1;
		unsigned int _PXLCK11:1;
		unsigned int _PXLCK12:1;
		unsigned int _PXLCK13:1;
		unsigned int _PXLCK14:1;
		unsigned int _PXLCK15:1;
		unsigned int _PXLCKKEY:16;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_LOCK (*((volatile union GPIOH_LOCK_REG *)0x500001DC))
// model

/** 0x5000 01E0 GPIOH_RMPL **/
union GPIOH_RMPL_REG{
	unsigned int reg;
	struct GPIOH_RMPL_BITS{
		unsigned int _PXRMP0:4;
		unsigned int _PXRMP1:4;
		unsigned int _PXRMP2:4;
		unsigned int _PXRMP3:4;
		unsigned int _PXRMP4:4;
		unsigned int _PXRMP5:4;
		unsigned int _PXRMP6:4;
		unsigned int _PXRMP7:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_RMPL (*((volatile union GPIOH_RMPL_REG *)0x500001E0))
// model

/** 0x5000 01E4 GPIOH_RMPH **/
union GPIOH_RMPH_REG{
	unsigned int reg;
	struct GPIOH_RMPH_BITS{
		unsigned int _PXRMP8:4;
		unsigned int _PXRMP9:4;
		unsigned int _PXRMP10:4;
		unsigned int _PXRMP11:4;
		unsigned int _PXRMP12:4;
		unsigned int _PXRMP13:4;
		unsigned int _PXRMP14:4;
		unsigned int _PXRMP15:4;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_RMPH (*((volatile union GPIOH_RMPH_REG *)0x500001E4))
// model

/** 0x5000 01F4 GPIOH_RMP_MSB **/
union GPIOH_RMP_MSB_REG{
	unsigned int reg;
	struct GPIOH_RMP_MSB_BITS{
		unsigned int _RMP_MSB:32;
	}__attribute__((packed)) bits;
	struct all_bit bit;
};
#define GPIOH_RMP_MSB (*((volatile union GPIOH_RMP_MSB_REG *)0x500001F4))
#endif
