#ifndef _LIBC_LIMITS_H_
# define _LIBC_LIMITS_H_	1

#include <newlib.h>
#include <sys/cdefs.h>
#include <sys/syslimits.h>
/************************************************************/
# ifdef _MB_LEN_MAX
#  define MB_LEN_MAX	_MB_LEN_MAX
# else
#  define MB_LEN_MAX    1
# endif

/* Maximum number of positional arguments, if _WANT_IO_POS_ARGS.  */
# ifndef NL_ARGMAX
#  define NL_ARGMAX 32
# endif
/************************************************************/
/* if do not have #include_next support, then we
   have to define the limits here. */
# if !defined __GNUC__ || __GNUC__ < 2

      #  ifndef _LIMITS_H
      #   define _LIMITS_H	1

      #   include <sys/config.h>

      /* Number of bits in a `char'.  */
      #   undef CHAR_BIT
      #   define CHAR_BIT 8

      /* Minimum and maximum values a `signed char' can hold.  */
      #   undef SCHAR_MIN
      #   define SCHAR_MIN (-128)
      #   undef SCHAR_MAX
      #   define SCHAR_MAX 127

      /* Maximum value an `unsigned char' can hold.  (Minimum is 0).  */
      #   undef UCHAR_MAX
      #   define UCHAR_MAX 255

      /* Minimum and maximum values a `char' can hold.  */
      #   ifdef __CHAR_UNSIGNED__
      #    undef CHAR_MIN
      #    define CHAR_MIN 0
      #    undef CHAR_MAX
      #    define CHAR_MAX 255
      #   else
      #    undef CHAR_MIN
      #    define CHAR_MIN (-128)
      #    undef CHAR_MAX
      #    define CHAR_MAX 127
      #   endif

      /* Minimum and maximum values a `signed short int' can hold.  */
      #   undef SHRT_MIN
      /* For the sake of 16 bit hosts, we may not use -32768 */
      #   define SHRT_MIN (-32767-1)
      #   undef SHRT_MAX
      #   define SHRT_MAX 32767

      /* Maximum value an `unsigned short int' can hold.  (Minimum is 0).  */
      #   undef USHRT_MAX
      #   define USHRT_MAX 65535

      /* Minimum and maximum values a `signed int' can hold.  */
      #   ifndef __INT_MAX__
      #    define __INT_MAX__ 2147483647
      #   endif
      #   undef INT_MIN
      #   define INT_MIN (-INT_MAX-1)
      #   undef INT_MAX
      #   define INT_MAX __INT_MAX__

      /* Maximum value an `unsigned int' can hold.  (Minimum is 0).  */
      #   undef UINT_MAX
      #   define UINT_MAX (INT_MAX * 2U + 1)

      /* Minimum and maximum values a `signed long int' can hold.
         (Same as `int').  */
      #   ifndef __LONG_MAX__
      #    if defined (__alpha__) || (defined (__sparc__) && defined(__arch64__)) || defined (__sparcv9)
      #     define __LONG_MAX__ 9223372036854775807L
      #    else
      #     define __LONG_MAX__ 2147483647L
      #    endif /* __alpha__ || sparc64 */
      #   endif
      #   undef LONG_MIN
      #   define LONG_MIN (-LONG_MAX-1)
      #   undef LONG_MAX
      #   define LONG_MAX __LONG_MAX__

      /* Maximum value an `unsigned long int' can hold.  (Minimum is 0).  */
      #   undef ULONG_MAX
      #   define ULONG_MAX (LONG_MAX * 2UL + 1)

      #   ifndef __LONG_LONG_MAX__
      #    define __LONG_LONG_MAX__ 9223372036854775807LL
      #   endif

      /*#   if __ISO_C_VISIBLE >= 1999*/
      /* Minimum and maximum values a `signed long long int' can hold.  */
      #    undef LLONG_MIN
      #    define LLONG_MIN (-LLONG_MAX-1)
      #    undef LLONG_MAX
      #    define LLONG_MAX __LONG_LONG_MAX__

      /* Maximum value an `unsigned long long int' can hold.  (Minimum is 0).  */
      #    undef ULLONG_MAX
      #    define ULLONG_MAX (LLONG_MAX * 2ULL + 1)
      /*#   endif*/

      #  if __GNU_VISIBLE
      /* Minimum and maximum values a `signed long long int' can hold.  */
      #    undef LONG_LONG_MIN
      #    define LONG_LONG_MIN (-LONG_LONG_MAX-1)
      #    undef LONG_LONG_MAX
      #    define LONG_LONG_MAX __LONG_LONG_MAX__

      /* Maximum value an `unsigned long long int' can hold.  (Minimum is 0).  */
      #    undef ULONG_LONG_MAX
      #    define ULONG_LONG_MAX (LONG_LONG_MAX * 2ULL + 1)
      #   endif

      #  endif /* _LIMITS_H  */
# endif	 /* GCC 2.  */
/************************************************************/
#endif	 /* !_LIBC_LIMITS_H_ */

#if defined __GNUC__ && !defined _GCC_LIMITS_H_
/* `_GCC_LIMITS_H_' is what GCC's file defines.  */
/*# include_next <limits.h>*/
	/* Copyright (C) 1991, 1992, 1993, 1996, 1997, 1998, 1999, 2000, 2001,
	   2002 Free Software Foundation, Inc.

	This file is part of GCC.

	GCC is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 3, or (at your option) any later
	version.

	GCC is distributed in the hope that it will be useful, but WITHOUT ANY
	WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
	for more details.

	Under Section 7 of GPL version 3, you are granted additional
	permissions described in the GCC Runtime Library Exception, version
	3.1, as published by the Free Software Foundation.

	You should have received a copy of the GNU General Public License and
	a copy of the GCC Runtime Library Exception along with this program;
	see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
	<http://www.gnu.org/licenses/>.  */

	#ifndef _LIMITS_H___
		#define _LIMITS_H___

		/* Number of bits in a `char'.  */
		#undef CHAR_BIT
		#define CHAR_BIT __CHAR_BIT__

		/* Maximum length of a multibyte character.  */
		#ifndef MB_LEN_MAX
			#define MB_LEN_MAX 1
		#endif

		/* Minimum and maximum values a `signed char' can hold.  */
		#undef SCHAR_MIN
		#define SCHAR_MIN (-SCHAR_MAX - 1)
		#undef SCHAR_MAX
		#define SCHAR_MAX __SCHAR_MAX__

		/* Maximum value an `unsigned char' can hold.  (Minimum is 0).  */
		#undef UCHAR_MAX
		#if __SCHAR_MAX__ == __INT_MAX__
			# define UCHAR_MAX (SCHAR_MAX * 2U + 1U)
		#else
			# define UCHAR_MAX (SCHAR_MAX * 2 + 1)
		#endif

		/* Minimum and maximum values a `char' can hold.  */
		#ifdef __CHAR_UNSIGNED__
			# undef CHAR_MIN
			# if __SCHAR_MAX__ == __INT_MAX__
				#  define CHAR_MIN 0U
			# else
				#  define CHAR_MIN 0
			# endif
			# undef CHAR_MAX
			# define CHAR_MAX UCHAR_MAX
		#else
			# undef CHAR_MIN
			# define CHAR_MIN SCHAR_MIN
			# undef CHAR_MAX
			# define CHAR_MAX SCHAR_MAX
		#endif

		/* Minimum and maximum values a `signed short int' can hold.  */
		#undef SHRT_MIN
		#define SHRT_MIN (-SHRT_MAX - 1)
		#undef SHRT_MAX
		#define SHRT_MAX __SHRT_MAX__

		/* Maximum value an `unsigned short int' can hold.  (Minimum is 0).  */
		#undef USHRT_MAX
		#if __SHRT_MAX__ == __INT_MAX__
		# define USHRT_MAX (SHRT_MAX * 2U + 1U)
		#else
		# define USHRT_MAX (SHRT_MAX * 2 + 1)
		#endif

		/* Minimum and maximum values a `signed int' can hold.  */
		#undef INT_MIN
		#define INT_MIN (-INT_MAX - 1)
		#undef INT_MAX
		#define INT_MAX __INT_MAX__

		/* Maximum value an `unsigned int' can hold.  (Minimum is 0).  */
		#undef UINT_MAX
		#define UINT_MAX (INT_MAX * 2U + 1U)

		/* Minimum and maximum values a `signed long int' can hold.
		   (Same as `int').  */
		#undef LONG_MIN
		#define LONG_MIN (-LONG_MAX - 1L)
		#undef LONG_MAX
		#define LONG_MAX __LONG_MAX__

		/* Maximum value an `unsigned long int' can hold.  (Minimum is 0).  */
		#undef ULONG_MAX
		#define ULONG_MAX (LONG_MAX * 2UL + 1UL)

		/*#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L*/
			/* Minimum and maximum values a `signed long long int' can hold.  */
			# undef LLONG_MIN
			# define LLONG_MIN (-LLONG_MAX - 1LL)
			# undef LLONG_MAX
			# define LLONG_MAX __LONG_LONG_MAX__

			/* Maximum value an `unsigned long long int' can hold.  (Minimum is 0).  */
			# undef ULLONG_MAX
			# define ULLONG_MAX (LLONG_MAX * 2ULL + 1ULL)
		/*#endif*/

		/*#if defined (__GNU_LIBRARY__) ? defined (__USE_GNU) : !defined (__STRICT_ANSI__)*/
			/* Minimum and maximum values a `signed long long int' can hold.  */
			# undef LONG_LONG_MIN
			# define LONG_LONG_MIN (-LONG_LONG_MAX - 1LL)
			# undef LONG_LONG_MAX
			# define LONG_LONG_MAX __LONG_LONG_MAX__

			/* Maximum value an `unsigned long long int' can hold.  (Minimum is 0).  */
			# undef ULONG_LONG_MAX
			# define ULONG_LONG_MAX (LONG_LONG_MAX * 2ULL + 1ULL)
		/*#endif*/

	#endif /* _LIMITS_H___ */
#endif /* __GNUC__ && !_GCC_LIMITS_H_ */

#ifndef _POSIX2_RE_DUP_MAX
/* The maximum number of repeated occurrences of a regular expression
 *    permitted when using the interval notation `\{M,N\}'.  */
#define _POSIX2_RE_DUP_MAX              255
#endif /* _POSIX2_RE_DUP_MAX  */

#ifndef ARG_MAX
#define ARG_MAX		4096
#endif

#ifndef PATH_MAX
#define PATH_MAX	4096
#endif
