#ifndef _MACHINE_IEEE_H_
#define _MACHINE_IEEE_H_
#include <sys/types.h>
#include <sys/cdefs.h>
#include <machine/ieeefp.h>
#include <float.h>
/********************************************************************/
#if LDBL_MANT_DIG == 24
    #define EXT_IMPLICIT_NBIT
    #define EXT_TO_ARRAY32(p, a) do {      \
        (a)[0] = (p)->ext_frac;  \
    } while (0)
    /*#ifdef __IEEE_LITTLE_ENDIAN*/
    struct ieee_ext {
        uint32_t   ext_frac:23;
        uint32_t   ext_exp:8;
        uint32_t   ext_sign:1;
    };
    /*#endif*/
/********************************************************************/
#elif LDBL_MANT_DIG == 53
    #define EXT_IMPLICIT_NBIT
    #define EXT_TO_ARRAY32(p, a) do {       \
        (a)[0] = (p)->ext_fracl;  \
        (a)[1] = (p)->ext_frach;  \
    } while (0)
    /*#ifdef __IEEE_LITTLE_ENDIAN*/
    struct ieee_ext {
        uint32_t   ext_fracl;
        uint32_t   ext_frach:20;
        uint32_t   ext_exp:11;
        uint32_t   ext_sign:1;
    };
    /*#endif*/
/********************************************************************/
#else
	#error  "long double format error config...
#endif
/********************************************************************/
#endif /* _MACHINE_IEEE_H_ */
