
#ifdef __cplusplus
extern "C" {
#endif
/********************************************************************/
#define _JBLEN 32
#define _JBTYPE unsigned int

/********************************************************************/

#ifdef _JBLEN
	#ifdef _JBTYPE
		typedef	_JBTYPE jmp_buf[_JBLEN];
	#else
		typedef	int 	jmp_buf[_JBLEN];
	#endif
#endif

#ifdef __cplusplus
}
#endif
/********************************************************************/
#if (defined(__CYGWIN__) || defined(__rtems__)) && __POSIX_VISIBLE
	#include <signal.h>

	#ifdef __cplusplus
	extern "C" {
	#endif

	/* POSIX sigsetjmp/siglongjmp macros */
	#ifdef _JBTYPE
		typedef _JBTYPE sigjmp_buf[_JBLEN+1+((sizeof (_JBTYPE) + sizeof (sigset_t) - 1)
					     /sizeof (_JBTYPE))];
	#else
		typedef int sigjmp_buf[_JBLEN+1+(sizeof (sigset_t)/sizeof (int))];
	#endif

	#define _SAVEMASK	_JBLEN
	#define _SIGMASK	(_JBLEN+1)


	#ifdef _POSIX_THREADS
		#define __SIGMASK_FUNC pthread_sigmask
	#else
		#define __SIGMASK_FUNC sigprocmask
	#endif


	#if defined(__GNUC__)

		#define sigsetjmp(env, savemask) \
		            __extension__ \
		            ({ \
		              sigjmp_buf *_sjbuf = &(env); \
		              ((*_sjbuf)[_SAVEMASK] = savemask,\
		              __SIGMASK_FUNC (SIG_SETMASK, 0, (sigset_t *)((*_sjbuf) + _SIGMASK)),\
		              setjmp (*_sjbuf)); \
		            })

		#define siglongjmp(env, val) \
		            __extension__ \
		            ({ \
		              sigjmp_buf *_sjbuf = &(env); \
		              ((((*_sjbuf)[_SAVEMASK]) ? \
		               __SIGMASK_FUNC (SIG_SETMASK, (sigset_t *)((*_sjbuf) + _SIGMASK), 0)\
		               : 0), \
		               longjmp (*_sjbuf, val)); \
		            })

	#else /* !__GNUC__ */

		#define sigsetjmp(env, savemask) ((env)[_SAVEMASK] = savemask,\
		               __SIGMASK_FUNC (SIG_SETMASK, 0, (sigset_t *) ((env) + _SIGMASK)),\
		               setjmp (env))

		#define siglongjmp(env, val) ((((env)[_SAVEMASK])?\
		               __SIGMASK_FUNC (SIG_SETMASK, (sigset_t *) ((env) + _SIGMASK), 0):0),\
		               longjmp (env, val))

	#endif

	/* POSIX _setjmp/_longjmp, maintained for XSI compatibility.  These
	   are equivalent to sigsetjmp/siglongjmp when not saving the signal mask.
	   New applications should use sigsetjmp/siglongjmp instead. */
	#define _setjmp(env)		sigsetjmp ((env), 0)
	#define _longjmp(env, val)	siglongjmp ((env), (val))

	#ifdef __cplusplus
	}
	#endif
	
#endif /* (__CYGWIN__ or __rtems__) and __POSIX_VISIBLE */
