
#ifndef __STDARG_H
#define __STDARG_H 1

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __clang__

	#define  va_list 				__builtin_va_list

	#define va_start(list,last)		__builtin_va_start(list,last)
	#define va_end(list)			__builtin_va_end(list)
	#define va_arg(list,type)		__builtin_va_arg(list,type)
	#define va_copy(dest, src) 		__builtin_va_copy(dest,src)
#else
typedef unsigned char * va_list;

#define va_start(list, last)    list = (unsigned char *)&last + sizeof(last)

#define va_arg(list, type)      *((type *)((list += sizeof(type)) - sizeof(type)))

#define va_end(list)		list = ((va_list) 0)

#ifndef va_copy
#define va_copy(dest, src)	 ((dest) = (src))
#endif

#endif

#ifdef __cplusplus
}
#endif
#endif	/* __STDARG_H */
