/*
 * @file:    
 * @version: V1.01
 * @purpose:
 *
 *
 */


#ifndef _CTYPE_H
#define	_CTYPE_H

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _NO_CTYPE_
/* search table */
/* _Ctype conversion bit */
#define _UP	0x02	/* 'A' - 'Z' */
#define _LO	0x10	/* 'a' - 'z' */
#define _DI	0x20	/* '0' - '9' */
#define _CN	0x40	/* CR, FF, HT, NL, VT */
#define _PU	0x08	/* punctuation */
#define _SP	0x04	/* space */
#define _XD	0x01	/* '0' - '9', 'A' - 'F', 'a' - 'f' */
#define _BB	0x80	/* BEL, BS, etc. */

/* combination bit */ 
#define XDI (_DI|_XD)
#define XLO (_LO|_XD)
#define XUP (_UP|_XD)

#define isalpha(_c)     ( _Ctype[(unsigned char)(_c)] & (_UP|_LO) )
#define isupper(_c)     ( _Ctype[(unsigned char)(_c)] & _UP )
#define islower(_c)     ( _Ctype[(unsigned char)(_c)] & _LO )
#define isdigit(_c)     ( _Ctype[(unsigned char)(_c)] & _DI )
#define isxdigit(_c)    ( _Ctype[(unsigned char)(_c)] & _XD )
#define isspace(_c)     ( _Ctype[(unsigned char)(_c)] & (_CN|_SP) )
#define ispunct(_c)     ( _Ctype[(unsigned char)(_c)] & _PU )
#define isalnum(_c)     ( _Ctype[(unsigned char)(_c)] & (_UP|_LO|_DI) )
#define isprint(_c)     ( _Ctype[(unsigned char)(_c)] & (_SP|_PU|_UP|_LO|_DI) )
#define isgraph(_c)     ( _Ctype[(unsigned char)(_c)] & (_PU|_UP|_LO|_DI) )
#define iscntrl(_c)     ( _Ctype[(unsigned char)(_c)] & (_BB|_CN) )

#define isascii(_c)     ( (unsigned int)(_c) < 0x80 )
#define tolower(_c)     ( isupper(_c) ? ((_c)-'A'+'a'): (_c) )
#define toupper(_c)     ( islower(_c) ? ((_c)-'a'+'A'): (_c) )

/* extern external  _Ctype conversion table */
extern const char *_Ctype;
#else
int isalpha(int c);
int isupper(int c);
int islower(int c);
int isdigit(int c);
int isxdigit(int c);
int isspace(int c);
int ispunct(int c);
int isalnum(int c);
int isprint(int c);
int isgraph(int c);
int iscntrl(int c);
int isascii(int c);
int tolower(int c);
int toupper(int c);
#endif	/* Not _NO_CTYPE_ */

#ifdef __cplusplus
}
#endif
#endif	/* _CTYPE_H */
