/*****************************************************************************/
/* @file:    stddef.h                                                        */
/* @version: V1.01                                                           */
/*****************************************************************************/

#ifndef _STDDEF_H
#define _STDDEF_H

#ifdef __cplusplus
extern "C" {
#endif

/* Define NULL pointer value and the offset() macro */

#ifndef	NULL
#define	NULL	0
#endif

#define offsetof(s,m)   (size_t)&(((s *)0)->m)

/* define the implementation dependent size types */

#ifndef _PTRDIFF_T
typedef int ptrdiff_t;
#define _PTRDIFF_T
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef	unsigned int size_t;
#endif

#ifndef __cplusplus
#ifndef _WCHAR_T
typedef unsigned short wchar_t;
#define _WCHAR_T
#endif
#endif

#ifdef __cplusplus
}
#endif
#endif /* _STDDEF_H */
